---
generated_at: 2026-01-23 10:45:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：94-定数一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **customer.constantsのキャッシュ実装**：キャッシュ機構の詳細確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_constantList.asp` - 定数一覧メインファイル
- E-02: `asp/includes/constant.asp` - cls_constantクラス定義
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | bHomeConstants権限が必要 | E-01 4行目 `logon.hasaccess secondAdmin.bHomeConstants` | ○ |
| C-02 | ページ一覧へのリンク | E-01 4行目 `getArtLink("bs_default.asp",l("pagelist")` | ○ |
| C-03 | 新規定数作成リンク | E-01 5行目 `getArtLink("bs_constantEdit.asp",l("newitem")` | ○ |
| C-04 | VBScript管理へのリンク（条件付き） | E-01 5行目 `if customer.bApplication and secondAdmin.bHomeVBScript` | ○ |
| C-05 | customer.constantsで定数取得 | E-01 6行目 `set cconstants=customer.constants` | ○ |
| C-06 | cls_formatListで種別表示 | E-01 8行目 `set formatList=new cls_formatList` | ○ |
| C-07 | VBScript種別の除外 | E-01 10行目 `if QS_VBScript<>cconstants(keyconstants).iType then` | ○ |
| C-08 | コピー用テキストボックス | E-01 10行目 `onclick="javascript:this.select()"` | ○ |
| C-09 | 定数参照形式`[定数名]` | E-01 10行目 `value="[<%=sanitize(...)%>]"` | ○ |
| C-10 | 編集リンクの生成 | E-01 10行目 `href="bs_constantEdit.asp?iContentID=<%=encrypt(keyconstants)%>"` | ○ |
| C-11 | 状態表示（statusString） | E-01 10行目 `cconstants(keyconstants).statusString` | ○ |
| C-12 | cls_constantクラスの存在 | E-02 2行目 `class cls_constant` | ○ |
| C-13 | bOnlineプロパティの実装 | E-02 87-89行目 `public function bOnline` | ○ |
| C-14 | statusStringプロパティの実装 | E-02 90-96行目 `public property get statusString` | ○ |
| C-15 | isBetween関数でオンライン判定 | E-02 88行目 `bOnline=isBetween(dOnlineFrom,date,dOnlineUntill)` | ○ |
| C-16 | 機能カテゴリが「管理画面/定数」 | E-03 95行目 | ○ |
| C-17 | 関連画面No.87, 88 | E-04 122-124行目 | ○ |
| C-18 | customer.constantsのキャッシュ機構 | **根拠不足** - cacheConstants()の実装確認が必要 | △ |

## 4) 不足情報（Unknown / Missing）
- customer.constantsプロパティのキャッシュ実装詳細
  - 候補：asp/includes/customer.asp / cacheConstants()メソッド
- QS_VBScript定数の定義場所
  - 候補：asp/includes/constants.asp

## 5) リスクフラグ（レビュー観点）
- 0: 権限チェック・データ取得（根拠十分）
- 0: VBScript除外ロジック（ソースコードで確認済み）
- 1: キャッシュの整合性（保存後のキャッシュ更新確認）

## 6) レビュアーチェックリスト（最小）
- [ ] bHomeConstants権限のデフォルト値を確認
- [ ] VBScript種別の定数が正しくフィルタリングされることを確認
- [ ] customer.constantsのキャッシュ更新タイミングを確認
- [ ] sanitize関数が適切にXSS対策を行っていることを確認
