---
generated_at: 2026-01-23 10:50:00
metrics:
  claims_total: 24
  claims_with_evidence: 23
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：95-定数作成・編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：23 / 24、根拠なし：1
- 優先レビュー（高）
  1. **FCKEditorのロード時間**：パフォーマンス要件の数値根拠なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_constantEdit.asp` - 定数編集メインファイル
- E-02: `asp/includes/constant.asp` - cls_constantクラス定義
- E-03: `asp/includes/fullsearch.asp` - cls_fullSearchクラス定義
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | bHomeConstants権限が必要 | E-01 4行目 `logon.hasaccess secondAdmin.bHomeConstants` | ○ |
| C-02 | cls_constant初期化 | E-01 5行目 `set constant=new cls_constant` | ○ |
| C-03 | postback判定 | E-01 7行目 `postback=convertBool(Request.Form("postback"))` | ○ |
| C-04 | CSRFチェック実装 | E-01 11行目, 17行目 `checkCSRF()` | ○ |
| C-05 | 保存アクション | E-01 10-15行目 `case l("save")` | ○ |
| C-06 | 削除アクション | E-01 16-23行目 `case l("delete")` | ○ |
| C-07 | VBScript種別の別リダイレクト | E-01 19-22行目 `if constant.iType=QS_VBscript then` | ○ |
| C-08 | cls_formatListで種別表示 | E-01 26行目 `set formatList=new cls_formatList` | ○ |
| C-09 | 種別によるフォーム切り替え | E-01 31行目 `select case constant.iType` | ○ |
| C-10 | HTMLエディタ（FCK）使用 | E-01 32行目 `createFCKInstance` | ○ |
| C-11 | VBScript確認ダイアログ | E-01 32行目 `confirm('Are you sure? Did you TEST the function?')` | ○ |
| C-12 | 使用箇所検索（cls_fullSearch） | E-01 35-43行目 `set fsearch=new cls_fullSearch` | ○ |
| C-13 | 正規表現パターン | E-01 36行目 `fsearch.pattern="\[+(...` | ○ |
| C-14 | VBScriptテストフォーム | E-01 45行目 `form ... action="bs_constantTest.asp"` | ○ |
| C-15 | pick関数の実装 | E-02 11-28行目 `Public Function Pick(id)` | ○ |
| C-16 | check関数の実装 | E-02 29-48行目 `Public Function Check()` | ○ |
| C-17 | 角括弧の除去 | E-02 31-32行目 `Replace(sConstant, "[", "")` | ○ |
| C-18 | 一意性チェック | E-02 42-47行目 `select count(iId) from tblConstant` | ○ |
| C-19 | save関数の実装 | E-02 49-77行目 `Public Function Save` | ○ |
| C-20 | キャッシュ更新 | E-02 76行目 `customer.cacheConstants()` | ○ |
| C-21 | remove関数の実装 | E-02 97-104行目 `public function remove` | ○ |
| C-22 | fullsearchのsearch関数 | E-03 265-400行目 `public function search` | ○ |
| C-23 | 機能カテゴリが「管理画面/定数」 | E-04 96行目 | ○ |
| C-24 | FCKEditorのロード時間（数秒） | **根拠なし** - 推定値 | △ |

## 4) 不足情報（Unknown / Missing）
- FCKEditorのロード時間に関する具体的な数値根拠がない
  - 候補：パフォーマンステスト結果 / ブラウザ開発者ツールの計測

## 5) リスクフラグ（レビュー観点）
- 0: CRUD操作（ソースコードで確認済み）
- 0: バリデーション・セキュリティ（根拠十分）
- 1: VBScript実行のセキュリティリスク（別ウィンドウ分離で軽減）

## 6) レビュアーチェックリスト（最小）
- [ ] 角括弧除去が正しく動作することを確認
- [ ] 定数名の一意性チェックが大文字/小文字を区別しないことを確認
- [ ] VBScriptテスト実行が本番環境に影響しないことを確認
- [ ] cacheConstants()が正しくキャッシュを更新することを確認
- [ ] 使用箇所検索の正規表現が全パターンをカバーすることを確認
