---
generated_at: 2026-01-23 10:55:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：96-スクリプト管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **bs_constantTest.aspのエラーハンドリング**：実装詳細の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_scriptList.asp` - スクリプト一覧メインファイル
- E-02: `asp/includes/constant.asp` - cls_constantクラス定義
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | bHomeVBScript権限が必要 | E-01 4行目 `logon.hasaccess secondAdmin.bHomeVBScript` | ○ |
| C-02 | bApplication設定チェック | E-01 4行目 `if not customer.bApplication then Response.Redirect` | ○ |
| C-03 | ページ一覧へのリンク | E-01 4行目 `getArtLink("bs_default.asp",l("pagelist")` | ○ |
| C-04 | 新規スクリプト作成リンク（iType付き） | E-01 5行目 `getArtLink("bs_constantEdit.asp?iType=" &QS_VBScript` | ○ |
| C-05 | 定数一覧へのリンク | E-01 6行目 `getArtLink("bs_constantlist.asp",l("constants")` | ○ |
| C-06 | customer.constantsで定数取得 | E-01 7行目 `set cconstants=customer.constants` | ○ |
| C-07 | VBScript種別のフィルタリング | E-01 9行目 `if QS_VBScript=cconstants(keyconstants).iType then` | ○ |
| C-08 | 参照コードのコピー用テキストボックス | E-01 9行目 `onclick="javascript:this.select();"` | ○ |
| C-09 | パラメータ付き表示 | E-01 9行目 `if not isLeeg(...sParameters) then Response.Write "("&...sParameters&")"` | ○ |
| C-10 | 編集リンクの生成 | E-01 9行目 `href="bs_constantEdit.asp?iContentID=<%=encrypt(keyconstants)%>"` | ○ |
| C-11 | 状態表示（statusString） | E-01 9行目 `cconstants(keyconstants).statusString` | ○ |
| C-12 | sParametersプロパティの存在 | E-02 3行目, 23-24行目 | ○ |
| C-13 | sGlobalプロパティの存在 | E-02 3行目, 24行目 | ○ |
| C-14 | 機能カテゴリが「管理画面/定数」 | E-03 97行目 | ○ |
| C-15 | 関連画面No.94 | E-04 130行目 | ○ |
| C-16 | bs_constantTest.aspのエラーハンドリング詳細 | **根拠不足** - テストファイルの実装確認が必要 | △ |

## 4) 不足情報（Unknown / Missing）
- bs_constantTest.aspの詳細な実装（エラーハンドリング方式）
  - 候補：asp/bs_constantTest.asp
- QS_VBScript定数の値
  - 候補：asp/includes/constants.asp

## 5) リスクフラグ（レビュー観点）
- 2: VBScript実行のセキュリティリスク（任意コード実行が可能）
- 0: 権限チェック・アクセス制御（根拠十分）
- 1: テスト実行時のエラーハンドリング（実装詳細未確認）

## 6) レビュアーチェックリスト（最小）
- [ ] bHomeVBScript権限のデフォルト値が適切であることを確認
- [ ] bApplication設定の影響範囲を確認
- [ ] VBScript内でのファイルシステムアクセス制限を確認
- [ ] bs_constantTest.aspがサンドボックス環境で実行されることを確認
- [ ] 本番環境でのエラー非表示が正しく機能することを確認
