---
generated_at: 2026-01-23 11:00:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：97-バックオフィス検索

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **treatParentheses関数の実装**：関数の定義場所を確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_search.asp` - バックオフィス検索メインファイル
- E-02: `asp/includes/fullsearch.asp` - cls_fullSearchクラス定義
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | セカンドアドミン制限 | E-01 4行目 `if logon.currentPW=customer.secondAdmin.sPassword then Response.redirect` | ○ |
| C-02 | 検索説明文の表示 | E-01 4行目 `l("sitesearchexpl")` | ○ |
| C-03 | CSRFトークン（hidden） | E-01 4行目 `QS_secCodeHidden` | ○ |
| C-04 | required属性 | E-01 4行目 `required type="text"` | ○ |
| C-05 | postback判定 | E-01 6行目 `postback=convertBool(Request.Form("postback"))` | ○ |
| C-06 | CSRFチェック実行 | E-01 8行目 `checkCSRF()` | ○ |
| C-07 | cls_fullSearch使用 | E-01 10行目 `set fsearch=new cls_fullSearch` | ○ |
| C-08 | treatParentheses関数使用 | E-01 11行目 `treatParentheses(Request.Form("svalue"))` | ○ |
| C-09 | 検索結果の空チェック | E-01 14行目 `if not isLeeg(result) then` | ○ |
| C-10 | 0件メッセージ表示 | E-01 17行目 `l("thereAre") & " 0 " & l("resultsForSearch")` | ○ |
| C-11 | 自動フォーカス | E-01 5行目 `document.bs.svalue.focus()` | ○ |
| C-12 | cls_fullSearchのクラス定義 | E-02 2行目 `class cls_fullSearch` | ○ |
| C-13 | pages関数の実装 | E-02 79-93行目 `public function pages` | ○ |
| C-14 | constants関数の実装 | E-02 94-108行目 `public function constants` | ○ |
| C-15 | forms関数の実装 | E-02 109-123行目 `public function forms` | ○ |
| C-16 | templates関数の実装 | E-02 139-153行目 `public function templates` | ○ |
| C-17 | search関数の結果集約 | E-02 265-400行目 `public function search` | ○ |
| C-18 | 機能カテゴリが「管理画面/検索」 | E-03 98行目 | ○ |
| C-19 | 関連画面No.21 | E-04 34行目 | ○ |
| C-20 | treatParentheses関数の実装詳細 | **根拠不足** - 関数定義ファイル未特定 | △ |

## 4) 不足情報（Unknown / Missing）
- treatParentheses関数の定義場所と実装詳細
  - 候補：asp/includes/functions.asp / asp/begin.asp

## 5) リスクフラグ（レビュー観点）
- 0: セキュリティチェック・CSRF対策（根拠十分）
- 0: 検索ロジック（ソースコードで確認済み）
- 1: 大量データ時のパフォーマンス（全テーブルスキャン）

## 6) レビュアーチェックリスト（最小）
- [ ] セカンドアドミン制限が正しく機能することを確認
- [ ] treatParentheses関数がSQLインジェクション対策として機能することを確認
- [ ] 大量コンテンツ時の検索パフォーマンスを検証
- [ ] 検索結果から編集画面へのリンクが正しく機能することを確認
