---
generated_at: 2026-01-23 11:05:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：98-ページ検証

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **customer.pagesTobeValidatedの実装**：プロパティの実装詳細を確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_validatepage.asp` - 個別ページ検証画面
- E-02: `asp/bs_validatepages.asp` - 検証待ちページ一覧
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | cls_pageでページデータ取得 | E-01 5-6行目 `set pobj=new cls_page` `pobj.pick` | ○ |
| C-02 | 4種類のアクション分岐 | E-01 7-32行目 `select case Request.Form("btnValidate")` | ○ |
| C-03 | タイトル承認処理 | E-01 8-14行目 `case "Save and Validate New Title"` | ○ |
| C-04 | タイトル却下処理 | E-01 15-19行目 `case "Remove New Title"` | ○ |
| C-05 | 本文承認処理 | E-01 20-26行目 `case "Save and Validate New Text"` | ○ |
| C-06 | 本文却下処理 | E-01 27-31行目 `case "Remove New Text"` | ○ |
| C-07 | sendMailToContact関数 | E-01 33-44行目 | ○ |
| C-08 | cls_contact使用 | E-01 35-36行目 `set nContact=new cls_contact` | ○ |
| C-09 | cls_mail_message使用 | E-01 38-42行目 `set notifMail=new cls_mail_message` | ○ |
| C-10 | pobj.save()で保存 | E-01 12-13行目, 17-18行目 | ○ |
| C-11 | 確認ダイアログ（confirm） | E-01 46-47行目 `confirm('Are you sure?')` | ○ |
| C-12 | FCKエディタ使用 | E-01 47行目 `createFCKInstance` | ○ |
| C-13 | customer.pagesTobeValidated | E-02 5行目 `set pv=customer.pagesTobeValidated` | ○ |
| C-14 | 編集者情報（pobj.updater） | E-02 7行目 `pobj.updater.sNickName` | ○ |
| C-15 | 編集日時（pobj.dUpdatedOn） | E-02 7行目 `convertEuroDateTime(pobj.dUpdatedOn)` | ○ |
| C-16 | 戻るリンク | E-02 9行目 `href="bs_default.asp"` | ○ |
| C-17 | 機能カテゴリが「管理画面/ページ検証」 | E-03 99行目 | ○ |
| C-18 | pagesTobeValidatedプロパティの実装詳細 | **根拠不足** - customerクラスの実装確認が必要 | △ |

## 4) 不足情報（Unknown / Missing）
- customer.pagesTobeValidatedプロパティの実装（sTitleToBeValidated/sValueToBeValidatedのフィルタリングロジック）
  - 候補：asp/includes/customer.asp

## 5) リスクフラグ（レビュー観点）
- 0: 承認・却下ロジック（ソースコードで確認済み）
- 0: メール送信処理（実装確認済み）
- 1: 大量の検証待ちページ時のパフォーマンス

## 6) レビュアーチェックリスト（最小）
- [ ] 部分承認（タイトルのみ/本文のみ）が正しく動作することを確認
- [ ] メール送信が失敗した場合のエラーハンドリングを確認
- [ ] 検証待ちデータがクリアされた後の画面遷移を確認
- [ ] FCKエディタの読み込みエラー時の対処を確認
