---
generated_at: 2026-01-23 11:10:00
metrics:
  claims_total: 26
  claims_with_evidence: 24
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：99-ページ表示

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：24 / 26、根拠なし：2
- 優先レビュー（高）
  1. **showFromCacheの実装**：キャッシュ機構の詳細確認が必要
  2. **addVisitのセッション判定**：訪問者カウントロジックの確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/process.asp` - メイン処理ロジック
- E-02: `default.asp` - サイトルートエントリーポイント
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | デフォルトPWチェック | E-01 2-6行目 `if customer.adminPassword=sha256(QS_defaultPW)` | ○ |
| C-02 | モバイルブラウザ判定 | E-01 8行目 `checkMobileBrowser()` | ○ |
| C-03 | UFL検索 | E-01 11行目 `selectedPage.pickByUserFriendlyURL()` | ○ |
| C-04 | pageAction分岐 | E-01 40行目 `select case lcase(convertStr(request("pageAction")))` | ○ |
| C-05 | 検索処理インクルード | E-01 50行目 `<!-- #include file="process_search.asp"-->` | ○ |
| C-06 | 投票処理 | E-01 61-81行目 `case "vote"`, `case "voteshowresults"` | ○ |
| C-07 | ログイン処理インクルード | E-01 133行目 `<!-- #include file="process_login.asp"-->` | ○ |
| C-08 | イントラネットログイン | E-01 145行目 `<!-- #include file="process_loginIntranet.asp"-->` | ○ |
| C-09 | ログオフ処理 | E-01 156-164行目 `case lcase(cLogOff)` | ○ |
| C-10 | オフラインページ判定 | E-01 189-205行目 `if not selectedPage.bOnline then` | ○ |
| C-11 | パスワード認証チェック | E-01 219行目 `if logon.logonItem(...)` | ○ |
| C-12 | イントラネット認証チェック | E-01 220-230行目 `if selectedPage.bIntranet then` | ○ |
| C-13 | コンテナページ処理 | E-01 232-233行目 `if selectedPage.bContainerPage then` | ○ |
| C-14 | 外部URLリダイレクト | E-01 234-235行目 `if not isLeeg(selectedPage.sExternalURL)` | ○ |
| C-15 | リストページ処理インクルード | E-01 239行目 `<!-- #include file="process_listpage.asp"-->` | ○ |
| C-16 | フォーム組み込み | E-01 242行目 `pageForm=selectedPage.form.build(...)` | ○ |
| C-17 | テーマ組み込み | E-01 246行目 `pageTheme=selectedPage.theme.build()` | ○ |
| C-18 | カタログ処理インクルード | E-01 249行目 `<!-- #include file="process_catalog.asp"-->` | ○ |
| C-19 | フィード組み込み | E-01 252行目 `pageFeed=selectedPage.Feed.build()` | ○ |
| C-20 | ヒット数記録 | E-01 268行目 `selectedPage.AddHit()` | ○ |
| C-21 | 訪問者数記録 | E-01 269行目 `selectedPage.addVisit()` | ○ |
| C-22 | テンプレート適用 | E-01 279行目 `selectedPage.buildTemplate()` | ○ |
| C-23 | 404ページ処理 | E-01 25-32行目 `if selectedPage.b404 then` | ○ |
| C-24 | 機能カテゴリが「フロントエンド/表示」 | E-03 100行目 | ○ |
| C-25 | showFromCacheメソッドの実装詳細 | **根拠不足** - ページクラスの実装確認が必要 | △ |
| C-26 | addVisitのセッション初回判定 | **根拠不足** - メソッド実装確認が必要 | △ |

## 4) 不足情報（Unknown / Missing）
- showFromCacheメソッドの実装（キャッシュ機構）
  - 候補：asp/includes/page.asp
- addVisitメソッドのセッション判定ロジック
  - 候補：asp/includes/page.asp

## 5) リスクフラグ（レビュー観点）
- 0: pageAction分岐ロジック（ソースコードで確認済み）
- 0: 認証チェック（実装確認済み）
- 1: キャッシュ機構の整合性（詳細未確認）

## 6) レビュアーチェックリスト（最小）
- [ ] デフォルトPWチェックがdevVersion時に正しくスキップされることを確認
- [ ] UFL検索のパフォーマンスを確認
- [ ] pageActionの全分岐が適切に処理されることを確認
- [ ] 統計カウントの正確性を確認
- [ ] テンプレート適用時のエラーハンドリングを確認
