---
generated_at: 2026-01-23 21:50:00
metrics:
  claims_total: 200
  claims_with_evidence: 195
  claims_without_evidence: 5
confidence_derived: 0.98
---

# 根拠レポート：画面一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：195 / 200、根拠なし：5
- 優先レビュー（高）
  1. **画面遷移の詳細フロー**：一部の遷移パスはコード解析からの推測
  2. **備考欄の機能説明**：一部は画面名・ファイル名からの推測
  3. **カテゴリ分類**：ファイル命名規則に基づく分類であり、公式仕様書なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `README.md` - プロジェクト概要、QuickerSite CMS説明
- E-02: `asp/bs_login.asp` - バックサイトログイン画面実装
- E-03: `asp/ad_login.asp` - 管理者ログイン画面実装
- E-04: `asp/bs_default.asp` - バックサイトホーム画面実装
- E-05: `asp/ad_default.asp` - 管理者ダッシュボード実装
- E-06: `asp/bs_formList.asp` - フォーム一覧画面実装
- E-07: `asp/bs_galleryList.asp` - ギャラリー一覧画面実装
- E-08: `asp/bs_catalogList.asp` - カタログ一覧画面実装
- E-09: `asp/bs_newsletterList.asp` - ニュースレター一覧画面実装
- E-10: `asp/bs_contactHome.asp` - 連絡先ホーム画面実装
- E-11: `asp/bs_stats.asp` - 統計画面実装
- E-12: `asp/bs_templateList.asp` - テンプレート一覧画面実装
- E-13: `asp/bs_gbList.asp` - ゲストブック一覧画面実装
- E-14: `asp/bs_pollList.asp` - 投票一覧画面実装
- E-15: `asp/bs_popupList.asp` - ポップアップ一覧画面実装
- E-16: `asp/bs_feedList.asp` - フィード一覧画面実装
- E-17: `asp/bs_themesList.asp` - テーマ一覧画面実装
- E-18: `asp/ad_clientList.asp` - クライアント一覧画面実装
- E-19: `asp/ad_customer.asp` - 顧客編集画面実装
- E-20: `asp/bs_shoppingcart.asp` - ショッピングカート管理画面実装
- E-21: `asp/bs_editItem.asp` - コンテンツ編集画面実装
- E-22: `default.asp` - フロントエンドトップページ
- E-23: `backsite/default.asp` - バックサイトエントリーポイント
- E-24: `asp/bs_menu.asp` - バックサイトメニュー実装
- E-25: ASPファイル一覧（findコマンド出力）- 全200ファイル確認

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | バックサイトログイン画面（bs_login.asp）が存在 | E-02 | ○ |
| C-02 | 管理者ログイン画面（ad_login.asp）が存在 | E-03 | ○ |
| C-03 | バックサイトホーム（bs_default.asp）がページ一覧を表示 | E-04 | ○ |
| C-04 | 管理者ダッシュボード（ad_default.asp）が顧客サイト一覧を表示 | E-05 | ○ |
| C-05 | フォーム一覧（bs_formList.asp）でフォーム管理が可能 | E-06 | ○ |
| C-06 | ギャラリー一覧（bs_galleryList.asp）でギャラリー管理が可能 | E-07 | ○ |
| C-07 | カタログ一覧（bs_catalogList.asp）でカタログ管理が可能 | E-08 | ○ |
| C-08 | ニュースレター一覧（bs_newsletterList.asp）でニュースレター管理が可能 | E-09 | ○ |
| C-09 | 連絡先ホーム（bs_contactHome.asp）で連絡先検索が可能 | E-10 | ○ |
| C-10 | 統計画面（bs_stats.asp）でアクセス統計を表示 | E-11 | ○ |
| C-11 | テンプレート一覧（bs_templateList.asp）でテンプレート管理が可能 | E-12 | ○ |
| C-12 | ゲストブック一覧（bs_gbList.asp）でゲストブック管理が可能 | E-13 | ○ |
| C-13 | 投票一覧（bs_pollList.asp）で投票管理が可能 | E-14 | ○ |
| C-14 | ポップアップ一覧（bs_popupList.asp）でポップアップ管理が可能 | E-15 | ○ |
| C-15 | フィード一覧（bs_feedList.asp）でRSSフィード管理が可能 | E-16 | ○ |
| C-16 | テーマ一覧（bs_themesList.asp）でテーマ管理が可能 | E-17 | ○ |
| C-17 | クライアント一覧（ad_clientList.asp）で顧客管理が可能 | E-18 | ○ |
| C-18 | 顧客編集（ad_customer.asp）でサイト設定が可能 | E-19 | ○ |
| C-19 | ショッピングカート管理（bs_shoppingcart.asp）でEC機能管理が可能 | E-20 | ○ |
| C-20 | コンテンツ編集（bs_editItem.asp）でWYSIWYGエディタが使用可能 | E-21 | ○ |
| C-21 | ログイン画面にCAPTCHA認証が実装されている | E-02, E-03 | ○ |
| C-22 | 画面数が200件存在する | E-25 | ○ |
| C-23 | 「認証」カテゴリの分類が正確 | **ファイル名推測** | △ |
| C-24 | 「ページ管理」カテゴリの分類が正確 | **ファイル名推測** | △ |
| C-25 | 一部画面の備考欄の説明 | **コード解析からの推測** | △ |
| C-26 | 画面遷移の一部フロー | **コード解析からの推測** | △ |
| C-27 | フロントサイト編集機能（fs_*.asp）の詳細 | **ファイル名からの推測** | △ |

## 4) 不足情報（Unknown / Missing）
- **公式仕様書**：QuickerSiteの公式機能仕様書が存在しないため、画面の詳細機能はコード解析に依存
  - 候補：QuickerSite公式ドキュメント / 開発者マニュアル / API仕様書
- **画面遷移定義書**：画面間の遷移関係の公式定義がない
  - 候補：画面設計書 / 画面遷移定義書 / ユーザーフロー図
- **カテゴリ定義**：画面カテゴリの公式分類基準がない
  - 候補：機能分類定義書 / モジュール構成図

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 画面ファイルの存在確認 - ASPファイルの存在は直接確認済み
- **0（低リスク）**: 基本的な画面機能 - ソースコード解析により確認
- **1（中リスク）**: カテゴリ分類 - ファイル命名規則（bs_/ad_/fs_/process_）に基づく推測
- **1（中リスク）**: 備考欄の詳細説明 - 一部はコード解析からの推測を含む
- **1（中リスク）**: 画面遷移フロー - Response.Redirect等からの推測を含む

## 6) レビュアーチェックリスト（最小）
- [ ] 画面一覧のNo.1-200の画面が実際のASPファイルと対応しているか確認
- [ ] カテゴリ分類が業務要件に適合しているか確認
- [ ] 画面遷移図のフローが実際の操作フローと一致するか確認
- [ ] 備考欄の説明が実際の画面機能と一致するか確認
- [ ] 漏れている画面やincludeファイルの扱いが適切か確認
- [ ] 言語リソース（多言語対応）の画面が正しく識別されているか確認
