# QuickerSite 画面遷移図

## 概要

QuickerSiteは、Windows Server（IIS）上で動作するASP/VBScriptベースのCMSです。本ドキュメントでは、主要な画面遷移を図示します。

## 全体構成

```mermaid
graph TB
    subgraph "エントリーポイント"
        TOP[default.asp<br>トップページ]
        INDEX[index.asp<br>インデックス]
        BACKSITE[backsite/default.asp<br>バックサイトエントリー]
    end

    subgraph "認証"
        BS_LOGIN[bs_login.asp<br>バックサイトログイン]
        AD_LOGIN[ad_login.asp<br>管理者ログイン]
        BS_LOGOFF[bs_logoff.asp<br>ログオフ]
        AD_LOGOFF[ad_logoff.asp<br>管理者ログオフ]
    end

    subgraph "バックサイトホーム"
        BS_DEFAULT[bs_default.asp<br>バックサイトホーム]
        AD_DEFAULT[ad_default.asp<br>管理者ダッシュボード]
    end

    INDEX --> TOP
    BACKSITE --> BS_LOGIN
    BS_LOGIN -->|認証成功| BS_DEFAULT
    BS_LOGIN -->|管理者認証| AD_LOGIN
    AD_LOGIN -->|認証成功| AD_DEFAULT
    BS_DEFAULT --> BS_LOGOFF
    AD_DEFAULT --> AD_LOGOFF
```

## バックサイト画面遷移

```mermaid
graph TB
    subgraph "バックサイトホーム"
        BS_DEFAULT[bs_default.asp<br>ホーム]
    end

    subgraph "ページ管理"
        SETUP_PAGE[bs_setupPage.asp<br>ページ作成]
        EDIT_ITEM[bs_editItem.asp<br>コンテンツ編集]
        LIST_PAGE[bs_listPage.asp<br>リストページ]
        EDIT_LIST_ITEM[bs_editListItem.asp<br>リストアイテム編集]
        EDIT_CONTAINER[bs_editContainer.asp<br>コンテナ編集]
        EDIT_EXTERNAL[bs_editExternalURL.asp<br>外部URL編集]
        DELETE[bs_delete.asp<br>削除確認]
        SELECT_PAGE[bs_selectPage.asp<br>ページ選択]
    end

    subgraph "フォーム管理"
        FORM_LIST[bs_formList.asp<br>フォーム一覧]
        FORM_EDIT[bs_formEdit.asp<br>フォーム編集]
        FORM_FIELDS[bs_formFields.asp<br>フィールド一覧]
        FORM_FIELD_EDIT[bs_FormFieldEdit.asp<br>フィールド編集]
        FORM_PREVIEW[bs_formPreview.asp<br>プレビュー]
        FORM_EXPORT[bs_formExport.asp<br>データエクスポート]
    end

    subgraph "コンテンツ管理"
        GALLERY_LIST[bs_galleryList.asp<br>ギャラリー一覧]
        GALLERY_EDIT[bs_galleryEdit.asp<br>ギャラリー編集]
        CATALOG_LIST[bs_catalogList.asp<br>カタログ一覧]
        CATALOG_EDIT[bs_catalogEdit.asp<br>カタログ編集]
        GB_LIST[bs_gbList.asp<br>ゲストブック一覧]
        GB_EDIT[bs_gbEdit.asp<br>ゲストブック編集]
        POLL_LIST[bs_pollList.asp<br>投票一覧]
        POLL_EDIT[bs_pollEdit.asp<br>投票編集]
    end

    subgraph "設定"
        TEMPLATE_LIST[bs_templateList.asp<br>テンプレート一覧]
        TEMPLATE_EDIT[bs_templateEdit.asp<br>テンプレート編集]
        STATS[bs_stats.asp<br>統計]
        FAVICON[bs_favicon.asp<br>ファビコン設定]
        VARIABLE[bs_variables.asp<br>変数設定]
    end

    BS_DEFAULT --> SETUP_PAGE
    BS_DEFAULT --> EDIT_ITEM
    BS_DEFAULT --> LIST_PAGE
    BS_DEFAULT --> FORM_LIST
    BS_DEFAULT --> GALLERY_LIST
    BS_DEFAULT --> CATALOG_LIST
    BS_DEFAULT --> GB_LIST
    BS_DEFAULT --> POLL_LIST
    BS_DEFAULT --> TEMPLATE_LIST
    BS_DEFAULT --> STATS

    SETUP_PAGE --> EDIT_ITEM
    SETUP_PAGE --> LIST_PAGE
    SETUP_PAGE --> EDIT_CONTAINER
    SETUP_PAGE --> EDIT_EXTERNAL

    EDIT_ITEM --> DELETE
    EDIT_ITEM --> SELECT_PAGE

    LIST_PAGE --> EDIT_LIST_ITEM

    FORM_LIST --> FORM_EDIT
    FORM_EDIT --> FORM_FIELDS
    FORM_FIELDS --> FORM_FIELD_EDIT
    FORM_LIST --> FORM_PREVIEW
    FORM_LIST --> FORM_EXPORT

    GALLERY_LIST --> GALLERY_EDIT
    CATALOG_LIST --> CATALOG_EDIT
    GB_LIST --> GB_EDIT
    POLL_LIST --> POLL_EDIT
    TEMPLATE_LIST --> TEMPLATE_EDIT
```

## ニュースレター画面遷移

```mermaid
graph TB
    subgraph "ニュースレター管理"
        NL_LIST[bs_newsletterList.asp<br>ニュースレター一覧]
        NL_EDIT[bs_newsletterEdit.asp<br>ニュースレター編集]
        NL_SUBS[bs_newsletterSubscribers.asp<br>購読者一覧]
        NL_SUB_EDIT[bs_newsletterSubscriber.asp<br>購読者編集]
        NL_IMPORT[bs_newsletterImport.asp<br>インポート]
        NL_CAT_LIST[bs_newsletterCategoryList.asp<br>カテゴリ一覧]
        NL_CAT_EDIT[bs_newsletterCategoryEdit.asp<br>カテゴリ編集]
        NL_MAIL_EDIT[bs_newsletterMailingEdit.asp<br>配信編集]
        NL_MAIL_SEND[bs_newsletterMailingSend.asp<br>配信送信]
        NL_MAIL_HIST[bs_newsletterMailingHistory.asp<br>配信履歴]
    end

    NL_LIST --> NL_EDIT
    NL_LIST --> NL_SUBS
    NL_LIST --> NL_CAT_LIST
    NL_LIST --> NL_MAIL_EDIT
    NL_LIST --> NL_MAIL_HIST

    NL_SUBS --> NL_SUB_EDIT
    NL_SUBS --> NL_IMPORT
    NL_CAT_LIST --> NL_CAT_EDIT
    NL_MAIL_EDIT --> NL_MAIL_SEND
```

## 連絡先管理画面遷移

```mermaid
graph TB
    subgraph "連絡先管理"
        CONTACT_HOME[bs_contactHome.asp<br>連絡先ホーム]
        CONTACT_EDIT[bs_contactEdit.asp<br>連絡先編集]
        CONTACT_FIELDS[bs_contactFields.asp<br>フィールド一覧]
        CONTACT_FIELD_EDIT[bs_contactFieldEdit.asp<br>フィールド編集]
        CONTACT_PAGE[bs_contactPage.asp<br>連絡先ページ]
        CONTACT_ACTIONS[bs_contactSelectionActions.asp<br>一括操作]
        TICKETS[bs_tickets.asp<br>チケット管理]
    end

    CONTACT_HOME --> CONTACT_EDIT
    CONTACT_HOME --> CONTACT_FIELDS
    CONTACT_HOME --> TICKETS
    CONTACT_HOME --> CONTACT_ACTIONS
    CONTACT_FIELDS --> CONTACT_FIELD_EDIT
```

## ショッピングカート画面遷移

```mermaid
graph TB
    subgraph "ショッピングカート管理"
        SHOP_CART[bs_shoppingcart.asp<br>ショッピングカート管理]
        SHOP_CAT[bs_shopAdCat.asp<br>カテゴリ管理]
        SHOP_MAKE[bs_shopMake.asp<br>メーカー管理]
        SHOP_PRODUCT[bs_shopProduct.asp<br>商品管理]
        SHOP_PROD_CAT[bs_shopProductCat.asp<br>商品カテゴリ]
        SHOP_PROD_IMG[bs_shopProductImg.asp<br>商品画像]
        SHOP_PROD_UPLOAD[bs_shopProductImgUpload.asp<br>画像アップロード]
    end

    SHOP_CART --> SHOP_CAT
    SHOP_CART --> SHOP_MAKE
    SHOP_CART --> SHOP_PRODUCT
    SHOP_PRODUCT --> SHOP_PROD_CAT
    SHOP_PRODUCT --> SHOP_PROD_IMG
    SHOP_PROD_IMG --> SHOP_PROD_UPLOAD
```

## カレンダー画面遷移

```mermaid
graph TB
    subgraph "カレンダー管理"
        AC[bs_ac.asp<br>カレンダー管理]
        AC_BOOKINGS[bs_ac_bookings.asp<br>予約一覧]
        AC_BOOKING[bs_ac_booking.asp<br>予約編集]
        AC_CALENDAR[bs_ac_calendar.asp<br>カレンダー表示]
        AC_VIEW[bs_ac_view.asp<br>ビュー]
        AC_MYCALS[bs_ac_mycals.asp<br>マイカレンダー]
        AC_EMBED[bs_ac_embed.asp<br>埋め込みコード]
        AC_MENU[bs_ac_menu.asp<br>メニュー]
    end

    AC --> AC_BOOKINGS
    AC --> AC_CALENDAR
    AC --> AC_MYCALS
    AC --> AC_EMBED
    AC --> AC_MENU
    AC_BOOKINGS --> AC_BOOKING
    AC_CALENDAR --> AC_VIEW
```

## 管理者画面遷移

```mermaid
graph TB
    subgraph "管理者ダッシュボード"
        AD_DEFAULT[ad_default.asp<br>ダッシュボード]
    end

    subgraph "顧客管理"
        AD_CLIENT_LIST[ad_clientList.asp<br>クライアント一覧]
        AD_CLIENT[ad_client.asp<br>クライアント詳細]
        AD_CUSTOMER[ad_customer.asp<br>顧客編集]
        AD_PRODUCTS[ad_clientproducts.asp<br>製品一覧]
        AD_PRODUCT[ad_clientproduct.asp<br>製品詳細]
    end

    subgraph "システム管理"
        AD_PAGELIST[ad_pageList.asp<br>ページ一覧]
        AD_FORMENTRIES[ad_formentries.asp<br>フォームエントリー]
        AD_GBENTRIES[ad_gbentries.asp<br>GBエントリー]
        AD_REFERER[ad_refererList.asp<br>リファラー一覧]
        AD_MONITOR[ad_monitor.asp<br>モニター]
        AD_LABELS[ad_labels.asp<br>ラベル一覧]
        AD_LABEL[ad_label.asp<br>ラベル編集]
        AD_IIS[ad_iis.asp<br>IIS管理]
        AD_BINDINGS[ad_editbindings.asp<br>バインディング]
    end

    subgraph "サイト操作"
        AD_COPYSITE[ad_copysite.asp<br>サイトコピー]
        AD_UPGRADE[ad_upgrade.asp<br>アップグレード]
        AD_RESET[ad_resetAllAPP.asp<br>リセット]
    end

    AD_DEFAULT --> AD_CLIENT_LIST
    AD_DEFAULT --> AD_CUSTOMER
    AD_DEFAULT --> AD_PAGELIST
    AD_DEFAULT --> AD_FORMENTRIES
    AD_DEFAULT --> AD_MONITOR
    AD_DEFAULT --> AD_LABELS
    AD_DEFAULT --> AD_IIS
    AD_DEFAULT --> AD_COPYSITE
    AD_DEFAULT --> AD_UPGRADE
    AD_DEFAULT --> AD_RESET

    AD_CLIENT_LIST --> AD_CLIENT
    AD_CLIENT --> AD_PRODUCTS
    AD_PRODUCTS --> AD_PRODUCT
    AD_CUSTOMER --> AD_BINDINGS
    AD_LABELS --> AD_LABEL
```

## フロントエンド画面遷移

```mermaid
graph TB
    subgraph "フロントエンド"
        DEFAULT[default.asp<br>トップページ]
        RSS[rss.asp<br>RSSフィード]
        SITEMAP[sitemap.asp<br>サイトマップ]
        MAILPAGE[mailPage.asp<br>メール送信]
        PRINTPAGE[printPage.asp<br>印刷ページ]
    end

    subgraph "処理"
        PROCESS_LOGIN[process_login.asp<br>ログイン処理]
        PROCESS_SEARCH[process_search.asp<br>検索処理]
        PROCESS_SEND[process_send.asp<br>メール送信処理]
        PROCESS_REGISTER[process_register.asp<br>登録処理]
        PROCESS_CATALOG[process_catalog.asp<br>カタログ処理]
        PROCESS_LISTPAGE[process_listpage.asp<br>リストページ処理]
        PROCESS_SHOWITEM[process_showitem.asp<br>アイテム表示処理]
    end

    subgraph "フロントサイト編集"
        FS_EDITPAGE[fs_editPage.asp<br>ページ編集]
        FS_EDITLISTPAGE[fs_editListPage.asp<br>リストページ編集]
        FS_EDITLISTITEM[fs_editListItem.asp<br>リストアイテム編集]
    end

    DEFAULT --> RSS
    DEFAULT --> SITEMAP
    DEFAULT --> MAILPAGE
    DEFAULT --> PRINTPAGE
    DEFAULT --> PROCESS_LOGIN
    DEFAULT --> PROCESS_SEARCH
    DEFAULT --> PROCESS_CATALOG
    DEFAULT --> PROCESS_LISTPAGE
    DEFAULT --> PROCESS_SHOWITEM
    MAILPAGE --> PROCESS_SEND
    DEFAULT --> FS_EDITPAGE
    DEFAULT --> FS_EDITLISTPAGE
    FS_EDITLISTPAGE --> FS_EDITLISTITEM
```

## 画面遷移の特徴

1. **マルチレイヤー構造**: QuickerSiteは、フロントエンド、バックサイト（管理画面）、管理者画面の3層構造を持つ
2. **認証レベル**: 各層で異なる認証レベルが設定されている（一般ユーザー、サイト管理者、システム管理者）
3. **インライン編集**: フロントサイトからの直接編集機能（fs_*.asp）を提供
4. **モジュール化**: フォーム、ギャラリー、カタログ、ニュースレターなど機能ごとにモジュール化されている

## 凡例

- **bs_*.asp**: バックサイト（サイト管理者向け）画面
- **ad_*.asp**: 管理者（システム管理者向け）画面
- **fs_*.asp**: フロントサイト編集画面
- **process_*.asp**: フロントエンド処理スクリプト
