---
generated_at: 2026-01-23 10:30:00
metrics:
  claims_total: 232
  claims_with_evidence: 228
  claims_without_evidence: 4
confidence_derived: 0.98
---

# 根拠レポート：画面機能マッピング.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：228 / 232、根拠なし：4
- 優先レビュー（高）
  1. **画面No.97 フィードバック → 機能No.91 アクセス統計表示**：関連性推定
  2. **画面No.144 モニター → 機能No.91 アクセス統計表示**：関連性推定
  3. **画面No.200 404エラー → 機能No.35 カスタム404ページ設定**：ファイル構造からの推定
  4. **一部の「補助機能」関連**：コード解析に基づく推定

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-03: `asp/bs_login.asp`
- E-04: `asp/bs_default.asp`
- E-05: `asp/bs_formList.asp`
- E-06: `asp/bs_formEdit.asp`
- E-07: `asp/bs_catalogList.asp`
- E-08: `asp/bs_newsletterList.asp`
- E-09: `asp/bs_security.asp`（include参照確認）
- E-10: `asp/includes/captcha.asp`（参照確認）
- E-11: ASPファイル群（約180ファイル）

## 3) Claims と根拠の対応（レビューの主戦場）

### 認証系画面マッピング
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面No.1 バックサイトログイン → 機能No.1 管理者ログイン | E-01, E-02, E-03 | ○ |
| C-02 | 画面No.1 → 機能No.118 CAPTCHA認証 | E-03 captcha参照確認 | ○ |
| C-03 | 画面No.1 → 機能No.117 CSRF対策 | E-03 QS_secCodeHidden参照 | ○ |
| C-04 | 画面No.2 管理者ログイン → 機能No.1 | E-01, E-02 | ○ |
| C-05 | 画面No.3/4 ログオフ → 機能No.2 | E-01, E-02 | ○ |

### ページ管理系画面マッピング
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-06 | 画面No.5 バックサイトホーム → 機能No.8 ページ一覧 | E-04 bs_menu.asp include確認 | ○ |
| C-07 | 画面No.7 ページ作成 → 機能No.9 ページ作成・編集 | E-01, E-02 説明一致 | ○ |
| C-08 | 画面No.8 コンテンツ編集 → 機能No.9 | E-01, E-02 bs_editItem.asp参照 | ○ |
| C-09 | 画面No.9 リストページ編集 → 機能No.13 | E-01, E-02 対応確認 | ○ |
| C-10 | 画面No.15 ページ削除 → 機能No.10 | E-01, E-02 | ○ |

### フォーム管理系画面マッピング
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-11 | 画面No.23 フォーム一覧 → 機能No.39 | E-05 フォーム一覧処理確認 | ○ |
| C-12 | 画面No.23 → 機能No.40/42/44 遷移先 | E-05 リンク確認 | ○ |
| C-13 | 画面No.24 フォーム編集 → 機能No.40 | E-06 フォーム作成・保存処理 | ○ |
| C-14 | 画面No.24 → 機能No.117 CSRF対策 | E-06 checkCSRF()呼び出し | ○ |

### カタログ管理系画面マッピング
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-15 | 画面No.34 カタログ一覧 → 機能No.45 | E-07 カタログ一覧処理確認 | ○ |
| C-16 | 画面No.34 → 機能No.46/47/49 遷移先 | E-07 リンク確認 | ○ |
| C-17 | 画面No.35-41 カタログ関連 | E-01, E-02 対応確認 | ○ |

### ニュースレター管理系画面マッピング
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-18 | 画面No.42 ニュースレター一覧 → 機能No.67 | E-08 ニュースレター一覧処理 | ○ |
| C-19 | 画面No.42 → 機能No.68/69/71 遷移先 | E-08 リンク確認 | ○ |
| C-20 | 画面No.43-51 ニュースレター関連 | E-01, E-02 対応確認 | ○ |

### フロントエンド系画面マッピング
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-21 | 画面No.158 トップページ → 機能No.99 ページ表示 | E-01, E-02 default.asp | ○ |
| C-22 | 画面No.162 RSS → 機能No.114 RSSフィード出力 | E-01, E-02 rss.asp | ○ |
| C-23 | 画面No.163 サイトマップ → 機能No.115 | E-01, E-02 sitemap.asp | ○ |
| C-24 | 画面No.164-174 処理画面 | E-01, E-02 process_*.asp | ○ |

### 根拠不足の主張
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-25 | 画面No.97 フィードバック → 機能No.91 アクセス統計表示 | 画面名と機能説明からの推定 | △ |
| C-26 | 画面No.144 モニター → 機能No.91 アクセス統計表示 | 管理者画面のカテゴリからの推定 | △ |
| C-27 | 一部の補助機能マッピング（サムネイル生成等） | コード構造からの推定 | △ |
| C-28 | 変換系画面（No.181-186）のマッピング | ファイル名からの推定 | △ |

## 4) 不足情報（Unknown / Missing）
- **フィードバック画面の詳細実装**
  - bs_feedback.aspの詳細解析が必要
  - 候補：ユーザーフィードバック管理機能 / アクセス統計関連 / 独自機能
- **モニター画面の具体的機能**
  - ad_monitor.aspの詳細解析が必要
  - 候補：サイト監視機能 / パフォーマンス統計 / エラーログ
- **一部補助機能の正確な関連**
  - インクルードファイルの詳細解析で精度向上可能

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 認証系・ページ管理系マッピング（直接的なコード確認済み）
- **0: 低リスク** - フォーム・カタログ・ニュースレター管理系（コード確認済み）
- **1: 中リスク** - 補助機能・遷移先機能のマッピング（推定含む）
- **1: 中リスク** - フロントエンド処理系のマッピング（ファイル名対応）
- **2: 高リスク** - フィードバック・モニター画面のマッピング（推定度高）

## 6) レビュアーチェックリスト（最小）
- [ ] 画面一覧.csvと機能一覧.csvの全項目がマッピングに含まれているか確認
- [ ] 主機能の関連が業務ロジック上妥当か確認
- [ ] 補助機能・遷移先機能の分類が適切か確認
- [ ] 根拠なし（△）の項目について実際のコードを確認
- [ ] 関連種別（主機能/補助機能/遷移先機能/API連携）の分類基準が一貫しているか確認
- [ ] フィードバック画面（No.97）のマッピングが正確か確認
- [ ] モニター画面（No.144）のマッピングが正確か確認
