# 画面設計書 1-バックサイトログイン画面

## 概要

本ドキュメントは、QuickerSite CMSのバックサイト（管理画面）へのログイン画面について、その機能仕様・画面構成・処理フローを詳細に記述した画面設計書である。

### 本画面の処理概要

この画面は、サイト管理者がバックサイト（CMS管理画面）にアクセスするための認証ゲートウェイとして機能する。パスワード入力とCAPTCHA認証の二重認証により、不正アクセスを防止しながら正規ユーザーのログインを処理する。

**業務上の目的・背景**：CMSのコンテンツ管理機能へのアクセスを制限し、権限のない第三者による不正な編集・削除操作を防ぐことが目的である。ブルートフォース攻撃対策として、ログイン試行回数の制限とCAPTCHA認証を組み合わせ、セキュリティを強化している。

**画面へのアクセス方法**：`/backsite/` または `/asp/bs_login.asp` へ直接アクセスする。認証されていない状態でバックサイトの他のページにアクセスした場合は、自動的にこのログイン画面にリダイレクトされる。

**主要な操作・処理内容**：
1. パスワード入力フィールドにサイト管理者パスワードを入力する
2. CAPTCHAに表示された文字列を入力する
3. ログインボタンを押下して認証を実行する
4. 認証成功時はバックサイトホーム（bs_default.asp）または元々アクセスしようとしていたページへリダイレクトされる
5. 認証失敗時はエラーメッセージとともにログイン画面が再表示される

**画面遷移**：
- 遷移元：backsite/default.asp（バックサイトエントリーポイント）、直接URLアクセス、認証切れ時のリダイレクト
- 遷移先：bs_default.asp（バックサイトホーム）、リクエストされた元ページ、bs_initialsetup.asp（デフォルトパスワード使用時）

**権限による表示制御**：この画面自体は未認証ユーザー向けの画面であり、権限による表示制御はない。ただし、ログイン時にセカンド管理者としてログインした場合と、フル管理者としてログインした場合で、ログイン後に利用できる機能が異なる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | 管理者ログイン | 主機能 | パスワードとCAPTCHA認証によるログイン処理の主画面 |
| 118 | CAPTCHA認証 | 補助機能 | スパム防止用の画像認証表示・検証 |
| 117 | CSRF対策 | 補助機能 | セキュリティトークンによるリクエスト検証 |

## 画面種別

認証画面（ログインフォーム）

## URL/ルーティング

- `/asp/bs_login.asp`
- `/backsite/default.asp` 経由でリダイレクト

## 入出力項目

| 項目名 | 項目ID | 入力/出力 | データ型 | 最大長 | 必須 | 説明 |
|--------|--------|----------|----------|--------|------|------|
| パスワード | password | 入力 | 文字列 | 50 | 必須 | サイト管理者パスワード |
| CAPTCHA | captcha | 入力 | 文字列 | 4 | 必須 | 画像認証の入力値 |
| ボタンアクション | btnaction | Hidden | 文字列 | - | - | 固定値「Login」 |
| 遷移先ページ | bs_page | Hidden | 文字列 | - | - | ログイン後の遷移先URL |

## 表示項目

| 項目名 | 表示位置 | 説明 |
|--------|----------|------|
| セキュリティ警告 | 上部中央 | IPブロック等の警告メッセージ |
| デフォルトパスワード警告 | 上部中央 | デフォルトパスワード使用時の警告 |
| パスワードラベル | フォーム内 | 多言語対応ラベル |
| CAPTCHAラベル | フォーム内 | 多言語対応ラベル |
| CAPTCHA画像 | フォーム内 | includes/captcha.asp で生成 |
| ログインボタン | フォーム内 | 多言語対応ラベル |
| 試行回数表示 | 下部中央 | 現在のログイン試行回数と上限警告 |

## イベント仕様

### 1-ログインボタン押下

**処理フロー**：
1. フォームをPOST送信（btnaction="Login"）
2. Session("captcha")と入力されたcaptcha値を比較（先頭4文字、大文字小文字無視）
3. CAPTCHAが一致しない場合：err_captchaエラーを追加
4. CAPTCHAが一致する場合：logon.logon関数を呼び出し、入力パスワードをSHA256ハッシュ化して検証
5. 認証成功時：
   - bs_pageパラメータが空の場合：bs_default.aspにリダイレクト
   - bs_pageにcontactEdit.aspが含まれる場合：session("bLoadCPinPP")を設定
   - その他：指定されたbs_pageにリダイレクト
6. 認証失敗時：err_loginエラーを追加
7. ログイン試行回数をApplication変数でカウント

### 2-IPブロック処理

**処理フロー**：
1. application("bsLoginCount"&UserIP)の値がQS_number_of_allowed_attempts_to_loginを超過した場合
2. lockBSAdmin関数でエラーを発生させ、アクセスを遮断
3. 管理者にメール通知（初回のみ）

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| ログイン成功時 | なし | - | データベース更新なし（Session変数のみ更新） |

### テーブル別更新項目詳細

本画面ではデータベースへの直接的な更新は行わない。認証状態はSessionおよびApplication変数で管理される。

**Application変数**：
- `bsLoginCount{UserIP}`: ログイン試行回数（IPアドレス別）

**Session変数**：
- `{cId}isAUTHENTICATED`: 認証フラグ
- `{cId}isAUTHENTICATEDSecondAdmin`: セカンド管理者認証フラグ

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 発生条件 |
|-------------|------|---------------|----------|
| err_captcha | エラー | CAPTCHA認証エラー | CAPTCHA入力が画像と一致しない |
| err_login | エラー | ログインエラー | パスワードが正しくない |
| lastchance | 警告 | 最後のチャンス警告 | 試行回数が上限に達した |

## 例外処理

| 例外状態 | 処理内容 |
|---------|----------|
| IPブロック状態 | エラーページへリダイレクト、管理者にメール通知 |
| デフォルトパスワード使用 | 警告表示後、初期設定画面へ強制リダイレクト |
| Cookie無効 | QS_enableCookieModeの設定に応じた代替処理 |

## 備考

- CAPTCHAはセッションに保存され、includes/captcha.aspで画像が動的生成される
- パスワードはSHA256でハッシュ化して検証される
- セカンド管理者としてログインした場合は、機能制限された状態でログインが完了する
- デフォルトパスワード（"admin"）使用時は、開発モード以外では強制的に初期設定画面へ遷移

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、認証に関わるデータ構造とセッション管理を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | logonEdit.asp | `asp/includes/logonEdit.asp` | cls_LogonEditクラスのlogon関数、セッション管理方法 |
| 1-2 | customer.asp | `asp/includes/customer.asp` | cls_customerクラスのadminPassword、secondAdminプロパティ |

**読解のコツ**: ASP/VBScriptではClassキーワードでクラスを定義し、Property GetでゲッターをProperty Setでセッターを定義する。Session変数のキーにcIdを含めることで、マルチテナント対応を実現している。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイルを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_login.asp | `asp/bs_login.asp` | ログイン画面のメインファイル、フォーム処理ロジック |

**主要処理フロー**:
1. **行8**: Request.Form("btnaction")="Login"でPOST送信を検知
2. **行9**: セッションのCAPTCHAと入力値を比較
3. **行12**: logon.logon関数でパスワード検証（SHA256ハッシュ化）
4. **行14-19**: 認証成功時のリダイレクト処理
5. **行24**: ログイン試行回数のインクリメント
6. **行26**: lockBSAdmin関数でブロック判定

#### Step 3: 認証処理を理解する

認証のコアロジックを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | logonEdit.asp | `asp/includes/logonEdit.asp` | logon関数（行22-44）の認証ロジック |

**主要処理フロー**:
- **行25**: customer.adminPasswordまたはsecondAdmin.sPasswordと比較
- **行27**: Session(cId & "isAUTHENTICATED")をTrueに設定
- **行33-35**: セカンド管理者の場合、専用フラグを設定
- **行41**: 成功時にログイン試行回数をリセット

#### Step 4: セキュリティ処理を理解する

ブルートフォース対策とCAPTCHA処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | logonEdit.asp | `asp/includes/logonEdit.asp` | lockBSAdmin関数（行86-98）のブロック処理 |
| 4-2 | captcha.asp | `asp/includes/captcha.asp` | CAPTCHA画像の生成処理 |

### プログラム呼び出し階層図

```
bs_login.asp (エントリーポイント)
    │
    ├─ begin.asp (初期化)
    │      ├─ database.asp (DB接続)
    │      ├─ customer.asp (顧客情報ロード)
    │      └─ logonEdit.asp (認証クラス)
    │
    ├─ includes/header.asp (共通ヘッダー)
    │
    ├─ logon.logon() (認証処理)
    │      └─ sha256() (パスワードハッシュ)
    │
    ├─ logon.lockBSAdmin() (ブロック判定)
    │      └─ dumpError() (エラー通知)
    │
    └─ includes/footer.asp (共通フッター)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

パスワード ────────▶ SHA256ハッシュ化 ────────▶ Session変数
                           │
                           ▼
CAPTCHA入力 ────────▶ セッション値と比較 ────────▶ 認証結果
                           │
                           ▼
IPアドレス ─────────▶ Application変数で
                     試行回数カウント ────────▶ ブロック判定
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_login.asp | `asp/bs_login.asp` | ソース | ログイン画面メイン |
| begin.asp | `asp/begin.asp` | インクルード | 初期化処理・クラスロード |
| logonEdit.asp | `asp/includes/logonEdit.asp` | インクルード | 認証処理クラス |
| customer.asp | `asp/includes/customer.asp` | インクルード | 顧客情報管理クラス |
| secondAdmin.asp | `asp/includes/secondAdmin.asp` | インクルード | セカンド管理者クラス |
| captcha.asp | `asp/includes/captcha.asp` | インクルード | CAPTCHA画像生成 |
| sha256.asp | `asp/includes/sha256.asp` | インクルード | SHA256ハッシュ関数 |
| header.asp | `asp/includes/header.asp` | テンプレート | 共通ヘッダーHTML |
| footer.asp | `asp/includes/footer.asp` | テンプレート | 共通フッターHTML |
| bs_header.asp | `asp/bs_header.asp` | テンプレート | バックサイト用ヘッダー |
