# 画面設計書 10-リストアイテム編集

## 概要

本ドキュメントは、QuickerSite CMSのリストアイテム編集画面について、その機能仕様・画面構成・処理フローを詳細に記述した画面設計書である。

### 本画面の処理概要

この画面は、リストページに属する個別のリストアイテム（記事、ニュース項目等）のコンテンツを編集する画面である。タイトル、本文、日付、外部URL、フィード連携などの属性を設定できる。

**業務上の目的・背景**：リストページ内の個別アイテムを詳細に編集するための画面である。ニュース記事、ブログ投稿、FAQ項目などの内容を、WYSIWYGエディタを使用して直感的に編集できる。外部URLへのリダイレクトやフィードからのコンテンツ取得にも対応している。

**画面へのアクセス方法**：リストページ管理画面（bs_listPage.asp）から「Add new item」リンクまたは既存アイテムの「Modify」ボタン、直接 `/asp/bs_editListItem.asp?iId={暗号化ID}` へアクセス。

**主要な操作・処理内容**：
1. リストアイテムのタイトルを入力する
2. 公開日（dPage）を設定する
3. 公開期間（dOnlineFrom〜dOnlineUntill）を設定する
4. 外部URLを設定する（オプション）
5. 新しいウィンドウで開くフラグを設定する
6. フィードを関連付ける（オプション）
7. WYSIWYGエディタで本文を編集する
8. ユーザーフレンドリーURLを設定する
9. 保存、リセット、削除を実行する

**画面遷移**：
- 遷移元：bs_listPage.asp（リストページ管理）
- 遷移先：bs_listPage.asp（保存/削除後）

**権限による表示制御**：
- secondAdmin.bPageUFL：ユーザーフレンドリーURL設定の表示/非表示
- customer.bUserFriendlyURL：ユーザーフレンドリーURL機能の有効/無効

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 9 | ページ作成・編集 | 主機能 | リストアイテムの編集・保存 |
| 37 | アセットマネージャー | 補助機能 | 画像・ファイルの挿入・管理 |

## 画面種別

編集画面

## URL/ルーティング

- `/asp/bs_editListItem.asp`
- `/asp/bs_editListItem.asp?iId={暗号化ID}`（既存編集）
- `/asp/bs_editListItem.asp?iListPageID={暗号化ID}`（新規作成）

## 入出力項目

| 項目名 | 項目ID | 入力/出力 | データ型 | 最大長 | 必須 | 説明 |
|--------|--------|----------|----------|--------|------|------|
| アイテムID | iId | Hidden | 暗号化数値 | - | - | 編集対象アイテムID |
| リストページID | iListPageID | Hidden | 暗号化数値 | - | - | 親リストページID |
| フリーページフラグ | bLossePagina | Hidden | Boolean | - | - | 固定値false |
| ボタンアクション | btnaction | Hidden | 文字列 | - | - | save_listitem |
| タイトル | sTitle | 入力 | 文字列 | 255 | 必須 | アイテムタイトル |
| 公開日 | dPage | 入力 | 日付 | - | - | アイテムの公開日 |
| 公開開始日 | dOnlineFrom | 入力 | 日付 | - | - | 公開開始日時 |
| 公開終了日 | dOnlineUntill | 入力 | 日付 | - | - | 公開終了日時 |
| 外部URL | sLPExternalURL | 入力 | 文字列 | 255 | - | 外部リンクURL |
| 新規ウィンドウ | bLPExternalOINW | Checkbox | Boolean | - | - | 外部URLを新規ウィンドウで開く |
| フィードID | iFeedID | Select | 数値 | - | - | 関連フィードID |
| 本文 | sValue | 入力 | HTML | - | - | WYSIWYGエディタで編集 |
| ユーザーフレンドリーURL | sUserFriendlyURL | 入力 | 文字列 | 49 | - | SEOフレンドリーURL |

## 表示項目

| 項目名 | 表示位置 | 説明 |
|--------|----------|------|
| BOヘッダー | 上部 | バックサイト共通ヘッダー |
| リスト説明文 | フォーム上部 | l("expllistitem") |
| リストページ名 | フォーム上部 | 親リストページのタイトル |
| タイトル入力欄 | フォーム内 | maxlength=255、size=45 |
| プレビューリンク | タイトル横 | bs_preview.aspインクルード |
| 公開日入力欄 | フォーム内 | jQuery DatePicker付き |
| 公開期間入力欄 | フォーム内 | From/Untill の2つのDatePicker |
| 外部URL入力欄 | フォーム内 | 条件付き表示 |
| 新規ウィンドウチェック | フォーム内 | 外部URL時のオプション |
| フィード選択 | フォーム内 | bs_feed.aspインクルード |
| WYSIWYGエディタ | 中央 | createFCKInstanceで生成 |
| ユーザーフレンドリーURL | フォーム内 | 条件付き表示（bUserFriendlyURL） |
| 必須マーク説明 | フォーム下部 | 「(*) mandatory」 |
| 保存ボタン | フォーム下部 | 保存実行 |
| リセットボタン | フォーム下部 | 入力リセット |
| 削除ボタン | フォーム下部 | bs_deleteButtonList.aspインクルード |
| コンテンツアイテム変換リンク | フォーム下部 | bs_convertToItemWithContent.asp |
| 戻るリンク | 最下部 | bs_listPage.aspへ戻る |

## イベント仕様

### 1-保存ボタン押下

**処理フロー**：
1. CSRFトークンチェック（checkCSRF）
2. page.getRequestValues()でフォーム値を取得
3. page.save()でデータベースに保存
4. 成功時：fb_saveOKメッセージを追加
5. 画面を再表示

### 2-削除ボタン押下

**処理フロー**：
1. JavaScript confirm確認ダイアログ表示
2. 確認後、bs_processPage.aspで削除処理
3. bDeleted=true、bOnline=false設定
4. bs_listPage.aspへリダイレクト

### 3-リセットボタン押下

**処理フロー**：
1. HTMLのtype="reset"によりフォームをリセット

### 4-日付選択（DatePicker）

**処理フロー**：
1. JQDatePicker関数でjQuery UI DatePickerを初期化
2. 日付選択でテキストフィールドに値設定

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存（新規） | tblPage | INSERT | 新規リストアイテム作成 |
| 保存（更新） | tblPage | UPDATE | 既存リストアイテム更新 |
| 削除 | tblPage | UPDATE | bDeleted=true、bOnline=false |

### テーブル別更新項目詳細

#### tblPage（保存時）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT/UPDATE | sTitle | Request.Form("sTitle") | タイトル |
| INSERT/UPDATE | sValue | Request.Form("sValue") | 本文HTML |
| INSERT/UPDATE | dPage | Request.Form("dPage") | 公開日 |
| INSERT/UPDATE | dOnlineFrom | Request.Form("dOnlineFrom") | 公開開始日 |
| INSERT/UPDATE | dOnlineUntill | Request.Form("dOnlineUntill") | 公開終了日 |
| INSERT/UPDATE | sLPExternalURL | Request.Form("sLPExternalURL") | 外部URL |
| INSERT/UPDATE | bLPExternalOINW | Request.Form("bLPExternalOINW") | 新規ウィンドウフラグ |
| INSERT/UPDATE | iFeedID | Request.Form("iFeedID") | フィードID |
| INSERT/UPDATE | sUserFriendlyURL | Request.Form("sUserFriendlyURL") | フレンドリーURL |
| INSERT/UPDATE | iListPageID | Request.Form("iListPageID") | 親リストページID |
| INSERT/UPDATE | updatedTS | now() | 更新日時 |
| INSERT | createdTS | now() | 作成日時（新規のみ） |
| INSERT | iCustomerID | cId | 顧客ID（新規のみ） |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 発生条件 |
|-------------|------|---------------|----------|
| fb_saveOK | 成功 | 保存完了メッセージ | 保存成功時 |
| mandatory | 情報 | 必須項目の説明 | 常時表示 |
| externalurlLP | 情報 | 外部URLの説明 | 外部URL="http://"時 |

## 例外処理

| 例外状態 | 処理内容 |
|---------|----------|
| 未認証状態 | bs_security.aspによりログイン画面へリダイレクト |
| 必須項目未入力 | エラーメッセージ表示、画面再表示 |
| CSRFトークン不正 | エラー処理 |

## 備考

- 外部URL入力欄の表示条件は複雑で、以下の場合に表示される：
  - sLPExternalURLが"http://"以外または新規作成時、かつフィード未設定、かつ本文が空
  - または本文があり、sLPExternalURLが"http://"以外で空でない場合
- フィードが設定されている場合、外部URLと本文編集は表示されない
- 本文が設定されている場合、外部URLは条件付きで表示される
- JQDatePicker関数でjQuery UI DatePickerを生成
- convertEuroDate関数で日付をヨーロッパ形式（dd/mm/yyyy）に変換
- 「Convert to item with content」リンクでリストアイテムを通常ページに変換可能

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

リストアイテム固有のプロパティを理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | page.asp | `asp/includes/page.asp` | cls_pageクラス、リストアイテム関連プロパティ |
| 1-2 | customer.asp | `asp/includes/customer.asp` | bUserFriendlyURLプロパティ |

**読解のコツ**: リストアイテムはtblPageテーブルに格納され、iListPageIDで親リストページに紐付く。dPage、dOnlineFrom、dOnlineUntillで公開期間を制御する。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイルを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_editListItem.asp | `asp/bs_editListItem.asp` | リストアイテム編集画面のメインファイル |

**主要処理フロー**:
1. **行2-3**: bs_security.asp、bs_process.aspのインクルード
2. **行7**: bs_processPage.aspのインクルード（保存処理）
3. **行8-9**: フォームの開始、Hidden項目設定
4. **行12**: タイトル入力欄（maxlength=255）
5. **行14-16**: 日付入力欄（JQDatePicker）
6. **行17-19**: 外部URL入力欄（条件付き表示）
7. **行20-23**: フィード選択、WYSIWYGエディタ
8. **行24-26**: ユーザーフレンドリーURL（条件付き表示）
9. **行32-33**: 保存、リセット、削除ボタン

#### Step 3: 条件付き表示ロジックを理解する

外部URLと本文エディタの表示条件を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_editListItem.asp | `asp/bs_editListItem.asp` | 行17-29の条件分岐 |

**表示条件ロジック**:
- **行17**: 外部URL表示条件
  - `(sLPExternalURL<>"http://" or iId=0) and isLeeg(iFeedID) and isLeeg(sValue)`
  - または `(not isLeeg(sValue) and sLPExternalURL<>"http://" and not isLeeg(sLPExternalURL))`
- **行20**: 本文エディタ表示条件
  - `not isLeeg(sValue) or iId=0 or not isLeeg(iFeedID) or isLeeg(sLPExternalURL)`

### プログラム呼び出し階層図

```
bs_editListItem.asp (エントリーポイント)
    │
    ├─ bs_security.asp (認証チェック)
    │
    ├─ bs_process.asp (共通処理)
    │
    ├─ bs_processPage.asp (保存処理)
    │      ├─ checkCSRF()
    │      ├─ page.getRequestValues()
    │      └─ page.save()
    │
    ├─ フォーム項目
    │      ├─ タイトル入力
    │      ├─ bs_preview.asp (プレビューリンク)
    │      ├─ JQDatePicker (日付選択)
    │      ├─ 外部URL (条件付き)
    │      ├─ bs_feed.asp (フィード選択)
    │      ├─ createFCKInstance (WYSIWYGエディタ)
    │      └─ ユーザーフレンドリーURL (条件付き)
    │
    ├─ bs_deleteButtonList.asp (削除ボタン)
    │
    └─ bs_convertToItemWithContent.asp (変換リンク)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

フォーム入力 ────────▶ getRequestValues() ─────▶ cls_pageオブジェクト
                              │
                              ▼
                         save()
                              │
                              ▼
                         tblPage ──────────────▶ 保存完了メッセージ

iListPageID ─────────▶ page.listPage ──────────▶ 親リストページ情報表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_editListItem.asp | `asp/bs_editListItem.asp` | ソース | リストアイテム編集画面メイン |
| bs_security.asp | `asp/bs_security.asp` | インクルード | 認証チェック |
| bs_process.asp | `asp/bs_process.asp` | インクルード | 共通処理 |
| bs_processPage.asp | `asp/bs_processPage.asp` | インクルード | 保存処理 |
| page.asp | `asp/includes/page.asp` | インクルード | cls_pageクラス |
| bs_preview.asp | `asp/bs_preview.asp` | インクルード | プレビューリンク |
| bs_feed.asp | `asp/bs_feed.asp` | インクルード | フィード選択 |
| ckeditor.asp | `asp/includes/ckeditor.asp` | インクルード | WYSIWYGエディタ |
| bs_deleteButtonList.asp | `asp/bs_deleteButtonList.asp` | インクルード | 削除ボタン |
| bs_convertToItemWithContent.asp | `asp/bs_convertToItemWithContent.asp` | インクルード | 変換リンク |
| functions.asp | `asp/includes/functions.asp` | インクルード | JQDatePicker、convertEuroDate |
| bs_header.asp | `asp/bs_header.asp` | テンプレート | バックサイト用ヘッダー |
| bs_endBack.asp | `asp/bs_endBack.asp` | テンプレート | バックサイト用フッター |
