# 画面設計書 100-メーカー管理

## 概要

本ドキュメントは、QuickerSite CMSのバックサイト（管理画面）におけるメーカー管理画面について記述する。bs_shopMake.aspはショッピングカート機能のメーカー（ブランド）情報を登録・編集・削除するための画面である。

### 本画面の処理概要

本画面は、ショッピングカートのメーカー（ブランド）情報をCRUD操作するための編集画面である。メーカー名、ロゴURL、オンライン状態を設定でき、商品に紐付けるメーカー情報の管理が可能である。

**業務上の目的・背景**：ECサイトで商品をブランド別に分類・表示するためには、メーカー（ブランド）情報の管理が必要である。本画面は、サイト管理者がメーカー情報を作成・編集し、商品との紐付けを可能にする。

**画面へのアクセス方法**：ショッピングカート管理画面（bs_shoppingcart.asp）のメーカー一覧からメーカー名をクリック、または「Add Make」ボタンをクリック

**主要な操作・処理内容**：
1. メーカー名の入力・編集
2. メーカーロゴURLの入力・編集
3. オンライン/オフライン状態の設定
4. メーカー情報の保存
5. メーカーの削除

**画面遷移**：
- 遷移元：bs_shoppingcart.asp（ショッピングカート管理）
- 遷移先：bs_shoppingcart.asp（保存/削除完了後）

**権限による表示制御**：
- secondAdmin.bShoppingCart権限が必要

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 81 | メーカー管理 | 主機能 | メーカーのCRUD操作 |
| 77 | ショッピングカート管理 | 遷移元/先 | ダッシュボードからの遷移 |

## 画面種別

編集画面（CRUD）

## URL/ルーティング

```
asp/bs_shopMake.asp
```

### URLパラメータ

| パラメータ名 | 型 | 必須 | 説明 |
|-------------|-----|------|------|
| iShopMakeID | String | 任意 | 暗号化されたメーカーID（編集時） |

## 入出力項目

### 入力項目

| 項目名 | 項目ID | 型 | 必須 | 最大長 | 説明 |
|--------|--------|-----|------|--------|------|
| メーカー名 | sName | text | * | 250 | メーカーの表示名 |
| ロゴURL | sLogo | text | * | 250 | メーカーロゴ画像のURL |
| オンライン | bOnline | checkbox | - | - | 公開状態 |

### 隠しフィールド

| 項目名 | 項目ID | 説明 |
|--------|--------|------|
| メーカーID | iShopMakeID | 暗号化されたメーカーID |
| ポストバック | postback | フォーム送信判定フラグ |
| CSRFトークン | QS_secCodeHidden | CSRF対策トークン |

## 表示項目

### フォーム項目

| 項目名 | 説明 | 表示条件 |
|--------|------|----------|
| Make name | メーカー名入力フィールド | 常時表示 |
| Url to Make logo | ロゴURL入力フィールド | 常時表示 |
| Online | オンライン状態チェックボックス | 常時表示 |

### ボタン

| ボタン名 | 説明 | 表示条件 |
|----------|------|----------|
| Save | メーカー情報を保存 | 常時表示 |
| Delete | メーカーを削除 | 既存メーカー編集時のみ |

## イベント仕様

### 1-保存ボタンクリック

**処理内容**：
1. フォーム入力値を取得
2. cls_shopMakeオブジェクトにプロパティを設定
3. saveメソッドでデータベースに保存
4. 保存成功時、bs_shoppingcart.aspにリダイレクト

**バリデーション**：
- sName（メーカー名）が空の場合、エラーメッセージ「err_mandatory」を表示

### 2-削除ボタンクリック

**処理内容**：
1. JavaScriptで確認ダイアログを表示（「areyousure」）
2. 確認後、deleteメソッドでデータベースから削除
3. bs_shoppingcart.aspにリダイレクト

**注意**：削除時、該当メーカーに紐付く商品のメーカー参照は解除されない（商品側のiMakeIDは残る）

## データベース更新仕様

### 新規作成（INSERT）

| テーブル名 | 操作 | 条件 |
|-----------|------|------|
| tblQShopMake | INSERT | iIdがnullの場合 |

**設定フィールド**：
- sName: メーカー名（trim処理、最大255文字）
- sLogo: ロゴURL（trim処理、最大255文字）
- bOnline: オンライン状態
- dCreatedTS: 作成日時（now()）
- dUpdatedTS: 更新日時（now()）
- iCustomerID: 顧客ID（cId）

### 更新（UPDATE）

| テーブル名 | 操作 | 条件 |
|-----------|------|------|
| tblQShopMake | UPDATE | iId一致 |

### 削除（DELETE）

| テーブル名 | 操作 | 条件 |
|-----------|------|------|
| tblQShopMake | DELETE | iId=削除対象ID |

## メッセージ仕様

| メッセージID | 表示条件 | メッセージ内容 |
|-------------|----------|---------------|
| err_mandatory | メーカー名が空 | 必須項目エラー |
| areyousure | 削除ボタンクリック時 | 確認ダイアログ |

## 例外処理

| 例外 | 処理内容 |
|------|----------|
| 未認証アクセス | bs_security.aspで認証チェック、未認証時はnoaccess.htmにリダイレクト |
| 権限不足 | logon.hasaccess secondAdmin.bShoppingCartでアクセス拒否 |
| 不正なID | decrypt失敗時、新規作成モードとして動作 |

## 備考

- cls_shopMakeクラスでメーカー情報を管理
- encrypt/decrypt関数でIDを暗号化してURLパラメータに使用
- sanitize関数でXSS対策を実施
- QS_secCodeHiddenでCSRF対策を実施
- メーカー削除時、商品との紐付け（tblQShopProduct.iMakeID）は解除されない（孤立参照となる可能性あり）
- showMakeメソッドで他画面（商品編集等）でのメーカー選択ドロップダウンを生成可能

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

メーカーデータはtblQShopMakeテーブルに格納される。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | データベース設計書.md | `docs/code-to-docs/データベース設計書/データベース設計書.md` | tblQShopMake（行33） |
| 1-2 | shopMake.asp | `asp/includes/shopMake.asp` | cls_shopMakeクラス全体構造 |

**読解のコツ**: カテゴリと異なり、メーカーは階層構造を持たないフラットな構造である。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_shopMake.asp | `asp/bs_shopMake.asp` | 全体の処理フロー（行1-21） |

**主要処理フロー**:
1. **行1-4**: インクルードファイル読み込みと権限チェック
2. **行5-6**: cls_shopMakeインスタンス作成、pick()でデータ取得
3. **行7-8**: postback判定
4. **行9-19**: postback時のsave/delete処理
5. **行20**: フォームHTML出力

#### Step 3: クラスの詳細を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | shopMake.asp | `asp/includes/shopMake.asp` | Pickメソッド（行23-38） |
| 3-2 | shopMake.asp | `asp/includes/shopMake.asp` | Saveメソッド（行47-72） |
| 3-3 | shopMake.asp | `asp/includes/shopMake.asp` | Deleteメソッド（行73-76） |

**主要処理フロー（Save）**:
- **行49-54**: Checkメソッドでバリデーション
- **行55-71**: INSERT/UPDATE実行

**主要処理フロー（Delete）**:
- **行75**: tblQShopMakeから本体削除（シンプルな削除のみ）

#### Step 4: ユーティリティメソッドを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | shopMake.asp | `asp/includes/shopMake.asp` | listメソッド（行10-22） |
| 4-2 | shopMake.asp | `asp/includes/shopMake.asp` | showMakeメソッド（行77-101） |

**ユーティリティ機能**:
- **list**: 全メーカー一覧をDictionaryで取得
- **showMake**: ドロップダウン用HTML生成（商品編集画面等で使用）

### プログラム呼び出し階層図

```
bs_shopMake.asp
    |
    +-- #include "begin.asp"
    |       +-- 共通初期化処理
    |
    +-- #include "bs_security.asp"
    |       +-- logon.hasaccess(secondAdmin.bShoppingCart)
    |
    +-- #include "bs_shoppingcartmenu.asp"
    |       +-- ショッピングカートメニューバー
    |
    +-- cls_shopMake
            +-- pick(decrypt(iShopMakeID))
            |       +-- SELECT from tblQShopMake
            |
            +-- save()
            |       +-- Check() -> バリデーション
            |       +-- INSERT/UPDATE tblQShopMake
            |
            +-- delete()
                    +-- DELETE from tblQShopMake
```

### データフロー図

```
[入力]               [処理]                    [出力]

iShopMakeID     ---> decrypt()           ---> 復号化されたID
(URLパラメータ)       |
                     v
                 pick(id)
                     |
                     v
              tblQShopMake      <--------->  メーカーデータ
                     |
                     v
             フォーム表示
                     |
                     v
[フォーム送信]
     |
     v
sName, sLogo, bOnline
     |
     +--[Save]--> Check() --> save()
     |                          |
     |                          v
     |                    INSERT/UPDATE
     |                    tblQShopMake
     |
     +--[Delete]--> delete()
                       |
                       v
                 DELETE tblQShopMake
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_shopMake.asp | `asp/bs_shopMake.asp` | ソース | メイン画面処理 |
| shopMake.asp | `asp/includes/shopMake.asp` | ソース | メーカークラス |
| bs_shoppingcart.asp | `asp/bs_shoppingcart.asp` | ソース | 遷移元/先画面 |
| bs_shoppingcartmenu.asp | `asp/bs_shoppingcartmenu.asp` | ソース | 共通メニューバー |
| bs_security.asp | `asp/bs_security.asp` | ソース | 認証・権限制御 |
| includes/header.asp | `asp/includes/header.asp` | テンプレート | HTMLヘッダー |
| includes/footer.asp | `asp/includes/footer.asp` | テンプレート | HTMLフッター |
