# 画面設計書 101-商品管理

## 概要

本ドキュメントは、QuickerSiteのECサイト機能における商品管理画面（bs_shopProduct.asp）の設計書です。商品情報の登録・編集・削除を行う管理画面について記載しています。

### 本画面の処理概要

商品管理画面は、ECサイト機能において商品の基本情報を管理するための画面です。

**業務上の目的・背景**：ECサイトを運営する際、商品マスタの管理は最も基本的かつ重要な業務です。本画面では、商品名、メーカー、説明文、在庫数などの基本情報を一元管理し、サイト管理者が効率的に商品カタログを構築・メンテナンスできるようにすることを目的としています。WYSIWYGエディタを搭載しており、HTMLの知識がなくても商品の詳細説明をリッチテキストで作成可能です。

**画面へのアクセス方法**：バックサイトにログイン後、ショッピングカート管理画面（bs_shoppingcart.asp）から「Add Product」ボタンをクリックして新規作成、または商品一覧から商品名リンクもしくは「Edit」ボタンをクリックして既存商品を編集します。

**主要な操作・処理内容**：
1. 新規商品の登録（商品名、メーカー、短い説明、詳細説明、在庫数、オンライン状態を入力）
2. 既存商品情報の編集（フォームに既存値を表示し、変更を保存）
3. 商品の削除（確認ダイアログ表示後に実行）
4. WYSIWYGエディタによるリッチテキスト形式での詳細説明作成

**画面遷移**：ショッピングカート管理画面（bs_shoppingcart.asp）から遷移してきます。保存・削除後はショッピングカート管理画面へリダイレクトします。商品カテゴリ割当画面（bs_shopProductCat.asp）、商品画像管理画面（bs_shopProductImg.asp）へは、ショッピングカート管理画面の商品一覧から遷移します。

**権限による表示制御**：セカンドアドミンのbShoppingCart権限を持つユーザーのみがアクセス可能です。権限がない場合はアクセス拒否されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 78 | 商品管理 | 主機能 | 商品の追加・編集・削除 |

## 画面種別

登録 / 編集

## URL/ルーティング

`asp/bs_shopProduct.asp`

パラメータ：
- `iShopProductID`：商品ID（暗号化済み）。新規作成時は指定なし。

## 入出力項目

| 項目名 | 項目ID | 型 | 必須 | 最大長 | 説明 |
|--------|--------|-----|------|--------|------|
| 商品名 | sName | text | * | 250 | 商品の名称 |
| メーカー | iMakeID | select | - | - | メーカーの選択（ドロップダウン） |
| 短い説明 | sShortDesc | textarea | - | - | 商品の概要説明 |
| 詳細説明 | sLongDesc | richtext | - | - | WYSIWYGエディタによる詳細説明 |
| 在庫数 | iStock | text | - | 10 | 在庫の数量（数値） |
| オンライン | bOnline | checkbox | - | - | 公開状態のフラグ |
| postback | postback | hidden | - | - | POSTバック判定フラグ |
| iShopProductID | iShopProductID | hidden | - | - | 商品ID（暗号化） |
| QSSEC | QSSEC | hidden | - | - | CSRFトークン |

## 表示項目

| 項目名 | 説明 |
|--------|------|
| 商品名入力欄 | 商品名を入力するテキストボックス |
| メーカー選択 | 登録済みメーカーを選択するドロップダウンリスト |
| 短い説明入力欄 | 商品の概要を入力するテキストエリア（3行60列） |
| 詳細説明入力欄 | FCKEditorによるリッチテキストエディタ |
| 在庫数入力欄 | 在庫数を入力するテキストボックス |
| オンラインチェックボックス | 公開状態を設定するチェックボックス |
| 保存ボタン | 商品情報を保存 |
| 削除ボタン | 商品を削除（既存商品編集時のみ表示） |

## イベント仕様

### 1-保存ボタン押下

1. フォームデータをPOSTでbs_shopProduct.aspに送信
2. postbackがtrueの場合、btnactionの値を確認
3. 「save」の場合：
   - リクエストから各項目を取得しshopProductオブジェクトに設定
   - shopProduct.save()を呼び出し
   - 入力検証（商品名必須、在庫数は数値のみ）
   - 検証成功時：tblQShopProductテーブルに保存
   - bs_shoppingcart.aspへリダイレクト

### 2-削除ボタン押下

1. JavaScriptのconfirmダイアログで削除確認
2. 確認OK時、フォームをPOST
3. 「delete」の場合：
   - shopProduct.delete()を呼び出し
   - 商品フォルダ（画像フォルダ）も削除
   - tblQShopProductテーブルから削除
   - bs_shoppingcart.aspへリダイレクト

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下（新規） | tblQShopProduct | INSERT | 新規商品レコードを作成 |
| 保存ボタン押下（更新） | tblQShopProduct | UPDATE | 既存商品レコードを更新 |
| 削除ボタン押下 | tblQShopProduct | DELETE | 商品レコードを削除 |

### テーブル別更新項目詳細

#### tblQShopProduct

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | iId | 自動採番 | 主キー |
| INSERT/UPDATE | sName | フォーム入力値（最大255文字） | 商品名 |
| INSERT/UPDATE | bOnline | チェックボックスの状態 | 公開フラグ |
| INSERT/UPDATE | sShortDesc | フォーム入力値 | 短い説明 |
| INSERT/UPDATE | sLongDesc | フォーム入力値 | 詳細説明 |
| INSERT/UPDATE | iStock | フォーム入力値（数値変換） | 在庫数 |
| INSERT/UPDATE | iMakeID | フォーム選択値（数値変換） | メーカーID |
| INSERT | dCreatedTS | now() | 作成日時 |
| INSERT/UPDATE | dUpdatedTS | now() | 更新日時 |
| INSERT/UPDATE | iCustomerID | cId（セッション） | 顧客ID |
| DELETE | - | WHERE iId={商品ID} | 条件 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| err_mandatory | エラー | 必須項目が入力されていません | 商品名が空の場合 |
| err_mandatory | エラー | 必須項目が入力されていません | 在庫数が非数値の場合 |
| areyousure | 確認 | 削除してよろしいですか？ | 削除ボタン押下時 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| 権限なし | セカンドアドミンのbShoppingCart権限がない場合、アクセス拒否 |
| 不正なID | 存在しない商品IDを指定した場合、空のフォームを表示（新規作成モード） |
| 入力検証エラー | エラーメッセージを表示し、フォームを再表示 |

## 備考

- 詳細説明（sLongDesc）の編集にはFCKEditor（WYSIWYGエディタ）を使用
- 商品削除時には、関連する画像フォルダも物理削除される
- 商品IDは暗号化されてURLパラメータとして渡される（encrypt/decrypt関数使用）
- CSRFトークン（QS_secCodeHidden）による保護が実装されている

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

商品データのクラス定義を理解することが、画面の動作を把握する第一歩です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | shopProduct.asp | `asp/includes/shopProduct.asp` | cls_shopProductクラスの構造、プロパティ、メソッドを理解する |
| 1-2 | shopMake.asp | `asp/includes/shopMake.asp` | メーカー選択ドロップダウンの生成方法を理解する |

**読解のコツ**: VBScriptのClassブロック内でPublicプロパティとして宣言された変数がテーブルカラムに対応しています。Pick関数がSELECT、Save関数がINSERT/UPDATE、Delete関数がDELETEに対応します。

#### Step 2: エントリーポイントを理解する

画面本体のASPファイルで、表示とPOST処理の両方を担当します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_shopProduct.asp | `asp/bs_shopProduct.asp` | 画面のメイン処理、フォーム表示とPOST処理の分岐を理解する |

**主要処理フロー**:
1. **4行目**: セキュリティチェック（logon.hasaccess secondAdmin.bShoppingCart）
2. **5-6行目**: shopProductオブジェクト生成、商品IDからデータ取得
3. **7-8行目**: showMakeオブジェクト生成（メーカー選択用）
4. **10-24行目**: POSTバック処理（保存/削除の分岐）
5. **25行目**: フォームHTML出力

#### Step 3: 関連インクルードファイルを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_security.asp | `asp/bs_security.asp` | 認証・権限チェックの仕組み |
| 3-2 | bs_shoppingcartmenu.asp | `asp/bs_shoppingcartmenu.asp` | ショッピングカート管理のナビゲーションメニュー |

### プログラム呼び出し階層図

```
bs_shopProduct.asp
    │
    ├─ begin.asp（初期化処理）
    │      └─ includes/shopProduct.asp（cls_shopProductクラス読込）
    │      └─ includes/shopMake.asp（cls_shopMakeクラス読込）
    │
    ├─ bs_security.asp（認証チェック）
    │      └─ logon.hasaccess()
    │
    ├─ cls_shopProduct
    │      ├─ pick()（商品データ取得）
    │      ├─ save()（商品データ保存）
    │      │      └─ check()（入力検証）
    │      └─ delete()（商品データ削除）
    │
    ├─ cls_shopMake
    │      └─ showMake()（メーカードロップダウン生成）
    │
    └─ createFCKInstance()（WYSIWYGエディタ生成）
```

### データフロー図

```
[入力]                    [処理]                         [出力]

ブラウザ（GET）     ───▶ bs_shopProduct.asp          ───▶ フォームHTML表示
iShopProductID            ├─ decrypt(iShopProductID)
                          ├─ shopProduct.pick()
                          └─ showMake.showMake()

ブラウザ（POST）    ───▶ bs_shopProduct.asp          ───▶ リダイレクト
フォームデータ            ├─ 各プロパティに値設定           (bs_shoppingcart.asp)
                          └─ shopProduct.save()
                                  │
                                  ▼
                          tblQShopProduct（DB）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_shopProduct.asp | `asp/bs_shopProduct.asp` | ソース | 商品管理画面本体 |
| shopProduct.asp | `asp/includes/shopProduct.asp` | ソース | 商品データクラス定義 |
| shopMake.asp | `asp/includes/shopMake.asp` | ソース | メーカーデータクラス定義 |
| bs_shoppingcartmenu.asp | `asp/bs_shoppingcartmenu.asp` | ソース | ナビゲーションメニュー |
| bs_security.asp | `asp/bs_security.asp` | ソース | 認証・権限チェック |
| begin.asp | `asp/begin.asp` | ソース | 共通初期化処理 |
| header.asp | `asp/includes/header.asp` | テンプレート | HTMLヘッダー |
| footer.asp | `asp/includes/footer.asp` | テンプレート | HTMLフッター |
