# 画面設計書 103-商品画像

## 概要

本ドキュメントは、QuickerSiteのECサイト機能における商品画像管理画面（bs_shopProductImg.asp）の設計書です。商品に紐付く画像の一覧表示、デフォルト画像設定、削除、およびアップロードフォームを提供する管理画面について記載しています。

### 本画面の処理概要

商品画像画面は、商品に関連付けられた画像ファイルを管理するための画面です。

**業務上の目的・背景**：ECサイトにおいて商品画像は購買意欲に直結する重要な要素です。本画面では、1つの商品に対して複数の画像を登録し、サムネイル形式で一覧表示できます。また、商品一覧等で使用するデフォルト画像を指定したり、不要な画像を削除することができます。これにより、商品の視覚的な訴求力を高め、効果的な商品展示を実現します。

**画面へのアクセス方法**：バックサイトにログイン後、ショッピングカート管理画面（bs_shoppingcart.asp）の商品一覧から「Images」ボタンをクリックしてアクセスします。

**主要な操作・処理内容**：
1. 商品に登録されている画像のサムネイル一覧表示（150px幅でリサイズ表示）
2. 画像クリックで拡大表示（600px幅のポップアップ）
3. デフォルト画像の設定（「set as default image」リンク）
4. 画像の削除（確認ダイアログ付き）
5. 新規画像のアップロード（JPGファイルのみ対応）

**画面遷移**：ショッピングカート管理画面（bs_shoppingcart.asp）から商品IDをパラメータとして遷移してきます。画像アップロード処理（bs_shopProductImgUpload.asp）へフォーム送信し、処理完了後に本画面へリダイレクトされます。

**権限による表示制御**：セカンドアドミンのbShoppingCart権限を持つユーザーのみがアクセス可能です。権限がない場合はアクセス拒否されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 80 | 商品画像管理 | 主機能 | 商品画像のアップロード・管理 |

## 画面種別

一覧 / 編集

## URL/ルーティング

`asp/bs_shopProductImg.asp`

パラメータ：
- `iShopProductID`：商品ID（暗号化済み）。必須。
- `delete`：削除対象の画像ファイル名（URLエンコード済み）。オプション。
- `default`：デフォルト設定対象の画像ファイル名（URLエンコード済み）。オプション。

## 入出力項目

| 項目名 | 項目ID | 型 | 必須 | 最大長 | 説明 |
|--------|--------|-----|------|--------|------|
| 画像ファイル | image1 | file | - | - | アップロードする画像ファイル（JPGのみ） |
| iShopProductID | iShopProductID | hidden | - | - | 商品ID（暗号化） |
| postback | postback | hidden | - | - | POSTバック判定フラグ |
| QSSEC | QSSEC | hidden | - | - | CSRFトークン |

## 表示項目

| 項目名 | 説明 |
|--------|------|
| 商品名 | 対象商品の名称（読取専用表示） |
| 画像サムネイル一覧 | 登録済み画像を150px幅のサムネイルで横並び表示 |
| 拡大表示リンク | サムネイルクリックで600px幅の拡大画像をポップアップ表示 |
| デフォルト表示 | デフォルト画像には「default image」とイタリック表示 |
| デフォルト設定リンク | デフォルト以外の画像に「set as default image」リンク表示 |
| 削除ボタン | 各画像の下に削除ボタン（確認ダイアログ付き） |
| ファイル選択 | アップロード用ファイル選択コントロール |
| アップロードボタン | 画像アップロード実行 |

## イベント仕様

### 1-デフォルト画像設定リンク押下

1. GETリクエストでdefaultパラメータに画像ファイル名を指定
2. shopProduct.setAsDefaultImage(request.querystring("default"))を呼び出し
3. sDefaultImageプロパティを更新してsave()実行
4. tblQShopProductのsDefaultImageカラムを更新
5. 同画面を再表示

### 2-削除ボタン押下

1. JavaScriptのconfirmダイアログで削除確認
2. 確認OK時、GETリクエストでdeleteパラメータに画像ファイル名を指定
3. shopProduct.deleteImage(request.querystring("delete"))を呼び出し
4. FileSystemObjectで画像ファイルを物理削除
5. 削除した画像がデフォルト画像の場合、sDefaultImageを空に設定
6. 同画面を再表示

### 3-アップロードボタン押下

1. フォームをmultipart/form-dataでbs_shopProductImgUpload.aspにPOST
2. アップロード処理画面で処理後、本画面にリダイレクト

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| デフォルト設定 | tblQShopProduct | UPDATE | sDefaultImageカラムを更新 |
| 削除（デフォルト画像の場合） | tblQShopProduct | UPDATE | sDefaultImageを空に設定 |

### テーブル別更新項目詳細

#### tblQShopProduct

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | sDefaultImage | 指定された画像ファイル名 | デフォルト画像設定時 |
| UPDATE | sDefaultImage | 空文字 | デフォルト画像を削除時 |
| UPDATE | dUpdatedTS | now() | 更新日時 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| areyousure | 確認 | 削除してよろしいですか？ | 削除ボタン押下時 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| 権限なし | セカンドアドミンのbShoppingCart権限がない場合、アクセス拒否 |
| 不正な商品ID | 存在しない商品IDを指定した場合、空の画面を表示 |
| 画像フォルダ不存在 | フォルダがない場合、画像一覧は空で表示 |

## 備考

- 画像ファイルは `{userfiles}/qsscart/{商品ID}/` フォルダに保存される
- サムネイル表示にはshowthumb.aspxを使用（動的リサイズ）
- 対応ファイル形式はJPGのみ
- 画像のクリック拡大にはQSPPIMGクラス（ポップアップ機能）を使用
- 複数画像を横並びで表示（float:left、margin:5px）
- 画像ファイル名がそのまま保存される（リネームなし）
- CSRFトークン（QS_secCodeHidden）による保護が実装されている

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

画像管理に関するメソッドを理解することが第一歩です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | shopProduct.asp | `asp/includes/shopProduct.asp` | images関数（103-116行目）で画像一覧取得、deleteImage関数（91-102行目）で削除、setAsDefaultImage関数（128-133行目）でデフォルト設定 |

**読解のコツ**: 画像ファイルはDBではなくファイルシステムに保存されます。FileSystemObjectでフォルダ内のファイル一覧を取得しています。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_shopProductImg.asp | `asp/bs_shopProductImg.asp` | 画面のメイン処理、画像一覧の動的生成、削除・デフォルト設定のクエリストリング処理 |

**主要処理フロー**:
1. **4行目**: セキュリティチェック
2. **5-6行目**: shopProductオブジェクト生成、商品データ取得
3. **8-10行目**: deleteクエリストリング処理（画像削除）
4. **11-13行目**: defaultクエリストリング処理（デフォルト設定）
5. **14行目**: 画像一覧取得（images）
6. **15行目以降**: 画像ごとにサムネイル・リンク・ボタンを生成

#### Step 3: アップロード処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_shopProductImgUpload.asp | `asp/bs_shopProductImgUpload.asp` | FreeASPUploadクラスによるファイルアップロード処理 |

**主要処理フロー**:
- **9-14行目**: 保存先フォルダの存在チェック・作成
- **17-20行目**: アップロード処理（FreeASPUpload）
- **24-31行目**: 拡張子チェック（JPGのみ許可）
- **36-39行目**: リダイレクト処理

### プログラム呼び出し階層図

```
bs_shopProductImg.asp
    │
    ├─ begin.asp（初期化処理）
    │      └─ includes/shopProduct.asp
    │
    ├─ bs_security.asp（認証チェック）
    │
    ├─ cls_shopProduct
    │      ├─ pick()（商品データ取得）
    │      ├─ images()（画像一覧取得）
    │      │      └─ FileSystemObject.getFolder()
    │      ├─ deleteImage()（画像削除）
    │      │      └─ FileSystemObject.deletefile()
    │      └─ setAsDefaultImage()（デフォルト設定）
    │             └─ save()
    │
    └─ フォーム送信
           └─ bs_shopProductImgUpload.asp
                  ├─ FreeASPUpload（ファイルアップロード）
                  └─ リダイレクト → bs_shopProductImg.asp
```

### データフロー図

```
[入力]                    [処理]                         [出力]

ブラウザ（GET）     ───▶ bs_shopProductImg.asp       ───▶ 画像一覧HTML
iShopProductID            ├─ shopProduct.pick()
                          └─ shopProduct.images()
                                 │
                                 ▼
                          ファイルシステム
                          ({userfiles}/qsscart/{ID}/)

ブラウザ（GET）     ───▶ bs_shopProductImg.asp       ───▶ 同画面再表示
?delete={filename}        └─ shopProduct.deleteImage()
                                 │
                                 ├─▶ ファイル削除
                                 └─▶ DB更新（デフォルト時）

ブラウザ（POST）    ───▶ bs_shopProductImgUpload.asp ───▶ リダイレクト
image1（ファイル）        ├─ FreeASPUpload.Save()
                          └─ ファイル保存
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_shopProductImg.asp | `asp/bs_shopProductImg.asp` | ソース | 商品画像管理画面本体 |
| bs_shopProductImgUpload.asp | `asp/bs_shopProductImgUpload.asp` | ソース | 画像アップロード処理 |
| shopProduct.asp | `asp/includes/shopProduct.asp` | ソース | 商品データクラス（images、deleteImage、setAsDefaultImageメソッド） |
| showthumb.aspx | `showthumb.aspx` | ソース | サムネイル動的生成 |
| bs_shoppingcartmenu.asp | `asp/bs_shoppingcartmenu.asp` | ソース | ナビゲーションメニュー |
| bs_security.asp | `asp/bs_security.asp` | ソース | 認証・権限チェック |
| begin.asp | `asp/begin.asp` | ソース | 共通初期化処理 |
| header.asp | `asp/includes/header.asp` | テンプレート | HTMLヘッダー |
| footer.asp | `asp/includes/footer.asp` | テンプレート | HTMLフッター |
