# 画面設計書 104-商品画像アップロード

## 概要

本ドキュメントは、QuickerSiteのECサイト機能における商品画像アップロード処理画面（bs_shopProductImgUpload.asp）の設計書です。商品画像のファイルアップロードを処理する非表示の処理画面について記載しています。

### 本画面の処理概要

商品画像アップロード画面は、商品画像管理画面（bs_shopProductImg.asp）から送信されたファイルを受け取り、サーバーに保存する処理専用の画面です。

**業務上の目的・背景**：ECサイトで商品画像を追加する際に、マルチパートフォームデータとして送信されたファイルを安全に処理し、適切なフォルダ構造で保存する必要があります。本画面はその処理を担当し、ファイル形式の検証（JPGのみ許可）、保存先フォルダの自動作成、CSRFトークンの検証など、セキュリティを考慮したアップロード処理を提供します。

**画面へのアクセス方法**：直接アクセスする画面ではありません。商品画像管理画面（bs_shopProductImg.asp）のアップロードフォームからPOSTリクエストで呼び出されます。

**主要な操作・処理内容**：
1. CSRFトークンの検証
2. 保存先フォルダの存在確認・作成
3. FreeASPUploadクラスによるファイル受信・保存
4. ファイル拡張子の検証（JPGのみ許可）
5. 検証失敗時のファイル削除
6. 処理完了後の商品画像管理画面へのリダイレクト

**画面遷移**：商品画像管理画面（bs_shopProductImg.asp）からPOSTで呼び出され、処理完了後は商品画像管理画面へリダイレクトします。エラー時もエラーメッセージパラメータ付きで同画面にリダイレクトします。

**権限による表示制御**：bs_security.aspがインクルードされているが、明示的な権限チェックは行われていません。ただし、呼び出し元の商品画像管理画面で権限チェックが行われているため、通常のフローでは権限のないユーザーはアクセスできません。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 80 | 商品画像管理 | 主機能 | 商品画像のアップロード処理 |

## 画面種別

処理専用（非表示）

## URL/ルーティング

`asp/bs_shopProductImgUpload.asp`

パラメータ（クエリストリング）：
- `iShopProductID`：商品ID（暗号化済み）。必須。

パラメータ（マルチパートフォーム）：
- `image1`：アップロードするJPG画像ファイル
- `QSSEC`：CSRFトークン

## 入出力項目

| 項目名 | 項目ID | 型 | 必須 | 最大長 | 説明 |
|--------|--------|-----|------|--------|------|
| 画像ファイル | image1 | file | - | - | アップロードする画像ファイル |
| 商品ID | iShopProductID | query | * | - | 対象商品のID（暗号化） |
| CSRFトークン | QSSEC | form | * | - | CSRF対策トークン |

## 表示項目

本画面は処理専用のため、画面表示は行いません。処理完了後は商品画像管理画面へリダイレクトします。

## イベント仕様

### 1-ファイルアップロード処理

1. 商品IDをクエリストリングから取得・復号化
2. shopProductオブジェクトで商品データを取得
3. 保存先フォルダの確認・作成処理：
   - `{userfiles}/qsscart/` フォルダが存在しなければ作成
   - `{userfiles}/qsscart/{商品ID}/` フォルダが存在しなければ作成
4. FreeASPUploadクラスでファイルを受信・保存
5. CSRFトークンの検証（checkCSRF_Upload）
6. アップロードされたファイルの検証：
   - ファイルが存在するか確認
   - 拡張子がJPGであるか確認
7. 検証失敗時：
   - アップロードされたファイルを削除
   - エラーメッセージをパラメータに設定
8. 処理完了：商品画像管理画面へリダイレクト

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | データベースへの更新は行われない |

### ファイルシステム更新

| 操作 | 対象 | 処理内容 |
|-----|------|---------|
| フォルダ作成 | {userfiles}/qsscart/ | 存在しない場合に作成 |
| フォルダ作成 | {userfiles}/qsscart/{商品ID}/ | 存在しない場合に作成 |
| ファイル保存 | {userfiles}/qsscart/{商品ID}/{ファイル名} | アップロードファイルを保存 |
| ファイル削除 | 同上 | 検証失敗時に削除 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| err_fileType | エラー | ファイル形式が不正です | JPG以外のファイルをアップロードした場合 |
| err_newFile | エラー | ファイルが選択されていません | ファイルが未選択の場合 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| ファイル未選択 | err_newFileエラーでリダイレクト |
| JPG以外のファイル | ファイルを削除し、err_fileTypeエラーでリダイレクト |
| CSRFトークン不正 | checkCSRF_Upload関数で処理（詳細は共通処理参照） |
| フォルダ作成失敗 | FileSystemObjectのエラーとして処理 |

## 備考

- FreeASPUploadクラスを使用したファイルアップロード処理
- アップロード後のcustomer.save呼び出し（37行目）は誤りの可能性あり（商品画像との関連が不明）
- ファイル名は元のファイル名のまま保存される（リネームなし）
- 複数ファイルの同時アップロードには対応していない（input name="image1"）
- エラーメッセージはURLパラメータ（strMessage）で渡される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | shopProduct.asp | `asp/includes/shopProduct.asp` | iIdプロパティが保存先フォルダ名として使用される |

**読解のコツ**: アップロード処理はDBではなくファイルシステムに保存します。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_shopProductImgUpload.asp | `asp/bs_shopProductImgUpload.asp` | 全41行のファイルアップロード処理 |

**主要処理フロー**:
1. **4-6行目**: セキュリティインクルード、商品オブジェクト生成・取得
2. **7-15行目**: フォルダ存在確認・作成（FileSystemObject）
3. **16-17行目**: 保存先パス設定
4. **18-21行目**: FreeASPUploadでファイル保存、CSRFチェック
5. **22-35行目**: ファイル検証ループ（拡張子チェック、エラー時削除）
6. **36-40行目**: リダイレクト処理

#### Step 3: 呼び出し元を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_shopProductImg.asp | `asp/bs_shopProductImg.asp` | アップロードフォームの構造、enctype="multipart/form-data" |

### プログラム呼び出し階層図

```
bs_shopProductImg.asp（フォーム送信）
    │
    └─▶ bs_shopProductImgUpload.asp
            │
            ├─ begin.asp（初期化処理）
            │      └─ includes/shopProduct.asp
            │
            ├─ bs_security.asp（インクルードのみ）
            │
            ├─ cls_shopProduct
            │      └─ pick()（商品データ取得）
            │
            ├─ FileSystemObject
            │      ├─ folderexists()（フォルダ存在確認）
            │      └─ createFolder()（フォルダ作成）
            │
            ├─ FreeASPUpload
            │      ├─ Save()（ファイル保存）
            │      └─ UploadedFiles（アップロードファイル一覧）
            │
            ├─ checkCSRF_Upload()（CSRFトークン検証）
            │
            ├─ GetFileExtension()（拡張子取得）
            │
            └─ Response.Redirect()
                   └─▶ bs_shopProductImg.asp
```

### データフロー図

```
[入力]                    [処理]                         [出力]

bs_shopProductImg.asp ──▶ bs_shopProductImgUpload.asp  ───▶ リダイレクト
（multipart/form-data）   │
                          ├─ フォルダ確認・作成
                          │      │
                          │      ▼
                          │  {userfiles}/qsscart/{ID}/
                          │
                          ├─ FreeASPUpload.Save()
                          │      │
                          │      ▼
                          │  ファイル保存
                          │
                          ├─ 拡張子チェック
                          │      ├─ OK → 正常リダイレクト
                          │      └─ NG → ファイル削除、エラーリダイレクト
                          │
                          └─▶ bs_shopProductImg.asp
                               ?iShopProductID=xxx
                               (&strMessage=err_xxx)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_shopProductImgUpload.asp | `asp/bs_shopProductImgUpload.asp` | ソース | 画像アップロード処理本体 |
| bs_shopProductImg.asp | `asp/bs_shopProductImg.asp` | ソース | 呼び出し元・リダイレクト先 |
| shopProduct.asp | `asp/includes/shopProduct.asp` | ソース | 商品データクラス |
| FreeASPUpload | 外部ライブラリ | ソース | ファイルアップロードライブラリ |
| begin.asp | `asp/begin.asp` | ソース | 共通初期化処理 |
| bs_security.asp | `asp/bs_security.asp` | ソース | セキュリティ関連（CSRF検証） |
