# 画面設計書 105-カレンダー管理

## 概要

本ドキュメントは、QuickerSiteの予約カレンダー機能における統合管理画面（bs_ac.asp）の設計書です。予約カレンダーの作成・編集、予約一覧、予約編集、埋め込みコード生成など複数の機能を統合したハブ画面について記載しています。

### 本画面の処理概要

カレンダー管理画面は、予約カレンダー機能の中心となるエントリーポイント画面です。calActionパラメータに応じて異なるサブ画面を動的にインクルードし、一つのURLで複数の機能を提供します。

**業務上の目的・背景**：レンタル物件、会議室、イベント施設など、予約管理が必要なビジネスにおいて、カレンダー形式で空き状況を公開し、予約を管理することは重要な業務です。本画面は、カレンダーの作成から予約管理、外部サイトへの埋め込みコード生成まで、予約カレンダーに関するすべての管理機能を一元的に提供します。

**画面へのアクセス方法**：バックサイトにログイン後、カレンダー管理メニュー（bs_ac_menu.asp）から「My Calendars」または「Create Calendar」リンクをクリックしてアクセスします。

**主要な操作・処理内容**：
1. マイカレンダー一覧表示（calAction指定なし）
2. カレンダー作成・編集（calAction=createCal/editCal）
3. 予約一覧表示（calAction=bookings）
4. 予約作成・編集（calAction=booking）
5. 埋め込みコード生成（calAction=embedCode）

**画面遷移**：calActionパラメータの値により内部的な画面遷移を制御します。各サブ画面は同一URL（bs_ac.asp）へのリンクでcalActionパラメータを変えることで遷移します。

**権限による表示制御**：セカンドアドミンのbAvailabilityCal権限を持つユーザーのみがアクセス可能です。権限がない場合はアクセス拒否されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 74 | 予約カレンダー | 主機能 | カレンダー管理画面 |

## 画面種別

統合ハブ画面（calActionにより一覧/登録/編集に分岐）

## URL/ルーティング

`asp/bs_ac.asp`

パラメータ：
- `calAction`：表示するサブ画面を指定
  - 未指定/空：マイカレンダー一覧（bs_ac_mycals.asp）
  - `createCal`：カレンダー新規作成（bs_ac_calendar.asp）
  - `editCal`：カレンダー編集（bs_ac_calendar.asp）
  - `bookings`：予約一覧（bs_ac_bookings.asp）
  - `booking`：予約編集（bs_ac_booking.asp）
  - `embedCode`：埋め込みコード（bs_ac_embed.asp）
- `iCalID`：対象カレンダーID
- `iBookingID`：対象予約ID（booking時）

## 入出力項目

calActionの値により異なるサブ画面が表示されるため、各サブ画面の設計書（No.106〜110）を参照してください。

## 表示項目

| calAction | 表示内容 |
|-----------|---------|
| 未指定 | マイカレンダー一覧（No.110参照） |
| createCal/editCal | カレンダー編集フォーム（No.108参照） |
| bookings | 予約一覧テーブル（No.106参照） |
| booking | 予約編集フォーム（No.107参照） |
| embedCode | 埋め込みコード生成画面 |

## イベント仕様

### 1-各サブ画面への分岐処理

```
calActionの値により条件分岐
  ↓
select case lcase(action)
  case "createcal","editcal" → bs_ac_calendar.aspをインクルード
  case "embedcode"           → bs_ac_embed.aspをインクルード
  case "booking"             → bs_ac_booking.aspをインクルード
  case "bookings"            → bs_ac_bookings.aspをインクルード
  case else                  → bs_ac_mycals.aspをインクルード
end select
```

## データベース更新仕様

本画面自体はルーティングのみを行い、データベース更新はサブ画面（インクルードファイル）で行われます。

### 関連テーブル

| テーブル名 | 用途 |
|-----------|------|
| tblCalendar | カレンダー基本情報 |
| tblCalendarBooking | 予約情報 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| - | 各種 | message.showAlert() | サブ画面での処理結果 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| 権限なし | セカンドアドミンのbAvailabilityCal権限がない場合、アクセス拒否 |
| 不正なcalAction | デフォルトとしてマイカレンダー一覧を表示 |

## 備考

- 本画面は統合ハブとして機能し、実際の処理は各インクルードファイルで行われる
- 各サブ画面の詳細は、それぞれの画面設計書（No.106〜110）を参照
- カレンダー機能全体でcls_calendar、cls_calendarbooking、cls_statusList、calendarviewの4クラスを使用
- メッセージ表示はすべてのサブ画面処理完了後に一括表示（message.showAlert()）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

カレンダー機能の中核となるクラスを理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ac_calendar.asp | `asp/includes/ac_calendar.asp` | cls_Calendarクラス - カレンダー基本情報とCRUD操作 |
| 1-2 | ac_calendarbooking.asp | `asp/includes/ac_calendarbooking.asp` | cls_calendarbookingクラス - 予約データと重複チェックロジック |
| 1-3 | ac_statuslist.asp | `asp/includes/ac_statuslist.asp` | cls_statusListクラス - 予約ステータス（Confirmed/Pending/Unavailable） |
| 1-4 | ac_calendarview.asp | `asp/includes/ac_calendarview.asp` | calendarviewクラス - 月次カレンダー表示生成 |

**読解のコツ**: cls_calendarbookingのcheck()関数に予約の重複チェックロジックがあり、予約システムの核心部分です。

#### Step 2: エントリーポイント（ルーター）を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_ac.asp | `asp/bs_ac.asp` | calActionによる画面分岐ロジック |

**主要処理フロー**:
1. **4行目**: セキュリティチェック（bAvailabilityCal権限）
2. **4行目**: 共通インクルード（ac_calendar.asp等4ファイル）
3. **4行目**: メニュー表示（bs_ac_menu.asp）
4. **5-6行目**: 変数宣言、calActionとpostback取得
5. **8行目**: select caseによる分岐
6. **9行目**: message.showAlert()でメッセージ表示

#### Step 3: 各サブ画面を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_ac_mycals.asp | `asp/bs_ac_mycals.asp` | マイカレンダー一覧表示 |
| 3-2 | bs_ac_calendar.asp | `asp/bs_ac_calendar.asp` | カレンダー作成・編集フォーム |
| 3-3 | bs_ac_bookings.asp | `asp/bs_ac_bookings.asp` | 予約一覧テーブル |
| 3-4 | bs_ac_booking.asp | `asp/bs_ac_booking.asp` | 予約編集フォーム |
| 3-5 | bs_ac_embed.asp | `asp/bs_ac_embed.asp` | 埋め込みコード生成 |

### プログラム呼び出し階層図

```
bs_ac.asp（エントリーポイント）
    │
    ├─ begin.asp（初期化処理）
    │
    ├─ bs_security.asp（認証チェック）
    │      └─ logon.hasaccess secondAdmin.bAvailabilityCal
    │
    ├─ includes/ac_calendar.asp（cls_Calendarクラス定義）
    ├─ includes/ac_calendarview.asp（calendarviewクラス定義）
    ├─ includes/ac_calendarbooking.asp（cls_calendarbookingクラス定義）
    ├─ includes/ac_statuslist.asp（cls_statusListクラス定義）
    │
    ├─ bs_ac_menu.asp（メニュー表示）
    │
    └─ select case calAction
           ├─ "createcal","editcal" → bs_ac_calendar.asp
           ├─ "embedcode"           → bs_ac_embed.asp
           ├─ "booking"             → bs_ac_booking.asp
           ├─ "bookings"            → bs_ac_bookings.asp
           └─ else                  → bs_ac_mycals.asp
```

### データフロー図

```
[入力]                    [処理]                         [出力]

ブラウザ（GET）     ───▶ bs_ac.asp                   ───▶ HTMLレスポンス
?calAction=xxx            │
?iCalID=xxx               ├─ calAction判定
                          │
                          ├─▶ bs_ac_mycals.asp（デフォルト）
                          │       └─ cls_calendar.mycals()
                          │              └─ SELECT from tblCalendar
                          │
                          ├─▶ bs_ac_calendar.asp（createCal/editCal）
                          │       └─ cls_calendar.pick/save/delete()
                          │              └─ tblCalendar
                          │
                          ├─▶ bs_ac_bookings.asp（bookings）
                          │       └─ cls_calendar.bookings()
                          │              └─ SELECT from tblCalendarBooking
                          │
                          ├─▶ bs_ac_booking.asp（booking）
                          │       └─ cls_calendarbooking.pick/save/delete()
                          │              └─ tblCalendarBooking
                          │
                          └─▶ bs_ac_embed.asp（embedCode）
                                  └─ 埋め込みコード文字列生成
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_ac.asp | `asp/bs_ac.asp` | ソース | カレンダー管理ハブ画面 |
| bs_ac_mycals.asp | `asp/bs_ac_mycals.asp` | ソース | マイカレンダー一覧 |
| bs_ac_calendar.asp | `asp/bs_ac_calendar.asp` | ソース | カレンダー作成・編集 |
| bs_ac_bookings.asp | `asp/bs_ac_bookings.asp` | ソース | 予約一覧 |
| bs_ac_booking.asp | `asp/bs_ac_booking.asp` | ソース | 予約編集 |
| bs_ac_embed.asp | `asp/bs_ac_embed.asp` | ソース | 埋め込みコード生成 |
| bs_ac_view.asp | `asp/bs_ac_view.asp` | ソース | カレンダービュー表示 |
| bs_ac_menu.asp | `asp/bs_ac_menu.asp` | ソース | カレンダーメニュー |
| ac_calendar.asp | `asp/includes/ac_calendar.asp` | ソース | cls_Calendarクラス |
| ac_calendarbooking.asp | `asp/includes/ac_calendarbooking.asp` | ソース | cls_calendarbookingクラス |
| ac_statuslist.asp | `asp/includes/ac_statuslist.asp` | ソース | cls_statusListクラス |
| ac_calendarview.asp | `asp/includes/ac_calendarview.asp` | ソース | calendarviewクラス |
