# 画面設計書 106-予約一覧

## 概要

本ドキュメントは、QuickerSiteの予約カレンダー機能における予約一覧画面（bs_ac_bookings.asp）の設計書です。特定のカレンダーに登録されている予約をテーブル形式で一覧表示する管理画面について記載しています。

### 本画面の処理概要

予約一覧画面は、選択されたカレンダーに紐付くすべての予約情報をテーブル形式で表示し、各予約の確認・編集への導線を提供する画面です。

**業務上の目的・背景**：予約管理を行う際、登録されている予約を一覧で確認し、ステータス（確定/保留/利用不可）ごとに把握することは重要な業務です。本画面では、開始日の降順で予約を一覧表示し、各予約のステータスをアイコンで視覚的に表示します。また、カレンダープレビューも同時に表示され、予約状況を視覚的に確認できます。

**画面へのアクセス方法**：カレンダー管理画面（bs_ac.asp）からcalAction=bookingsパラメータを指定してアクセスします。マイカレンダー一覧の「Reservations」リンクからも遷移できます。

**主要な操作・処理内容**：
1. カレンダー選択ドロップダウンで対象カレンダーを切り替え
2. 予約一覧のテーブル表示（ソート可能）
3. 各予約のステータスアイコン表示
4. 予約詳細へのリンク（Modify）
5. メモ欄のポップアップ表示（Notes）
6. 新規予約追加へのリンク（Add Reservation）
7. カレンダープレビューの表示（12ヶ月分）

**画面遷移**：カレンダー管理画面（bs_ac.asp）からインクルードされます。予約編集（booking）、新規予約追加へ遷移できます。

**権限による表示制御**：親画面（bs_ac.asp）でセカンドアドミンのbAvailabilityCal権限チェックが行われます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 75 | カレンダー予約管理 | 主機能 | 予約の一覧表示・管理 |

## 画面種別

一覧

## URL/ルーティング

`asp/bs_ac.asp?calAction=bookings&iCalID={カレンダーID}`

パラメータ：
- `calAction`：bookings（固定）
- `iCalID`：対象カレンダーID

## 入出力項目

| 項目名 | 項目ID | 型 | 必須 | 最大長 | 説明 |
|--------|--------|-----|------|--------|------|
| カレンダー選択 | iCalID | select | * | - | 表示対象カレンダーの選択 |

## 表示項目

| 項目名 | 説明 |
|--------|------|
| カレンダー選択ドロップダウン | 所有カレンダーの一覧から選択 |
| 予約追加リンク | Add Reservationリンク |
| 予約一覧テーブル | ソート可能なテーブル |
| - ID | 予約ID |
| - ステータスアイコン | 状態を示すアイコン画像 |
| - Status | ステータス名（Confirmed/Pending/Unavailable） |
| - Start Date | 開始日（ヨーロッパ形式） |
| - End Date | 終了日（ヨーロッパ形式） |
| - Name | 予約者名 |
| - Email | メールアドレス（mailtoリンク） |
| - Phone | 電話番号 |
| - Notes | メモ（ポップアップリンク） |
| - Modify | 編集リンク |
| カレンダープレビュー | 12ヶ月分のカレンダー表示 |

## イベント仕様

### 1-カレンダー選択変更

1. ドロップダウンのonchangeでフォームをサブミット
2. 選択されたiCalIDで同画面を再読み込み
3. 新しいカレンダーの予約一覧を表示

### 2-Notesリンク押下

1. rel="example1"属性付きリンクでポップアップを開く
2. bs_ac_booking.aspにseeNotes=1パラメータを付けてアクセス
3. ポップアップ内に予約者名とメモ内容を表示
4. Modifyリンクで予約編集画面へ遷移可能

### 3-Modifyリンク押下

1. bs_ac.aspへcalAction=booking、iBookingID、iCalIDパラメータを付けて遷移
2. 予約編集画面を表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | tblCalendarBooking | SELECT | 予約一覧を取得 |
| 画面表示 | tblCalendar | SELECT | カレンダー情報を取得 |

### テーブル別取得項目詳細

#### tblCalendarBooking

| 項目（カラム名） | 用途 |
|-----------------|------|
| iId | 予約ID |
| iStatus | ステータスコード（15:Unavailable, 17:Pending, 20:Confirmed） |
| dStartDate | 開始日 |
| dEndDate | 終了日 |
| sName | 予約者名 |
| sEmail | メールアドレス |
| sPhone | 電話番号 |
| sNotes | メモ |

## メッセージ仕様

本画面では特定のメッセージ表示はありません。

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| 予約が0件 | 空のテーブルを表示（ヘッダー行のみ） |
| カレンダーが存在しない | カレンダー選択ドロップダウンが空 |

## 備考

- sorttable.jsによるテーブルソート機能を提供
- 日付はconvertEuroDate関数でヨーロッパ形式（DD/MM/YYYY）に変換
- メールアドレスがない場合は「---」を表示
- 電話番号がない場合は「---」を表示
- メモがない場合は「---」を表示（リンクなし）
- カレンダープレビューはbs_ac_view.aspをJavaScriptモードで呼び出し

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ac_calendar.asp | `asp/includes/ac_calendar.asp` | bookings関数で予約一覧を取得 |
| 1-2 | ac_calendarbooking.asp | `asp/includes/ac_calendarbooking.asp` | 予約データの構造を理解 |
| 1-3 | ac_statuslist.asp | `asp/includes/ac_statuslist.asp` | ステータスコードとアイコンの対応 |

#### Step 2: 画面本体を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_ac_bookings.asp | `asp/bs_ac_bookings.asp` | 予約一覧テーブルの生成ロジック |

**主要処理フロー**:
1. **2-3行目**: カレンダーオブジェクト生成、データ取得
2. **5行目**: 予約一覧取得（bookings）
3. **6行目**: ステータスリスト生成
4. **6行目**: カレンダー選択ドロップダウン、テーブルヘッダー出力
5. **6行目**: for each bookingで各予約行を生成
6. **6行目**: カレンダープレビュースクリプト出力

### プログラム呼び出し階層図

```
bs_ac.asp（親画面）
    │
    └─▶ bs_ac_bookings.asp（インクルード）
            │
            ├─ cls_calendar
            │      ├─ pick()（カレンダーデータ取得）
            │      ├─ calenderlist()（ドロップダウン生成）
            │      └─ bookings()（予約一覧取得）
            │              └─ cls_calendarbooking.pick()
            │
            ├─ cls_statusList
            │      ├─ getImage()（ステータスアイコン）
            │      └─ showSelected()（ステータス名）
            │
            └─ bs_ac_view.asp（JavaScriptインクルード）
                   └─ カレンダープレビュー表示
```

### データフロー図

```
[入力]                    [処理]                         [出力]

ブラウザ（GET）     ───▶ bs_ac_bookings.asp          ───▶ 予約一覧HTML
?iCalID=xxx               │
                          ├─ cal.pick(iCalID)
                          │      └─ SELECT from tblCalendar
                          │
                          ├─ cal.bookings()
                          │      └─ SELECT from tblCalendarBooking
                          │              WHERE iCalendarID=xxx
                          │              ORDER BY dStartdate desc
                          │
                          ├─ テーブル行生成
                          │      └─ for each booking in bookings
                          │
                          └─ カレンダープレビュー
                                 └─ bs_ac_view.asp?mode=js
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_ac_bookings.asp | `asp/bs_ac_bookings.asp` | ソース | 予約一覧画面本体 |
| bs_ac.asp | `asp/bs_ac.asp` | ソース | 親画面（ルーター） |
| bs_ac_booking.asp | `asp/bs_ac_booking.asp` | ソース | 予約編集画面 |
| bs_ac_view.asp | `asp/bs_ac_view.asp` | ソース | カレンダービュー |
| ac_calendar.asp | `asp/includes/ac_calendar.asp` | ソース | cls_Calendarクラス |
| ac_calendarbooking.asp | `asp/includes/ac_calendarbooking.asp` | ソース | cls_calendarbookingクラス |
| ac_statuslist.asp | `asp/includes/ac_statuslist.asp` | ソース | cls_statusListクラス |
| sorttable.js | `js/sorttable.js` | JavaScript | テーブルソート機能 |
