# 画面設計書 108-カレンダー表示

## 概要

本ドキュメントは、QuickerSiteの予約カレンダー機能におけるカレンダー編集画面（bs_ac_calendar.asp）の設計書です。カレンダーの基本情報（名前）の新規作成・編集・削除を行う管理画面について記載しています。

### 本画面の処理概要

カレンダー表示画面（カレンダー編集画面）は、予約カレンダーの基本情報を登録・編集するための画面です。カレンダー名を設定し、予約を管理するためのカレンダーマスタを作成します。

**業務上の目的・背景**：予約管理を行うには、まずカレンダー（予約対象となる物件、施設、リソースなど）を登録する必要があります。本画面では、カレンダーに名前を付けて登録し、その後予約管理を開始できるようにします。複数のカレンダーを管理でき、施設ごと、部屋ごとなど柔軟な運用が可能です。

**画面へのアクセス方法**：カレンダー管理画面（bs_ac.asp）からcalAction=createCal（新規）またはcalAction=editCal（編集）パラメータを指定してアクセスします。マイカレンダー一覧の「Modify / Delete」リンク、または「Create Calendar」リンクからも遷移できます。

**主要な操作・処理内容**：
1. カレンダー名の入力
2. カレンダーの保存（新規作成/更新）
3. カレンダーの削除（確認ダイアログ付き、関連予約も削除）

**画面遷移**：カレンダー管理画面（bs_ac.asp）からインクルードされます。保存・削除後はマイカレンダー一覧画面へリダイレクトします。

**権限による表示制御**：親画面（bs_ac.asp）でセカンドアドミンのbAvailabilityCal権限チェックが行われます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 74 | 予約カレンダー | 主機能 | カレンダー表示画面 |

## 画面種別

登録 / 編集

## URL/ルーティング

`asp/bs_ac.asp?calAction=createCal` または `asp/bs_ac.asp?calAction=editCal&iCalID={カレンダーID}`

パラメータ：
- `calAction`：createCal（新規）/ editCal（編集）
- `iCalID`：カレンダーID（編集時必須）

## 入出力項目

| 項目名 | 項目ID | 型 | 必須 | 最大長 | 説明 |
|--------|--------|-----|------|--------|------|
| カレンダー名 | sName | text | * | 50 | カレンダーの名称 |
| postback | postback | hidden | - | - | POSTバック判定フラグ |
| calAction | calAction | hidden | - | - | editCal（固定） |
| iCalID | iCalID | hidden | - | - | カレンダーID |

## 表示項目

| 項目名 | 説明 |
|--------|------|
| カレンダー名入力欄 | カレンダー名を入力するテキストボックス |
| 補足説明 | 「(in most cases the name of the property)」 |
| 保存ボタン | カレンダーを保存 |
| 削除ボタン | カレンダーを削除（既存編集時のみ表示、確認ダイアログ付き） |

## イベント仕様

### 1-保存ボタン押下

1. フォームデータをPOSTで送信
2. btnNameが「Save」の場合：
   - calendar.sNameにフォーム値を設定
   - calendar.save()を呼び出し
   - 入力検証（カレンダー名必須）
   - 検証成功時：tblCalendarに保存
   - マイカレンダー一覧へリダイレクト

### 2-削除ボタン押下

1. JavaScriptのconfirmダイアログで削除確認（NO WAY TO UNDO!警告付き）
2. btnNameが「Delete」の場合：
   - calendar.delete()を呼び出し
   - 関連するtblCalendarBookingレコードをすべて削除
   - tblCalendarレコードを削除
   - マイカレンダー一覧へリダイレクト

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下（新規） | tblCalendar | INSERT | 新規カレンダーレコードを作成 |
| 保存ボタン押下（更新） | tblCalendar | UPDATE | 既存カレンダーレコードを更新 |
| 削除ボタン押下 | tblCalendarBooking | DELETE | 関連予約をすべて削除 |
| 削除ボタン押下 | tblCalendar | DELETE | カレンダーレコードを削除 |

### テーブル別更新項目詳細

#### tblCalendar

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | iId | 自動採番 | 主キー |
| INSERT/UPDATE | sName | フォーム入力値 | カレンダー名 |
| INSERT/UPDATE | sBGColor | - | 背景色（本画面では未設定） |
| INSERT/UPDATE | sFontFamily | - | フォント（本画面では未設定） |
| INSERT/UPDATE | iCustomerID | cId（セッション） | 顧客ID |
| INSERT | dCreatedTS | now() | 作成日時 |
| DELETE | - | WHERE iId={カレンダーID} | 条件 |

#### tblCalendarBooking

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | - | WHERE iCalendarID={カレンダーID} | 関連予約一括削除 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| err_mandatory | エラー | 必須項目が入力されていません | カレンダー名が空の場合 |
| - | 確認 | Are you sure to delete this calendar? NO WAY TO UNDO! | 削除ボタン押下時 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| カレンダー名未入力 | エラーメッセージを表示し、フォームを再表示 |
| 存在しないカレンダーID | 空のフォームを表示（新規作成モード） |

## 備考

- カレンダー削除時は関連するすべての予約も削除される（カスケード削除）
- 削除は取り消し不可（NO WAY TO UNDO!）
- sBGColor、sFontFamilyはcls_Calendarに存在するが、本画面では編集UI未実装
- 補足説明として「物件名」を想定していることがわかる

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ac_calendar.asp | `asp/includes/ac_calendar.asp` | cls_Calendarクラス、save/delete関数 |

**読解のコツ**: delete関数ではtblCalendarBookingを先に削除してからtblCalendarを削除しています（外部キー制約対応）。

#### Step 2: 画面本体を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_ac_calendar.asp | `asp/bs_ac_calendar.asp` | カレンダー編集フォームとPOSTバック処理 |

**主要処理フロー**:
1. **2-3行目**: calendarオブジェクト生成、データ取得
2. **4-14行目**: POSTバック処理（Save/Delete分岐）
3. **15行目以降**: フォームHTML出力

### プログラム呼び出し階層図

```
bs_ac.asp（親画面）
    │
    └─▶ bs_ac_calendar.asp（インクルード）
            │
            └─ cls_calendar
                   ├─ pick()（カレンダーデータ取得）
                   ├─ save()（カレンダー保存）
                   │      └─ check()（入力検証）
                   └─ delete()（カレンダー削除）
                          ├─ DELETE from tblCalendarBooking
                          └─ DELETE from tblCalendar
```

### データフロー図

```
[入力]                    [処理]                         [出力]

ブラウザ（GET）     ───▶ bs_ac_calendar.asp          ───▶ 編集フォームHTML
?iCalID=xxx               └─ calendar.pick(iCalID)

ブラウザ（POST）    ───▶ bs_ac_calendar.asp          ───▶ リダイレクト
sName=xxx                 ├─ calendar.sName=xxx            (bs_ac.asp)
btnName=Save              ├─ calendar.save()
                          │      └─ INSERT/UPDATE tblCalendar
                          └─▶ bs_ac.asp

ブラウザ（POST）    ───▶ bs_ac_calendar.asp          ───▶ リダイレクト
btnName=Delete            └─ calendar.delete()
                                 ├─ DELETE tblCalendarBooking
                                 └─ DELETE tblCalendar
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_ac_calendar.asp | `asp/bs_ac_calendar.asp` | ソース | カレンダー編集画面本体 |
| bs_ac.asp | `asp/bs_ac.asp` | ソース | 親画面（ルーター） |
| bs_ac_mycals.asp | `asp/bs_ac_mycals.asp` | ソース | マイカレンダー一覧画面 |
| ac_calendar.asp | `asp/includes/ac_calendar.asp` | ソース | cls_Calendarクラス |
