# 画面設計書 109-カレンダービュー

## 概要

本ドキュメントは、QuickerSiteの予約カレンダー機能におけるカレンダービュー画面（bs_ac_view.asp）の設計書です。予約状況をカレンダー形式で視覚的に表示し、外部サイトへの埋め込みも可能な表示専用画面について記載しています。

### 本画面の処理概要

カレンダービュー画面は、特定のカレンダーの予約状況を月次カレンダー形式で表示する画面です。管理画面内でのプレビュー表示だけでなく、JavaScript/iframe/HTMLリンクとして外部サイトに埋め込むための出力モードも備えています。

**業務上の目的・背景**：予約カレンダーの最終的な目的は、顧客に空き状況を公開することです。本画面は、予約状況を色分けされたカレンダー形式で視覚的に表示し、利用可能/利用不可/保留中/予約済みの状態を一目で確認できるようにします。また、外部サイト（公開ウェブサイト）に埋め込み可能なコードを生成し、リアルタイムの空き状況を公開できます。

**画面へのアクセス方法**：直接URLアクセス、または管理画面内でのJavaScriptインクルードとして使用されます。予約一覧画面や予約編集画面のプレビュー表示、埋め込みコード画面のプレビュー等で使用されます。

**主要な操作・処理内容**：
1. 指定された月数分のカレンダーを表示（最大36ヶ月）
2. 予約状況に応じた日付セルの色分け表示
3. 前月/次月へのナビゲーション（Ajax対応）
4. 凡例（Available/Unavailable/Pending/Booked）の表示
5. JavaScript/iframe/HTMLリンク形式での出力

**画面遷移**：本画面は独立した表示専用画面のため、他画面への遷移機能はありません。Ajax通信で前月/次月の表示切り替えを行います。

**権限による表示制御**：認証不要の公開画面として動作します（secureプロパティ=false）。ただし、存在しないカレンダーIDが指定された場合は「Calendar not available」と表示します。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 74 | 予約カレンダー | 主機能 | カレンダービュー表示 |

## 画面種別

表示専用（埋め込み対応）

## URL/ルーティング

`asp/bs_ac_view.asp`

パラメータ：
- `iCalID`：カレンダーID（必須）
- `months`：表示月数（デフォルト12、最大36）
- `time`：表示期間モード
  - 0：今月から指定月数分（デフォルト）
  - 1：現在の暦年
  - 2：来年の暦年
- `mode`：出力モード
  - js：JavaScript形式
  - if/html：iframe/HTML形式
- `legend`：凡例表示（true/false、デフォルトtrue）

## 入出力項目

| 項目名 | 項目ID | 型 | 必須 | 最大長 | 説明 |
|--------|--------|-----|------|--------|------|
| Ajax操作 | ajax | form | - | - | prev/nextで前月/次月切り替え |

## 表示項目

| 項目名 | 説明 |
|--------|------|
| 月別カレンダー | 指定月数分の月次カレンダーをグリッド表示 |
| 曜日ヘッダー | 日〜土の曜日表示（多言語対応） |
| 日付セル | 予約状況に応じた背景色表示 |
| - 緑（10.gif） | Available（利用可能） |
| - 赤（15.gif） | Unavailable（利用不可） |
| - 黄（17.gif） | Pending（保留中） |
| - 青（20.gif） | Booked（予約済み） |
| ナビゲーション | < Prev / Next > リンク |
| 凡例 | ステータスと色の対応表 |

## イベント仕様

### 1-前月ナビゲーション押下

1. JavaScriptのget{calId}('prev')関数を呼び出し
2. Ajax通信でbs_ac_view.aspにPOSTリクエスト
3. ajax=prevパラメータでセッション変数を更新
4. session(cal.iId&"c0")をデクリメント
5. 更新後のカレンダーHTMLを返却し、DOM更新

### 2-次月ナビゲーション押下

1. JavaScriptのget{calId}('next')関数を呼び出し
2. Ajax通信でbs_ac_view.aspにPOSTリクエスト
3. ajax=nextパラメータでセッション変数を更新
4. session(cal.iId&"c0")をインクリメント
5. 更新後のカレンダーHTMLを返却し、DOM更新

## データベース更新仕様

本画面はデータベースの更新を行いません（読取専用）。

### データ取得

| テーブル | 用途 |
|---------|------|
| tblCalendar | カレンダー基本情報（名前、背景色、フォント） |
| tblCalendarBooking | 予約情報（日付、ステータス） |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| - | エラー | Calendar not available | カレンダーIDが不正または存在しない場合 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| カレンダーID未指定/不正 | 「Calendar not available」を表示して終了 |
| 月数が36を超える | 36に制限 |

## 備考

- calendarviewクラスのviewMonth関数でカレンダーHTML生成
- セッション変数でナビゲーション位置を保持（カレンダーIDごと）
- 半日予約は午前/午後で異なる背景パターンを適用
- スタイルは[R1][R2][R3]プレースホルダーで置換（インライン最適化）
- ajax.txtファイルからAjax用JavaScriptを読み込み
- 多言語対応（曜日名、月名、ナビゲーションテキスト）
- 処理時間はHTMLコメントで出力（PrintTimer）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ac_calendarview.asp | `asp/includes/ac_calendarview.asp` | calendarviewクラス、viewMonth関数でカレンダーHTML生成 |
| 1-2 | ac_statuslist.asp | `asp/includes/ac_statuslist.asp` | ステータスコードと背景画像の対応 |

**読解のコツ**: getDays関数で予約日ごとのステータスをDictionaryに格納し、viewMonth関数で各日付セルの背景を決定しています。

#### Step 2: 画面本体を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_ac_view.asp | `asp/bs_ac_view.asp` | 出力モード分岐、Ajax処理、カレンダー生成ループ |

**主要処理フロー**:
1. **4-18行目**: インクルードと初期化、カレンダー取得
2. **19-29行目**: 表示月数制限、time パラメータ処理
3. **33-85行目**: timeモードごとのカレンダー生成ループ
4. **86-112行目**: ナビゲーションと凡例HTML生成
5. **113-117行目**: スタイルプレースホルダー置換
6. **118-144行目**: 出力モード（js/if/html）による出力分岐
7. **145-161行目**: getAjaxJS関数（Ajax用JavaScript生成）

### プログラム呼び出し階層図

```
bs_ac_view.asp
    │
    ├─ begin.asp（初期化処理）
    │
    ├─ includes/ac_calendar.asp
    ├─ includes/ac_calendarview.asp
    ├─ includes/ac_calendarbooking.asp
    ├─ includes/ac_statuslist.asp
    │
    ├─ cls_calendar
    │      └─ pick()（secure=false）
    │
    ├─ calendarview
    │      ├─ getDays()（予約日のステータス取得）
    │      └─ viewMonth()（月次カレンダーHTML生成）
    │
    ├─ cls_statuslist
    │      └─ getCss()（ステータス背景スタイル）
    │
    └─ getAjaxJS()（Ajax JavaScript生成）
           └─ ajax.txt（テンプレート読み込み）
```

### データフロー図

```
[入力]                    [処理]                         [出力]

ブラウザ（GET）     ───▶ bs_ac_view.asp              ───▶ HTML/JS出力
?iCalID=xxx               │
?months=12                ├─ cal.pick(iCalID)
?mode=js                  │      └─ SELECT from tblCalendar
                          │
                          ├─ cv.getDays()
                          │      └─ SELECT from tblCalendarBooking
                          │
                          ├─ cv.viewMonth() × months
                          │      └─ カレンダーHTML生成
                          │
                          ├─ ナビゲーション・凡例追加
                          │
                          └─ 出力モード分岐
                                 ├─ js → document.write()
                                 ├─ if/html → 完全HTML
                                 └─ ajax → 部分HTML
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_ac_view.asp | `asp/bs_ac_view.asp` | ソース | カレンダービュー画面本体 |
| ac_calendar.asp | `asp/includes/ac_calendar.asp` | ソース | cls_Calendarクラス |
| ac_calendarview.asp | `asp/includes/ac_calendarview.asp` | ソース | calendarviewクラス |
| ac_calendarbooking.asp | `asp/includes/ac_calendarbooking.asp` | ソース | cls_calendarbookingクラス |
| ac_statuslist.asp | `asp/includes/ac_statuslist.asp` | ソース | cls_statusListクラス |
| ajax.txt | `asp/ajax.txt` | テンプレート | Ajax用JavaScriptテンプレート |
| ACimages/ | `fixedImages/ACimages/` | 画像 | ステータス背景画像（10.gif、15.gif、17.gif、20.gif） |
