# 画面設計書 11-リストテンプレート編集

## 概要

本ドキュメントは、QuickerSite CMSのバックサイト（管理画面）における「リストテンプレート編集」画面の設計仕様を定義するものである。

### 本画面の処理概要

リストテンプレート編集画面は、リスト形式ページの表示スタイルを選択・設定するための専用画面である。リストページ（ブログ、ニュース一覧など）における各アイテムの表示レイアウトを、3種類のプリセットテンプレートから選択することができる。

**業務上の目的・背景**：
リストページはCMSにおいてブログ記事一覧やニュース一覧など頻繁に使用される形式であり、各サイトのデザインや用途に応じて適切な表示スタイルを選択する必要がある。本画面は、技術的な知識がなくてもビジュアルプレビューを見ながら簡単にレイアウトを変更できるようにすることで、サイト管理者の業務効率を向上させる。

**画面へのアクセス方法**：
1. バックサイトにログイン後、ホーム画面からリストページを選択
2. リストページ編集画面（bs_listPage.asp）内のテンプレート設定リンクをクリック
3. URLパラメータとして暗号化されたページID（iId）が渡される

**主要な操作・処理内容**：
1. 3種類のリストテンプレートの視覚的なプレビュー画像を表示
2. ラジオボタンでテンプレートを選択
3. 保存ボタンで選択内容をデータベースに保存
4. 保存成功後、リストページ編集画面に自動リダイレクト

**画面遷移**：
- 遷移元: リストページ編集画面（bs_listPage.asp）
- 遷移先: リストページ編集画面（bs_listPage.asp）※保存後

**権限による表示制御**：
bs_security.aspによる認証チェックが行われ、ログインしていないユーザーはアクセスできない。セカンド管理者の権限設定による制限は本画面では適用されない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 13 | リストページ管理 | 主機能 | リストページのHTMLテンプレート編集 |
| 26 | テンプレート作成・編集 | 補助機能 | HTML・CSS構造の編集 |

## 画面種別

編集画面（設定変更）

## URL/ルーティング

```
asp/bs_editListTemplate.asp?iId={暗号化されたページID}
```

## 入出力項目

| 項目名 | 入力/出力 | データ型 | 必須 | 説明 |
|--------|----------|---------|------|------|
| iId | 入力（hidden） | String | Yes | 暗号化されたページID |
| sLPTemplate | 入力（radio） | String | Yes | テンプレート種別（1/2/3） |
| QS_secCodeHidden | 入力（hidden） | String | Yes | CSRF対策トークン |

## 表示項目

| 項目名 | 表示形式 | 説明 |
|--------|---------|------|
| ページタイトル | テキスト | 編集対象のリストページ名を表示 |
| テンプレート1プレビュー | 画像 | リストスタイル1のプレビュー画像（ls1.jpg） |
| テンプレート2プレビュー | 画像 | リストスタイル2のプレビュー画像（ls2.jpg） |
| テンプレート3プレビュー | 画像 | リストスタイル3のプレビュー画像（ls3.jpg） |
| 戻るリンク | リンク | リストページ編集画面への戻りリンク |

## イベント仕様

### 1-保存ボタン押下

1. フォームをPOST送信（同一ページへ送信）
2. サーバー側でsLPTemplateの値を取得
3. cls_pageオブジェクトのsLPTemplateプロパティを更新
4. page.save()メソッドでデータベースに保存
5. 保存成功時、リストページ編集画面にリダイレクト

### 2-リセットボタン押下

フォームの入力内容を初期状態（データベースの値）に戻す。

### 3-戻るリンククリック

リストページ編集画面（bs_listPage.asp）に遷移する。ページIDは暗号化されてURLパラメータとして渡される。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | tblPage | UPDATE | リストテンプレート設定を更新 |

### テーブル別更新項目詳細

#### tblPage

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | sLPTemplate | フォームから取得した値（1/2/3） | リストページの表示テンプレート |
| UPDATE | updatedTS | now() | 更新日時を自動設定 |

## メッセージ仕様

| メッセージID | 種別 | 表示条件 | メッセージ内容 |
|-------------|------|---------|--------------|
| - | - | 本画面では直接メッセージ表示なし | 保存成功後はリダイレクトのため |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| 未認証アクセス | bs_security.aspによりログイン画面にリダイレクト |
| 不正なページID | page.pick()で該当なしの場合、空のオブジェクトとなる |
| 保存失敗 | リダイレクトされず、同一画面に留まる |

## 備考

- テンプレートのプレビュー画像は`{C_DIRECTORY_QUICKERSITE}/fixedImages/liststyles/`ディレクトリに配置
- 各画像は200px幅で表示され、box-shadowスタイルが適用される
- CSRF対策としてQS_secCodeHiddenが使用されている

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

リストページのテンプレート設定がどのようにデータベースに格納されるかを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | page.asp | `asp/includes/page.asp` | cls_pageクラスのsLPTemplateプロパティの定義と保存処理 |

**読解のコツ**: ASP/VBScriptではClassステートメントでクラスを定義する。Publicプロパティがデータベースカラムに対応していることが多い。

#### Step 2: エントリーポイントを理解する

画面表示とフォーム処理の流れを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_editListTemplate.asp | `asp/bs_editListTemplate.asp` | メイン処理ファイル、フォーム表示とPOST処理 |

**主要処理フロー**:
1. **行7-10**: ページオブジェクトの初期化と既存データの取得
2. **行12-15**: POSTリクエスト時のテンプレート保存処理
3. **行20-43**: フォーム表示（テンプレート選択UI）

#### Step 3: 認証・セキュリティを理解する

アクセス制御の仕組みを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_security.asp | `asp/bs_security.asp` | バックサイトの認証チェック処理 |

**主要処理フロー**:
- ログインセッションの確認
- 未認証時のリダイレクト処理

#### Step 4: 共通部品を理解する

インクルードファイルの役割を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | begin.asp | `asp/begin.asp` | セッション初期化、基本設定読み込み |
| 4-2 | header.asp | `asp/includes/header.asp` | HTMLヘッダー出力 |
| 4-3 | bs_initBack.asp | `asp/bs_initBack.asp` | バックサイト初期化処理 |
| 4-4 | bs_header.asp | `asp/bs_header.asp` | バックサイト用ヘッダー出力 |

### プログラム呼び出し階層図

```
bs_editListTemplate.asp
    │
    ├─ begin.asp（セッション・DB初期化）
    │      └─ 各種設定ファイル読み込み
    │
    ├─ bs_security.asp（認証チェック）
    │
    ├─ bs_initBack.asp（バックサイト初期化）
    │
    ├─ cls_page.pick()（ページデータ取得）
    │      └─ tblPageテーブルSELECT
    │
    └─ cls_page.save()（データ保存）
           └─ tblPageテーブルUPDATE
```

### データフロー図

```
[入力]                  [処理]                      [出力]

URLパラメータ(iId) ─────▶ decrypt() ─────────────▶ ページID取得
                              │
                              ▼
                        cls_page.pick() ──────────▶ 現在のテンプレート設定
                              │
                              ▼
フォーム選択(sLPTemplate) ──▶ request.form() ─────▶ 選択値取得
                              │
                              ▼
                        cls_page.save() ──────────▶ tblPage UPDATE
                              │
                              ▼
                        response.redirect() ──────▶ リストページ編集画面
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_editListTemplate.asp | `asp/bs_editListTemplate.asp` | ソース | メイン画面処理 |
| begin.asp | `asp/begin.asp` | インクルード | 初期化処理 |
| bs_security.asp | `asp/bs_security.asp` | インクルード | 認証チェック |
| header.asp | `asp/includes/header.asp` | インクルード | HTMLヘッダー |
| bs_initBack.asp | `asp/bs_initBack.asp` | インクルード | バックサイト初期化 |
| bs_header.asp | `asp/bs_header.asp` | インクルード | バックサイトヘッダー |
| page.asp | `asp/includes/page.asp` | インクルード | cls_pageクラス定義 |
| bs_endBack.asp | `asp/bs_endBack.asp` | インクルード | バックサイトフッター |
| footer.asp | `asp/includes/footer.asp` | インクルード | HTMLフッター |
| ls1.jpg | `fixedImages/liststyles/ls1.jpg` | 画像 | テンプレート1プレビュー |
| ls2.jpg | `fixedImages/liststyles/ls2.jpg` | 画像 | テンプレート2プレビュー |
| ls3.jpg | `fixedImages/liststyles/ls3.jpg` | 画像 | テンプレート3プレビュー |
