# 画面設計書 110-マイカレンダー

## 概要

本ドキュメントは、QuickerSiteの予約カレンダー機能におけるマイカレンダー一覧画面（bs_ac_mycals.asp）の設計書です。ログインユーザーが所有するカレンダーの一覧を表示し、各種管理機能へのナビゲーションを提供する画面について記載しています。

### 本画面の処理概要

マイカレンダー画面は、カレンダー管理機能のダッシュボードとして機能する画面です。所有するすべてのカレンダーを一覧表示し、各カレンダーに対する操作メニューを提供します。

**業務上の目的・背景**：複数のカレンダー（物件、施設など）を管理する場合、まず全体像を把握できるダッシュボードが必要です。本画面では、登録済みのカレンダーを一覧で確認し、各カレンダーの編集・削除、予約管理、プレビュー、埋め込みコード生成への導線を提供します。これにより、効率的なカレンダー管理を実現します。

**画面へのアクセス方法**：カレンダー管理画面（bs_ac.asp）にcalActionパラメータなしでアクセス、またはカレンダー管理メニューの「My Calendars」リンクからアクセスします。

**主要な操作・処理内容**：
1. 所有カレンダーの一覧表示（カレンダー名をリスト形式）
2. カレンダーごとの操作メニュー表示
   - Modify / Delete：カレンダー編集画面へ
   - Reservations：予約一覧画面へ
   - Add Reservation：新規予約追加へ
   - Preview Calendar：カレンダービューを別タブで表示
   - Add this Calendar to my website：埋め込みコード画面へ

**画面遷移**：カレンダー管理画面（bs_ac.asp）からインクルードされます。各リンクから編集画面、予約一覧、予約編集、プレビュー、埋め込みコード画面へ遷移できます。

**権限による表示制御**：親画面（bs_ac.asp）でセカンドアドミンのbAvailabilityCal権限チェックが行われます。カレンダー一覧はiCustomerIDでフィルタリングされ、自分のカレンダーのみ表示されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 74 | 予約カレンダー | 主機能 | 個人カレンダーの一覧表示 |

## 画面種別

一覧（ダッシュボード）

## URL/ルーティング

`asp/bs_ac.asp`（calActionパラメータなし）

## 入出力項目

本画面は表示専用のため、入力項目はありません。

## 表示項目

| 項目名 | 説明 |
|--------|------|
| カレンダー一覧 | 所有カレンダーを順序付きリスト（ul）で表示 |
| カレンダー名 | 太字で表示 |
| 操作メニュー | 各カレンダーの下にネストしたリスト |
| - Modify / Delete | カレンダー編集・削除画面へのリンク |
| - Reservations | 予約一覧画面へのリンク |
| - Add Reservation | 新規予約追加へのリンク |
| - Preview Calendar | カレンダービュー（別タブ） |
| - Add this Calendar to my website | 埋め込みコード画面へのリンク |
| 空メッセージ | カレンダーが0件の場合「No calendars yet.」を表示 |

## イベント仕様

### 1-Modify / Deleteリンク押下

- `bs_ac.asp?iCalID={calId}&calAction=editCal`へ遷移
- カレンダー編集画面を表示

### 2-Reservationsリンク押下

- `bs_ac.asp?iCalID={calId}&calAction=bookings`へ遷移
- 予約一覧画面を表示

### 3-Add Reservationリンク押下

- `bs_ac.asp?iCalID={calId}&calAction=booking`へ遷移
- 新規予約編集画面を表示

### 4-Preview Calendarリンク押下

- `bs_ac_view.asp?time=1&mode=html&iCalID={calId}`を別タブで開く
- 現在の暦年のカレンダービューをHTML形式で表示

### 5-Add this Calendar to my websiteリンク押下

- `bs_ac.asp?iCalID={calId}&calAction=embedCode`へ遷移
- 埋め込みコード生成画面を表示

## データベース更新仕様

本画面はデータベースの更新を行いません（読取専用）。

### データ取得

| テーブル | 用途 |
|---------|------|
| tblCalendar | カレンダー一覧取得（WHERE iCustomerID=cId ORDER BY sName） |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| - | 情報 | No calendars yet. | カレンダーが0件の場合 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| カレンダー0件 | 「No calendars yet.」を中央揃えで表示 |

## 備考

- カレンダーは名前順（ORDER BY sName）で表示
- 各カレンダーの操作メニューはネストしたリスト構造
- プレビューリンクはclass="QSPP"（ポップアップ表示用）とtarget="_blank"
- カレンダー作成リンクはbs_ac_menu.aspで提供（Create Calendar）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ac_calendar.asp | `asp/includes/ac_calendar.asp` | mycals関数でカレンダー一覧を取得 |

**読解のコツ**: mycals関数はDictionaryオブジェクトを返し、カレンダーIDをキー、cls_calendarオブジェクトを値として格納しています。

#### Step 2: 画面本体を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_ac_mycals.asp | `asp/bs_ac_mycals.asp` | カレンダー一覧の生成ロジック |

**主要処理フロー**:
1. **2-3行目**: calObjオブジェクト生成、mycals取得
2. **4-6行目**: カレンダーが1件以上あればulタグ開始
3. **7-16行目**: for eachループで各カレンダーの表示
4. **17-22行目**: カレンダー0件時のメッセージ表示
5. **23-24行目**: クリーンアップ

### プログラム呼び出し階層図

```
bs_ac.asp（親画面）
    │
    └─▶ bs_ac_mycals.asp（インクルード）
            │
            └─ cls_calendar
                   └─ mycals()（カレンダー一覧取得）
                          ├─ SELECT iId FROM tblCalendar
                          │      WHERE iCustomerID=cId
                          │      ORDER BY sName
                          │
                          └─ for each → cls_calendar.pick()
```

### データフロー図

```
[入力]                    [処理]                         [出力]

ブラウザ（GET）     ───▶ bs_ac_mycals.asp            ───▶ 一覧HTML
                          │
                          ├─ calObj.mycals()
                          │      └─ SELECT from tblCalendar
                          │              WHERE iCustomerID=cId
                          │
                          ├─ if mycals.count>0
                          │      └─ for each cal in mycals
                          │             └─ リンク生成
                          │
                          └─ else
                                 └─ 「No calendars yet.」
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_ac_mycals.asp | `asp/bs_ac_mycals.asp` | ソース | マイカレンダー一覧画面本体 |
| bs_ac.asp | `asp/bs_ac.asp` | ソース | 親画面（ルーター） |
| bs_ac_calendar.asp | `asp/bs_ac_calendar.asp` | ソース | カレンダー編集画面 |
| bs_ac_bookings.asp | `asp/bs_ac_bookings.asp` | ソース | 予約一覧画面 |
| bs_ac_booking.asp | `asp/bs_ac_booking.asp` | ソース | 予約編集画面 |
| bs_ac_view.asp | `asp/bs_ac_view.asp` | ソース | カレンダービュー画面 |
| bs_ac_embed.asp | `asp/bs_ac_embed.asp` | ソース | 埋め込みコード画面 |
| bs_ac_menu.asp | `asp/bs_ac_menu.asp` | ソース | カレンダーメニュー |
| ac_calendar.asp | `asp/includes/ac_calendar.asp` | ソース | cls_Calendarクラス |
