# 画面設計書 111-埋め込みコード

## 概要

本ドキュメントは、QuickerSite CMSにおける「埋め込みコード」画面（bs_ac_embed.asp）の設計仕様を定義するものである。

### 本画面の処理概要

本画面は、予約カレンダーを外部Webサイトに埋め込むためのコードを生成する機能を提供する。管理者は表示形式や表示期間を選択し、JavaScript、iframe、HTMLリンクの3種類の埋め込みコードを取得できる。

**業務上の目的・背景**：予約カレンダー機能を持つサイト運営者が、外部の既存Webサイトやブログにカレンダーを埋め込みたいというニーズに対応する。コピー＆ペーストで簡単に埋め込みを実現できることで、技術的知識が乏しいユーザーでもカレンダーの外部公開が可能になる。宿泊施設、レンタルスペース、イベント会場などの空き状況を外部に公開する際に使用される。

**画面へのアクセス方法**：バックサイトにログイン後、「予約カレンダー」メニューからマイカレンダー一覧を表示し、対象カレンダーの「埋め込みコード」ボタンをクリックすることでアクセスする。URLパラメータに`calAction=embedcode`および`iCalID=`（カレンダーID）が必要。

**主要な操作・処理内容**：
1. 表示期間の選択（次のX月、今年のカレンダー、来年のカレンダー）
2. 表示月数の選択（1〜24ヶ月）
3. 凡例（Legend）の表示/非表示設定
4. 生成された埋め込みコード（JavaScript/HTML/iframe）のコピー

**画面遷移**：
- 遷移元：bs_ac.asp（カレンダー管理画面）
- 遷移先：bs_ac.asp（保存後リダイレクト）

**権限による表示制御**：セカンド管理者設定において`bAvailabilityCal`がtrueの場合のみアクセス可能。プライマリ管理者は常にアクセス可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 76 | カレンダー埋め込みコード | 主機能 | 外部サイトへの埋め込み用コード生成 |
| 74 | 予約カレンダー | 補助機能 | カレンダー情報の取得 |

## 画面種別

設定 / コード生成

## URL/ルーティング

```
asp/bs_ac.asp?calAction=embedcode&iCalID={カレンダーID}
```

## 入出力項目

| 項目名 | 項目ID | 型 | 必須 | 入力/出力 | 説明 |
|--------|--------|-----|------|-----------|------|
| カレンダーID | iCalID | 数値 | 必須 | 入力 | 対象カレンダーのID |
| 表示期間タイプ | time | 数値 | 必須 | 入力 | 0:次のX月, 1:今年, 2:来年 |
| 表示月数 | months | 数値 | 条件付 | 入力 | time=0の場合必須（1-24） |
| 凡例表示 | iLegend | ブール | 任意 | 入力 | 凡例を表示するか |
| ポストバック | postback | ブール | - | 入力 | フォーム送信フラグ |

## 表示項目

| 項目名 | 説明 |
|--------|------|
| カレンダー名 | 対象カレンダーの名称 |
| JavaScriptコード | scriptタグ形式の埋め込みコード |
| HTMLリンクコード | aタグで使用するURL |
| iframeコード | iframe形式の埋め込みコード |

## イベント仕様

### 1-表示期間選択変更

表示期間タイプのセレクトボックスを変更すると、JavaScriptでフォームが自動送信される。

**処理フロー**：
1. ユーザーが表示期間タイプを選択
2. `onchange`イベントで`document.embedForm.submit()`が実行
3. サーバー側で選択値に応じたパラメータを構築
4. 画面が再描画され、必要に応じて月数選択が表示される

### 2-月数選択変更

表示期間タイプが「次のX月」の場合に表示される月数選択を変更すると、フォームが自動送信される。

### 3-凡例表示チェックボックス変更

チェックボックスをクリックすると、フォームが自動送信され、埋め込みコードの凡例パラメータが更新される。

### 4-埋め込みコードのコピー

各テキストエリアをクリックすると、JavaScriptの`select()`メソッドでテキスト全体が選択され、ユーザーはCtrl+Cでコピーできる。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | tblCalendar | SELECT | カレンダー情報の取得 |

### テーブル別更新項目詳細

#### tblCalendar（参照のみ）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | iId | クエリパラメータのiCalID | カレンダー識別 |
| SELECT | sName | - | カレンダー名表示用 |
| SELECT | iCustomerID | 現在のcIdと一致確認 | セキュリティ検証 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| - | 情報 | Add calender {カレンダー名} to my website. | 常時表示 |
| - | 説明 | Recommended use: Copy/Paste the JavaScript below... | 埋め込みコード生成時 |
| - | TIP | You can set the number of months to be displayed... | 埋め込みコード生成時 |

## 例外処理

| 例外パターン | 処理内容 |
|-------------|---------|
| カレンダーIDが無効 | 画面に何も表示されない（フォームのみ） |
| カレンダーが存在しない | カレンダー情報が取得できず、空白表示 |
| 権限不足 | bs_security.aspでアクセス拒否 |

## 備考

- JavaScript埋め込みコードを推奨：iframeよりもシームレスに表示される
- 最大表示月数は36ヶ月に制限されている（bs_ac_view.asp Line 30-31）
- 凡例には Available/Unavailable/Pending/Booked の4つのステータスが表示される
- 外部サイトへの埋め込み時は、QuickerSiteサーバーへのアクセスが必要

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

カレンダーの基本データ構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ac_calendar.asp | `asp/includes/ac_calendar.asp` | cls_Calendarクラスの構造、プロパティ（iId, sName, sBGColor, sFontFamily）を理解 |

**読解のコツ**: VBScriptのClassブロック内でPublicキーワードで定義されているプロパティがデータ項目となる。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイルを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_ac.asp | `asp/bs_ac.asp` | カレンダー管理のルーティング処理。calAction=embedcodeでbs_ac_embed.aspがインクルードされる |

**主要処理フロー**:
1. **Line 8**: `action=request("calAction")`でアクションを取得
2. **Line 9**: `case "embedcode"`でbs_ac_embed.aspをインクルード

#### Step 3: 埋め込みコード生成処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_ac_embed.asp | `asp/bs_ac_embed.asp` | 埋め込みコード生成のメインロジック |

**主要処理フロー**:
- **Line 2-3**: カレンダーオブジェクトの生成とデータ取得
- **Line 4-13**: 凡例表示フラグの処理
- **Line 15-19**: 表示月数の取得（デフォルト12ヶ月）
- **Line 30-32**: embedJSCode/embedIFcode/embedHTMLcodeの生成

#### Step 4: カレンダービュー生成を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | bs_ac_view.asp | `asp/bs_ac_view.asp` | 実際のカレンダー表示を生成するエンドポイント |

**主要処理フロー**:
- **Line 29-31**: 最大月数を36に制限
- **Line 33-85**: timeパラメータによる表示期間の制御
- **Line 118-144**: mode（if/html/js）による出力形式の切り替え

### プログラム呼び出し階層図

```
bs_ac.asp
    │
    ├─ bs_security.asp（認証チェック）
    │
    ├─ includes/ac_calendar.asp（cls_Calendarクラス）
    │
    └─ bs_ac_embed.asp（calAction=embedcode時）
           │
           └─ cls_calendar.pick()（カレンダー情報取得）
```

### データフロー図

```
[入力]                    [処理]                         [出力]

iCalID ─────────────▶ cls_calendar.pick() ──▶ カレンダー情報取得
time (0/1/2) ────────▶ パラメータ構築 ───────▶ 表示期間設定
months (1-24) ───────▶ パラメータ構築 ───────▶ 表示月数設定
iLegend ─────────────▶ パラメータ構築 ───────▶ 凡例設定
                              │
                              ▼
                     埋め込みコード生成
                              │
              ┌───────────────┼───────────────┐
              ▼               ▼               ▼
         embedJSCode    embedHTMLcode   embedIFcode
         (JavaScript)    (リンクURL)     (iframe)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_ac.asp | `asp/bs_ac.asp` | ソース | カレンダー管理のルーター |
| bs_ac_embed.asp | `asp/bs_ac_embed.asp` | ソース | 埋め込みコード生成画面 |
| bs_ac_view.asp | `asp/bs_ac_view.asp` | ソース | カレンダービュー表示（埋め込み先が参照） |
| ac_calendar.asp | `asp/includes/ac_calendar.asp` | インクルード | cls_Calendarクラス定義 |
| ac_calendarview.asp | `asp/includes/ac_calendarview.asp` | インクルード | カレンダービュークラス |
| bs_security.asp | `asp/bs_security.asp` | インクルード | セキュリティ・認証処理 |
| ajax.txt | `asp/ajax.txt` | 設定 | Ajax用JavaScriptテンプレート |
