# 画面設計書 112-カレンダーメニュー

## 概要

本ドキュメントは、QuickerSite CMSにおける「カレンダーメニュー」画面（bs_ac_menu.asp）の設計仕様を定義するものである。

### 本画面の処理概要

本画面は、予約カレンダー管理機能へのナビゲーションメニューを提供する。マイカレンダー一覧へのリンクと新規カレンダー作成へのリンクが表示される、シンプルなメニュー画面である。

**業務上の目的・背景**：予約カレンダー機能を使用する際に、一貫したナビゲーションを提供するために用意されている。カレンダー管理の各サブ画面（カレンダー一覧、新規作成、埋め込みコード、予約管理など）からこのメニューを通じて他の機能に素早くアクセスできるようにすることで、管理者の作業効率を向上させる。

**画面へのアクセス方法**：このファイルは単独でアクセスされるものではなく、bs_ac.asp（カレンダー管理画面）内でインクルードされて表示される。すべてのカレンダー関連画面の上部にナビゲーションとして表示される。

**主要な操作・処理内容**：
1. 「My Calendars」リンクのクリック：マイカレンダー一覧画面へ遷移
2. 「Create Calendar」リンクのクリック：新規カレンダー作成画面へ遷移

**画面遷移**：
- 遷移元：bs_ac.asp（カレンダー管理の各サブ画面）からインクルード
- 遷移先：bs_ac.asp（パラメータなし：マイカレンダー一覧）、bs_ac.asp?calAction=createCal（新規カレンダー作成）

**権限による表示制御**：親画面（bs_ac.asp）でセカンド管理者設定の`bAvailabilityCal`による権限チェックが行われる。このメニュー自体では追加の権限チェックは行わない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 74 | 予約カレンダー | 主機能 | カレンダーメニューの表示 |
| 75 | カレンダー予約管理 | 遷移先機能 | 予約一覧画面への遷移 |
| 76 | カレンダー埋め込みコード | 遷移先機能 | 埋め込みコード画面への遷移 |

## 画面種別

メニュー / ナビゲーション

## URL/ルーティング

```
asp/bs_ac_menu.asp（インクルードファイル、直接アクセス不可）
```

親画面経由：
```
asp/bs_ac.asp
```

## 入出力項目

本画面は入力項目を持たない。ナビゲーションリンクのみを表示するインクルードファイルである。

| 項目名 | 項目ID | 型 | 必須 | 入力/出力 | 説明 |
|--------|--------|-----|------|-----------|------|
| なし | - | - | - | - | 入力項目なし |

## 表示項目

| 項目名 | 説明 |
|--------|------|
| My Calendarsリンク | マイカレンダー一覧へのナビゲーションリンク |
| Create Calendarリンク | 新規カレンダー作成へのナビゲーションリンク |

## イベント仕様

### 1-My Calendarsリンククリック

リンクをクリックすると、マイカレンダー一覧画面に遷移する。

**処理フロー**：
1. ユーザーが「My Calendars」リンクをクリック
2. bs_ac.asp（パラメータなし）にGETリクエスト送信
3. bs_ac.aspでcalActionが空のため、bs_ac_mycals.aspがインクルードされる
4. マイカレンダー一覧が表示される

### 2-Create Calendarリンククリック

リンクをクリックすると、新規カレンダー作成画面に遷移する。

**処理フロー**：
1. ユーザーが「Create Calendar」リンクをクリック
2. bs_ac.asp?calAction=createCalにGETリクエスト送信
3. bs_ac.aspでcalAction=createCalのため、bs_ac_calendar.aspがインクルードされる
4. 新規カレンダー作成フォームが表示される

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| なし | - | - | データベースアクセスなし |

本画面はナビゲーションメニューのみを表示するため、データベースへのアクセスは発生しない。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| なし | - | - | メッセージ表示なし |

## 例外処理

| 例外パターン | 処理内容 |
|-------------|---------|
| 認証エラー | 親画面（bs_ac.asp）でリダイレクト処理 |

本画面単独での例外処理はなく、親画面で処理される。

## 備考

- 本ファイルは非常にシンプルで、3行のHTMLコードのみで構成されている
- getArtLink関数を使用してスタイル付きリンクを生成している
- メニュー項目は固定で、動的な表示制御は行われない
- 予約カレンダー機能のすべてのサブ画面で共通して表示される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

本画面はデータを扱わないため、このステップは省略可能。ただし、リンク先で使用されるカレンダーデータ構造を理解しておくとよい。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ac_calendar.asp | `asp/includes/ac_calendar.asp` | リンク先で使用されるcls_Calendarクラス |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_ac.asp | `asp/bs_ac.asp` | 本メニューをインクルードしている親画面 |

**主要処理フロー**:
1. **Line 4**: `<!-- #include file="bs_ac_menu.asp"-->`でメニューをインクルード
2. **Line 8**: `action=request("calAction")`でサブ画面を決定

#### Step 3: メニュー表示処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_ac_menu.asp | `asp/bs_ac_menu.asp` | メニュー表示の実装 |

**主要処理フロー**:
- **Line 2**: テーブルレイアウトでメニューを中央配置
- **Line 2**: `getArtLink("bs_ac.asp","My Calendars",...)`でマイカレンダーリンク生成
- **Line 3**: `getArtLink("bs_ac.asp?calAction=createCal","Create Calendar",...)`で作成リンク生成

#### Step 4: リンク生成関数を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | functions.asp | `asp/includes/functions.asp` | getArtLink関数の実装 |

**読解のコツ**: getArtLink関数はアンカータグにスタイルを適用してリンクを生成するヘルパー関数。

### プログラム呼び出し階層図

```
bs_ac.asp
    │
    ├─ bs_security.asp（認証チェック）
    │
    ├─ bs_ac_menu.asp（本ファイル）
    │       │
    │       └─ getArtLink()（リンク生成）
    │
    └─ bs_ac_mycals.asp / bs_ac_calendar.asp / ...（サブ画面）
```

### データフロー図

```
[入力]              [処理]                    [出力]

    なし ─────────▶ HTML生成 ─────────▶ ナビゲーションメニュー
                         │
                         ├─▶ My Calendarsリンク
                         │
                         └─▶ Create Calendarリンク
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_ac_menu.asp | `asp/bs_ac_menu.asp` | ソース | カレンダーメニュー表示（本ファイル） |
| bs_ac.asp | `asp/bs_ac.asp` | ソース | カレンダー管理の親画面（本ファイルをインクルード） |
| bs_ac_mycals.asp | `asp/bs_ac_mycals.asp` | ソース | マイカレンダー一覧（リンク先） |
| bs_ac_calendar.asp | `asp/bs_ac_calendar.asp` | ソース | カレンダー作成/編集（リンク先） |
| functions.asp | `asp/includes/functions.asp` | インクルード | getArtLink関数定義 |
| bs_security.asp | `asp/bs_security.asp` | インクルード | 権限チェック処理 |
