# 画面設計書 113-セキュリティ設定

## 概要

本ドキュメントは、QuickerSite CMSにおける「セキュリティ設定」画面（bs_security.asp）の設計仕様を定義するものである。

### 本画面の処理概要

本画面は、バックサイト（管理画面）へのアクセス認証とセキュリティ制御を行う基盤処理である。ユーザーの認証状態を検証し、認証されていない場合はアクセスを拒否してリダイレクトする。また、セカンド管理者の権限設定に基づいて各機能へのアクセス可否を制御する。これは画面というよりも、他の管理画面からインクルードされるセキュリティインクルードファイルである。

**業務上の目的・背景**：CMSの管理画面は機密情報や重要な設定を扱うため、適切な認証・認可制御が不可欠である。本ファイルは、認証されていないユーザーの不正アクセスを防止し、セカンド管理者に対しては許可された機能のみへのアクセスを制限することで、セキュリティを確保する。プライマリ管理者とセカンド管理者の権限分離により、運用上のリスクを軽減する。

**画面へのアクセス方法**：本ファイルは直接アクセスするものではなく、バックサイトのほぼすべての画面で`<!-- #include file="bs_security.asp"-->`としてインクルードされる。管理画面にアクセスすると自動的にこのセキュリティチェックが実行される。

**主要な操作・処理内容**：
1. セッション変数によるログイン認証の検証
2. Cookie認証モードでのログイン検証（オプション）
3. セカンド管理者の場合、全機能アクセス権限の設定
4. デフォルトパスワード使用時の初期セットアップ画面へのリダイレクト
5. ページキャッシュのクリア

**画面遷移**：
- 遷移元：バックサイトの各画面からインクルード
- 遷移先（リダイレクト）：noaccess.htm（認証失敗時）、bs_initialsetup.asp（初期設定未完了時）、bs_page（リクエストパラメータ指定時）

**権限による表示制御**：プライマリ管理者の場合は全機能へのアクセス権限が自動的に付与される。セカンド管理者の場合は、tblSecondAdminに保存された権限設定に基づいてアクセスが制御される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 3 | セカンドアドミン管理 | 主機能 | バックサイトのセキュリティ・アクセス制御設定 |
| 117 | CSRF対策 | 補助機能 | セキュリティトークンによるリクエスト検証 |

## 画面種別

インクルードファイル / セキュリティ制御

## URL/ルーティング

```
asp/bs_security.asp（インクルードファイル、直接アクセス不可）
```

## 入出力項目

| 項目名 | 項目ID | 型 | 必須 | 入力/出力 | 説明 |
|--------|--------|-----|------|-----------|------|
| ページリダイレクト先 | bs_page | 文字列 | 任意 | 入力 | 認証後のリダイレクト先ページ |
| 認証セッション | Session(cId & "isAUTHENTICATED") | ブール | - | 参照 | プライマリ管理者ログイン状態 |
| セカンド管理者認証 | Session(cId & "isAUTHENTICATEDSecondAdmin") | ブール | - | 参照 | セカンド管理者ログイン状態 |
| Cookie認証トークン | cookies.item(cId&"hfsdsiiqqssdfjf") | 文字列 | 任意 | 参照 | Cookie認証用トークン |

## 表示項目

本ファイルは画面表示を行わない（セキュリティ処理のみ）。

## イベント仕様

### 1-認証チェック処理

ファイルがインクルードされた際に自動実行される。

**処理フロー**：
1. セカンド管理者オブジェクト（secondAdmin）を取得
2. Session変数で認証状態をチェック
3. 認証されていない場合：
   - Cookie認証モードが有効ならCookie認証を試行
   - 認証失敗時はnoaccess.htmにリダイレクト
4. bs_pageパラメータがある場合、そのページにリダイレクト
5. プライマリ管理者の場合、secondAdminオブジェクトに全権限を設定
6. デフォルトパスワード使用中ならbs_initialsetup.aspにリダイレクト
7. ページキャッシュをクリア

### 2-権限設定処理

プライマリ管理者でログインした場合、セカンド管理者用の権限フラグすべてにtrueを設定する。

**設定される権限フラグ**：
- bSetupGeneral, bSetupPageElements, bStats, bTemplates
- bHomeConstants, bHomeVBScript, bFiles, bForms
- bIntranet, bIntranetSetup, bIntranetContacts, bIntranetMail
- bCatalog, bFeed, bTheme, bFormExport, bApplicationpath
- bGallery, bPagesAdd, bPagesPW, bPagesMove, bPagesDelete
- bPageUrlRSS, bPageAdditionalHeader, bPageDescription, bPageKeywords
- bPageTitleTag, bPageRefresh, bPageTemplate, bPageTheme, bPageForm
- bPageCatalog, bPageFeed, bPageSetHomepage, bPagePublish, bPageOrder
- bPageTitle, bPageBody, bPageUFL, bCalendar, bPoll, bGuestbook
- bPopup, bAvailabilityCal, bShoppingCart, bCookieWarning, bCustom404
- bNewsletter

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| セカンド管理者情報取得 | tblSecondAdmin | SELECT | 権限設定の読み取り |

### テーブル別更新項目詳細

#### tblSecondAdmin（参照のみ）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | sPassword | customer.secondAdmin経由 | パスワード比較用 |
| SELECT | 全権限フラグ | customer.secondAdmin経由 | アクセス権限判定 |

## メッセージ仕様

本ファイルはメッセージを表示しない（リダイレクト処理のみ）。

## 例外処理

| 例外パターン | 処理内容 |
|-------------|---------|
| 未認証アクセス | noaccess.htmにリダイレクト |
| Cookie認証失敗 | noaccess.htmにリダイレクト |
| デフォルトパスワード使用 | bs_initialsetup.aspにリダイレクト |

## 備考

- QS_enableCookieMode：Cookie認証を有効にするグローバル設定
- blockDefaultPW：デフォルトパスワード使用をブロックする設定
- devVersion()：開発バージョンフラグ（開発時はデフォルトPW制限を緩和）
- logon.currentPW：現在ログイン中のパスワード
- customer.adminPassword：プライマリ管理者パスワード（SHA256ハッシュ）
- このファイルはセキュリティの要であり、すべてのバックサイト画面で必須

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

セカンド管理者の権限データ構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | secondAdmin.asp | `asp/includes/secondAdmin.asp` | cls_secondAdminクラス、50以上の権限フラグを持つ |

**読解のコツ**: Public宣言されているフラグ（bSetupGeneral, bPagesAdd等）が権限制御に使用される。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_security.asp | `asp/bs_security.asp` | セキュリティチェックのメインロジック |

**主要処理フロー**:
1. **Line 2-3**: secondAdminオブジェクトの取得
2. **Line 7-13**: 認証状態の検証とリダイレクト
3. **Line 14-16**: bs_pageパラメータによるリダイレクト
4. **Line 17-75**: プライマリ管理者時の全権限付与
5. **Line 76-78**: デフォルトパスワードチェック
6. **Line 79**: ページキャッシュクリア

#### Step 3: 認証処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | logon.asp | `asp/includes/logon.asp`（推定） | logonオブジェクトの実装 |

**読解のコツ**: logon.logon()メソッドがCookie認証を行い、logon.currentPWでログインパスワードを取得。

#### Step 4: Customerオブジェクトとの連携を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | customer.asp | `asp/includes/customer.asp` | customerオブジェクトのsecondAdminプロパティ |

### プログラム呼び出し階層図

```
任意のバックサイト画面
    │
    └─ bs_security.asp（インクルード）
           │
           ├─ customer.secondAdmin（セカンド管理者情報取得）
           │      └─ tblSecondAdmin（SELECT）
           │
           ├─ Session(cId & "isAUTHENTICATED")（認証チェック）
           │
           ├─ Session(cId & "isAUTHENTICATEDSecondAdmin")（認証チェック）
           │
           ├─ logon.logon()（Cookie認証、オプション）
           │
           └─ customer.clearPageCache()（キャッシュクリア）
```

### データフロー図

```
[入力]                      [処理]                         [出力]

Session変数 ─────────────▶ 認証状態チェック ─────────▶ 認証OK → 処理続行
                                │                    └─ 認証NG → リダイレクト
Cookie ──────────────────▶ Cookie認証（オプション）
                                │
customer.secondAdmin ────▶ パスワード比較 ─────────▶ プライマリ/セカンド判定
                                │
                                ▼
                         権限フラグ設定
                                │
                                ▼
                         secondAdminオブジェクト
                         （各画面で参照）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_security.asp | `asp/bs_security.asp` | ソース | セキュリティチェック処理（本ファイル） |
| secondAdmin.asp | `asp/includes/secondAdmin.asp` | インクルード | cls_secondAdminクラス定義 |
| customer.asp | `asp/includes/customer.asp` | インクルード | customerオブジェクト、secondAdminプロパティ |
| noaccess.htm | `asp/noaccess.htm` | 静的HTML | アクセス拒否時のリダイレクト先 |
| bs_initialsetup.asp | `asp/bs_initialsetup.asp` | ソース | 初期セットアップ画面 |
| begin.asp | `asp/begin.asp` | インクルード | 共通初期化処理 |
