# 画面設計書 114-管理者セキュリティ

## 概要

本ドキュメントは、QuickerSite CMSにおける「管理者セキュリティ」画面（ad_security.asp）の設計仕様を定義するものである。

### 本画面の処理概要

本画面は、システム管理者（Admin）向けのセキュリティチェック処理を行うインクルードファイルである。管理者画面（ad_*.asp）へのアクセス時に認証状態を検証し、未認証の場合やデフォルトパスワード使用時にアクセスを拒否する。バックサイト用のbs_security.aspとは異なり、より厳格なセキュリティ要件を持つ管理者専用の認証チェックである。

**業務上の目的・背景**：システム管理者（Admin）は、顧客サイトの管理、IIS設定、システムアップグレードなど、より高い権限を持つ操作を行う。そのため、通常のバックサイト管理者よりも厳格な認証が必要である。特にデフォルトパスワードの使用を禁止することで、初期設定のまま放置されたシステムへの不正アクセスを防止する。

**画面へのアクセス方法**：本ファイルは直接アクセスするものではなく、管理者画面（ad_*.asp）で`<!-- #include file="ad_security.asp"-->`としてインクルードされる。管理者画面にアクセスすると自動的にこのセキュリティチェックが実行される。

**主要な操作・処理内容**：
1. C_ADMINPASSWORDがデフォルトパスワードでないことを確認
2. セッション変数によるAdmin認証状態の検証
3. 認証失敗時のリダイレクト処理

**画面遷移**：
- 遷移元：管理者画面（ad_*.asp）からインクルード
- 遷移先（リダイレクト）：noaccess.htm（認証失敗時）

**権限による表示制御**：Admin権限（Session(cId & "isAUTHENTICATEDasADMIN")）を持つユーザーのみがアクセス可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | 管理者ログイン | 主機能 | 管理者の認証・セキュリティ設定 |

## 画面種別

インクルードファイル / セキュリティ制御

## URL/ルーティング

```
asp/ad_security.asp（インクルードファイル、直接アクセス不可）
```

## 入出力項目

| 項目名 | 項目ID | 型 | 必須 | 入力/出力 | 説明 |
|--------|--------|-----|------|-----------|------|
| Admin認証セッション | Session(cId & "isAUTHENTICATEDasADMIN") | ブール | - | 参照 | システム管理者ログイン状態 |

## 表示項目

本ファイルは画面表示を行わない（セキュリティ処理のみ）。

## イベント仕様

### 1-デフォルトパスワードチェック

ファイルがインクルードされた際に最初に実行される。

**処理フロー**：
1. devVersion()で開発バージョンかどうかをチェック
2. 開発バージョンでない場合、C_ADMINPASSWORDがQS_defaultPWと一致するかチェック
3. デフォルトパスワードが使用されている場合、noaccess.htmにリダイレクト

### 2-認証状態チェック

デフォルトパスワードチェックを通過した後に実行される。

**処理フロー**：
1. Session(cId & "isAUTHENTICATEDasADMIN")をチェック
2. falseの場合、noaccess.htmにリダイレクト
3. trueの場合、インクルード先の処理が続行される

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| なし | - | - | データベースアクセスなし |

本ファイルはセッション変数と設定値のみをチェックするため、データベースアクセスは発生しない。

## メッセージ仕様

本ファイルはメッセージを表示しない（リダイレクト処理のみ）。

## 例外処理

| 例外パターン | 処理内容 |
|-------------|---------|
| デフォルトパスワード使用 | noaccess.htmにリダイレクト |
| Admin未認証 | noaccess.htmにリダイレクト |

## 備考

- C_ADMINPASSWORD：システム管理者パスワード（設定ファイルで定義）
- QS_defaultPW：システムのデフォルトパスワード
- devVersion()：開発バージョンフラグ（開発時はデフォルトPW制限を緩和）
- bs_security.aspとは異なり、Cookie認証やセカンド管理者の概念はない
- 非常にシンプルな3行のコードで構成されている
- 本番環境では必ずデフォルトパスワードを変更する必要がある

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

本ファイルが参照する設定値とセッション変数を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | web_config.asp | `asp/config/web_config.asp` | C_ADMINPASSWORDの定義を確認 |

**読解のコツ**: グローバル設定値（C_で始まる定数）は設定ファイルで定義される。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ad_security.asp | `asp/ad_security.asp` | セキュリティチェックの全体像（3行のみ） |

**主要処理フロー**:
1. **Line 2**: devVersion()とデフォルトパスワードチェック、リダイレクト
2. **Line 3**: Session認証チェック、リダイレクト

#### Step 3: 使用箇所を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ad_default.asp | `asp/ad_default.asp` | 管理者ダッシュボードでの使用例 |
| 3-2 | ad_clientList.asp | `asp/ad_clientList.asp` | 顧客一覧での使用例 |

**読解のコツ**: ad_*.aspファイルの冒頭で`<!-- #include file="ad_security.asp"-->`としてインクルードされている。

### プログラム呼び出し階層図

```
任意の管理者画面（ad_*.asp）
    │
    └─ ad_security.asp（インクルード）
           │
           ├─ devVersion()（開発モード判定）
           │
           ├─ C_ADMINPASSWORD（設定値参照）
           │
           ├─ QS_defaultPW（設定値参照）
           │
           └─ Session(cId & "isAUTHENTICATEDasADMIN")（認証状態チェック）
                  │
                  └─ Response.Redirect("noaccess.htm")（失敗時）
```

### データフロー図

```
[入力]                      [処理]                         [出力]

C_ADMINPASSWORD ─────────▶ デフォルトPWチェック ───▶ NG → リダイレクト
        │
QS_defaultPW ─────────────▶
                                    │
                                    ▼ OK
Session(isAUTHENTICATEDasADMIN) ─▶ 認証チェック ────────▶ NG → リダイレクト
                                    │
                                    ▼ OK
                              処理続行（インクルード先へ）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ad_security.asp | `asp/ad_security.asp` | ソース | 管理者セキュリティチェック（本ファイル） |
| web_config.asp | `asp/config/web_config.asp` | 設定 | C_ADMINPASSWORD定義 |
| noaccess.htm | `asp/noaccess.htm` | 静的HTML | アクセス拒否時のリダイレクト先 |
| ad_login.asp | `asp/ad_login.asp` | ソース | 管理者ログイン画面 |
| ad_default.asp | `asp/ad_default.asp` | ソース | 管理者ダッシュボード（使用例） |
| begin.asp | `asp/begin.asp` | インクルード | 共通初期化処理 |
