# 画面設計書 115-セカンド管理者

## 概要

本ドキュメントは、QuickerSite CMSにおける「セカンド管理者」画面（bs_secondAdmin.asp）の設計仕様を定義するものである。

### 本画面の処理概要

本画面は、セカンド管理者（副管理者）の権限設定を行う画面である。プライマリ管理者が、セカンド管理者に対して許可する機能を細かく設定できる。50以上の権限フラグをチェックボックスで個別に設定可能であり、これによりセカンド管理者のアクセス範囲を柔軟に制御できる。

**業務上の目的・背景**：大規模なサイト運営や複数人での管理を行う場合、すべての管理者にフルアクセス権限を与えることはセキュリティリスクとなる。セカンド管理者機能により、コンテンツ編集のみ、統計閲覧のみ、といった制限付きの管理者アカウントを作成できる。これにより、外部委託先や一般スタッフに必要最小限の権限のみを付与する運用が可能になる。

**画面へのアクセス方法**：バックサイトにプライマリ管理者としてログイン後、「Setup」メニューから「Security」を選択し、セカンド管理者パスワードが設定済みの場合にこの画面が表示される。セカンド管理者でログインしている場合は、bs_default.aspにリダイレクトされる。

**主要な操作・処理内容**：
1. ページ関連権限の設定（追加、パスワード管理、移動、削除、編集など）
2. 機能モジュール権限の設定（フォーム、ギャラリー、カタログなど）
3. セットアップ関連権限の設定（一般設定、テンプレート、統計など）
4. 権限設定の保存
5. セカンド管理者設定の削除

**画面遷移**：
- 遷移元：bs_secondAdminPW.asp（パスワード設定後）、メニューから直接
- 遷移先：bs_applyTotalPW.asp（削除後）

**権限による表示制御**：プライマリ管理者のみがアクセス可能。セカンド管理者でログインしている場合はbs_default.aspにリダイレクトされる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 3 | セカンドアドミン管理 | 主機能 | 制限付き副管理者アカウントの作成・管理 |

## 画面種別

編集 / 設定

## URL/ルーティング

```
asp/bs_secondAdmin.asp
```

## 入出力項目

| 項目名 | 項目ID | 型 | 必須 | 入力/出力 | 説明 |
|--------|--------|-----|------|-----------|------|
| ポストバック | postback | ブール | - | 入力 | フォーム送信フラグ |
| ボタンアクション | btnaction | 文字列 | - | 入力 | "save"または"delete" |
| ページ追加権限 | bPagesAdd | ブール | - | 入力 | 新規ページ追加の可否 |
| ページPW管理権限 | bPagesPW | ブール | - | 入力 | ページパスワード管理の可否 |
| ページ移動権限 | bPagesMove | ブール | - | 入力 | ページ移動の可否 |
| ページ削除権限 | bPagesDelete | ブール | - | 入力 | ページ削除の可否 |
| ページタイトル編集権限 | bPageTitle | ブール | - | 入力 | タイトル編集の可否 |
| ページコンテンツ編集権限 | bPageBody | ブール | - | 入力 | コンテンツ編集の可否 |
| ページ順序設定権限 | bPageOrder | ブール | - | 入力 | 並び順設定の可否 |
| ページ公開権限 | bPagePublish | ブール | - | 入力 | 公開/非公開切り替えの可否 |
| ホームページ設定権限 | bPageSetHomepage | ブール | - | 入力 | ホームページ設定の可否 |
| UFL編集権限 | bPageUFL | ブール | - | 入力 | ユーザーフレンドリーURL編集の可否 |
| アプリケーションパス権限 | bApplicationpath | ブール | - | 入力 | アプリケーションパス設定の可否 |
| フィード設定権限 | bPageFeed | ブール | - | 入力 | ページフィード設定の可否 |
| カタログ設定権限 | bPageCatalog | ブール | - | 入力 | ページカタログ設定の可否 |
| フォーム設定権限 | bPageForm | ブール | - | 入力 | ページフォーム設定の可否 |
| テーマ設定権限 | bPageTheme | ブール | - | 入力 | ページテーマ設定の可否 |
| テンプレート設定権限 | bPageTemplate | ブール | - | 入力 | ページテンプレート設定の可否 |
| リフレッシュ設定権限 | bPageRefresh | ブール | - | 入力 | 自動リフレッシュ設定の可否 |
| タイトルタグ設定権限 | bPageTitleTag | ブール | - | 入力 | titleタグ設定の可否 |
| キーワードタグ設定権限 | bPageKeywords | ブール | - | 入力 | keywordsタグ設定の可否 |
| 説明タグ設定権限 | bPageDescription | ブール | - | 入力 | descriptionタグ設定の可否 |
| ヘッダータグ設定権限 | bPageAdditionalHeader | ブール | - | 入力 | 追加ヘッダータグ設定の可否 |
| RSSリンク設定権限 | bPageUrlRSS | ブール | - | 入力 | RSSリンク設定の可否 |
| セットアップ一般権限 | bSetupGeneral | ブール | - | 入力 | 一般設定の可否 |
| ページ要素権限 | bSetupPageElements | ブール | - | 入力 | ページ要素設定の可否 |
| 統計権限 | bStats | ブール | - | 入力 | 統計閲覧の可否 |
| テンプレート権限 | bTemplates | ブール | - | 入力 | テンプレート管理の可否 |
| Cookie警告権限 | bCookieWarning | ブール | - | 入力 | Cookie警告設定の可否 |
| 404カスタマイズ権限 | bCustom404 | ブール | - | 入力 | 404ページカスタマイズの可否 |
| 定数権限 | bHomeConstants | ブール | - | 入力 | 定数管理の可否 |
| VBScript権限 | bHomeVBScript | ブール | - | 入力 | VBScript編集の可否 |
| ファイル権限 | bFiles | ブール | - | 入力 | ファイル管理の可否 |
| フォーム権限 | bForms | ブール | - | 入力 | フォーム管理の可否 |
| フォームエクスポート権限 | bFormExport | ブール | - | 入力 | フォームデータエクスポートの可否 |
| イントラネット権限 | bIntranet | ブール | - | 入力 | イントラネット機能の可否 |
| イントラネットセットアップ権限 | bIntranetSetup | ブール | - | 入力 | イントラネット設定の可否 |
| イントラネット連絡先権限 | bIntranetContacts | ブール | - | 入力 | イントラネット連絡先管理の可否 |
| イントラネットメール権限 | bIntranetMail | ブール | - | 入力 | イントラネットメール機能の可否 |
| カタログ権限 | bCatalog | ブール | - | 入力 | カタログ管理の可否 |
| フィード権限 | bFeed | ブール | - | 入力 | フィード管理の可否 |
| ギャラリー権限 | bGallery | ブール | - | 入力 | ギャラリー管理の可否 |
| 投票権限 | bPoll | ブール | - | 入力 | 投票管理の可否 |
| ゲストブック権限 | bGuestbook | ブール | - | 入力 | ゲストブック管理の可否 |
| ポップアップ権限 | bPopup | ブール | - | 入力 | ポップアップ管理の可否 |
| ニュースレター権限 | bNewsletter | ブール | - | 入力 | ニュースレター管理の可否 |
| 予約カレンダー権限 | bAvailabilityCal | ブール | - | 入力 | 予約カレンダー管理の可否 |
| ショッピングカート権限 | bShoppingCart | ブール | - | 入力 | ショッピングカート管理の可否 |
| テーマ権限 | bTheme | ブール | - | 入力 | テーマ管理の可否 |

## 表示項目

| 項目名 | 説明 |
|--------|------|
| パスワード設定ステータス | Step 1: セカンド管理者パスワード設定状況 |
| 権限チェックボックス群 | Step 2: 各機能へのアクセス権限設定 |

## イベント仕様

### 1-保存ボタン押下

権限設定を保存する。

**処理フロー**：
1. ユーザーが「Save」ボタンをクリック
2. CSRFトークンを検証（checkCSRF）
3. フォーム値をsecAdminオブジェクトに取得
4. secAdmin.save()でデータベースに保存
5. 成功メッセージを表示

### 2-削除ボタン押下

セカンド管理者設定を削除する。

**処理フロー**：
1. ユーザーが「Delete」ボタンをクリック
2. 確認ダイアログを表示
3. CSRFトークンを検証（checkCSRF）
4. secAdmin.delete()でデータベースから削除
5. bs_applyTotalPW.aspにリダイレクト

### 3-チェックボックス変更（一部）

一部のチェックボックスは変更時に自動的にフォームを送信し、関連オプションの表示/非表示を切り替える。

**対象チェックボックス**：
- bHomeConstants：VBScriptオプションの表示切り替え
- bForms：フォームエクスポートオプションの表示切り替え
- bIntranet：イントラネット関連オプションの表示切り替え
- bIntranetContacts：イントラネットメールオプションの表示切り替え

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | tblSecondAdmin | SELECT | 現在の権限設定を取得 |
| 保存ボタン押下 | tblSecondAdmin | INSERT/UPDATE | 権限設定を保存 |
| 削除ボタン押下 | tblSecondAdmin | DELETE | 権限設定を削除 |

### テーブル別更新項目詳細

#### tblSecondAdmin

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | iCustomerID = cId | 初期表示用 |
| INSERT/UPDATE | sPassword | 既存値を維持 | パスワードは別画面で設定 |
| INSERT/UPDATE | bSetupGeneral〜bCookieWarning | チェックボックス値 | 約50項目 |
| INSERT/UPDATE | iCustomerID | cId | 顧客ID |
| DELETE | - | iCustomerID = cId | 削除条件 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| explsecondadmin | 説明 | セカンド管理者の説明文 | 常時表示 |
| fb_saveOK | 成功 | 保存完了メッセージ | 保存成功時 |
| areyousure | 確認 | 確認ダイアログ | 保存/削除ボタン押下時 |

## 例外処理

| 例外パターン | 処理内容 |
|-------------|---------|
| セカンド管理者でログイン | bs_default.aspにリダイレクト |
| パスワード未設定 | bs_secondAdminPW.aspにリダイレクト |
| CSRF検証失敗 | エラー処理（checkCSRF関数内） |

## 備考

- セカンド管理者パスワードは別画面（bs_secondAdminPW.asp）で設定
- 権限は階層構造になっており、親権限が無効の場合は子権限も無効
- customer.bApplication / customer.bEnableNewsletters / customer.bShoppingCartの設定により、一部権限は非表示
- 権限変更後はメニューキャッシュがクリアされる（clearMenuCache）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

セカンド管理者の権限データ構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | secondAdmin.asp | `asp/includes/secondAdmin.asp` | cls_secondAdminクラス、50以上の権限フラグの定義 |

**読解のコツ**: Line 3-7でPublic宣言されているフラグが権限項目。pick()で読み込み、save()で保存。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_secondAdmin.asp | `asp/bs_secondAdmin.asp` | 権限設定画面の実装 |

**主要処理フロー**:
1. **Line 1-4**: インクルードとセキュリティチェック
2. **Line 4**: セカンド管理者でログインしていればリダイレクト
3. **Line 5-7**: cls_secondAdminオブジェクト生成、パスワード未設定ならリダイレクト
4. **Line 10-12**: postbackでフォーム値を取得
5. **Line 13-21**: ボタンアクションによる分岐（保存/削除）
6. **Line 22-26**: HTMLフォームと権限チェックボックス群

#### Step 3: 保存処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | secondAdmin.asp | `asp/includes/secondAdmin.asp` | save()メソッド（Line 95-172） |

**主要処理フロー**:
- **Line 95-101**: check()でバリデーション
- **Line 102-107**: 既存レコードの有無でINSERT/UPDATEを分岐
- **Line 108-166**: 全権限フラグをレコードに設定
- **Line 169**: clearMenuCacheでキャッシュクリア

### プログラム呼び出し階層図

```
bs_secondAdmin.asp
    │
    ├─ bs_security.asp（認証チェック）
    │
    ├─ cls_secondAdmin（オブジェクト生成）
    │      └─ pick()（権限設定読み込み）
    │             └─ tblSecondAdmin（SELECT）
    │
    ├─ [保存時]
    │      ├─ checkCSRF()（CSRF検証）
    │      ├─ getRequestValues()（フォーム値取得）
    │      └─ save()（保存）
    │             └─ tblSecondAdmin（INSERT/UPDATE）
    │
    └─ [削除時]
           ├─ checkCSRF()（CSRF検証）
           └─ delete()（削除）
                  └─ tblSecondAdmin（DELETE）
```

### データフロー図

```
[入力]                      [処理]                         [出力]

チェックボックス群 ─────▶ getRequestValues() ──────▶ secAdminオブジェクト
                                │
                                ▼
                            save()
                                │
                                ▼
                     tblSecondAdmin（更新）
                                │
                                ▼
                      clearMenuCache()
                                │
                                ▼
                      保存成功メッセージ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_secondAdmin.asp | `asp/bs_secondAdmin.asp` | ソース | 権限設定画面（本ファイル） |
| bs_secondAdminPW.asp | `asp/bs_secondAdminPW.asp` | ソース | パスワード設定画面 |
| secondAdmin.asp | `asp/includes/secondAdmin.asp` | インクルード | cls_secondAdminクラス定義 |
| bs_security.asp | `asp/bs_security.asp` | インクルード | セキュリティチェック |
| bs_applyTotalPW.asp | `asp/bs_applyTotalPW.asp` | ソース | 削除後のリダイレクト先 |
