# 画面設計書 116-セカンド管理者PW

## 概要

本ドキュメントは、QuickerSite CMSにおける「セカンド管理者PW」画面（bs_secondAdminPW.asp）の設計仕様を定義するものである。

### 本画面の処理概要

本画面は、セカンド管理者（副管理者）のパスワードを設定する画面である。セカンド管理者機能を有効にするための最初のステップとして、専用のパスワードを設定する必要がある。パスワードと確認用パスワードを入力し、一致した場合のみ保存される。

**業務上の目的・背景**：セカンド管理者機能を使用するには、まずプライマリ管理者とは異なるパスワードを設定する必要がある。これにより、セカンド管理者はプライマリ管理者のパスワードを知ることなく、制限された権限でシステムにアクセスできる。パスワードの分離により、セキュリティが強化される。

**画面へのアクセス方法**：バックサイトにプライマリ管理者としてログイン後、「Setup」メニューから「Security」を選択する。セカンド管理者パスワードが未設定の場合、権限設定画面（bs_secondAdmin.asp）から自動的にこの画面にリダイレクトされる。また、権限設定画面から「Change」リンクをクリックしてもアクセスできる。

**主要な操作・処理内容**：
1. 新しいセカンド管理者パスワードの入力
2. 確認用パスワードの入力
3. パスワードの保存

**画面遷移**：
- 遷移元：bs_secondAdmin.asp（パスワード未設定時のリダイレクト、または変更リンク）
- 遷移先：bs_secondAdmin.asp（保存成功後）

**権限による表示制御**：プライマリ管理者のみがアクセス可能。セカンド管理者でログインしている場合はbs_default.aspにリダイレクトされる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 4 | パスワード変更 | 主機能 | セカンド管理者のパスワード設定 |

## 画面種別

登録 / 編集

## URL/ルーティング

```
asp/bs_secondAdminPW.asp
```

## 入出力項目

| 項目名 | 項目ID | 型 | 必須 | 入力/出力 | 説明 |
|--------|--------|-----|------|-----------|------|
| パスワード | sPassword | 文字列 | 必須 | 入力 | 新しいパスワード（最大30文字） |
| 確認用パスワード | sPasswordConfirm | 文字列 | 必須 | 入力 | パスワード確認（最大30文字） |
| ポストバック | postback | ブール | - | 入力 | フォーム送信フラグ |
| ボタンアクション | btnaction | 文字列 | - | 入力 | "save" |

## 表示項目

| 項目名 | 説明 |
|--------|------|
| 説明文 | セカンド管理者機能の説明 |
| ステップ表示 | 「Step 1」パスワード設定であることを示す |
| パスワード入力欄 | パスワード入力フィールド |
| 確認パスワード入力欄 | 確認用パスワード入力フィールド |
| 必須表示 | (*)マークで必須項目を示す |

## イベント仕様

### 1-保存ボタン押下

パスワードを検証して保存する。

**処理フロー**：
1. ユーザーが「Save」ボタンをクリック
2. 確認ダイアログを表示
3. CSRFトークンを検証（checkCSRF）
4. secAdmin.getPasswordValues()でパスワード値を取得（SHA256ハッシュ化）
5. secAdmin.save()でデータベースに保存
6. 保存成功時、bs_secondAdmin.aspにリダイレクト
7. 保存失敗時、エラーメッセージを表示して画面を再表示

**バリデーション（check関数）**：
- パスワードと確認用パスワードが両方入力されているか
- パスワードと確認用パスワードが一致するか
- プライマリ管理者パスワードと同じでないか
- デフォルトパスワードと同じでないか

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | tblSecondAdmin | INSERT/UPDATE | パスワードを保存 |

### テーブル別更新項目詳細

#### tblSecondAdmin

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT/UPDATE | sPassword | SHA256ハッシュ化されたパスワード | パスワード更新 |
| INSERT/UPDATE | iCustomerID | cId | 顧客ID |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| explsecondadmin | 説明 | セカンド管理者の説明文 | 常時表示 |
| step12ndadmin | 説明 | Step 1の説明文 | 常時表示 |
| secondadminpw | ラベル | パスワードラベル | 常時表示 |
| confirmpassword | ラベル | 確認パスワードラベル | 常時表示 |
| mandatory | 説明 | 必須項目の説明 | 常時表示 |
| areyousure | 確認 | 確認ダイアログ | 保存ボタン押下時 |
| err_mandatory | エラー | 必須項目未入力エラー | バリデーション失敗時 |
| pwnomatch | エラー | パスワード不一致エラー | バリデーション失敗時 |
| err_firstandsecondpassword | エラー | プライマリPWと同一エラー | バリデーション失敗時 |
| err_backsitepw | エラー | デフォルトPWと同一エラー | バリデーション失敗時 |

## 例外処理

| 例外パターン | 処理内容 |
|-------------|---------|
| セカンド管理者でログイン | bs_default.aspにリダイレクト |
| パスワード未入力 | err_mandatoryエラーを表示 |
| パスワード不一致 | pwnomatchエラーを表示 |
| プライマリPWと同一 | err_firstandsecondpasswordエラーを表示 |
| デフォルトPWと同一 | err_backsitepwエラーを表示 |
| CSRF検証失敗 | エラー処理（checkCSRF関数内） |

## 備考

- パスワードはSHA256でハッシュ化されて保存される
- 入力フィールドはtype="password"で、入力値がマスクされる
- 最大入力文字数は30文字
- 保存後は権限設定画面（bs_secondAdmin.asp）に自動的にリダイレクト
- セキュリティ上、プライマリ管理者パスワードやデフォルトパスワードと同じものは設定不可

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

パスワードの保存構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | secondAdmin.asp | `asp/includes/secondAdmin.asp` | sPassword, sPasswordConfirmプロパティ |

**読解のコツ**: getPasswordValues()（Line 173-176）でSHA256ハッシュ化、check()（Line 75-94）でバリデーション。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_secondAdminPW.asp | `asp/bs_secondAdminPW.asp` | パスワード設定画面の実装 |

**主要処理フロー**:
1. **Line 1-4**: インクルードとセキュリティチェック
2. **Line 4**: セカンド管理者でログインしていればリダイレクト
3. **Line 5-6**: cls_secondAdminオブジェクト生成
4. **Line 7-11**: ボタンアクション処理
5. **Line 11**: 保存成功時はbs_secondAdmin.aspにリダイレクト
6. **Line 12**: HTMLフォーム表示

#### Step 3: バリデーション処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | secondAdmin.asp | `asp/includes/secondAdmin.asp` | check()メソッド（Line 75-94） |

**主要処理フロー**:
- **Line 77-79**: 必須チェック
- **Line 80-82**: パスワード一致チェック
- **Line 83-85**: プライマリPWとの重複チェック
- **Line 86-88**: デフォルトPWとの重複チェック

### プログラム呼び出し階層図

```
bs_secondAdminPW.asp
    │
    ├─ bs_security.asp（認証チェック）
    │
    ├─ cls_secondAdmin（オブジェクト生成）
    │
    └─ [保存時]
           ├─ checkCSRF()（CSRF検証）
           ├─ getPasswordValues()（パスワード取得・ハッシュ化）
           │      └─ sha256()（ハッシュ関数）
           ├─ save()（保存）
           │      ├─ check()（バリデーション）
           │      └─ tblSecondAdmin（INSERT/UPDATE）
           └─ Response.Redirect("bs_secondAdmin.asp")
```

### データフロー図

```
[入力]                      [処理]                         [出力]

sPassword ─────────────▶ sha256() ─────────────▶ ハッシュ値
sPasswordConfirm ──────▶ sha256() ─────────────▶ ハッシュ値
                                │
                                ▼
                            check()
                                │
                    ┌───────────┴───────────┐
                    ▼                       ▼
                バリデーションOK         バリデーションNG
                    │                       │
                    ▼                       ▼
               save() → DB更新        エラーメッセージ表示
                    │
                    ▼
         bs_secondAdmin.aspへリダイレクト
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_secondAdminPW.asp | `asp/bs_secondAdminPW.asp` | ソース | パスワード設定画面（本ファイル） |
| bs_secondAdmin.asp | `asp/bs_secondAdmin.asp` | ソース | 権限設定画面（リダイレクト先） |
| secondAdmin.asp | `asp/includes/secondAdmin.asp` | インクルード | cls_secondAdminクラス定義 |
| bs_security.asp | `asp/bs_security.asp` | インクルード | セキュリティチェック |
| functions.asp | `asp/includes/functions.asp` | インクルード | sha256関数など |
