# 画面設計書 117-イントラネット管理

## 概要

本ドキュメントは、QuickerSite CMSにおける「イントラネット管理」画面（bs_intranet.asp）の設計仕様を定義するものである。

### 本画面の処理概要

本画面は、会員限定エリア（イントラネット）のページ管理を行う画面である。イントラネット機能が有効な場合、ここで会員専用ページを一覧表示し、新規ページの追加やページ管理操作を行うことができる。ページは階層構造（メニュー形式）で表示され、ページの追加、コピー、移動、パスワード設定などの操作が可能である。

**業務上の目的・背景**：企業や組織においては、一般公開サイトとは別に、会員や社員のみがアクセスできる限定コンテンツを提供するニーズがある。イントラネット機能は、このような会員限定エリアを構築するための機能であり、本画面はそのコンテンツ管理の中心となる。会員登録した利用者のみがアクセスできるセキュアなページを効率的に管理できる。

**画面へのアクセス方法**：バックサイトにログイン後、「Intranet」メニューをクリックすることでアクセスできる。セカンド管理者の場合は、bIntranet権限が必要。

**主要な操作・処理内容**：
1. イントラネットページの階層表示
2. 新規ページの追加（bs_setupPage.aspへ遷移）
3. ページのコピー
4. ページの移動
5. ページのパスワード設定
6. フリーページ（親を持たないページ）の表示

**画面遷移**：
- 遷移元：バックサイトメニュー、各イントラネット関連画面
- 遷移先：bs_setupPage.asp（新規ページ作成）、各ページ編集画面

**権限による表示制御**：セカンド管理者の場合、bIntranet権限が必要。さらに、個別の操作（コピー、移動、パスワード管理など）についてもsecondAdmin権限フラグで制御される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 82 | イントラネット管理 | 主機能 | 会員限定エリアの設定・管理 |

## 画面種別

一覧 / 管理

## URL/ルーティング

```
asp/bs_intranet.asp
```

## 入出力項目

| 項目名 | 項目ID | 型 | 必須 | 入力/出力 | 説明 |
|--------|--------|-----|------|-----------|------|
| イントラネットフラグ | bIntranet | ブール | - | 入力 | 新規ページ作成時のパラメータ |

## 表示項目

| 項目名 | 説明 |
|--------|------|
| 新規アイテム追加リンク | 新規ページ作成画面へのリンク |
| ページメニュー | 階層構造のイントラネットページ一覧 |
| フリーページ一覧 | 親を持たないページの一覧 |

## イベント仕様

### 1-新規アイテム追加リンククリック

新規ページ作成画面に遷移する。

**処理フロー**：
1. ユーザーが「New Item」リンクをクリック
2. bs_setupPage.asp?bIntranet=trueに遷移
3. イントラネットページとしてページ作成画面が表示される

### 2-ページコピー

既存ページをコピーする。

**処理フロー**：
1. ユーザーがコピーアイコンをクリック
2. 確認ダイアログが表示される（copyItem JavaScript関数）
3. OKで bs_default.asp?btnaction=Copy&iId={ページID} に遷移
4. ページがコピーされる

### 3-ページ移動

ページを別の親の下に移動する。

**処理フロー**：
1. ユーザーが移動アイコンをクリック
2. bs_selectPage.asp?btnaction=Move&iId={ページID} に遷移
3. 移動先を選択してページを移動

### 4-パスワード管理

ページへのパスワード保護を設定/解除する。

**処理フロー**：
1. ユーザーがロック/アンロックアイコンをクリック
2. bs_applyPw.asp?iId={ページID} に遷移
3. パスワード設定画面が表示される

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | tblPage | SELECT | イントラネットページの取得 |
| ページコピー | tblPage他 | INSERT | ページ複製（別画面で処理） |
| ページ移動 | tblPage | UPDATE | 親ページ変更（別画面で処理） |

### テーブル別更新項目詳細

画面表示時はtblPageからイントラネットページを取得するが、更新処理は遷移先の画面で行われる。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| newitem | リンク | 新規アイテム追加 | 常時表示 |
| areyousuretocopy | 確認 | コピー確認ダイアログ | コピーアイコンクリック時 |
| freepages | ラベル | フリーページ見出し | フリーページ存在時 |
| copyitem | ツールチップ | コピーアイコンのツールチップ | アイコン表示時 |
| managepw | ツールチップ | パスワード管理アイコンのツールチップ | アイコン表示時 |
| moveitem | ツールチップ | 移動アイコンのツールチップ | アイコン表示時 |

## 例外処理

| 例外パターン | 処理内容 |
|-------------|---------|
| イントラネット権限なし | bs_security.aspでアクセス拒否 |
| ページなし | メニューとフリーページ一覧が空で表示 |

## 備考

- bs_menuIntranet.aspをインクルードしてメニューを表示
- cls_menuクラスのgetBOMenuメソッドでページ階層を取得
- lossePaginasメソッドで親を持たないフリーページを取得
- 各操作アイコンはsecondAdmin権限フラグで表示/非表示が制御される
- bPagesAdd：コピーアイコン表示
- bPagesPW：パスワード管理アイコン表示
- bPagesMove：移動アイコン表示

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

イントラネットページのデータ構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | page.asp（推定） | `asp/includes/page.asp` | ページクラスの構造 |
| 1-2 | menu.asp（推定） | `asp/includes/menu.asp` | cls_menuクラス、getBOMenu, lossePaginasメソッド |

**読解のコツ**: ページは親子関係を持つ階層構造。bIntranetフラグでイントラネットページを識別。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_intranet.asp | `asp/bs_intranet.asp` | イントラネット管理画面の実装 |

**主要処理フロー**:
1. **Line 1-4**: インクルードとセキュリティチェック（bIntranet権限）
2. **Line 4**: 新規アイテム追加リンクの表示
3. **Line 4**: bs_menuIntranet.aspのインクルード
4. **Line 5-14**: JavaScript copyItem関数の定義

#### Step 3: メニュー表示処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_menuIntranet.asp | `asp/bs_menuIntranet.asp` | イントラネットメニュー表示 |

**主要処理フロー**:
- **Line 2-4**: cls_menuオブジェクト生成、getBOMenu呼び出し
- **Line 5-6**: lossePaginas（フリーページ）取得
- **Line 7-22**: フリーページのループ処理、アイコン表示

### プログラム呼び出し階層図

```
bs_intranet.asp
    │
    ├─ bs_security.asp（認証チェック）
    │      └─ logon.hasaccess(secondAdmin.bIntranet)
    │
    ├─ bs_process.asp（共通処理）
    │
    └─ bs_menuIntranet.asp（インクルード）
           │
           ├─ cls_menu.getBOMenu()
           │      └─ tblPage（SELECT - イントラネットページ）
           │
           └─ cls_menu.lossePaginas()
                  └─ tblPage（SELECT - フリーページ）
```

### データフロー図

```
[入力]                      [処理]                         [出力]

（なし） ────────────────▶ cls_menu.getBOMenu() ────▶ ページ階層HTML
                                │
                                ▼
                     cls_menu.lossePaginas() ─────▶ フリーページ一覧HTML
                                │
                                ▼
                     権限に応じたアイコン表示
                     （コピー/移動/PW管理）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_intranet.asp | `asp/bs_intranet.asp` | ソース | イントラネット管理画面（本ファイル） |
| bs_menuIntranet.asp | `asp/bs_menuIntranet.asp` | インクルード | イントラネットメニュー表示 |
| bs_setupPage.asp | `asp/bs_setupPage.asp` | ソース | 新規ページ作成（遷移先） |
| bs_selectPage.asp | `asp/bs_selectPage.asp` | ソース | ページ移動先選択（遷移先） |
| bs_applyPw.asp | `asp/bs_applyPw.asp` | ソース | パスワード設定（遷移先） |
| bs_security.asp | `asp/bs_security.asp` | インクルード | セキュリティチェック |
