# 画面設計書 118-イントラネット管理者

## 概要

本ドキュメントは、QuickerSite CMSにおける「イントラネット管理者」画面（bs_adminIntranet.asp）の設計仕様を定義するものである。

### 本画面の処理概要

本画面は、イントラネット機能の詳細設定を行う管理画面である。イントラネット（会員限定エリア）の有効/無効、名称設定、ログインモード、会員登録設定、アバター設定など、イントラネット機能全体の動作を制御する各種パラメータを設定できる。

**業務上の目的・背景**：イントラネット機能は単にページを制限するだけでなく、会員登録、プロフィール機能、メール通知など多くの関連機能を持つ。本画面は、これらの機能を組織のニーズに合わせて細かく設定するためのものである。新規会員登録の許可/禁止、登録時のステータス設定、管理者への通知メールなど、運用上重要な設定項目を一元管理できる。

**画面へのアクセス方法**：バックサイトにログイン後、「Intranet」メニューから「Setup」を選択することでアクセスできる。セカンド管理者の場合は、bIntranetSetup権限が必要。

**主要な操作・処理内容**：
1. イントラネット機能の有効/無効切り替え
2. イントラネット名称の設定
3. ログインモードの設定（メール/ニックネーム）
4. 公開プロフィール機能の有効/無効
5. アバター機能の設定
6. 新規会員登録の許可設定
7. 登録時のデフォルトステータス設定
8. 管理者への通知メール設定

**画面遷移**：
- 遷移元：イントラネットメニュー
- 遷移先：bs_adminIntranetOSM.asp（オンスクリーンメッセージ設定）、bs_adminIntranetEM.asp（自動メール設定）

**権限による表示制御**：セカンド管理者の場合、bIntranetSetup権限が必要。また、intranetUseMyProfile（公開プロフィール）が有効な場合のみ、関連する追加オプションが表示される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 82 | イントラネット管理 | 主機能 | イントラネットの管理者設定 |

## 画面種別

編集 / 設定

## URL/ルーティング

```
asp/bs_adminIntranet.asp
```

## 入出力項目

| 項目名 | 項目ID | 型 | 必須 | 入力/出力 | 説明 |
|--------|--------|-----|------|-----------|------|
| イントラネット使用 | intranetUse | ブール | - | 入力 | イントラネット機能の有効/無効 |
| イントラネット名 | intranetName | 文字列 | 条件付 | 入力 | イントラネットの表示名（最大49文字） |
| サイト編集ラベル | sLabelEditSite | 文字列 | 条件付 | 入力 | 「サイト編集」ボタンのラベル（最大50文字） |
| ログインモード | iLoginMode | 数値 | 条件付 | 入力 | 0:メール、1:ニックネーム |
| ログオフラベル | intranetLogOff | 文字列 | 条件付 | 入力 | 「ログオフ」リンクのラベル（最大49文字） |
| 公開プロフィール使用 | intranetUseMyProfile | ブール | - | 入力 | 公開プロフィール機能の有効/無効 |
| マイプロフィールラベル | intranetMyProfile | 文字列 | 条件付 | 入力 | 「マイプロフィール」リンクのラベル（最大49文字） |
| アバター使用 | bUseAvatars | ブール | - | 入力 | アバター機能の有効/無効 |
| アバターサイズ | iAvatarSize | 数値 | 条件付 | 入力 | アバター画像のサイズ（32-150px） |
| アバターボーダー色 | sAvatarBorderColor | 文字列 | - | 入力 | アバター枠線の色（最大40文字） |
| 新規登録許可 | bAllowNewRegistrations | ブール | - | 入力 | 新規会員登録の許可/禁止 |
| デフォルトステータス | iDefaultStatus | 数値 | 条件付 | 入力 | 新規登録時のステータス |
| 登録ラベル | sLabelRegister | 文字列 | 条件付 | 入力 | 「登録」リンクのラベル（最大100文字） |
| 登録メール送信 | bSendMailUponNewMember | ブール | - | 入力 | 新規登録時に管理者へメール送信 |
| 通知メールアドレス | sEmailNewRegistrations | 文字列 | 条件付 | 入力 | 登録通知メールの送信先 |
| 更新通知メール | sNotifValidate | 文字列 | - | 入力 | ページ更新通知メールの送信先（最大100文字） |
| ポストバック | postback | ブール | - | 入力 | フォーム送信フラグ |

## 表示項目

| 項目名 | 説明 |
|--------|------|
| 一般設定セクション | イントラネット使用、名称、ラベル設定 |
| 公開プロフィールセクション | プロフィール機能関連設定 |
| アバターセクション | アバター機能関連設定 |
| 新規登録セクション | 会員登録関連設定 |
| 追加リンク | オンスクリーンメッセージ、自動メール設定画面へのリンク |

## イベント仕様

### 1-保存ボタン押下

設定を保存する。

**処理フロー**：
1. ユーザーが「Save」ボタンをクリック
2. 確認ダイアログが表示される
3. CSRFトークンを検証（checkCSRF）
4. customer.getIntranetAdminRequestValues()でフォーム値を取得
5. customer.save()でデータベースに保存
6. 保存成功時、fb_saveOKメッセージを表示

### 2-チェックボックス変更による動的表示

一部のチェックボックスを変更すると、関連するオプションの表示/非表示が切り替わる。

**対象チェックボックス**：
- intranetUse：イントラネット関連のすべてのオプション表示切り替え
- intranetUseMyProfile：プロフィール関連オプション表示切り替え
- bUseAvatars：アバター関連オプション表示切り替え
- bAllowNewRegistrations：登録関連オプション表示切り替え
- bSendMailUponNewMember：通知メールアドレス入力欄表示切り替え

### 3-追加設定リンククリック

公開プロフィールが有効な場合に表示される追加設定画面へのリンク。

**処理フロー**：
1. オンスクリーンメッセージ：bs_adminIntranetOSM.aspに遷移
2. 自動メール設定：bs_adminIntranetEM.aspに遷移

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | tblCustomer | SELECT | 現在の設定値を取得 |
| 保存ボタン押下 | tblCustomer | UPDATE | 設定を保存 |

### テーブル別更新項目詳細

#### tblCustomer

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT/UPDATE | intranetUse | チェックボックス値 | 機能有効/無効 |
| SELECT/UPDATE | intranetName | テキスト値 | イントラネット名 |
| SELECT/UPDATE | sLabelEditSite | テキスト値 | 編集ラベル |
| SELECT/UPDATE | iLoginMode | セレクト値 | ログインモード |
| SELECT/UPDATE | intranetLogOff | テキスト値 | ログオフラベル |
| SELECT/UPDATE | intranetUseMyProfile | チェックボックス値 | プロフィール機能 |
| SELECT/UPDATE | intranetMyProfile | テキスト値 | プロフィールラベル |
| SELECT/UPDATE | bUseAvatars | チェックボックス値 | アバター機能 |
| SELECT/UPDATE | iAvatarSize | セレクト値 | アバターサイズ |
| SELECT/UPDATE | sAvatarBorderColor | テキスト値 | ボーダー色 |
| SELECT/UPDATE | bAllowNewRegistrations | チェックボックス値 | 登録許可 |
| SELECT/UPDATE | iDefaultStatus | セレクト値 | デフォルトステータス |
| SELECT/UPDATE | sLabelRegister | テキスト値 | 登録ラベル |
| SELECT/UPDATE | bSendMailUponNewMember | チェックボックス値 | メール送信 |
| SELECT/UPDATE | sEmailNewRegistrations | テキスト値 | 通知メール |
| SELECT/UPDATE | sNotifValidate | テキスト値 | 更新通知メール |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| fb_saveOK | 成功 | 保存完了メッセージ | 保存成功時 |
| areyousure | 確認 | 確認ダイアログ | フォーム送信時 |
| general | ヘッダー | 一般設定セクション見出し | 常時表示 |
| useintranet | ラベル | イントラネット使用 | 常時表示 |
| name | ラベル | 名前 | 条件表示 |
| labeleditsite | ラベル | 編集ラベル | 条件表示 |
| labellogoff | ラベル | ログオフラベル | 条件表示 |
| publicprofile | ラベル | 公開プロフィール | 条件表示 |
| labelmyprofile | ラベル | マイプロフィールラベル | 条件表示 |
| allownewregistrations | ラベル | 新規登録許可 | 条件表示 |
| defaultstatus | ラベル | デフォルトステータス | 条件表示 |
| labelregister | ラベル | 登録ラベル | 条件表示 |
| sendmailuponnewmember | ラベル | 登録メール送信 | 条件表示 |
| onscreenmessages | リンク | オンスクリーンメッセージ | プロフィール有効時 |
| automatedemails | リンク | 自動メール設定 | プロフィール有効時 |
| mandatory | 説明 | 必須項目の説明 | 常時表示 |

## 例外処理

| 例外パターン | 処理内容 |
|-------------|---------|
| イントラネットセットアップ権限なし | bs_security.aspでアクセス拒否 |
| CSRF検証失敗 | エラー処理（checkCSRF関数内） |

## 備考

- 設定項目は階層的に表示される：イントラネット使用→プロフィール使用→アバター使用→登録許可
- アバターサイズのデフォルトは80px（未設定の場合）
- ステータスリストはcslist.list.remove(cs_silent)で「サイレント」を除外
- customer.getIntranetAdminRequestValues()でフォーム値を一括取得
- 公開プロフィール有効時のみ、追加設定画面（OSM/EM）へのリンクが表示

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

customerオブジェクトのイントラネット関連プロパティを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | customer.asp | `asp/includes/customer.asp` | イントラネット関連プロパティ、getIntranetAdminRequestValues() |

**読解のコツ**: intranet〜で始まるプロパティ、bUseAvatars、bAllowNewRegistrations等が対象。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_adminIntranet.asp | `asp/bs_adminIntranet.asp` | イントラネット管理者設定画面の実装 |

**主要処理フロー**:
1. **Line 1-4**: インクルードとセキュリティチェック（bIntranetSetup権限）
2. **Line 4**: cslist.list.remove(cs_silent)でステータスリスト調整
3. **Line 5-8**: postbackでフォーム値取得
4. **Line 10-15**: 保存処理
5. **Line 16-18**: HTMLフォームと動的表示制御

#### Step 3: 動的表示制御を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_adminIntranet.asp | `asp/bs_adminIntranet.asp` | if文による条件分岐表示 |

**主要処理フロー**:
- **Line 16**: `<%if convertBool(customer.intranetUse) then%>`でイントラネット詳細表示
- **Line 16**: `<%if convertBool(customer.intranetUseMyProfile) then%>`でプロフィール詳細表示
- **Line 16-17**: `<%if convertBool(customer.bUseAvatars) then%>`でアバター詳細表示
- **Line 17-18**: `<%if convertBool(customer.bAllowNewRegistrations) then%>`で登録詳細表示

### プログラム呼び出し階層図

```
bs_adminIntranet.asp
    │
    ├─ bs_security.asp（認証チェック）
    │      └─ logon.hasaccess(secondAdmin.bIntranetSetup)
    │
    ├─ cslist.list.remove(cs_silent)（ステータスリスト調整）
    │
    └─ [保存時]
           ├─ checkCSRF()（CSRF検証）
           ├─ customer.getIntranetAdminRequestValues()（フォーム値取得）
           └─ customer.save()（保存）
                  └─ tblCustomer（UPDATE）
```

### データフロー図

```
[入力]                      [処理]                         [出力]

チェックボックス群 ──────▶ getIntranetAdminRequestValues()
テキスト入力 ────────────▶          │
セレクト入力 ────────────▶          │
                                    ▼
                              customer.save()
                                    │
                                    ▼
                           tblCustomer（更新）
                                    │
                                    ▼
                           fb_saveOKメッセージ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_adminIntranet.asp | `asp/bs_adminIntranet.asp` | ソース | イントラネット管理者設定（本ファイル） |
| bs_adminIntranetOSM.asp | `asp/bs_adminIntranetOSM.asp` | ソース | オンスクリーンメッセージ設定（遷移先） |
| bs_adminIntranetEM.asp | `asp/bs_adminIntranetEM.asp` | ソース | 自動メール設定（遷移先） |
| customer.asp | `asp/includes/customer.asp` | インクルード | customerオブジェクト定義 |
| bs_security.asp | `asp/bs_security.asp` | インクルード | セキュリティチェック |
