# 画面設計書 119-イントラネットメニュー

## 概要

本ドキュメントは、QuickerSite CMSにおける「イントラネットメニュー」画面（bs_menuIntranet.asp）の設計仕様を定義するものである。

### 本画面の処理概要

本画面は、イントラネット管理画面でページ階層を表示するためのインクルードファイルである。イントラネット（会員限定エリア）のページをメニュー形式で一覧表示し、各ページに対してコピー、移動、パスワード管理などの操作アイコンを表示する。また、親を持たないフリーページも別途表示する。

**業務上の目的・背景**：イントラネット機能で作成したページを視覚的に管理しやすくするために、階層構造でページを表示する必要がある。本画面は、ページの親子関係を反映したメニュー形式の表示を提供し、各ページに対する管理操作へのクイックアクセスを可能にする。これにより、複雑なページ構造を持つイントラネットでも効率的に管理できる。

**画面へのアクセス方法**：本ファイルは直接アクセスするものではなく、bs_intranet.asp（イントラネット管理画面）で`<!-- #include file="bs_menuIntranet.asp"-->`としてインクルードされる。

**主要な操作・処理内容**：
1. イントラネットページの階層構造表示（cls_menu.getBOMenuを使用）
2. フリーページ（親を持たないページ）の一覧表示
3. 各ページに対する管理操作アイコンの表示
   - アプリケーションパス表示（アイコン）
   - コピー操作へのリンク
   - パスワード管理へのリンク（ロック/アンロック状態表示）
   - 移動操作へのリンク

**画面遷移**：
- 遷移元：bs_intranet.asp（インクルード元）
- 遷移先（各アイコンクリック時）：bs_default.asp（コピー）、bs_applyPw.asp（パスワード管理）、bs_selectPage.asp（移動）

**権限による表示制御**：各操作アイコンはsecondAdmin権限フラグで表示/非表示が制御される。
- bApplicationpath：アプリケーションパスアイコン
- bPagesAdd：コピーアイコン
- bPagesPW：パスワード管理アイコン
- bPagesMove：移動アイコン

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 82 | イントラネット管理 | 主機能 | イントラネットメニューの表示 |

## 画面種別

インクルードファイル / メニュー表示

## URL/ルーティング

```
asp/bs_menuIntranet.asp（インクルードファイル、直接アクセス不可）
```

## 入出力項目

本画面は入力項目を持たない。ページ階層の表示のみを行う。

| 項目名 | 項目ID | 型 | 必須 | 入力/出力 | 説明 |
|--------|--------|-----|------|-----------|------|
| なし | - | - | - | - | 入力項目なし |

## 表示項目

| 項目名 | 説明 |
|--------|------|
| ページメニュー | 階層構造のイントラネットページ一覧 |
| フリーページ見出し | 「Free pages:」という見出し |
| フリーページ一覧 | 親を持たないページの一覧（リスト形式） |
| ページリンク | 各ページの編集画面へのリンク |
| アプリケーションアイコン | アプリケーションパスが設定されている場合に表示 |
| コピーアイコン | ページコピー機能へのリンク |
| ロック/アンロックアイコン | パスワード保護状態に応じたアイコン |
| 移動アイコン | ページ移動機能へのリンク |

## イベント仕様

### 1-ページリンククリック

ページの編集画面に遷移する。

**処理フロー**：
1. ユーザーがページ名リンクをクリック
2. getClickLink()メソッドで生成されたリンク先に遷移
3. 該当ページの編集画面が表示される

### 2-コピーアイコンクリック

ページをコピーする（copyItem JavaScript関数が呼び出される）。

**処理フロー**：
1. ユーザーがコピーアイコンをクリック
2. 親画面のcopyItem()関数で確認ダイアログ表示
3. OKの場合、bs_default.asp?btnaction=Copy&iId={ページID}に遷移
4. ページがコピーされる

### 3-パスワード管理アイコンクリック

ページのパスワード保護設定画面に遷移する。

**処理フロー**：
1. ユーザーがロック/アンロックアイコンをクリック
2. bs_applyPw.asp?iId={ページID}に遷移
3. パスワード設定画面が表示される

### 4-移動アイコンクリック

ページの移動先選択画面に遷移する。

**処理フロー**：
1. ユーザーが移動アイコンをクリック
2. bs_selectPage.asp?btnaction=Move&iId={ページID}に遷移
3. 移動先選択画面が表示される

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | tblPage | SELECT | イントラネットページの取得 |

### テーブル別更新項目詳細

#### tblPage（参照のみ）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | iId | イントラネットページ | ページ識別 |
| SELECT | sTitle | - | ページタイトル表示 |
| SELECT | sApplication | - | アプリケーションパス有無判定 |
| SELECT | sPw | - | パスワード保護状態判定 |
| SELECT | iParentID | null | フリーページ判定 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| freepages | ラベル | フリーページ見出し | フリーページ存在時 |
| application | ツールチップ | アプリケーションアイコンのツールチップ | アプリケーションパス設定時 |
| copyitem | ツールチップ | コピーアイコンのツールチップ | bPagesAdd有効時 |
| managepw | ツールチップ | パスワード管理アイコンのツールチップ | bPagesPW有効時 |
| moveitem | ツールチップ | 移動アイコンのツールチップ | bPagesMove有効時 |

## 例外処理

| 例外パターン | 処理内容 |
|-------------|---------|
| ページなし | メニューとフリーページ一覧が空で表示 |

本ファイルはインクルードファイルのため、認証エラーは親画面で処理される。

## 備考

- cls_menuクラスのgetBOMenu(null,true)でイントラネットページのメニューを取得
- 第2引数trueはイントラネットモードを示す
- lossePaginas(true)で親を持たないイントラネットページを取得
- フリーページはulタグ内にリスト形式で表示
- 各アイコンはgetIcon()関数でスタイル付きリンクとして生成
- EnCrypt()関数でページIDを暗号化してURLに含める

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ページデータとメニュークラスの構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | menu.asp（推定） | `asp/includes/menu.asp` | cls_menuクラス、getBOMenu, lossePaginasメソッド |

**読解のコツ**: getBOMenuは階層構造のHTMLを返す。lossePaginasは親を持たないページのDictionaryを返す。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_menuIntranet.asp | `asp/bs_menuIntranet.asp` | イントラネットメニュー表示の実装 |

**主要処理フロー**:
1. **Line 2-4**: cls_menuオブジェクト生成、getBOMenu(null,true)でメニューHTML出力
2. **Line 5-6**: lossePaginas(true)でフリーページ取得
3. **Line 7-22**: フリーページが存在する場合のループ処理
4. **Line 11**: getClickLink(true)でページリンク生成
5. **Line 13-18**: 各アイコンの条件付き表示

#### Step 3: アイコン生成処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | functions.asp | `asp/includes/functions.asp` | getIcon()関数の実装 |

**読解のコツ**: getIcon(alt, icon, href, onclick, id)でスタイル付きアイコンリンクを生成。

### プログラム呼び出し階層図

```
bs_intranet.asp
    │
    └─ bs_menuIntranet.asp（インクルード）
           │
           ├─ cls_menu.getBOMenu(null, true)
           │      └─ tblPage（SELECT - イントラネットページ）
           │
           ├─ cls_menu.lossePaginas(true)
           │      └─ tblPage（SELECT - フリーページ）
           │
           └─ フリーページループ
                  ├─ getClickLink(true)（ページリンク生成）
                  ├─ getIcon()（アプリケーションアイコン）
                  ├─ getIcon()（コピーアイコン）
                  ├─ getIcon()（ロック/アンロックアイコン）
                  └─ getIcon()（移動アイコン）
```

### データフロー図

```
[入力]                      [処理]                         [出力]

（なし） ────────────────▶ cls_menu.getBOMenu(null,true) ─▶ ページ階層HTML
                                │
                                ▼
                     cls_menu.lossePaginas(true)
                                │
                                ▼
                     フリーページDictionary
                                │
                                ▼
                     各ページのループ処理
                                │
                    ┌───────────┴───────────┐
                    ▼                       ▼
               ページリンク            操作アイコン群
             （getClickLink）          （getIcon）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_menuIntranet.asp | `asp/bs_menuIntranet.asp` | ソース | イントラネットメニュー表示（本ファイル） |
| bs_intranet.asp | `asp/bs_intranet.asp` | ソース | インクルード元の親画面 |
| menu.asp | `asp/includes/menu.asp` | インクルード | cls_menuクラス定義（推定） |
| functions.asp | `asp/includes/functions.asp` | インクルード | getIcon, EnCrypt関数など |
| bs_default.asp | `asp/bs_default.asp` | ソース | コピー処理の遷移先 |
| bs_applyPw.asp | `asp/bs_applyPw.asp` | ソース | パスワード設定の遷移先 |
| bs_selectPage.asp | `asp/bs_selectPage.asp` | ソース | 移動先選択の遷移先 |
