# 画面設計書 12-外部URL編集

## 概要

本ドキュメントは、QuickerSite CMSのバックサイト（管理画面）における「外部URL編集」画面の設計仕様を定義するものである。

### 本画面の処理概要

外部URL編集画面は、メニュー項目として外部サイトへのリンクを設定するための画面である。サイトのナビゲーションメニュー内に、外部Webサイトへのリダイレクトリンクを作成・編集することができる。

**業務上の目的・背景**：
Webサイトのナビゲーションには、自サイト内のページだけでなく、関連会社サイトやSNSページなど外部サイトへのリンクを含めることが多い。本画面は、コンテンツを持たない純粋なリンク項目を作成し、ユーザーを外部URLにリダイレクトさせる機能を提供する。これにより、サイト管理者は統一されたナビゲーション構造の中で外部リンクを管理できる。

**画面へのアクセス方法**：
1. バックサイトにログイン後、ホーム画面でページ作成を選択
2. ページタイプとして「外部URL」を選択
3. または既存の外部URLページをクリックして編集
4. URLパラメータとして暗号化されたページID（iId）とiParentIDが渡される

**主要な操作・処理内容**：
1. ページタイトルの設定（メニューに表示される名前）
2. 外部URLのプロトコル選択（http://、https://、mailto:など）
3. 外部URLのアドレス入力
4. 新しいウィンドウで開くかどうかの設定
5. rel属性とclass属性の設定
6. メニュー内での表示順序の設定
7. 公開/非公開の設定
8. ページの削除

**画面遷移**：
- 遷移元: バックサイトホーム（bs_default.asp）、ページ作成画面（bs_setupPage.asp）
- 遷移先: バックサイトホーム（bs_default.asp）、イントラネット管理（bs_intranet.asp）

**権限による表示制御**：
- secondAdmin.bPageBodyがfalseの場合、URL関連の入力項目が非表示になる
- secondAdmin.bPageTitleがfalseの場合、タイトルは表示のみで編集不可
- secondAdmin.bPagePublishがfalseの場合、公開設定項目が非表示
- secondAdmin.bPagesMoveとbPageOrderがfalseの場合、並び順設定が非表示

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 14 | 外部URL設定 | 主機能 | 外部サイトへのリダイレクト先URL設定 |

## 画面種別

編集画面（登録・更新）

## URL/ルーティング

```
asp/bs_editExternalURL.asp?iId={暗号化されたページID}&iParentID={暗号化された親ページID}
```

## 入出力項目

| 項目名 | 入力/出力 | データ型 | 必須 | 説明 |
|--------|----------|---------|------|------|
| iId | 入力（hidden） | String | Yes | 暗号化されたページID |
| iParentID | 入力（hidden） | String | No | 暗号化された親ページID |
| btnaction | 入力（hidden） | String | Yes | アクション種別（save） |
| sTitle | 入力（text） | String | Yes | ページタイトル（メニュー表示名） |
| sExternalURLPrefix | 入力（select） | String | Yes | URLプロトコル選択 |
| sExternalURL | 入力（text） | String | Yes | 外部URL本体 |
| bOpenInNewWindow | 入力（checkbox） | Boolean | No | 新しいウィンドウで開く |
| sRel | 入力（text） | String | No | rel属性値 |
| sClassname | 入力（text） | String | No | class属性値（Colorbox用など） |
| iRang | 入力（select） | Integer | No | メニュー内の表示順 |
| bOnline | 入力（checkbox） | Boolean | No | 公開状態 |
| bIntranet | 入力（hidden） | Boolean | No | イントラネットフラグ |
| QS_secCodeHidden | 入力（hidden） | String | Yes | CSRF対策トークン |

## 表示項目

| 項目名 | 表示形式 | 説明 |
|--------|---------|------|
| 親ページ名 | テキスト | 紐付け先の親ページ名（ある場合） |
| ページタイトル | 入力フィールド/テキスト | メニューに表示される名前 |
| 外部URL | プルダウン＋入力フィールド | プロトコル選択とURL入力 |
| 新しいウィンドウで開く | チェックボックス | target="_blank"相当 |
| rel属性 | 入力フィールド | SEO・セキュリティ用 |
| class属性 | 入力フィールド | スタイル・動作指定用（Colorbox等） |
| 表示順 | プルダウン | メニュー内の並び順 |
| 公開状態 | チェックボックス | オンライン/オフライン切替 |

## イベント仕様

### 1-保存ボタン押下

1. フォームをPOST送信
2. btnaction=l("save")でbs_processPage.aspの処理が実行
3. checkCSRF()でCSRFトークン検証
4. page.getRequestValues()でフォーム値をオブジェクトに設定
5. page.save()でデータベースに保存
6. 保存成功時、message.Add("fb_saveOK")でメッセージ設定

### 2-削除ボタン押下

1. JavaScript確認ダイアログ表示
2. 確認OKでbtnaction=l("delete")を設定してフォーム送信
3. page.bDeleted=trueを設定
4. 親ページのrang（並び順）を再計算
5. page.save()で削除フラグ付きで保存
6. バックサイトホームまたはイントラネット管理にリダイレクト

### 3-変換リンク（コンテナ/リストページ/コンテンツ付きへの変換）

画面下部のインクルードファイルにより、他のページタイプへの変換リンクが提供される：
- bs_convertToContainerItem.asp
- bs_convertToListpage.asp
- bs_convertToItemWithContent.asp

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | tblPage | INSERT/UPDATE | 外部URL設定を保存 |
| 削除ボタン押下 | tblPage | UPDATE | 論理削除（bDeleted=true） |

### テーブル別更新項目詳細

#### tblPage

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT/UPDATE | sTitle | フォームから取得 | ページタイトル |
| INSERT/UPDATE | sExternalURLPrefix | フォームから取得 | URLプロトコル |
| INSERT/UPDATE | sExternalURL | フォームから取得 | URL本体 |
| INSERT/UPDATE | bOpenInNewWindow | フォームから取得 | 新窓フラグ |
| INSERT/UPDATE | sRel | フォームから取得 | rel属性 |
| INSERT/UPDATE | sClassname | フォームから取得 | class属性 |
| INSERT/UPDATE | iRang | フォームから取得 | 表示順 |
| INSERT/UPDATE | bOnline | フォームから取得 | 公開フラグ |
| INSERT/UPDATE | iParentID | フォームから取得 | 親ページID |
| INSERT/UPDATE | bIntranet | フォームから取得 | イントラネットフラグ |
| UPDATE | bDeleted | true | 削除時のみ |
| INSERT | createdTS | now() | 新規作成時のみ |
| INSERT/UPDATE | updatedTS | now() | 更新日時 |

## メッセージ仕様

| メッセージID | 種別 | 表示条件 | メッセージ内容 |
|-------------|------|---------|--------------|
| fb_saveOK | 成功 | 保存成功時 | 保存が完了しました |
| err_mandatory | エラー | 必須項目未入力 | 必須項目を入力してください |
| deletecomplete | 確認 | 削除ボタン押下時 | 削除してよろしいですか？ |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| 未認証アクセス | bs_security.aspによりログイン画面にリダイレクト |
| 不正なページID | page.pick()で該当なしの場合、空のオブジェクトとなる |
| 必須項目未入力 | エラーメッセージを表示し、保存を中止 |
| CSRFトークン不正 | checkCSRF()でエラー処理 |

## 備考

- URLプロトコルは cls_urlTypeList クラスで管理されている
- Colorbox統合：sClassnameに「QSCCB_530_300」を設定すると530x300pxのColorboxで開く
- 論理削除方式を採用（bDeleted=trueで削除扱い）
- 外部URLページは自身のコンテンツを持たない

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

外部URLページがどのようにデータベースに格納されるかを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | page.asp | `asp/includes/page.asp` | cls_pageクラスのsExternalURL関連プロパティ |

**読解のコツ**: sExternalURLPrefixとsExternalURLを組み合わせて完全なURLが構成される点に注意。

#### Step 2: エントリーポイントを理解する

画面表示の流れを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_editExternalURL.asp | `asp/bs_editExternalURL.asp` | メイン画面構成、インクルード順序 |

**主要処理フロー**:
1. **行1-4**: 各種インクルードファイル読み込み
2. **行4**: cls_urlTypeListによるプロトコル選択肢生成
3. **行4-5**: フォーム構成と入力項目表示

#### Step 3: 保存・削除処理を理解する

データ永続化の仕組みを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_processPage.asp | `asp/bs_processPage.asp` | 保存・削除処理のメインロジック |
| 3-2 | bs_process.asp | `asp/bs_process.asp` | 共通処理（Move、Copy等） |

**主要処理フロー**:
- **行12-25**: 保存処理（page.getRequestValues、page.save）
- **行26-44**: 削除処理（論理削除、リダイレクト）

#### Step 4: 共通部品を理解する

フォーム構成用のインクルードファイルを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | bs_commoncont.asp | `asp/bs_commoncont.asp` | タイトル入力、親ページ表示 |
| 4-2 | bs_sortorder.asp | `asp/bs_sortorder.asp` | 表示順選択 |
| 4-3 | bs_onlineOrNot.asp | `asp/bs_onlineOrNot.asp` | 公開設定 |
| 4-4 | bs_deleteButton.asp | `asp/bs_deleteButton.asp` | 削除ボタン表示 |

### プログラム呼び出し階層図

```
bs_editExternalURL.asp
    │
    ├─ begin.asp（セッション・DB初期化）
    │
    ├─ bs_security.asp（認証チェック）
    │
    ├─ bs_process.asp（共通処理）
    │      └─ cls_page操作（Move、Copy等）
    │
    ├─ bs_processPage.asp（保存・削除処理）
    │      ├─ checkCSRF()
    │      ├─ page.getRequestValues()
    │      └─ page.save()
    │
    ├─ cls_urlTypeList（プロトコル選択肢）
    │
    ├─ bs_commoncont.asp（タイトル入力）
    │
    ├─ bs_sortorder.asp（表示順）
    │
    ├─ bs_onlineOrNot.asp（公開設定）
    │
    └─ bs_deleteButton.asp（削除ボタン）
```

### データフロー図

```
[入力]                      [処理]                      [出力]

URLパラメータ(iId) ─────────▶ decrypt() ─────────────▶ ページID取得
                                  │
                                  ▼
                            cls_page.pick() ──────────▶ 現在の設定値表示
                                  │
フォーム入力 ───────────────────▶ request.form() ─────▶ 入力値取得
   │                              │
   │ sExternalURLPrefix           ▼
   │ sExternalURL         page.getRequestValues() ────▶ オブジェクト設定
   │ bOpenInNewWindow             │
   │ sRel                         ▼
   │ sClassname              page.save() ─────────────▶ tblPage INSERT/UPDATE
   │                              │
   └──────────────────────────────▼
                            response.redirect() ──────▶ ホーム画面
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_editExternalURL.asp | `asp/bs_editExternalURL.asp` | ソース | メイン画面処理 |
| bs_process.asp | `asp/bs_process.asp` | インクルード | 共通処理 |
| bs_processPage.asp | `asp/bs_processPage.asp` | インクルード | 保存・削除処理 |
| bs_commoncont.asp | `asp/bs_commoncont.asp` | インクルード | タイトル入力部品 |
| bs_sortorder.asp | `asp/bs_sortorder.asp` | インクルード | 表示順選択部品 |
| bs_onlineOrNot.asp | `asp/bs_onlineOrNot.asp` | インクルード | 公開設定部品 |
| bs_deleteButton.asp | `asp/bs_deleteButton.asp` | インクルード | 削除ボタン部品 |
| bs_addnewitem.asp | `asp/bs_addnewitem.asp` | インクルード | 新規アイテム追加 |
| bs_convertToContainerItem.asp | `asp/bs_convertToContainerItem.asp` | インクルード | コンテナ変換 |
| bs_convertToListpage.asp | `asp/bs_convertToListpage.asp` | インクルード | リストページ変換 |
| bs_convertToItemWithContent.asp | `asp/bs_convertToItemWithContent.asp` | インクルード | コンテンツ付き変換 |
| bs_back.asp | `asp/bs_back.asp` | インクルード | 戻るリンク |
| page.asp | `asp/includes/page.asp` | インクルード | cls_pageクラス |
