# 画面設計書 120-メール履歴

## 概要

本ドキュメントは、QuickerSite CMSにおける「メール履歴」画面（bs_mailHistory.asp）の設計仕様を定義するものである。

### 本画面の処理概要

本画面は、システムから送信されたメールの履歴を一覧表示する画面である。件名、送信日時、受信者数を確認でき、各メールの詳細内容や受信者リストをポップアップウィンドウで確認できる。また、不要な履歴を削除する機能も提供する。

**業務上の目的・背景**：会員向けの一斉メール送信やシステム通知など、CMSから送信されるメールの履歴を管理する必要がある。本画面は、過去に送信したメールの確認、受信者の確認、不要な履歴の削除といった運用作業を支援する。メール送信の証跡管理や、送信ミスの確認にも活用できる。

**画面へのアクセス方法**：バックサイトにログイン後、「Intranet」メニューから「Sent Messages」を選択することでアクセスできる。セカンド管理者の場合は、bIntranetMail権限が必要。

**主要な操作・処理内容**：
1. 送信済みメール一覧の表示
2. メール詳細の閲覧（ポップアップ）
3. メール受信者一覧の閲覧（ポップアップ）
4. メール履歴の削除

**画面遷移**：
- 遷移元：イントラネットメニュー
- 遷移先（ポップアップ）：bs_mailDetail.asp（メール詳細）、bs_mailReceivers.asp（受信者一覧）

**権限による表示制御**：セカンド管理者の場合、bIntranetMail権限が必要。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 87 | メール送信履歴 | 主機能 | 送信メール履歴の一覧表示 |

## 画面種別

一覧 / 管理

## URL/ルーティング

```
asp/bs_mailHistory.asp
```

削除時：
```
asp/bs_mailHistory.asp?{QS_secCodeURL}&iMail_ID={暗号化されたメールID}
```

## 入出力項目

| 項目名 | 項目ID | 型 | 必須 | 入力/出力 | 説明 |
|--------|--------|-----|------|-----------|------|
| メールID | iMail_ID | 数値（暗号化） | - | 入力 | 削除対象メールのID |

## 表示項目

| 項目名 | 説明 |
|--------|------|
| 件名 | メールの件名（メール詳細へのリンク） |
| 送信日 | メール送信日時 |
| 受信者数 | 送信先の連絡先数（受信者一覧へのリンク） |
| 削除アイコン | メール履歴削除へのリンク |

## イベント仕様

### 1-件名リンククリック

メールの詳細内容をポップアップウィンドウで表示する。

**処理フロー**：
1. ユーザーが件名リンクをクリック
2. openPopUpWindow()関数でbs_mailDetail.aspをポップアップ表示
3. ポップアップウィンドウサイズ：670x500px
4. メールの本文内容が表示される

### 2-受信者数リンククリック

メールの受信者一覧をポップアップウィンドウで表示する。

**処理フロー**：
1. ユーザーが受信者数リンクをクリック
2. openPopUpWindow()関数でbs_mailReceivers.aspをポップアップ表示
3. ポップアップウィンドウサイズ：390x700px
4. 受信者のメールアドレス一覧が表示される

### 3-削除アイコンクリック

メール履歴を削除する。

**処理フロー**：
1. ユーザーが削除アイコンをクリック
2. 確認ダイアログが表示される
3. OKの場合、bs_mailHistory.asp?{CSRFトークン}&iMail_ID={暗号化ID}にリダイレクト
4. CSRFトークンを検証（checkCSRF）
5. theMail.delete()でメールデータを削除
6. 画面が再表示される

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | tblMail | SELECT | メール一覧の取得 |
| 画面表示 | tblMailContact | SELECT | 受信者数の取得 |
| 削除アイコンクリック | tblMailContact | DELETE | 受信者データの削除 |
| 削除アイコンクリック | tblMail | DELETE | メールデータの削除 |

### テーブル別更新項目詳細

#### tblMail

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | iId | iCustomerID = cId | メール識別 |
| SELECT | sSubject | - | 件名表示 |
| SELECT | dDateSent | - | 送信日時表示 |
| DELETE | - | iId = {指定ID} | メール削除 |

#### tblMailContact

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | COUNT(*) | iMailID = {メールID} | 受信者数取得 |
| DELETE | - | iMailId = {メールID} | 受信者データ削除 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| sentmessages | 見出し | 送信済みメッセージ見出し | メールが存在する場合 |
| subject | ヘッダー | 件名列ヘッダー | メールが存在する場合 |
| sent | ヘッダー | 送信列ヘッダー | メールが存在する場合 |
| on | ヘッダー | 日付列ヘッダー | メールが存在する場合 |
| contacts | ヘッダー | 連絡先数列ヘッダー | メールが存在する場合 |
| areyousure | 確認 | 削除確認ダイアログ | 削除アイコンクリック時 |
| delete | ツールチップ | 削除アイコンのツールチップ | アイコン表示時 |
| nomessagessent | 情報 | 送信済みメッセージなし | メールが存在しない場合 |

## 例外処理

| 例外パターン | 処理内容 |
|-------------|---------|
| イントラネットメール権限なし | bs_security.aspでアクセス拒否 |
| メールなし | 「No messages sent」を表示 |
| メールIDが無効 | 削除処理がスキップされる |
| CSRF検証失敗 | エラー処理（checkCSRF関数内） |

## 備考

- テーブルはsortableクラスを持ち、ソート可能
- 送信日時はconvertEuroDateで欧州形式に変換して表示
- メールIDはencrypt/decrypt関数で暗号化/復号化
- 削除時は関連するtblMailContactのレコードも削除される
- customer.mailsプロパティでメール一覧を取得

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

メールデータの構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | mail.asp | `asp/includes/mail.asp` | cls_mailクラス、プロパティ（iId, sSubject, dDateSent等） |

**読解のコツ**: iNumberRecプロパティで受信者数を取得。receivers()で受信者一覧を取得。delete()でメールと受信者を削除。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_mailHistory.asp | `asp/bs_mailHistory.asp` | メール履歴画面の実装 |

**主要処理フロー**:
1. **Line 1-4**: インクルードとセキュリティチェック（bIntranetMail権限）
2. **Line 4-9**: 削除処理（iMail_IDパラメータがある場合）
3. **Line 11**: customer.mailsでメール一覧取得
4. **Line 12**: テーブル表示（sortableクラス）
5. **Line 12**: 各メールのループ処理、リンク/アイコン表示

#### Step 3: メールクラスの詳細を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | mail.asp | `asp/includes/mail.asp` | cls_mailクラスの詳細 |

**主要処理フロー**:
- **Line 44-52**: delete()メソッド - tblMailContactとtblMailから削除
- **Line 53-57**: iNumberRecプロパティ - receivers()を呼び出して件数取得
- **Line 58-67**: receivers()メソッド - tblMailContactから受信者取得

### プログラム呼び出し階層図

```
bs_mailHistory.asp
    │
    ├─ bs_security.asp（認証チェック）
    │      └─ logon.hasaccess(secondAdmin.bIntranetMail)
    │
    ├─ [削除時]
    │      ├─ checkCSRF()（CSRF検証）
    │      └─ theMail.delete()（メール削除）
    │             ├─ tblMailContact（DELETE）
    │             └─ tblMail（DELETE）
    │
    └─ customer.mails（メール一覧取得）
           └─ tblMail（SELECT）
                  │
                  └─ 各メールのiNumberRec
                         └─ tblMailContact（SELECT COUNT）
```

### データフロー図

```
[入力]                      [処理]                         [出力]

iMail_ID ─────────────────▶ decrypt() ────────────────▶ メールID
（削除時）                          │
                                    ▼
                            cls_mail.delete()
                                    │
                                    ▼
                            DB削除（Mail + Contact）

（一覧表示時）
customer.mails ────────────▶ tblMail SELECT ─────────▶ メール一覧
                                    │
                                    ▼
                            テーブル表示
                                    │
                    ┌───────────────┼───────────────┐
                    ▼               ▼               ▼
              件名リンク      受信者数リンク    削除アイコン
         （ポップアップ）   （ポップアップ）   （削除処理）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_mailHistory.asp | `asp/bs_mailHistory.asp` | ソース | メール履歴画面（本ファイル） |
| bs_mailDetail.asp | `asp/bs_mailDetail.asp` | ソース | メール詳細（ポップアップ） |
| bs_mailReceivers.asp | `asp/bs_mailReceivers.asp` | ソース | 受信者一覧（ポップアップ） |
| mail.asp | `asp/includes/mail.asp` | インクルード | cls_mailクラス定義 |
| customer.asp | `asp/includes/customer.asp` | インクルード | mailsプロパティ |
| bs_security.asp | `asp/bs_security.asp` | インクルード | セキュリティチェック |
