# 画面設計書 121-メール詳細

## 概要

本ドキュメントは、QuickerSiteにおける送信メール詳細画面（bs_mailDetail.asp）の設計を定義する。

### 本画面の処理概要

送信メール詳細画面は、過去に送信したメールの本文内容を詳細表示するための画面である。

**業務上の目的・背景**：イントラネット機能や連絡先管理機能から送信された一斉メールの履歴を確認することは、業務管理上重要である。本画面は、送信済みメールの本文や件名などの詳細情報を閲覧し、過去のコミュニケーション内容を把握するために必要となる。送信内容の確認、トラブル発生時の調査、コンプライアンス対応などの用途に活用される。

**画面へのアクセス方法**：バックサイトホーム > イントラネット管理 > 送信メッセージ履歴（bs_mailHistory.asp）画面から、件名のリンクをクリックすることでポップアップウィンドウとして表示される。

**主要な操作・処理内容**：
1. メール履歴画面から選択されたメールIDに基づき、データベースからメール情報を取得
2. メール本文（sBody）を画面に表示
3. 本文はHTML形式で保存されているため、そのままレンダリングされる

**画面遷移**：
- 遷移元：メール履歴画面（bs_mailHistory.asp）からポップアップ表示
- 遷移先：なし（閲覧専用のポップアップ画面）

**権限による表示制御**：secondAdmin.bIntranetMail権限を持つ管理者のみがアクセス可能。権限がない場合はアクセスが拒否される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 87 | メール送信履歴 | 主機能 | 送信メールの詳細内容確認 |

## 画面種別

詳細（ポップアップ）

## URL/ルーティング

```
asp/bs_mailDetail.asp?iMail_id={暗号化されたメールID}
```

## 入出力項目

| 項目名 | 入出力 | データ型 | 必須 | 説明 |
|--------|--------|----------|------|------|
| iMail_id | 入力（パラメータ） | String | 必須 | 暗号化されたメールID |
| sBody | 出力（表示） | String | - | メール本文（HTML形式） |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| メール本文 | HTML | 送信されたメールの本文内容 |

## イベント仕様

### 1-画面表示

- 画面がポップアップとして開かれると、GETパラメータのiMail_idを復号化してメールIDを取得
- cls_mailクラスをインスタンス化し、該当メールの本文を取得
- sBodyプロパティの内容をResponse.Writeで出力

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | tblMail | SELECT | メール本文の取得 |

### テーブル別更新項目詳細

#### tblMail

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | sBody | iMailID = decrypt(iMail_id) | メール本文HTML |

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|-----------|----------|
| - | - | 本画面ではメッセージ表示なし |

## 例外処理

| 例外 | 対処 |
|------|------|
| 権限不足 | secondAdmin.bIntranetMail権限がない場合、アクセス拒否 |
| メールが存在しない | 空の本文が表示される |
| 無効なiMail_id | 復号化に失敗した場合、エラーまたは空表示 |

## 備考

- 本画面はポップアップウィンドウ（670x500px）として表示される
- メール本文はHTML形式で保存されており、そのままブラウザでレンダリングされる
- セキュリティのため、bs_security.aspによるログオン認証が必須

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

メールデータはcls_mailクラスで管理され、tblMailテーブルに保存される。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | tblMail | データベーステーブル | メールID、本文、件名などのカラム構造を理解 |

**読解のコツ**: cls_mailクラスの定義ファイルを探し、sBodyプロパティの取得方法を確認する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_mailDetail.asp | `asp/bs_mailDetail.asp` | 画面の起点、7行の簡潔なコード |

**主要処理フロー**:
1. **行1**: begin.aspをインクルード（共通初期化）
2. **行4**: bs_security.aspでセキュリティチェック、logon.hasaccessでbIntranetMail権限確認
3. **行4**: bs_process.aspをインクルード（リクエスト処理）
4. **行5-6**: cls_mailをインスタンス化し、sBodyを出力
5. **行7**: mailオブジェクトを解放

#### Step 3: セキュリティ処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_security.asp | `asp/bs_security.asp` | ログオン状態と権限の検証方法 |

**主要処理フロー**:
- logon.hasaccess関数がsecondAdmin.bIntranetMail権限をチェック
- 権限がない場合はアクセスを拒否

#### Step 4: メールクラスを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | cls_mail.asp | `asp/classes/` 配下（推定） | sBodyプロパティの実装、データベースアクセス方法 |

### プログラム呼び出し階層図

```
bs_mailDetail.asp
    │
    ├─ begin.asp (共通初期化)
    │
    ├─ bs_security.asp (セキュリティチェック)
    │      └─ logon.hasaccess(secondAdmin.bIntranetMail)
    │
    ├─ bs_process.asp (リクエスト処理)
    │
    └─ cls_mail (メールクラス)
           └─ sBody プロパティ → tblMail SELECT
```

### データフロー図

```
[入力]               [処理]                    [出力]

iMail_id ───▶ decrypt() ───▶ メールID
     │                          │
     │                          ▼
     │                  cls_mail.pick()
     │                          │
     │                          ▼
     │              tblMail SELECT(sBody)
     │                          │
     └──────────────────────────┘
                               │
                               ▼
                        [Response.Write]
                               │
                               ▼
                    HTML表示（メール本文）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_mailDetail.asp | `asp/bs_mailDetail.asp` | ソース | メール詳細表示画面 |
| bs_security.asp | `asp/bs_security.asp` | ソース | セキュリティチェック |
| bs_process.asp | `asp/bs_process.asp` | ソース | リクエスト処理 |
| begin.asp | `asp/begin.asp` | ソース | 共通初期化処理 |
| cls_mail | クラス定義ファイル | ソース | メールデータ管理クラス |
| bs_mailHistory.asp | `asp/bs_mailHistory.asp` | ソース | 遷移元のメール履歴画面 |
