# 画面設計書 122-メール受信者

## 概要

本ドキュメントは、QuickerSiteにおけるメール受信者一覧画面（bs_mailReceivers.asp）の設計を定義する。

### 本画面の処理概要

メール受信者一覧画面は、特定の送信メールの受信者（宛先メールアドレス）を一覧表示するための画面である。

**業務上の目的・背景**：一斉メール送信機能で送信されたメールについて、どの連絡先・メールアドレスに送信されたかを確認する必要がある。本画面は、送信履歴の詳細として受信者リストを提供し、送信漏れの確認や送信対象の把握に活用される。コンプライアンス対応や顧客サポートにおいて、特定のメールが誰に送られたかを迅速に確認できることは業務効率向上に寄与する。

**画面へのアクセス方法**：バックサイトホーム > イントラネット管理 > 送信メッセージ履歴（bs_mailHistory.asp）画面から、受信者数（N° contacts列）のリンクをクリックすることでポップアップウィンドウとして表示される。

**主要な操作・処理内容**：
1. メール履歴画面から選択されたメールIDに基づき、cls_mailクラスのreceiversメソッドで受信者リストを取得
2. 受信者のメールアドレスを番号付きリスト形式で一覧表示
3. 受信者数のカウンターも取得される

**画面遷移**：
- 遷移元：メール履歴画面（bs_mailHistory.asp）からポップアップ表示
- 遷移先：なし（閲覧専用のポップアップ画面）

**権限による表示制御**：secondAdmin.bIntranetMail権限を持つ管理者のみがアクセス可能。権限がない場合はアクセスが拒否される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 87 | メール送信履歴 | 主機能 | メール受信者の一覧表示 |

## 画面種別

一覧（ポップアップ）

## URL/ルーティング

```
asp/bs_mailReceivers.asp?iMail_id={暗号化されたメールID}
```

## 入出力項目

| 項目名 | 入出力 | データ型 | 必須 | 説明 |
|--------|--------|----------|------|------|
| iMail_id | 入力（パラメータ） | String | 必須 | 暗号化されたメールID |
| receivers | 出力（内部） | Array | - | 受信者情報の2次元配列 |
| counter | 出力（内部） | Integer | - | 受信者数 |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| 受信者リスト | HTML（ol/li） | 番号付きリストで表示される受信者メールアドレス |

## イベント仕様

### 1-画面表示

- 画面がポップアップとして開かれると、GETパラメータのiMail_idを復号化してメールIDを取得
- cls_mailクラスをインスタンス化
- receiversメソッドを呼び出し、受信者配列とカウンターを取得
- 配列をループしてHTML順序付きリスト（ol）として出力

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | tblMailContact | SELECT | メール受信者一覧の取得 |

### テーブル別更新項目詳細

#### tblMailContact

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | sEmail | iMailID = decrypt(iMail_id) | 受信者のメールアドレス |
| SELECT | iMailID | 検索条件 | メールID |

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|-----------|----------|
| - | - | 本画面ではメッセージ表示なし |

## 例外処理

| 例外 | 対処 |
|------|------|
| 権限不足 | secondAdmin.bIntranetMail権限がない場合、アクセス拒否 |
| 受信者が存在しない | 空のリストが表示される |
| 無効なiMail_id | 復号化に失敗した場合、エラーまたは空リスト |

## 備考

- 本画面はポップアップウィンドウ（390x700px）として表示される
- 受信者情報は2次元配列として返される（receivers(0,i)がメールアドレス）
- セキュリティのため、bs_security.aspによるログオン認証が必須
- HTMLは簡潔な構造で、titleタグにl("list")の多言語対応ラベルを使用

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

受信者データはcls_mailクラスのreceiversメソッドで取得され、2次元配列として返される。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | tblMailContact | データベーステーブル | メールIDとメールアドレスの関連付け |

**読解のコツ**: receivers配列は(0,i)でメールアドレスにアクセスする構造。2次元配列の1次元目は項目種別、2次元目がレコードインデックス。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_mailReceivers.asp | `asp/bs_mailReceivers.asp` | 画面の起点、13行の簡潔なコード |

**主要処理フロー**:
1. **行1**: begin.aspをインクルード（共通初期化）
2. **行4**: bs_security.aspでセキュリティチェック、logon.hasaccessでbIntranetMail権限確認
3. **行4**: bs_process.aspをインクルード、HTML基本構造開始
4. **行5**: cls_mailをインスタンス化
5. **行6**: mail.receivers(counter)を呼び出し、受信者配列とカウンターを取得
6. **行7**: olタグ開始
7. **行8-11**: 配列をループしてliタグで各受信者を出力
8. **行12**: olタグ終了、mailオブジェクト解放

#### Step 3: 受信者取得処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | cls_mail | クラス定義ファイル | receiversメソッドの実装、SQLクエリ |

**主要処理フロー**:
- receiversメソッドはtblMailContactテーブルからsEmailを取得
- ByRef引数counterで受信者数を返す

### プログラム呼び出し階層図

```
bs_mailReceivers.asp
    │
    ├─ begin.asp (共通初期化)
    │
    ├─ bs_security.asp (セキュリティチェック)
    │      └─ logon.hasaccess(secondAdmin.bIntranetMail)
    │
    ├─ bs_process.asp (リクエスト処理)
    │
    └─ cls_mail (メールクラス)
           └─ receivers(counter) メソッド
                  └─ tblMailContact SELECT
```

### データフロー図

```
[入力]               [処理]                    [出力]

iMail_id ───▶ decrypt() ───▶ メールID
     │                          │
     │                          ▼
     │                  cls_mail.pick()
     │                          │
     │                          ▼
     │              cls_mail.receivers(counter)
     │                          │
     │                          ▼
     │              tblMailContact SELECT
     │                  │
     └──────────────────┘
                        │
                        ▼
                 receivers配列
                 counter(件数)
                        │
                        ▼
                 [For Each ループ]
                        │
                        ▼
              HTML<ol><li>出力
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_mailReceivers.asp | `asp/bs_mailReceivers.asp` | ソース | メール受信者一覧画面 |
| bs_security.asp | `asp/bs_security.asp` | ソース | セキュリティチェック |
| bs_process.asp | `asp/bs_process.asp` | ソース | リクエスト処理 |
| begin.asp | `asp/begin.asp` | ソース | 共通初期化処理 |
| cls_mail | クラス定義ファイル | ソース | メールデータ管理クラス |
| bs_mailHistory.asp | `asp/bs_mailHistory.asp` | ソース | 遷移元のメール履歴画面 |
