# 画面設計書 123-一斉メール送信

## 概要

本ドキュメントは、QuickerSiteにおける一斉メール送信処理画面（bs_massMailing2.asp）の設計を定義する。

### 本画面の処理概要

一斉メール送信画面は、連絡先管理機能で登録された複数の連絡先に対して一斉にメールを送信するためのバックエンド処理画面である。

**業務上の目的・背景**：会員や顧客に対して重要なお知らせ、ニュースレター、キャンペーン情報などを効率的に一斉配信する必要がある。本画面は、連絡先選択画面から送信対象と本文を受け取り、実際のメール送信処理を実行する。一斉送信では差し込み機能（プレースホルダ置換）により、宛先ごとにパーソナライズされた内容を送信できる。送信後は履歴として保存され、後から確認可能となる。

**画面へのアクセス方法**：連絡先選択・一括操作画面（bs_contactSelectionActions.asp）からフォームPOSTで呼び出される。直接のURL アクセスは想定されていない処理画面である。

**主要な操作・処理内容**：
1. POSTデータから件名（hSubject）、本文（hBody）、CC宛先、連絡先IDリストを取得
2. 各連絡先IDについてループ処理を実行
3. 連絡先情報を取得し、プレースホルダ（[email]、[sPw]、カスタムフィールド）を置換
4. 重複チェック（Dictionaryオブジェクト）で同一メールアドレスへの二重送信を防止
5. メール送信を実行し、CC宛先にも送信
6. 送信履歴をtblMailテーブルに保存
7. 送信先情報をtblMailContactテーブルに記録
8. 送信完了画面（bs_massMailingFB.asp）にリダイレクト

**画面遷移**：
- 遷移元：連絡先選択・一括操作画面（bs_contactSelectionActions.asp）
- 遷移先：送信完了フィードバック画面（bs_massMailingFB.asp）

**権限による表示制御**：インクルード構造から見て、呼び出し元で権限チェックが行われる想定。直接アクセスは想定されていない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 86 | 一括メール送信 | 主機能 | 会員への一斉メール送信 |

## 画面種別

処理（バックエンド処理画面）

## URL/ルーティング

```
asp/bs_massMailing2.asp
（POSTリクエストで呼び出し、直接アクセスは想定外）
```

## 入出力項目

| 項目名 | 入出力 | データ型 | 必須 | 説明 |
|--------|--------|----------|------|------|
| hSubject | 入力（POST） | String | 必須 | メール件名 |
| hBody | 入力（POST） | String | 必須 | メール本文（HTML形式） |
| hBodyBGColor | 入力（POST） | String | 任意 | メール本文の背景色 |
| ccEmails | 入力（POST） | String | 任意 | CC宛先（カンマ区切り） |
| iContactIDM | 入力（POST） | String | 必須 | 送信対象連絡先ID（暗号化、カンマ区切り） |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| なし | - | 処理画面のため画面表示なし（リダイレクト先で結果表示） |

## イベント仕様

### 1-メール送信処理

- server.ScriptTimeoutを10000秒に設定（長時間処理対応）
- contactDictにDictionaryオブジェクトを作成（重複チェック用）
- cls_mail_messageクラスでメール送信オブジェクトを作成
- contactIDsをループし、各連絡先に対して以下を実行：
  - cls_contactで連絡先情報を取得
  - メールアドレスが空でなく、未送信の場合のみ処理
  - 件名・本文のプレースホルダを連絡先情報で置換
  - theMail.send()でメール送信
  - contactDictに送信済みメールアドレスを登録
  - CC宛先にも同内容を送信

### 2-履歴保存処理

- cls_mailオブジェクトに本文・件名・背景色を設定
- mailobj.save()で履歴保存
- tblMailContactテーブルに各送信先メールアドレスを記録

### 3-リダイレクト処理

- bs_massMailingFB.aspに送信件数をパラメータとしてリダイレクト

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 連絡先取得 | tblContact | SELECT | 連絡先情報の取得 |
| 履歴保存 | tblMail | INSERT | 送信メール履歴の保存 |
| 送信先記録 | tblMailContact | INSERT | 各送信先メールアドレスの記録 |

### テーブル別更新項目詳細

#### tblMail

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | sBody | hBody（置換後本文） | メール本文HTML |
| INSERT | sSubject | hSubject（件名） | メール件名 |
| INSERT | sBodyBGColor | hBodyBGColor | 背景色 |
| INSERT | iMailID | 自動採番 | メールID |

#### tblMailContact

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | iMailID | mailobj.iId | 関連メールID |
| INSERT | sEmail | emailKey（各送信先） | 送信先メールアドレス |

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|-----------|----------|
| 情報 | {counter} messages sent | リダイレクト先で表示 |
| エラー | ErrorReport | メール送信エラー時（ログ出力） |

## 例外処理

| 例外 | 対処 |
|------|------|
| メールアドレスが空 | スキップして次の連絡先を処理 |
| 重複メールアドレス | Dictionaryで検出しスキップ |
| メール送信エラー | ErrorReport関数でログ出力、On Error Resume Nextで処理継続 |
| 無効なCC宛先 | CheckEmailSyntax関数で検証、無効な場合はスキップ |

## 備考

- プレースホルダ置換機能：
  - `[email]`：連絡先のメールアドレス
  - `[sPw]`：連絡先のパスワード
  - `[{フィールド名}]`：連絡先のカスタムフィールド値（日付型は特別処理）
- ScriptTimeoutを10000秒に設定し、大量送信に対応
- On Error Resume Nextでエラーが発生しても処理を継続
- 送信完了後は自動的にリダイレクトされる

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

送信処理では複数のデータ構造が関わる。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | contactDict | Dictionary | 送信済みメールアドレスの重複チェック用 |
| 1-2 | contactFields | Collection | 連絡先カスタムフィールド定義 |
| 1-3 | tblMail/tblMailContact | DB | 送信履歴の保存構造 |

**読解のコツ**: Dictionaryオブジェクトは重複排除に使用。キーにメールアドレス、値は空文字。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_massMailing2.asp | `asp/bs_massMailing2.asp` | 全体の処理フロー（83行） |

**主要処理フロー**:
1. **行6-7**: ScriptTimeout設定、Dictionary作成
2. **行9-14**: メールオブジェクト初期化、POSTデータ取得
3. **行16-17**: CC宛先と連絡先IDリストをsplitで配列化
4. **行20-64**: 連絡先ループ処理（メイン処理）
5. **行32-41**: プレースホルダ置換処理
6. **行42-46**: メール送信、contactDict登録
7. **行49-56**: CC宛先への送信
8. **行65-79**: 履歴保存処理
9. **行80**: リダイレクト

#### Step 3: プレースホルダ置換を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_massMailing2.asp | `asp/bs_massMailing2.asp` 行28-41 | replace関数によるプレースホルダ置換 |

**主要処理フロー**:
- **行28-31**: 固定プレースホルダ（[email]、[sPw]）の置換
- **行32-41**: カスタムフィールドの動的置換（日付型は特別処理）

#### Step 4: メール送信クラスを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | cls_mail_message | クラス定義 | send()メソッドの実装 |
| 4-2 | cls_mail | クラス定義 | save()メソッドの実装 |
| 4-3 | cls_contact | クラス定義 | pick()メソッドの実装 |

### プログラム呼び出し階層図

```
bs_massMailing2.asp
    │
    ├─ Dictionary作成 (contactDict)
    │
    ├─ cls_mail_message インスタンス化
    │
    ├─ FOR EACH contactID
    │      │
    │      ├─ cls_contact.pick(decrypt(contactID))
    │      │      └─ tblContact SELECT
    │      │
    │      ├─ プレースホルダ置換
    │      │      ├─ [email] 置換
    │      │      ├─ [sPw] 置換
    │      │      └─ カスタムフィールド置換
    │      │
    │      ├─ theMail.send()
    │      │      └─ SMTP送信
    │      │
    │      └─ CC送信ループ
    │             └─ theMail.send()
    │
    ├─ cls_mail.save()
    │      └─ tblMail INSERT
    │
    ├─ tblMailContact INSERT（各送信先）
    │
    └─ Response.Redirect → bs_massMailingFB.asp
```

### データフロー図

```
[入力]                    [処理]                      [出力]

hSubject ────────────┐
hBody ───────────────┤
ccEmails ────────────┼───▶ 初期化処理
iContactIDM ─────────┘          │
                                ▼
                    ┌─────────────────────┐
                    │  FOR EACH contactID │
                    │         │           │
                    │         ▼           │
                    │  cls_contact.pick() │
                    │         │           │
                    │         ▼           │
                    │  プレースホルダ置換   │
                    │         │           │
                    │         ▼           │
                    │  theMail.send()     │──▶ SMTP送信
                    │         │           │
                    │         ▼           │
                    │  CC送信ループ        │
                    └─────────────────────┘
                                │
                                ▼
                    cls_mail.save() ──────▶ tblMail INSERT
                                │
                                ▼
                    tblMailContact INSERT ──▶ 送信先記録
                                │
                                ▼
                    Response.Redirect ────▶ bs_massMailingFB.asp?counter=N
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_massMailing2.asp | `asp/bs_massMailing2.asp` | ソース | 一斉メール送信処理 |
| bs_massMailingFB.asp | `asp/bs_massMailingFB.asp` | ソース | 送信完了フィードバック画面 |
| cls_mail_message | クラス定義 | ソース | メール送信クラス |
| cls_mail | クラス定義 | ソース | メール履歴管理クラス |
| cls_contact | クラス定義 | ソース | 連絡先管理クラス |
| bs_contactSelectionActions.asp | `asp/bs_contactSelectionActions.asp` | ソース | 遷移元の連絡先選択画面 |
