# 画面設計書 124-FBメール送信

## 概要

本ドキュメントは、QuickerSiteにおけるフィードバックメール送信完了画面（bs_massMailingFB.asp）の設計を定義する。

### 本画面の処理概要

FBメール送信画面（フィードバック画面）は、一斉メール送信処理完了後に表示される結果通知画面である。

**業務上の目的・背景**：一斉メール送信処理（bs_massMailing2.asp）が完了した後、管理者に対して送信結果をフィードバックする必要がある。本画面は、送信が正常に完了したことを伝え、送信件数を明示することで、管理者が処理結果を確認できるようにする。また、送信履歴画面へのリンクを提供し、詳細な履歴確認への導線を確保している。

**画面へのアクセス方法**：一斉メール送信処理（bs_massMailing2.asp）からリダイレクトされて表示される。直接アクセスも可能だが、通常は送信処理完了後のリダイレクトで開かれる。

**主要な操作・処理内容**：
1. GETパラメータから送信件数（counter）を取得
2. 送信件数と「messages sent」メッセージを表示
3. 送信履歴画面（bs_mailHistory.asp）へのリンクを提供

**画面遷移**：
- 遷移元：一斉メール送信処理（bs_massMailing2.asp）からリダイレクト
- 遷移先：送信履歴画面（bs_mailHistory.asp）へのリンク

**権限による表示制御**：secondAdmin.bIntranetMail権限を持つ管理者のみがアクセス可能。権限がない場合はアクセスが拒否される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 86 | 一括メール送信 | 主機能 | フィードバックへのメール送信結果表示 |

## 画面種別

結果表示

## URL/ルーティング

```
asp/bs_massMailingFB.asp?counter={送信件数}
```

## 入出力項目

| 項目名 | 入出力 | データ型 | 必須 | 説明 |
|--------|--------|----------|------|------|
| counter | 入力（GETパラメータ） | Integer | 任意 | 送信されたメール件数 |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| 送信件数 | Integer | 送信されたメールの総数 |
| メッセージ | String | 「messages sent」の多言語対応ラベル |
| 履歴リンク | HTML | 送信履歴画面へのリンク |

## イベント仕様

### 1-画面表示

- バックサイトヘッダーを表示（イントラネット管理メニュー内）
- GETパラメータのcounterを取得
- 中央揃えで「{counter} messages sent」を表示
- 送信履歴画面へのリンクを表示

### 2-履歴リンククリック

- bs_mailHistory.aspに遷移

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| なし | なし | なし | 本画面ではデータベース操作なし |

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|-----------|----------|
| 情報 | {counter} messages sent | 常に表示 |
| リンク | -> sent messages <- | 常に表示 |

## 例外処理

| 例外 | 対処 |
|------|------|
| 権限不足 | secondAdmin.bIntranetMail権限がない場合、アクセス拒否 |
| counterパラメータなし | 空または0が表示される |

## 備考

- 本画面はバックサイト管理画面の一部として表示される
- ヘッダーにはイントラネット管理メニュー（btn_Intranet）と送信メッセージタブ（btn_sentmessages）が表示
- 多言語対応：l("messagessent")、l("sentmessages")関数で言語切り替え
- シンプルな結果表示画面で、主な役割は送信完了の通知と履歴画面への導線提供

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

本画面はデータベースアクセスを行わないシンプルな結果表示画面である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | GETパラメータ | URL | counter パラメータの渡し方 |

**読解のコツ**: bs_massMailing2.aspからのリダイレクト時にcounterパラメータがURLに付与される。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_massMailingFB.asp | `asp/bs_massMailingFB.asp` | 画面の全体構造（5行の簡潔なコード） |

**主要処理フロー**:
1. **行1**: begin.aspをインクルード（共通初期化）
2. **行4**: bs_security.aspでセキュリティチェック、bs_process.aspインクルード
3. **行4**: header.asp、bs_initBack.asp、bs_header.aspでヘッダー構築
4. **行4**: getBOHeader(btn_Intranet)でイントラネットメニュー表示
5. **行4**: getBOHeaderIntranet(btn_sentmessages)でサブメニュー表示
6. **行4**: request.querystring("counter")で送信件数取得・表示
7. **行4**: l("messagessent")で多言語メッセージ表示
8. **行4**: bs_mailHistory.aspへのリンク表示

#### Step 3: ヘッダー構築を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_header.asp | `asp/bs_header.asp` | getBOHeader、getBOHeaderIntranet関数の定義 |
| 3-2 | includes/header.asp | `asp/includes/header.asp` | HTMLヘッダー出力 |

### プログラム呼び出し階層図

```
bs_massMailingFB.asp
    │
    ├─ begin.asp (共通初期化)
    │
    ├─ bs_security.asp (セキュリティチェック)
    │      └─ logon.hasaccess(secondAdmin.bIntranetMail)
    │
    ├─ bs_process.asp (リクエスト処理)
    │
    ├─ includes/header.asp (HTMLヘッダー)
    │
    ├─ bs_initBack.asp (バックサイト初期化)
    │
    ├─ bs_header.asp (メニューヘッダー)
    │      ├─ getBOHeader(btn_Intranet)
    │      └─ getBOHeaderIntranet(btn_sentmessages)
    │
    ├─ 結果表示
    │      ├─ request.querystring("counter")
    │      └─ l("messagessent")
    │
    ├─ bs_endBack.asp (バックサイト終了)
    │
    └─ includes/footer.asp (HTMLフッター)
```

### データフロー図

```
[入力]               [処理]                    [出力]

counter ───▶ request.querystring("counter")
     │                    │
     │                    ▼
     │              文字列結合
     │     "{counter} {l("messagessent")}"
     │                    │
     └────────────────────┘
                          │
                          ▼
              [HTML Response.Write]
                          │
                          ▼
              結果メッセージ表示
              履歴リンク表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_massMailingFB.asp | `asp/bs_massMailingFB.asp` | ソース | 送信完了フィードバック画面 |
| bs_massMailing2.asp | `asp/bs_massMailing2.asp` | ソース | 遷移元の一斉送信処理 |
| bs_mailHistory.asp | `asp/bs_mailHistory.asp` | ソース | 遷移先の送信履歴画面 |
| bs_security.asp | `asp/bs_security.asp` | ソース | セキュリティチェック |
| bs_header.asp | `asp/bs_header.asp` | ソース | メニューヘッダー生成 |
| begin.asp | `asp/begin.asp` | ソース | 共通初期化処理 |
| includes/header.asp | `asp/includes/header.asp` | ソース | HTMLヘッダー |
| includes/footer.asp | `asp/includes/footer.asp` | ソース | HTMLフッター |
