# 画面設計書 125-アセットマネージャー

## 概要

本ドキュメントは、QuickerSiteにおけるアセットマネージャー画面（bs_assetmanager.asp）の設計を定義する。

### 本画面の処理概要

アセットマネージャー画面は、サイト内のファイルアセット（画像、ドキュメントなど）を管理するためのメイン画面である。

**業務上の目的・背景**：CMSでコンテンツを作成・編集する際、画像やドキュメントなどのファイルアセットを効率的に管理する必要がある。本画面は、ファイルの一元管理、フォルダ構造の整理、ファイルのアップロード・削除・選択などの機能を提供する。コンテンツ編集時の画像挿入やファイル添付の基盤となる重要な機能である。

**画面へのアクセス方法**：バックサイトホーム > フォルダ管理メニュー（btn_Folder）から直接アクセス。または、WYSIWYGエディタ等からファイル選択時にポップアップとして呼び出される。

**主要な操作・処理内容**：
1. アセットマネージャーインターフェース（assetmanagerIF.asp）をiframeで埋め込み表示
2. iframeは910x450pxのサイズで中央に配置
3. 実際のファイル操作はiframe内のassetmanagerIF.aspで実行

**画面遷移**：
- 遷移元：バックサイトホーム、各種編集画面のファイル選択ボタン
- 遷移先：iframe内で各種操作画面（フォルダ作成、削除等）

**権限による表示制御**：secondAdmin.bFiles権限を持つ管理者のみがアクセス可能。権限がない場合はアクセスが拒否される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 37 | アセットマネージャー | 主機能 | 画像・ドキュメント等のファイル管理 |

## 画面種別

管理（コンテナ）

## URL/ルーティング

```
asp/bs_assetmanager.asp
```

## 入出力項目

| 項目名 | 入出力 | データ型 | 必須 | 説明 |
|--------|--------|----------|------|------|
| なし | - | - | - | 本画面はiframeコンテナのため入出力なし |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| iframe | HTML | assetmanagerIF.aspを埋め込み表示（910x450px） |

## イベント仕様

### 1-画面表示

- バックサイトヘッダーを表示（フォルダ管理メニュー）
- session("showInsertButton")をfalseに設定（挿入ボタン非表示）
- iframeでassetmanagerIF.aspを埋め込み表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| なし | なし | なし | 本画面はコンテナのためDB操作なし |

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|-----------|----------|
| - | - | 本画面ではメッセージ表示なし |

## 例外処理

| 例外 | 対処 |
|------|------|
| 権限不足 | secondAdmin.bFiles権限がない場合、アクセス拒否 |

## 備考

- 本画面は主にiframeコンテナとして機能
- 実際のファイル操作機能はassetmanagerIF.asp（No.126）で実装
- session("showInsertButton")=falseにより、ファイル選択モードではなく管理モードとして動作
- iframeのframeborderは0で境界線なし
- C_DIRECTORY_QUICKERSITEでQuickerSiteのディレクトリパスを取得

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

本画面はiframeコンテナのため、直接的なデータ構造は持たない。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | session変数 | セッション | showInsertButtonの役割 |

**読解のコツ**: showInsertButtonセッション変数は、アセットマネージャーがファイル選択モード（true）か管理モード（false）かを制御する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_assetmanager.asp | `asp/bs_assetmanager.asp` | 画面の全体構造（5行の簡潔なコード） |

**主要処理フロー**:
1. **行1**: begin.aspをインクルード（共通初期化）
2. **行4**: bs_security.aspでセキュリティチェック（bFiles権限）
3. **行4**: header.asp、bs_initBack.asp、bs_header.aspでヘッダー構築
4. **行4**: getBOHeader(btn_Folder)でフォルダ管理メニュー表示
5. **行4**: session("showInsertButton")=falseを設定
6. **行4**: iframeでassetmanagerIF.aspを埋め込み

#### Step 3: iframe内コンテンツを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | assetmanagerIF.asp | `asp/assetmanager/assetmanagerIF.asp` | iframe内で表示される実際のファイル管理UI |

### プログラム呼び出し階層図

```
bs_assetmanager.asp
    │
    ├─ begin.asp (共通初期化)
    │
    ├─ bs_security.asp (セキュリティチェック)
    │      └─ logon.hasaccess(secondAdmin.bFiles)
    │
    ├─ includes/header.asp (HTMLヘッダー)
    │
    ├─ bs_initBack.asp (バックサイト初期化)
    │
    ├─ bs_header.asp (メニューヘッダー)
    │      └─ getBOHeader(btn_Folder)
    │
    ├─ session("showInsertButton") = false
    │
    ├─ <iframe> ───────────────────────────┐
    │      └─ assetmanagerIF.asp           │
    │             ├─ フォルダ選択           │
    │             ├─ ファイル一覧           │
    │             ├─ ファイルアップロード    │
    │             ├─ ファイル削除           │
    │             ├─ フォルダ作成           │
    │             └─ フォルダ削除           │
    │                                      │
    ├─ bs_endBack.asp (バックサイト終了)    │
    │                                      │
    └─ includes/footer.asp (HTMLフッター)   │
         └──────────────────────────────────┘
```

### データフロー図

```
[入力]               [処理]                    [出力]

アクセス要求 ───▶ 権限チェック
                     │
                     ▼
              session設定
        (showInsertButton=false)
                     │
                     ▼
              ヘッダー生成
                     │
                     ▼
              iframe生成
                     │
                     ▼
              [HTML Response]
                     │
                     ▼
         ┌──────────────────────┐
         │  assetmanagerIF.asp  │
         │  (iframe内で動作)    │
         └──────────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_assetmanager.asp | `asp/bs_assetmanager.asp` | ソース | アセットマネージャーコンテナ画面 |
| assetmanagerIF.asp | `asp/assetmanager/assetmanagerIF.asp` | ソース | iframe内のファイル管理UI |
| bs_security.asp | `asp/bs_security.asp` | ソース | セキュリティチェック |
| bs_header.asp | `asp/bs_header.asp` | ソース | メニューヘッダー生成 |
| begin.asp | `asp/begin.asp` | ソース | 共通初期化処理 |
| foldernew.asp | `asp/assetmanager/foldernew.asp` | ソース | フォルダ作成ダイアログ |
| folderdel.asp | `asp/assetmanager/folderdel.asp` | ソース | フォルダ削除ダイアログ |
