# 画面設計書 126-アセットマネージャーIF

## 概要

本ドキュメントは、QuickerSiteにおけるアセットマネージャーインターフェース画面（assetmanagerIF.asp）の設計を定義する。

### 本画面の処理概要

アセットマネージャーIF画面は、ファイルアセット管理の実際の操作インターフェースを提供する画面である。フォルダ選択、ファイル一覧表示、ファイルアップロード、ファイル削除、プレビュー表示などの機能を実装している。

**業務上の目的・背景**：CMSでのコンテンツ編集において、画像やドキュメントファイルを効率的に管理・選択する必要がある。本画面は、直感的なファイルブラウザインターフェースを提供し、フォルダ階層のナビゲーション、ファイルのプレビュー、アップロード、削除といった基本的なファイル操作をすべて一画面で完結できるようにする。WYSIWYGエディタとの連携により、コンテンツ作成時のファイル挿入をスムーズに行える。

**画面へのアクセス方法**：通常はbs_assetmanager.aspのiframe内に表示されるか、WYSIWYGエディタ（CKEditor）からモーダルダイアログとして呼び出される。直接アクセスも可能。

**主要な操作・処理内容**：
1. フォルダ選択（ドロップダウン）でファイル表示対象を切り替え
2. ファイル一覧をアイコン付きで表示（ファイルタイプ別）
3. ファイルをクリックでプレビュー表示
4. ファイルタイプフィルタ（全て/画像/Flash/メディア）で絞り込み
5. ファイルアップロード機能
6. ファイル削除機能
7. フォルダ作成/削除機能（ダイアログ呼び出し）
8. ファイル選択結果を親ウィンドウまたはCKEditorに返す

**画面遷移**：
- 遷移元：bs_assetmanager.asp（iframe）、CKEditor（ポップアップ）
- 遷移先：foldernew.asp（フォルダ作成ダイアログ）、folderdel.asp（フォルダ削除ダイアログ）

**権限による表示制御**：security.aspによるセッション認証チェック。認証済みユーザー（管理者、セカンド管理者、ユーザー、イントラネットユーザー）のみアクセス可能。読み取り専用権限設定も可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 37 | アセットマネージャー | 主機能 | アセットマネージャーのインターフェース表示 |

## 画面種別

管理（ファイルブラウザ）

## URL/ルーティング

```
asp/assetmanager/assetmanagerIF.asp
asp/assetmanager/assetmanagerIF.asp?showInsertButton=true  (挿入ボタン表示)
asp/assetmanager/assetmanagerIF.asp?showSelectButton=true  (選択ボタン表示)
asp/assetmanager/assetmanagerIF.asp?ffilter=image          (画像フィルタ)
asp/assetmanager/assetmanagerIF.asp?CKEditorFuncNum=N      (CKEditor連携)
```

## 入出力項目

| 項目名 | 入出力 | データ型 | 必須 | 説明 |
|--------|--------|----------|------|------|
| showInsertButton | 入力（GET/Session） | Boolean | 任意 | 挿入ボタン表示フラグ |
| showSelectButton | 入力（GET） | Boolean | 任意 | 選択ボタン表示フラグ |
| ffilter | 入力（GET/POST） | String | 任意 | ファイルタイプフィルタ |
| CKEditorFuncNum | 入力（GET） | Integer | 任意 | CKEditorコールバック関数番号 |
| inpCurrFolder | 入力（POST） | String | 任意 | 現在のフォルダパス |
| inpFileToDelete | 入力（POST） | String | 任意 | 削除対象ファイルパス |
| File1 | 入力（POST/FILE） | File | 任意 | アップロードファイル |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| フォルダ選択 | select | 利用可能なフォルダの階層表示 |
| ファイル一覧 | table | フォルダ内のファイル一覧（アイコン、名前、サイズ、削除リンク） |
| プレビューエリア | div | 選択ファイルのプレビュー表示 |
| ファイルパス入力 | input | 選択ファイルの仮想パス |
| フィルタ選択 | select | ファイルタイプフィルタ |
| アップロードフォーム | form | ファイルアップロード用 |

## イベント仕様

### 1-フォルダ選択変更（changeFolder）

- ドロップダウンで別フォルダを選択
- Form1をsubmitしてページリロード
- 選択フォルダのファイル一覧を表示

### 2-ファイル選択（selectFile）

- ファイル名クリックでJavaScript関数呼び出し
- ファイルタイプに応じてプレビュー表示（画像、SWF、動画、音声）
- ファイルパスをinpSourceに設定
- HTM/CSS/TXT/JSの場合はbs_editcode.aspで編集画面を開く

### 3-ファイル削除（deleteFile）

- 確認ダイアログ表示
- inpFileToDeleteにパスを設定してsubmit
- FileSystemObjectでファイル削除

### 4-ファイルアップロード（upload）

- ファイル選択確認
- 同名ファイル存在時は上書き確認
- Form2をmultipart/form-dataでsubmit
- Uploadクラスでファイル保存

### 5-フォルダ作成（newFolder）

- foldernew.aspをモーダルダイアログで表示

### 6-フォルダ削除（deleteFolder）

- ベースフォルダ削除防止チェック
- folderdel.aspをモーダルダイアログで表示

### 7-フィルタ適用（applyFilter）

- フィルタ値を取得してページリロード
- image/flash/media/allで絞り込み

### 8-挿入/選択（doOk、setU）

- 選択ファイルパスを親ウィンドウに返す
- CKEditor連携時はCKEDITOR.tools.callFunctionを呼び出し

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| なし | なし | なし | 本画面はファイルシステム操作のみ |

### ファイルシステム操作

| 操作 | 対象 | 処理内容 |
|------|------|----------|
| フォルダ一覧取得 | arrBaseFolder配下 | FileSystemObject.GetFolder |
| ファイル一覧取得 | 選択フォルダ | oFolder.files |
| ファイルアップロード | 選択フォルダ | Uploadクラス.SaveFile |
| ファイル削除 | 指定ファイル | oFile.Delete |

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|-----------|----------|
| 確認 | File already exists. Do you want to replace it? | アップロード時に同名ファイル存在 |
| 確認 | Delete this file ? | ファイル削除時 |
| 警告 | Cannot delete Asset Base Folder. | ベースフォルダ削除試行時 |
| エラー | The File Type is not allowed. | 許可されていないファイルタイプ |
| エラー | The posted data exceeds the maximum size allowed. | ファイルサイズ超過 |
| 状態 | Uploading... | アップロード中 |
| 状態 | Empty... | フォルダ内にファイルなし |

## 例外処理

| 例外 | 対処 |
|------|------|
| 認証なし | security.aspでResponse.End |
| ベースフォルダ削除 | JavaScriptで削除処理中止 |
| 許可外ファイルタイプ | アップロード処理スキップ |
| ファイルサイズ超過 | エラーメッセージ表示 |
| フォルダ作成エラー | エラーメッセージ表示 |

## 備考

- 許可ファイルタイプ：jpg, jpeg, gif, bmp, png, psd, eps, ico, tif, doc, pdf, xls, ppt, mp3, wma, mp4, avi, css, rar, zip, swf, js等
- 最大ファイルサイズ：150MB（MaxFileSize = 150000000）
- 多言語対応：language/{lang}/asset.js からテキスト取得
- CKEditor連携：CKEditorFuncNumパラメータでコールバック指定
- プレビュー対応形式：JPG/JPEG/PNG/GIF（画像）、SWF（Flash）、AVI/WMV/MPG（動画）、WMA/WAV/MID（音声）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

アセットマネージャーは複数の設定とファイルシステム操作で構成される。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | settings.asp | `asp/assetmanager/settings.asp` | arrBaseFolder配列、bReturnAbsolute設定 |
| 1-2 | security.asp | `asp/assetmanager/security.asp` | セッション認証チェック |

**読解のコツ**: arrBaseFolder配列は最大4つのベースフォルダを定義可能。arrBaseName配列で表示名を設定。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | assetmanagerIF.asp | `asp/assetmanager/assetmanagerIF.asp` | 全体構造（671行） |

**主要処理フロー**:
1. **行1-2**: security.asp、settings.aspインクルード
2. **行5-17**: showInsertButton、showSelectButton設定
3. **行19-54**: 権限設定（bReadOnly、bWriteFolderAdmin）
4. **行26-31**: FileSystemObjectでベースフォルダ取得
5. **行56-99**: recursive関数でフォルダ階層構築
6. **行110-264**: writeFileSelections関数でファイル一覧生成
7. **行277-517**: JavaScript関数群（クライアント側処理）

#### Step 3: アップロード処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | i_upload_object_FSO.asp | `asp/assetmanager/i_upload_object_FSO.asp` | Uploadクラス、ファイル保存処理 |

**主要処理フロー**:
- **行13-233**: Uploadクラス定義（Recieve、SaveFile）
- **行243-308**: メインのアップロード処理ロジック

#### Step 4: JavaScript処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | assetmanagerIF.asp | JavaScript部分 | selectFile、deleteFile、upload関数 |
| 4-2 | language/english/asset.js | 多言語リソース | getTxt関数用テキスト定義 |

### プログラム呼び出し階層図

```
assetmanagerIF.asp
    │
    ├─ security.asp (認証チェック)
    │      └─ Session変数確認
    │
    ├─ settings.asp (設定読み込み)
    │      ├─ arrBaseFolder設定
    │      └─ arrBaseName設定
    │
    ├─ i_upload_object_FSO.asp (アップロード処理)
    │      ├─ Uploadクラス定義
    │      └─ ファイル保存/削除処理
    │
    ├─ VBScript関数
    │      ├─ writeFolderSelections() → recursive()
    │      ├─ writeFileSelections()
    │      └─ getExt()
    │
    └─ JavaScript関数
           ├─ changeFolder()
           ├─ selectFile(index)
           ├─ deleteFile(index)
           ├─ upload()
           ├─ newFolder() → foldernew.asp
           ├─ deleteFolder() → folderdel.asp
           ├─ applyFilter()
           ├─ doOk()
           └─ setU(surl)
```

### データフロー図

```
[入力]                    [処理]                      [出力]

フォルダ選択 ───────────▶ changeFolder()
                              │
                              ▼
                    inpCurrFolder設定
                              │
                              ▼
                    Form1.submit()
                              │
                              ▼
                    writeFileSelections()
                              │
                              ▼
                    ファイル一覧HTML
                              │
                              ▼
                    [ブラウザ表示]

ファイルクリック ─────────▶ selectFile(index)
                              │
                              ▼
                    inpFile{index}取得
                              │
                              ├───▶ プレビュー生成
                              │
                              └───▶ inpSource設定

ファイルアップロード ─────▶ upload()
                              │
                              ▼
                    Form2.submit()
                              │
                              ▼
                    Uploadクラス.Recieve()
                              │
                              ▼
                    Uploadクラス.SaveFile()
                              │
                              ▼
                    ファイルシステム書き込み
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| assetmanagerIF.asp | `asp/assetmanager/assetmanagerIF.asp` | ソース | メインインターフェース |
| security.asp | `asp/assetmanager/security.asp` | ソース | セッション認証 |
| settings.asp | `asp/assetmanager/settings.asp` | 設定 | ベースフォルダ設定 |
| i_upload_object_FSO.asp | `asp/assetmanager/i_upload_object_FSO.asp` | ソース | アップロードクラス |
| foldernew.asp | `asp/assetmanager/foldernew.asp` | ソース | フォルダ作成ダイアログ |
| folderdel.asp | `asp/assetmanager/folderdel.asp` | ソース | フォルダ削除ダイアログ |
| folderdel_.asp | `asp/assetmanager/folderdel_.asp` | ソース | フォルダ削除実行 |
| style.css | `asp/assetmanager/style.css` | スタイル | UI スタイルシート |
| asset.js | `asp/assetmanager/language/english/asset.js` | 多言語 | 英語テキスト |
