# 画面設計書 127-フォルダ作成

## 概要

本ドキュメントは、QuickerSiteにおけるフォルダ作成ダイアログ画面（foldernew.asp）の設計を定義する。

### 本画面の処理概要

フォルダ作成画面は、アセットマネージャー内で新規フォルダを作成するためのモーダルダイアログ画面である。

**業務上の目的・背景**：ファイルアセットを効率的に整理・管理するためには、適切なフォルダ構造が必要である。本画面は、アセットマネージャー内で動的にフォルダを作成する機能を提供し、ユーザーがコンテンツを論理的に分類・整理できるようにする。プロジェクト別、日付別、カテゴリ別など、用途に応じたフォルダ構成を構築できる。

**画面へのアクセス方法**：アセットマネージャーIF画面（assetmanagerIF.asp）の「New Folder」リンクをクリックすることで、モーダルダイアログとして表示される。

**主要な操作・処理内容**：
1. 新規フォルダ名を入力
2. 「create」ボタンで作成実行
3. FileSystemObjectでフォルダ作成
4. 作成結果メッセージを表示
5. 「close & refresh」ボタンで親ウィンドウを更新して閉じる

**画面遷移**：
- 遷移元：アセットマネージャーIF画面（assetmanagerIF.asp）からモーダルダイアログ
- 遷移先：なし（モーダルダイアログを閉じて親画面に戻る）

**権限による表示制御**：親画面（assetmanagerIF.asp）のsecurity.aspによる認証が前提。直接アクセスも可能だが、親ウィンドウとの連携がないと正常に動作しない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 37 | アセットマネージャー | 主機能 | 新規フォルダの作成 |

## 画面種別

ダイアログ（モーダル）

## URL/ルーティング

```
asp/assetmanager/foldernew.asp
（通常はモーダルダイアログとして呼び出し）
```

## 入出力項目

| 項目名 | 入出力 | データ型 | 必須 | 説明 |
|--------|--------|----------|------|------|
| inpCurrFolder | 入力（hidden/JS） | String | 必須 | 親フォルダのパス（親ウィンドウから取得） |
| inpNewFolderName | 入力（text） | String | 必須 | 作成するフォルダ名 |
| sMsg | 出力 | String | - | 処理結果メッセージ |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| フォルダ名入力 | input text | 新規フォルダ名入力欄 |
| 結果メッセージ | text | フォルダ作成結果（成功/エラー） |
| close & refreshボタン | button | 親ウィンドウ更新して閉じる |
| createボタン | button | フォルダ作成実行 |

## イベント仕様

### 1-画面表示（onload）

- loadTxt()関数で多言語テキストを設定
- 入力フォーカスを設定

### 2-作成ボタン押下（doSubmit）

- doPreSubmit()でバリデーション
  - 親ウィンドウからinpCurrFolder（現在フォルダ）を取得
  - フォルダ名が空の場合はアラート表示
- Form1をsubmitしてPOST送信
- サーバー側でフォルダ作成処理

### 3-サーバー側処理

- inpCurrFolderとinpNewFolderNameを結合してパス生成
- FileSystemObjectでフォルダ存在チェック
- 存在しない場合はCreateFolderで作成
- 結果メッセージを設定（sMsg）

### 4-閉じて更新ボタン押下

- 親ウィンドウのchangeFolder()関数を呼び出し
- self.close()でダイアログを閉じる

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| なし | なし | なし | 本画面はファイルシステム操作のみ |

### ファイルシステム操作

| 操作 | 対象 | 処理内容 |
|------|------|----------|
| フォルダ存在チェック | 指定パス | FileSystemObject.FolderExists |
| フォルダ作成 | 指定パス | FileSystemObject.CreateFolder |

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|-----------|----------|
| エラー | Invalid input. | フォルダ名が空の場合（JS/サーバー） |
| エラー | Folder already exists. | 同名フォルダが既に存在 |
| 成功 | Folder created. | フォルダ作成成功 |

## 例外処理

| 例外 | 対処 |
|------|------|
| フォルダ名空 | JavaScriptでアラート表示、送信キャンセル |
| フォルダ既存 | エラーメッセージ表示 |
| 作成エラー | On Error Resume Nextで捕捉し「Invalid input.」表示 |

## 備考

- モーダルダイアログサイズ：250x192px（IE）または250x150px（その他ブラウザ）
- ブラウザ判定でIE用showModalDialogとその他用window.openを使い分け
- 多言語対応：language/{lang}/foldernew.jsからテキスト取得
- 親ウィンドウとの連携：dialogArguments（IE）またはwindow.opener（その他）を使用
- フォルダパスは親フォルダパス + "\" + 新規フォルダ名で構成

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

フォルダ作成処理はシンプルなファイルシステム操作である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Request変数 | POSTデータ | inpCurrFolder、inpNewFolderNameの受け渡し |

**読解のコツ**: inpCurrFolderは親ウィンドウのJavaScriptから設定される。doPreSubmit()関数を確認。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | foldernew.asp | `asp/assetmanager/foldernew.asp` | 全体構造（81行） |

**主要処理フロー**:
1. **行1**: security.aspインクルード（認証）
2. **行3-20**: サーバー側フォルダ作成処理
3. **行4-5**: POSTデータ取得、パス構築
4. **行7-8**: FileSystemObject作成、存在チェック
5. **行9**: 既存の場合はエラーメッセージ
6. **行10-17**: 作成処理（On Error Resume Next）
7. **行36-54**: JavaScript関数（doPreSubmit、doSubmit）
8. **行63-68**: フォーム定義
9. **行74-75**: ボタン（close & refresh、create）

#### Step 3: 親ウィンドウとの連携を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | assetmanagerIF.asp | `asp/assetmanager/assetmanagerIF.asp` 行377-383 | newFolder関数、モーダルダイアログ呼び出し |
| 3-2 | assetmanagerIF.asp | `asp/assetmanager/assetmanagerIF.asp` 行339-348 | changeFolder関数（更新時に呼ばれる） |

### プログラム呼び出し階層図

```
assetmanagerIF.asp
    │
    └─ newFolder() [JavaScript]
           │
           ├─ IE: window.showModalDialog("foldernew.asp")
           │
           └─ Other: window.open("foldernew.asp")
                  │
                  ▼
           foldernew.asp
                  │
                  ├─ security.asp (認証)
                  │
                  ├─ [画面表示]
                  │      ├─ loadTxt() (多言語)
                  │      └─ フォーム表示
                  │
                  ├─ doPreSubmit() [JavaScript]
                  │      ├─ 親ウィンドウからcurrFolder取得
                  │      │      ├─ IE: dialogArguments.selCurrFolder.value
                  │      │      └─ Other: window.opener.document...
                  │      │
                  │      └─ バリデーション
                  │
                  ├─ Form1.submit()
                  │      │
                  │      ▼
                  │  [サーバー処理]
                  │      ├─ パス構築
                  │      ├─ FolderExists チェック
                  │      └─ CreateFolder 実行
                  │
                  └─ close & refresh
                         ├─ 親ウィンドウ.changeFolder()
                         └─ self.close()
```

### データフロー図

```
[入力]                    [処理]                      [出力]

親ウィンドウ ────────────▶ doPreSubmit()
(selCurrFolder)                 │
       │                        ▼
       │              inpCurrFolder設定
       │                        │
       ▼                        ▼
inpNewFolderName ──────▶ Form1.submit()
       │                        │
       │                        ▼
       │              [サーバー処理]
       │                        │
       │            sFolder = currFolder + "\" + newName
       │                        │
       │                        ▼
       │              FolderExists(sFolder)?
       │                   │         │
       │                  YES        NO
       │                   │         │
       │                   ▼         ▼
       │              sMsg=Error  CreateFolder
       │                             │
       │                             ▼
       │                        sMsg=Success
       │                             │
       └─────────────────────────────┘
                                     │
                                     ▼
                              [結果表示]
                                     │
                                     ▼
                      close & refresh → 親ウィンドウ更新
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| foldernew.asp | `asp/assetmanager/foldernew.asp` | ソース | フォルダ作成ダイアログ |
| security.asp | `asp/assetmanager/security.asp` | ソース | セッション認証 |
| assetmanagerIF.asp | `asp/assetmanager/assetmanagerIF.asp` | ソース | 呼び出し元 |
| foldernew.js | `asp/assetmanager/language/english/foldernew.js` | 多言語 | 英語テキスト |
| style.css | `asp/assetmanager/style.css` | スタイル | UIスタイルシート |
