# 画面設計書 128-フォルダ削除

## 概要

本ドキュメントは、QuickerSiteにおけるフォルダ削除ダイアログ画面（folderdel.asp、folderdel_.asp）の設計を定義する。

### 本画面の処理概要

フォルダ削除画面は、アセットマネージャー内でフォルダを削除するためのモーダルダイアログ画面である。確認画面と実行画面の2段階構成となっている。

**業務上の目的・背景**：不要になったフォルダを整理・削除することは、ファイルアセット管理において重要な機能である。本画面は、誤削除を防ぐための確認ステップを設けながら、フォルダ削除機能を提供する。削除対象のフォルダとその中身がすべて削除されるため、確認ダイアログによる安全性確保が重要である。

**画面へのアクセス方法**：アセットマネージャーIF画面（assetmanagerIF.asp）の「Del Folder」リンクをクリックすることで、モーダルダイアログとして表示される。ただし、ベースフォルダ選択時はJavaScriptで削除を阻止。

**主要な操作・処理内容**：
1. 削除確認メッセージを表示（folderdel.asp）
2. 「delete」ボタンで削除実行画面に遷移（folderdel_.asp）
3. FileSystemObjectでフォルダ削除
4. 削除結果メッセージを表示
5. 「close & refresh」ボタンで親ウィンドウを更新して閉じる

**画面遷移**：
- 遷移元：アセットマネージャーIF画面（assetmanagerIF.asp）からモーダルダイアログ
- 内部遷移：folderdel.asp → folderdel_.asp（削除実行）
- 遷移先：なし（モーダルダイアログを閉じて親画面に戻る）

**権限による表示制御**：親画面（assetmanagerIF.asp）でベースフォルダ削除が防止される。また、bWriteFolderAdmin権限により削除リンク自体が非表示になる場合がある。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 37 | アセットマネージャー | 主機能 | フォルダの削除処理 |

## 画面種別

ダイアログ（モーダル、2画面構成）

## URL/ルーティング

```
asp/assetmanager/folderdel.asp   （確認画面）
asp/assetmanager/folderdel_.asp  （実行画面）
（通常はモーダルダイアログとして呼び出し）
```

## 入出力項目

### folderdel.asp（確認画面）

| 項目名 | 入出力 | データ型 | 必須 | 説明 |
|--------|--------|----------|------|------|
| inpCurrFolder | 入力（hidden/JS） | String | 必須 | 削除対象フォルダのパス（親ウィンドウから取得） |

### folderdel_.asp（実行画面）

| 項目名 | 入出力 | データ型 | 必須 | 説明 |
|--------|--------|----------|------|------|
| inpCurrFolder | 入力（POST） | String | 必須 | 削除対象フォルダのパス |
| inpDest | 出力（hidden） | String | - | 削除後の遷移先フォルダ（親フォルダ） |
| sMsq | 出力 | String | - | 処理結果メッセージ |

## 表示項目

### folderdel.asp（確認画面）

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| 確認メッセージ | text | 「Are you sure you want to delete this folder?」 |
| closeボタン | button | ダイアログを閉じる |
| deleteボタン | button | 削除実行（folderdel_.aspに遷移） |

### folderdel_.asp（実行画面）

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| 結果メッセージ | text | 削除結果（成功/エラー） |
| close & refreshボタン | button | 親ウィンドウ更新して閉じる |

## イベント仕様

### 1-確認画面表示（folderdel.asp）

- loadTxt()関数で多言語テキストを設定
- 削除確認メッセージを表示

### 2-削除ボタン押下（del関数）

- 親ウィンドウからinpCurrFolder（現在フォルダ）を取得
- Form1をfolderdel_.aspにsubmit

### 3-サーバー側削除処理（folderdel_.asp）

- inpCurrFolderを取得
- FileSystemObjectでフォルダ存在チェック
- 存在する場合はDeleteFolderで削除
- 親フォルダパスをinpDestに設定
- 結果メッセージを設定（sMsq）

### 4-閉じて更新ボタン押下

- 親ウィンドウのrefreshAfterDelete(inpDest)関数を呼び出し
- self.close()でダイアログを閉じる

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| なし | なし | なし | 本画面はファイルシステム操作のみ |

### ファイルシステム操作

| 操作 | 対象 | 処理内容 |
|------|------|----------|
| フォルダ存在チェック | 指定パス | FileSystemObject.FolderExists |
| 親フォルダ取得 | 指定パス | FileSystemObject.GetParentFolderName |
| フォルダ削除 | 指定パス | FileSystemObject.DeleteFolder |

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|-----------|----------|
| 確認 | Are you sure you want to delete this folder? | 確認画面で常に表示 |
| 警告 | Cannot delete Asset Base Folder. | ベースフォルダ削除試行時（親画面で阻止） |
| 成功 | Folder deleted. | フォルダ削除成功 |
| エラー | Folder does not exist. | 指定フォルダが存在しない |

## 例外処理

| 例外 | 対処 |
|------|------|
| ベースフォルダ削除 | 親画面のJavaScriptで阻止（deleteFolder関数） |
| フォルダ非存在 | エラーメッセージ表示 |
| 削除権限エラー | FileSystemObjectのエラーとして処理 |

## 備考

- モーダルダイアログサイズ：250x192px（IE）または250x150px（その他ブラウザ）
- 2画面構成：確認（folderdel.asp）→ 実行（folderdel_.asp）
- ベースフォルダ削除防止は親画面のJavaScriptで実装
- 削除後は親フォルダに移動（refreshAfterDelete）
- 多言語対応：language/{lang}/folderdel.js、folderdel_.jsからテキスト取得
- フォルダ内のファイルも含めて再帰的に削除される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

フォルダ削除処理はシンプルなファイルシステム操作である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Request変数 | POSTデータ | inpCurrFolderの受け渡し |
| 1-2 | inpDest | hidden | 削除後の遷移先（親フォルダ） |

**読解のコツ**: 削除後に親フォルダへ移動するため、GetParentFolderNameで親パスを取得している。

#### Step 2: 確認画面を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | folderdel.asp | `asp/assetmanager/folderdel.asp` | 確認画面（49行） |

**主要処理フロー**:
1. **行1**: security.aspインクルード（認証）
2. **行16-24**: del()関数（親ウィンドウからcurrFolder取得、submit）
3. **行33-37**: フォーム定義（hidden:inpCurrFolder、確認メッセージ）
4. **行43**: ボタン（close、delete）

#### Step 3: 実行画面を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | folderdel_.asp | `asp/assetmanager/folderdel_.asp` | 実行画面（62行） |

**主要処理フロー**:
1. **行1**: security.aspインクルード（認証）
2. **行3-16**: サーバー側削除処理
3. **行4**: inpCurrFolder取得
4. **行6-7**: FileSystemObject作成、存在チェック
5. **行8**: 親フォルダパス取得（GetParentFolderName）
6. **行10**: DeleteFolderで削除
7. **行32-37**: refresh()関数（親ウィンドウのrefreshAfterDelete呼び出し）
8. **行48**: inpDest（親フォルダパス）をhiddenで保持
9. **行55**: close & refreshボタン

#### Step 4: 親ウィンドウとの連携を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | assetmanagerIF.asp | `asp/assetmanager/assetmanagerIF.asp` 行384-401 | deleteFolder関数、ベースフォルダチェック |
| 4-2 | assetmanagerIF.asp | `asp/assetmanager/assetmanagerIF.asp` 行329-338 | refreshAfterDelete関数 |

### プログラム呼び出し階層図

```
assetmanagerIF.asp
    │
    └─ deleteFolder() [JavaScript]
           │
           ├─ ベースフォルダチェック
           │      └─ 該当の場合: alert() で中止
           │
           ├─ IE: window.showModalDialog("folderdel.asp")
           │
           └─ Other: window.open("folderdel.asp")
                  │
                  ▼
           folderdel.asp（確認画面）
                  │
                  ├─ security.asp (認証)
                  │
                  ├─ [確認メッセージ表示]
                  │
                  ├─ del() [JavaScript]
                  │      ├─ 親ウィンドウからcurrFolder取得
                  │      └─ Form1.submit()
                  │
                  └─ POST → folderdel_.asp
                           │
                           ▼
                    folderdel_.asp（実行画面）
                           │
                           ├─ security.asp (認証)
                           │
                           ├─ [サーバー処理]
                           │      ├─ FolderExists チェック
                           │      ├─ GetParentFolderName
                           │      └─ DeleteFolder 実行
                           │
                           ├─ [結果表示]
                           │
                           └─ close & refresh
                                  ├─ 親ウィンドウ.refreshAfterDelete(inpDest)
                                  └─ self.close()
```

### データフロー図

```
[入力]                    [処理]                      [出力]

親ウィンドウ ────────────▶ deleteFolder() [JS]
(selCurrFolder)                 │
       │                        │
       │              ベースフォルダ? ─── YES ──▶ alert() 中止
       │                        │
       │                       NO
       │                        │
       │                        ▼
       │              folderdel.asp 表示
       │                        │
       ▼                        ▼
inpCurrFolder設定 ◀──── del() [JS]
       │                        │
       │                        ▼
       │              Form1 submit
       │                        │
       │                        ▼
       │              folderdel_.asp
       │                        │
       │              FolderExists?
       │                   │         │
       │                  YES        NO
       │                   │         │
       │                   ▼         ▼
       │        GetParentFolderName  sMsq=Error
       │                   │
       │                   ▼
       │              DeleteFolder
       │                   │
       │                   ▼
       │              sMsq=Success
       │                   │
       │                   ▼
       │              inpDest=親フォルダ
       │                   │
       └───────────────────┘
                           │
                           ▼
           close & refresh → refreshAfterDelete(親フォルダ)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| folderdel.asp | `asp/assetmanager/folderdel.asp` | ソース | 削除確認ダイアログ |
| folderdel_.asp | `asp/assetmanager/folderdel_.asp` | ソース | 削除実行・結果表示 |
| security.asp | `asp/assetmanager/security.asp` | ソース | セッション認証 |
| assetmanagerIF.asp | `asp/assetmanager/assetmanagerIF.asp` | ソース | 呼び出し元 |
| folderdel.js | `asp/assetmanager/language/english/folderdel.js` | 多言語 | 確認画面テキスト |
| folderdel_.js | `asp/assetmanager/language/english/folderdel_.js` | 多言語 | 実行画面テキスト |
| style.css | `asp/assetmanager/style.css` | スタイル | UIスタイルシート |
