# 画面設計書 129-ファイルアップロード

## 概要

本ドキュメントは、QuickerSiteにおけるファイルアップロード処理画面（uploader214.asp）の設計を定義する。

### 本画面の処理概要

ファイルアップロード画面は、マルチファイルアップロード機能（Uploadify）のバックエンド処理を担当するASPスクリプトである。

**業務上の目的・背景**：Webサイトのコンテンツ管理において、複数ファイルの一括アップロードは効率的なファイル管理に不可欠である。本画面は、Uploadify（Flash/JavaScript ベースのアップロードライブラリ）からのファイル送信を受け取り、サーバー上の指定フォルダに保存する処理を行う。セキュリティを考慮し、セッション検証とIP検証を実装している。

**画面へのアクセス方法**：直接アクセスは想定されていない。マルチファイルアップロード画面（bs_multifileupload.asp）からUploadifyライブラリを通じて呼び出される。

**主要な操作・処理内容**：
1. セキュリティ検証（IP、セッションID、パス）
2. アップロードされたファイルデータを受信
3. Uploaderクラスでファイルを指定フォルダに保存
4. 空のHTML応答を返す

**画面遷移**：
- 遷移元：bs_multifileupload.asp（Uploadifyからの非同期呼び出し）
- 遷移先：なし（バックエンド処理のみ）

**権限による表示制御**：Application変数に設定されたセッションID、ユーザーIP、アップロードパスによる検証。不正アクセスの場合はResponse.Endで処理終了。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 38 | マルチファイルアップロード | 主機能 | ファイルのアップロード処理 |

## 画面種別

処理（バックエンド）

## URL/ルーティング

```
asp/uploader214.asp?sId={セッションID}
（Uploadifyからの非同期呼び出し専用）
```

## 入出力項目

| 項目名 | 入出力 | データ型 | 必須 | 説明 |
|--------|--------|----------|------|------|
| sId | 入力（GET） | String | 必須 | セッションID（検証用） |
| Filedata | 入力（POST/Binary） | Binary | 必須 | アップロードファイルデータ |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| なし | - | 空のHTML応答（処理結果はUploadifyが処理） |

## イベント仕様

### 1-セキュリティ検証

- Application("UserIP")とリクエスト元IPの一致確認
- Application("mupath")が空でないことを確認
- Application("sessionID")とGETパラメータsIdの一致確認
- いずれかが不一致の場合、Response.Endで処理終了

### 2-ファイル保存処理

- Uploaderクラス（uploaderCLS.asp）をインスタンス化
- Server.MapPath(Application("mupath"))で保存先パスを取得
- UploadifyObject.Save()でファイル保存

### 3-応答出力

- 空のHTMLドキュメントを出力

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| なし | なし | なし | 本画面はファイルシステム操作のみ |

### ファイルシステム操作

| 操作 | 対象 | 処理内容 |
|------|------|----------|
| ファイル保存 | 指定フォルダ | Uploaderクラス.Save |

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|-----------|----------|
| - | - | 本画面では直接メッセージ表示なし |

## 例外処理

| 例外 | 対処 |
|------|------|
| IP不一致 | Response.Endで処理終了 |
| パス未設定 | Response.Endで処理終了 |
| セッションID不一致 | Response.Endで処理終了 |
| セッションID空 | Response.Endで処理終了 |
| その他エラー | On Error Resume Nextで処理終了 |

## 備考

- Uploadifyライブラリ専用のバックエンド処理
- セキュリティ検証が厳密（IP、セッション、パス）
- uploaderCLS.aspにUploaderクラスが定義
- Application変数はbs_multifileupload.aspで設定される
- ファイルタイプと最大サイズの制限はUploaderクラス内で実装
- UserIP関数でプロキシ経由のIPも考慮（HTTP_X_FORWARDED_FOR）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

アップロード処理ではApplication変数とUploaderクラスが中心。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Application変数 | メモリ | UserIP、mupath、sessionIDの役割 |
| 1-2 | Uploaderクラス | uploaderCLS.asp | ファイル保存処理の実装 |

**読解のコツ**: Application変数はbs_multifileupload.aspで設定され、uploader214.aspで検証される。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | uploader214.asp | `asp/uploader214.asp` | 全体構造（27行） |

**主要処理フロー**:
1. **行2**: uploaderCLS.aspインクルード
2. **行3-10**: セキュリティ検証（On Error Resume Next）
3. **行4**: UserIP一致チェック
4. **行5**: mupath空チェック
5. **行6**: sessionID一致チェック（Application vs GET）
6. **行7-9**: 空チェック、エラーチェック
7. **行11-14**: 変数初期化（パス取得、フォルダ設定）
8. **行15-16**: Uploaderクラスインスタンス化、Save実行
9. **行17**: 空HTML応答

#### Step 3: Uploaderクラスを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | uploaderCLS.asp | `asp/uploaderCLS.asp` | Uploaderクラス定義（382行） |

**主要処理フロー**:
- **行10-38**: Class_Initialize（初期化）
- **行39-82**: Save関数（ファイル保存）
- **行128-233**: Upload関数（バイナリデータ解析）
- **行296-320**: UploadedFileクラス（ファイル情報）
- **行347-376**: GetFileName関数（重複ファイル名処理）

#### Step 4: 呼び出し元を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | bs_multifileupload.asp | `asp/bs_multifileupload.asp` | Uploadify設定、Application変数設定 |

### プログラム呼び出し階層図

```
bs_multifileupload.asp
    │
    ├─ Application変数設定
    │      ├─ Application("mupath") = アップロード先パス
    │      ├─ Application("UserIP") = ユーザーIP
    │      └─ Application("sessionID") = セッションID
    │
    └─ Uploadify初期化
           └─ 'script': 'uploader214.asp?sId={sessionID}'
                  │
                  ▼ [非同期ファイル送信]
           uploader214.asp
                  │
                  ├─ uploaderCLS.asp インクルード
                  │      └─ Uploaderクラス定義
                  │
                  ├─ セキュリティ検証
                  │      ├─ UserIP一致?
                  │      ├─ mupath空?
                  │      └─ sessionID一致?
                  │
                  ├─ Uploaderインスタンス化
                  │
                  └─ UploadifyObject.Save(path)
                         │
                         ├─ Upload() [バイナリ解析]
                         │      ├─ Request.BinaryRead
                         │      └─ ファイル情報抽出
                         │
                         └─ SaveToFile [ADODB.Stream]
```

### データフロー図

```
[入力]                    [処理]                      [出力]

bs_multifileupload.asp
       │
       ├─ Application変数設定
       │
       ▼
Uploadify (Flash/JS)
       │
       ├─ sId パラメータ
       │
       ├─ Filedata (Binary)
       │
       ▼
uploader214.asp ──────────▶ セキュリティ検証
                                  │
                          失敗 ◀──┼──▶ 成功
                           │             │
                           ▼             ▼
                    Response.End   Uploader.Save()
                                         │
                                         ▼
                                  Server.MapPath(mupath)
                                         │
                                         ▼
                                  ファイル保存
                                         │
                                         ▼
                                  空HTML応答
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| uploader214.asp | `asp/uploader214.asp` | ソース | アップロード受信処理 |
| uploaderCLS.asp | `asp/uploaderCLS.asp` | ソース | Uploaderクラス定義 |
| bs_multifileupload.asp | `asp/bs_multifileupload.asp` | ソース | 呼び出し元（UI） |
| uploadify.swf | `asp/uploadify214/uploadify.swf` | Flash | Uploadifyコンポーネント |
| jquery.uploadify.v2.1.4.min.js | `asp/uploadify214/` | JavaScript | Uploadifyライブラリ |
