# 画面設計書 13-コンテナ編集

## 概要

本ドキュメントは、QuickerSite CMSのバックサイト（管理画面）における「コンテナ編集」画面の設計仕様を定義するものである。

### 本画面の処理概要

コンテナ編集画面は、子ページを持つ親ページ（コンテナページ）を作成・編集するための画面である。コンテナページはそれ自体にはコンテンツを持たず、メニュー構造上で他のページをグループ化する役割を果たす。

**業務上の目的・背景**：
大規模なWebサイトでは、ページを階層的に整理する必要がある。例えば「製品情報」というメニュー項目の下に「製品A」「製品B」「製品C」を配置するような場合、「製品情報」自体はコンテンツを持たず、単に子ページの親としてメニュー上に表示される。本画面は、このようなコンテナページを作成・管理することで、論理的なサイト構造の構築を支援する。

**画面へのアクセス方法**：
1. バックサイトにログイン後、ホーム画面でページ作成を選択
2. ページタイプとして「コンテナ」を選択
3. または既存のコンテナページをクリックして編集
4. URLパラメータとして暗号化されたページID（iId）とiParentIDが渡される

**主要な操作・処理内容**：
1. ページタイトルの設定（メニューに表示される名前）
2. メニュー内での表示順序の設定
3. 公開/非公開の設定
4. アプリケーションコード（sCode）の設定（オプション）
5. ページの削除

**画面遷移**：
- 遷移元: バックサイトホーム（bs_default.asp）、ページ作成画面（bs_setupPage.asp）
- 遷移先: バックサイトホーム（bs_default.asp）、イントラネット管理（bs_intranet.asp）

**権限による表示制御**：
- secondAdmin.bPageTitleがfalseの場合、タイトルは表示のみで編集不可
- secondAdmin.bPagePublishがfalseの場合、公開設定項目が非表示
- secondAdmin.bPagesMoveとbPageOrderがfalseの場合、並び順設定が非表示
- customer.bApplicationとsecondAdmin.bApplicationpathが有効な場合のみsCode入力欄を表示

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 18 | コンテナページ管理 | 主機能 | 子ページを持つコンテナページの管理 |
| 11 | ページ移動・並び替え | 補助機能 | 子ページの並び順変更 |

## 画面種別

編集画面（登録・更新）

## URL/ルーティング

```
asp/bs_editContainer.asp?iId={暗号化されたページID}&iParentID={暗号化された親ページID}
```

## 入出力項目

| 項目名 | 入力/出力 | データ型 | 必須 | 説明 |
|--------|----------|---------|------|------|
| iId | 入力（hidden） | String | Yes | 暗号化されたページID |
| iParentID | 入力（hidden） | String | No | 暗号化された親ページID |
| btnaction | 入力（hidden） | String | Yes | アクション種別（save） |
| bContainerPage | 入力（hidden） | Boolean | Yes | コンテナページフラグ（常に1） |
| sTitle | 入力（text） | String | Yes | ページタイトル（メニュー表示名） |
| iRang | 入力（select） | Integer | No | メニュー内の表示順 |
| bOnline | 入力（checkbox） | Boolean | No | 公開状態 |
| sCode | 入力（text） | String | No | アプリケーションコード |
| bIntranet | 入力（hidden） | Boolean | No | イントラネットフラグ |
| QS_secCodeHidden | 入力（hidden） | String | Yes | CSRF対策トークン |

## 表示項目

| 項目名 | 表示形式 | 説明 |
|--------|---------|------|
| 親ページ名 | テキスト | 紐付け先の親ページ名（ある場合） |
| ページタイトル | 入力フィールド/テキスト | メニューに表示される名前 |
| 表示順 | プルダウン | メニュー内の並び順 |
| 公開状態 | チェックボックス | オンライン/オフライン切替 |
| sCode | 入力フィールド | アプリケーションコード |

## イベント仕様

### 1-保存ボタン押下

1. フォームをPOST送信
2. btnaction=l("save")でbs_processPage.aspの処理が実行
3. checkCSRF()でCSRFトークン検証
4. page.getRequestValues()でフォーム値をオブジェクトに設定
5. bContainerPage=1がhiddenで送信されコンテナフラグが設定
6. page.save()でデータベースに保存
7. 保存成功時、message.Add("fb_saveOK")でメッセージ設定

### 2-削除ボタン押下

1. JavaScript確認ダイアログ表示（deletePage()関数）
2. 確認OKでbtnaction=l("delete")を設定してフォーム送信
3. page.bDeleted=trueを設定
4. 親ページのrang（並び順）を再計算
5. page.save()で削除フラグ付きで保存
6. バックサイトホームまたはイントラネット管理にリダイレクト

### 3-変換リンク（コンテンツ付き/外部URLへの変換）

画面下部のインクルードファイルにより、他のページタイプへの変換リンクが提供される：
- bs_convertToItemWithContent.asp
- bs_convertToExternalURL.asp

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | tblPage | INSERT/UPDATE | コンテナページ設定を保存 |
| 削除ボタン押下 | tblPage | UPDATE | 論理削除（bDeleted=true） |

### テーブル別更新項目詳細

#### tblPage

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT/UPDATE | sTitle | フォームから取得 | ページタイトル |
| INSERT/UPDATE | bContainerPage | true | コンテナフラグ |
| INSERT/UPDATE | iRang | フォームから取得 | 表示順 |
| INSERT/UPDATE | bOnline | フォームから取得 | 公開フラグ |
| INSERT/UPDATE | sCode | フォームから取得 | アプリケーションコード |
| INSERT/UPDATE | iParentID | フォームから取得 | 親ページID |
| INSERT/UPDATE | bIntranet | フォームから取得 | イントラネットフラグ |
| UPDATE | bDeleted | true | 削除時のみ |
| INSERT | createdTS | now() | 新規作成時のみ |
| INSERT/UPDATE | updatedTS | now() | 更新日時 |

## メッセージ仕様

| メッセージID | 種別 | 表示条件 | メッセージ内容 |
|-------------|------|---------|--------------|
| fb_saveOK | 成功 | 保存成功時 | 保存が完了しました |
| err_mandatory | エラー | 必須項目未入力 | 必須項目を入力してください |
| deletecomplete | 確認 | 削除ボタン押下時 | 削除してよろしいですか？ |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| 未認証アクセス | bs_security.aspによりログイン画面にリダイレクト |
| 不正なページID | page.pick()で該当なしの場合、空のオブジェクトとなる |
| 必須項目未入力 | エラーメッセージを表示し、保存を中止 |
| CSRFトークン不正 | checkCSRF()でエラー処理 |

## 備考

- コンテナページはbContainerPage=trueで識別される
- コンテナページ自体にはコンテンツ（sValue）を持たない
- 子ページの管理はバックサイトホームのツリー構造から行う
- 論理削除方式を採用（bDeleted=trueで削除扱い）
- sCodeはアプリケーション連携時に使用される一意識別子

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

コンテナページがどのようにデータベースに格納されるかを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | page.asp | `asp/includes/page.asp` | cls_pageクラスのbContainerPageプロパティ |

**読解のコツ**: bContainerPage=trueのページは、子ページを持つコンテナとして機能する。sValueは空で、メニュー上の親要素として表示される。

#### Step 2: エントリーポイントを理解する

画面表示の流れを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_editContainer.asp | `asp/bs_editContainer.asp` | メイン画面構成、hiddenフィールド |

**主要処理フロー**:
1. **行1-4**: 各種インクルードファイル読み込み
2. **行4**: bContainerPage=1をhiddenで送信
3. **行4**: フォーム構成（タイトル、並び順、公開設定、sCode）

#### Step 3: 保存・削除処理を理解する

データ永続化の仕組みを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_processPage.asp | `asp/bs_processPage.asp` | 保存・削除処理のメインロジック |

**主要処理フロー**:
- **行12-25**: 保存処理（page.getRequestValues、page.save）
- **行26-44**: 削除処理（論理削除、リダイレクト）

#### Step 4: 共通部品を理解する

フォーム構成用のインクルードファイルを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | bs_commoncont.asp | `asp/bs_commoncont.asp` | タイトル入力、親ページ表示 |
| 4-2 | bs_sortorder.asp | `asp/bs_sortorder.asp` | 表示順選択 |
| 4-3 | bs_onlineOrNot.asp | `asp/bs_onlineOrNot.asp` | 公開設定 |
| 4-4 | bs_sCode.asp | `asp/bs_sCode.asp` | アプリケーションコード入力 |
| 4-5 | bs_deleteButton.asp | `asp/bs_deleteButton.asp` | 削除ボタン表示 |

### プログラム呼び出し階層図

```
bs_editContainer.asp
    │
    ├─ begin.asp（セッション・DB初期化）
    │
    ├─ bs_security.asp（認証チェック）
    │
    ├─ bs_process.asp（共通処理）
    │
    ├─ bs_processPage.asp（保存・削除処理）
    │      ├─ checkCSRF()
    │      ├─ page.getRequestValues()
    │      │      └─ bContainerPage = request("bContainerPage")
    │      └─ page.save()
    │
    ├─ bs_commoncont.asp（タイトル入力）
    │
    ├─ bs_sortorder.asp（表示順）
    │
    ├─ bs_onlineOrNot.asp（公開設定）
    │
    ├─ bs_sCode.asp（アプリケーションコード）
    │
    └─ bs_deleteButton.asp（削除ボタン）
```

### データフロー図

```
[入力]                      [処理]                      [出力]

URLパラメータ(iId) ─────────▶ decrypt() ─────────────▶ ページID取得
                                  │
                                  ▼
                            cls_page.pick() ──────────▶ 現在の設定値表示
                                  │
フォーム入力 ───────────────────▶ request.form() ─────▶ 入力値取得
   │                              │
   │ sTitle                       ▼
   │ iRang               page.getRequestValues() ────▶ オブジェクト設定
   │ bOnline                      │
   │ sCode                        │
   │ bContainerPage=1             ▼
   │                         page.save() ─────────────▶ tblPage INSERT/UPDATE
   │                              │
   └──────────────────────────────▼
                            response.redirect() ──────▶ ホーム画面
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_editContainer.asp | `asp/bs_editContainer.asp` | ソース | メイン画面処理 |
| bs_process.asp | `asp/bs_process.asp` | インクルード | 共通処理 |
| bs_processPage.asp | `asp/bs_processPage.asp` | インクルード | 保存・削除処理 |
| bs_commoncont.asp | `asp/bs_commoncont.asp` | インクルード | タイトル入力部品 |
| bs_sortorder.asp | `asp/bs_sortorder.asp` | インクルード | 表示順選択部品 |
| bs_onlineOrNot.asp | `asp/bs_onlineOrNot.asp` | インクルード | 公開設定部品 |
| bs_sCode.asp | `asp/bs_sCode.asp` | インクルード | sCode入力部品 |
| bs_deleteButton.asp | `asp/bs_deleteButton.asp` | インクルード | 削除ボタン部品 |
| bs_addnewitem.asp | `asp/bs_addnewitem.asp` | インクルード | 新規アイテム追加 |
| bs_convertToItemWithContent.asp | `asp/bs_convertToItemWithContent.asp` | インクルード | コンテンツ付き変換 |
| bs_convertToExternalURL.asp | `asp/bs_convertToExternalURL.asp` | インクルード | 外部URL変換 |
| bs_back.asp | `asp/bs_back.asp` | インクルード | 戻るリンク |
| page.asp | `asp/includes/page.asp` | インクルード | cls_pageクラス |
