# 画面設計書 130-マルチファイルアップロード

## 概要

本ドキュメントは、QuickerSiteにおけるマルチファイルアップロード画面（bs_multifileupload.asp）の設計を定義する。

### 本画面の処理概要

マルチファイルアップロード画面は、複数ファイルを一括でアップロードするためのユーザーインターフェース画面である。Uploadifyライブラリを使用してドラッグ&ドロップ感覚でのファイルアップロードを実現する。

**業務上の目的・背景**：大量の画像やドキュメントをアップロードする際、1ファイルずつのアップロードは非効率である。本画面は、Uploadify（Flash/JavaScript ベースのアップロードライブラリ）を使用して、複数ファイルの選択と一括アップロードを可能にする。進捗状況の表示やファイルタイプの制限機能も提供し、効率的なファイル管理を支援する。

**画面へのアクセス方法**：バックサイト管理画面からアクセス。アセットマネージャーからの「Back to file manager」リンクからも遷移可能。

**主要な操作・処理内容**：
1. アップロード先フォルダを選択
2. ファイルを選択（複数選択可能）
3. 「Upload files」リンクでアップロード開始
4. 進捗状況表示、完了したファイルの一覧表示
5. アセットマネージャーへの遷移

**画面遷移**：
- 遷移元：バックサイト管理画面、アセットマネージャー
- 遷移先：アセットマネージャーIF画面（assetmanagerIF.asp）

**権限による表示制御**：secondAdmin.bFiles権限を持つ管理者のみがアクセス可能。権限がない場合はアクセスが拒否される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 38 | マルチファイルアップロード | 主機能 | 複数ファイルの一括アップロード |

## 画面種別

アップロード

## URL/ルーティング

```
asp/bs_multifileupload.asp
asp/bs_multifileupload.asp?sPath=/subfolder/
```

## 入出力項目

| 項目名 | 入出力 | データ型 | 必須 | 説明 |
|--------|--------|----------|------|------|
| sPath | 入力（GET/POST） | String | 任意 | アップロード先サブフォルダパス |
| uploadify | 入力（FILE） | File | 必須 | アップロードファイル（複数可） |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| ファイルマネージャーリンク | link | アセットマネージャーへのリンク |
| フォルダ選択 | select | アップロード先フォルダのドロップダウン |
| Upload filesリンク | link | アップロード実行トリガー |
| ファイル選択ボタン | button | Uploadifyファイル選択UI |
| アップロード済みファイル一覧 | div | 完了したファイルのリスト |

## イベント仕様

### 1-画面表示

- bs_security.aspでbFiles権限チェック
- cls_fileexplorerで利用可能なフォルダを取得
- Application変数を設定（mupath、UserIP、sessionID）
- Uploadifyを初期化

### 2-フォルダ選択変更

- selectボックスのonchangeでフォームsubmit
- 選択されたsPathで画面リロード
- Application("mupath")を更新

### 3-ファイル選択

- Uploadify UIでファイルを選択
- 複数ファイル選択可能（multi: true）
- 自動アップロード（auto: true）

### 4-アップロード実行（Send_document）

- $('#uploadify').uploadifyUpload()を呼び出し
- 各ファイルがuploader214.aspに送信される
- 進捗表示、エラー表示

### 5-アップロード完了（onComplete）

- filesUploadedにファイルリンクを追加
- ファイル名とダウンロードリンクを表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| なし | なし | なし | 本画面はファイルシステム操作のみ |

### ファイルシステム操作

| 操作 | 対象 | 処理内容 |
|------|------|----------|
| フォルダ一覧取得 | userfilesフォルダ | cls_fileexplorer.SelectBoxFolders |
| ファイル保存 | 選択フォルダ | uploader214.asp経由 |

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|-----------|----------|
| エラー | Could not find upload script. | uploader214.aspが見つからない場合 |
| エラー | File Size Limit: 1MB! | ファイルサイズ超過（sizeLimit設定） |
| エラー | error {type}: {text} | その他のアップロードエラー |

## 例外処理

| 例外 | 対処 |
|------|------|
| 権限不足 | secondAdmin.bFiles権限がない場合、アクセス拒否 |
| アップロードスクリプトエラー | onErrorコールバックでアラート表示 |
| ファイルサイズ超過 | onErrorコールバックでアラート表示 |
| 不正ファイルタイプ | Uploadifyのfileext設定で制限 |

## 備考

- Uploadifyライブラリ（v2.1.4）を使用
- ファイルサイズ制限：1,324,000バイト（約1.3MB、sizeLimit）
- 許可ファイルタイプ：allowedFileTypes配列から動的生成
- 自動アップロードモード（auto: true）
- jQuery 1.5を使用
- Application変数はセキュリティ検証用にuploader214.aspで使用
- session("bHasSetUF")で初期フォルダ設定状態を管理

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

マルチアップロードではApplication変数とUploadify設定が重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Application変数 | メモリ | mupath、UserIP、sessionIDの設定タイミング |
| 1-2 | allowedFileTypes | 配列 | 許可ファイルタイプの定義場所 |

**読解のコツ**: Application変数は画面表示時に設定され、uploader214.aspで検証に使用される。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_multifileupload.asp | `asp/bs_multifileupload.asp` | 全体構造（50行、1行に圧縮） |

**主要処理フロー**:
1. **行1-4**: インクルード、セキュリティチェック
2. **行4-8**: cls_fileexplorer、Application変数設定
3. **行9-48**: JavaScript（Uploadify初期化、Send_document関数）
4. **行49**: HTML構造（フォルダ選択、アップロードUI）

#### Step 3: Uploadify設定を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_multifileupload.asp | JavaScript部分 | Uploadify初期化パラメータ |

**主要設定**:
- **uploader**: uploadify.swfのパス
- **script**: uploader214.asp?sId={sessionID}
- **cancelImg**: キャンセルボタン画像
- **sizeLimit**: 1324000（約1.3MB）
- **fileDesc/fileExt**: 許可ファイルタイプ
- **folder**: Application("mupath")
- **multi**: true（複数選択可）
- **auto**: true（自動アップロード）
- **onError**: エラーハンドリング
- **onComplete**: 完了時処理

#### Step 4: バックエンド処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | uploader214.asp | `asp/uploader214.asp` | セキュリティ検証、ファイル保存 |
| 4-2 | uploaderCLS.asp | `asp/uploaderCLS.asp` | Uploaderクラス |

### プログラム呼び出し階層図

```
bs_multifileupload.asp
    │
    ├─ begin.asp (共通初期化)
    │
    ├─ bs_security.asp (セキュリティチェック)
    │      └─ logon.hasaccess(secondAdmin.bFiles)
    │
    ├─ Application変数設定
    │      ├─ mupath = アップロード先パス
    │      ├─ UserIP = ユーザーIP
    │      └─ sessionID = Session.SessionID
    │
    ├─ cls_fileexplorer
    │      └─ SelectBoxFolders() → フォルダ選択肢生成
    │
    ├─ Uploadify初期化 [JavaScript]
    │      ├─ uploader: uploadify.swf
    │      ├─ script: uploader214.asp
    │      ├─ sizeLimit: 1324000
    │      ├─ fileDesc/fileExt: allowedFileTypes
    │      ├─ folder: mupath
    │      ├─ multi: true
    │      ├─ auto: true
    │      ├─ onError: エラーハンドリング
    │      └─ onComplete: ファイルリスト更新
    │
    └─ ユーザー操作
           │
           ├─ フォルダ選択 → form submit → リロード
           │
           ├─ ファイル選択 → Uploadify UI
           │
           └─ Upload files クリック
                  │
                  └─ Send_document() → uploadifyUpload()
                         │
                         ▼
                  uploader214.asp (非同期)
                         │
                         ├─ セキュリティ検証
                         │
                         └─ Uploader.Save()
                                │
                                ▼
                         ファイル保存完了
                                │
                                ▼
                         onComplete コールバック
                                │
                                ▼
                         filesUploaded 更新
```

### データフロー図

```
[入力]                    [処理]                      [出力]

sPath (フォルダ) ─────────▶ Application("mupath")設定
                                  │
                                  ▼
                    Uploadify初期化
                                  │
                    ┌─────────────┴─────────────┐
                    │                           │
              フォルダ選択                  ファイル選択
                    │                           │
                    ▼                           ▼
              form submit               Uploadify UI
                    │                           │
                    ▼                           ▼
              画面リロード              自動アップロード開始
                                               │
                                               ▼
                               uploader214.asp?sId={sessionID}
                                               │
                                    ┌──────────┴──────────┐
                                    │                     │
                             セキュリティOK          セキュリティNG
                                    │                     │
                                    ▼                     ▼
                             Uploader.Save()      Response.End
                                    │
                                    ▼
                             ファイル保存
                                    │
                                    ▼
                             onComplete
                                    │
                                    ▼
                             filesUploaded DOM更新
                             (ファイルリンク追加)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_multifileupload.asp | `asp/bs_multifileupload.asp` | ソース | マルチアップロードUI |
| uploader214.asp | `asp/uploader214.asp` | ソース | アップロード受信処理 |
| uploaderCLS.asp | `asp/uploaderCLS.asp` | ソース | Uploaderクラス |
| cls_fileexplorer | クラス定義 | ソース | フォルダ一覧取得 |
| bs_security.asp | `asp/bs_security.asp` | ソース | セキュリティチェック |
| begin.asp | `asp/begin.asp` | ソース | 共通初期化 |
| uploadify.swf | `asp/uploadify214/uploadify.swf` | Flash | Uploadifyコンポーネント |
| jquery.uploadify.v2.1.4.min.js | `asp/uploadify214/` | JavaScript | Uploadifyライブラリ |
| swfobject.js | `asp/uploadify214/` | JavaScript | Flash埋め込み |
| assetmanagerIF.asp | `asp/assetmanager/assetmanagerIF.asp` | ソース | 遷移先（ファイルマネージャー） |
