# 画面設計書 131-アイテムファイルアップロード

## 概要

本ドキュメントは、QuickerSite CMSにおけるアイテムファイルアップロード画面（bs_itemuploadfile.asp）の設計仕様を定義するものである。

### 本画面の処理概要

本画面は、ページアイテムに対して画像ファイル（JPG/JPEG/PNG）をアップロードする機能を提供する。アップロードされたファイルはページメディアフォルダに保存され、ページコンテンツに添付可能となる。

**業務上の目的・背景**：CMSでページを作成・編集する際、テキストコンテンツだけでなく画像ファイルを添付する必要がある。本画面は、各ページ（アイテム）に対して専用のメディアファイルをアップロードし、コンテンツを視覚的に充実させるために使用される。WYSIWYGエディタと連携し、ページ内に画像を挿入する際の素材を提供する役割を担う。

**画面へのアクセス方法**：バックサイト管理画面のページ編集画面（bs_editItem.asp）またはアイテムメディア管理画面（bs_itemmedia.asp）から、ファイルアップロード機能を呼び出すことでアクセスする。リクエストパラメータとして対象ページのiIdを必要とする。

**主要な操作・処理内容**：
1. 対象ページのIDを取得し、ファイル保存先ディレクトリを決定
2. pagemediaフォルダが存在しない場合は自動作成
3. ページIDに対応するサブフォルダが存在しない場合は自動作成
4. アップロードプラグインを使用してファイルを保存
5. ファイル拡張子を検証し、許可された形式（jpg, jpeg, png）以外は削除
6. 不正なファイル形式の場合はエラーを発生させる

**画面遷移**：本画面はAJAX処理として呼び出されるため、直接的な画面遷移は発生しない。処理完了後は呼び出し元（bs_itemmedia.asp）に制御が戻る。

**権限による表示制御**：バックサイトのセキュリティ認証（assetmanager/security.asp）を通過した管理者のみがアクセス可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 38 | マルチファイルアップロード | 主機能 | アイテム用ファイルのアップロード処理 |
| 37 | アセットマネージャー | 補助機能 | ファイル管理・フォルダ操作 |

## 画面種別

処理（ファイルアップロード処理画面）

## URL/ルーティング

`asp/bs_itemuploadfile.asp?iId={暗号化されたページID}`

## 入出力項目

| 項目名 | 項目ID | 入力/出力 | データ型 | 必須 | 説明 |
|--------|--------|-----------|----------|------|------|
| ページID | iId | 入力 | String | 必須 | 暗号化されたページ識別子 |
| アップロードファイル | - | 入力 | File | 必須 | アップロードする画像ファイル（multipart/form-data） |

## 表示項目

本画面は処理専用であり、HTMLレンダリングは行わない。

## イベント仕様

### 1-ファイルアップロード

ファイルがPOSTされると以下の処理が実行される：

1. ページIDからアップロード先ディレクトリパスを生成（`userfiles/pagemedia/{pageId}/`）
2. 必要に応じてディレクトリを作成
3. aspLiteのuploaderプラグインを使用してファイルを保存
4. 各ファイルの拡張子を検証
5. 許可されていない拡張子の場合、ファイルを削除しエラーを発生

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| ファイルアップロード | - | - | データベース更新なし（ファイルシステムのみ） |

### ファイルシステム操作

| 操作 | 対象パス | 処理内容 |
|-----|---------|---------|
| フォルダ作成 | `{siteRoot}/userfiles/pagemedia/` | 親フォルダが存在しない場合に作成 |
| フォルダ作成 | `{siteRoot}/userfiles/pagemedia/{pageId}/` | ページ用フォルダが存在しない場合に作成 |
| ファイル保存 | `{siteRoot}/userfiles/pagemedia/{pageId}/{filename}` | アップロードファイルの保存 |
| ファイル削除 | - | 不正な拡張子のファイルは即座に削除 |

## メッセージ仕様

| 種別 | メッセージ | 発生条件 |
|------|----------|---------|
| エラー | "This filetype is not allowed" | 許可されていないファイル形式がアップロードされた場合 |

## 例外処理

| 例外 | 処理内容 |
|------|---------|
| 不正なファイル形式 | err.raise 10 でエラーを発生させ、アップロードファイルを削除 |
| フォルダ作成失敗 | FileSystemObjectのエラーとして処理 |
| セキュリティ認証失敗 | security.aspにより処理が中断される |

## 備考

- 対応ファイル形式：JPG、JPEG、PNGのみ
- ファイルサイズ制限はサーバー設定に依存
- aspLiteフレームワークのuploaderプラグインを使用
- ファイル名は元のファイル名がそのまま使用される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

アップロード処理ではデータベースは使用せず、ファイルシステムへの書き込みのみを行う。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | asplite.asp | `asp/asplite/asplite.asp` | aspLiteフレームワークの基本構造とプラグイン機構を理解する |

**読解のコツ**: ASP/VBScriptでは、Server.CreateObjectでCOMオブジェクトを生成する。FileSystemObjectはファイル操作の標準的なオブジェクトである。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_itemuploadfile.asp | `asp/bs_itemuploadfile.asp` | メイン処理ファイル。ファイルアップロードのエントリーポイント |

**主要処理フロー**:
1. **行10**: security.aspをインクルードしてセキュリティチェック
2. **行19**: ページIDからアップロード先パスを生成
3. **行21-27**: 必要なフォルダを自動作成
4. **行29-31**: uploaderプラグインでファイル保存
5. **行33-48**: ファイル拡張子の検証と不正ファイルの削除

#### Step 3: セキュリティ層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | security.asp | `asp/assetmanager/security.asp` | アセットマネージャー用のセキュリティ認証処理 |

**主要処理フロー**:
- セッションベースの認証確認
- 未認証の場合は処理を中断

### プログラム呼び出し階層図

```
bs_itemuploadfile.asp
    │
    ├─ security.asp (認証チェック)
    │
    ├─ asplite/asplite.asp (フレームワーク初期化)
    │      └─ aspl.plugin("uploader") (アップロードプラグイン)
    │
    └─ FileSystemObject
           ├─ folderexists() (フォルダ存在確認)
           ├─ createfolder() (フォルダ作成)
           └─ deletefile() (ファイル削除)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

HTTPリクエスト           ┌─────────────────┐
  ├─ iId           ───▶ │ パス生成       │
  └─ ファイル            │ ・pagemedia/   │
                        │ ・{pageId}/    │
                        └─────────────────┘
                               │
                               ▼
                        ┌─────────────────┐
                        │ フォルダ確認/作成│ ───▶ ファイルシステム
                        └─────────────────┘       userfiles/pagemedia/{id}/
                               │
                               ▼
                        ┌─────────────────┐
                        │ ファイル保存     │ ───▶ {filename}.{ext}
                        └─────────────────┘
                               │
                               ▼
                        ┌─────────────────┐
                        │ 拡張子検証       │
                        │ jpg/jpeg/png    │
                        └─────────────────┘
                               │
                    ┌──────────┴──────────┐
                    ▼                     ▼
               [成功]                 [エラー]
              処理完了              ファイル削除
                                   エラー発生
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_itemuploadfile.asp | `asp/bs_itemuploadfile.asp` | ソース | ファイルアップロード処理のメインファイル |
| security.asp | `asp/assetmanager/security.asp` | インクルード | セキュリティ認証 |
| asplite.asp | `asp/asplite/asplite.asp` | フレームワーク | aspLiteフレームワーク本体 |
| bs_itemmedia.asp | `asp/bs_itemmedia.asp` | ソース | アイテムメディア管理画面（呼び出し元） |
| bs_itemmedia_handler.asp | `asp/bs_itemmedia_handler.asp` | ソース | メディア管理のAJAXハンドラー |
