# 画面設計書 132-アイテムメディア

## 概要

本ドキュメントは、QuickerSite CMSにおけるアイテムメディア管理画面（bs_itemmedia.asp）の設計仕様を定義するものである。

### 本画面の処理概要

本画面は、ページアイテムに添付されたメディアファイル（画像）を管理するためのUIを提供する。ファイルのアップロード、一覧表示、削除、表示位置設定などの機能を備えている。

**業務上の目的・背景**：CMSでページコンテンツを編集する際、テキストだけでなく画像などのメディアファイルを管理する必要がある。本画面は、特定のページに紐づくメディアファイルを一元管理し、メディアの表示位置（テキストの上/右/下/左）を設定できる機能を提供する。これにより、コンテンツ制作者は視覚的に豊かなページを効率的に作成できる。

**画面へのアクセス方法**：バックサイト管理画面のページ編集画面（bs_editItem.asp）から、メディア管理機能のリンク/ボタンをクリックすることでアクセスする。Colorboxモーダルウィンドウとして表示されることが多い。リクエストパラメータとして対象ページのiIdを必要とする。

**主要な操作・処理内容**：
1. ページに関連付けられたメディアファイルの一覧表示
2. 新規画像ファイルのアップロード（複数ファイル対応）
3. 個別画像の削除
4. 全画像の一括削除
5. メディア表示位置の設定（テキストの上/右/下/左）
6. プレビュー機能でページでの表示確認

**画面遷移**：
- 遷移元：bs_editItem.asp（コンテンツ付きアイテム編集）
- 遷移先：default.asp（プレビュー、新規ウィンドウ）
- 処理完了時：モーダルウィンドウを閉じて親画面に戻る

**権限による表示制御**：バックサイトのセキュリティ認証（bs_security.asp）を通過した管理者のみがアクセス可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 37 | アセットマネージャー | 主機能 | アイテムメディアの管理 |
| 38 | マルチファイルアップロード | 補助機能 | 画像ファイルのアップロード |

## 画面種別

一覧・編集（メディアファイル管理画面）

## URL/ルーティング

`asp/bs_itemmedia.asp?iId={暗号化されたページID}`

## 入出力項目

| 項目名 | 項目ID | 入力/出力 | データ型 | 必須 | 説明 |
|--------|--------|-----------|----------|------|------|
| ページID | iId | 入力 | String | 必須 | 暗号化されたページ識別子 |
| メディア表示位置 | iPMlocation | 入力 | Integer | - | 1:上, 2:右, 3:下, 4:左 |
| 削除ファイル名 | delFile | 入力 | String | - | 削除対象ファイル名 |
| 全削除フラグ | delAll | 入力 | Integer | - | 1:全画像削除 |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| ページタイトル | String | 対象ページのタイトル（ヘッダーに表示） |
| メディア表示位置 | Select | Above text/Right from text/Below text/Left from text |
| 画像サムネイル一覧 | Image | アップロード済み画像のサムネイル表示 |
| 削除ボタン | Button | 各画像の削除ボタン |
| 全削除ボタン | Button | 3枚以上の場合に表示される一括削除ボタン |
| プレビューボタン | Button | ページプレビューへのリンク |
| 保存ボタン | Button | 表示位置設定の保存 |
| 閉じるボタン | Button | モーダルウィンドウを閉じる |

## イベント仕様

### 1-メディア表示位置変更

フォーム送信時、iPMlocation（メディア表示位置）をページ情報として保存する。

1. セッションセキュリティチェック
2. iPMlocationの値を取得
3. pageオブジェクトのiPMlocationを更新
4. 保存成功時、「Saved!」メッセージを表示

### 2-個別画像削除

delFileパラメータが指定された場合、該当ファイルを削除する。

1. ファイル存在確認
2. ファイルシステムからファイル削除
3. 画面をリロードして一覧を更新

### 3-全画像一括削除

delAll=1が指定された場合、ページに関連する全メディアを削除する。

1. page.removeallmediaメソッドを呼び出し
2. 全画像を削除
3. iPMlocationを0にリセット

### 4-ファイルアップロード

uploadフォーム領域からファイルをアップロードする。

1. bs_itemuploadfile.aspを呼び出し
2. ファイルをpagemedia/{pageId}/フォルダに保存
3. アップロード完了後、一覧を更新

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 表示位置変更 | tblPage | UPDATE | iPMlocation列を更新 |
| ファイル削除 | - | - | データベース更新なし（ファイルシステムのみ） |

### テーブル別更新項目詳細

#### tblPage

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | iPMlocation | 1-4（表示位置）または0（なし） | ファイルが0件の場合は自動で0に設定 |
| UPDATE | updatedTS | now() | 更新日時 |

## メッセージ仕様

| 種別 | メッセージ | 発生条件 |
|------|----------|---------|
| 成功 | "Saved!" | 表示位置設定が保存された場合 |
| 確認 | "Are you sure? This will delete ALL images!" | 全削除ボタンクリック時 |

## 例外処理

| 例外 | 処理内容 |
|------|---------|
| ファイル不存在 | aspl.dieでエラー終了 |
| セッション不一致 | 処理をスキップ（セキュリティ対策） |

## 備考

- Bootstrap 5.3.2を使用したレスポンシブデザイン
- jQuery + aspLiteによるAJAX通信
- Colorboxモーダルウィンドウとして表示される想定
- サムネイル表示はshowthumb.aspxで300pxに縮小

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | page.asp | `asp/includes/page.asp` | cls_pageクラスのiPMlocation、mediafilesプロパティを理解する |

**読解のコツ**: cls_pageクラスはページの全情報を管理する中心的なクラス。mediafilesプロパティでページに関連付けられたファイル一覧を取得できる。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_itemmedia.asp | `asp/bs_itemmedia.asp` | UIのHTML構造とJavaScript初期化 |
| 2-2 | bs_itemmedia_handler.asp | `asp/bs_itemmedia_handler.asp` | AJAXリクエストのルーティング |

**主要処理フロー**:
1. **bs_itemmedia.asp 行26-27**: uploadとmedia用のdiv領域を定義
2. **bs_itemmedia.asp 行32**: aspLiteAjaxHandlerを設定
3. **bs_itemmedia_handler.asp 行7-12**: イベントに応じて処理を振り分け

#### Step 3: AJAX処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_itemmedia_ajax.resx | `asp/bs_itemmedia_ajax.resx` | メディア一覧表示と設定保存処理 |
| 3-2 | bs_itemmedia_upload.resx | `asp/bs_itemmedia_upload.resx` | アップロードフォームの生成 |

**主要処理フロー（bs_itemmedia_ajax.resx）**:
- **行4-10**: 個別ファイル削除処理
- **行12-14**: 全ファイル削除処理
- **行16-26**: ファイル数に応じてiPMlocationを更新
- **行33-46**: フォームセッション検証と保存処理
- **行52-64**: 表示位置選択肢の定義
- **行106-113**: 画像サムネイル一覧の生成

### プログラム呼び出し階層図

```
bs_itemmedia.asp (UI/HTML)
    │
    ├─ asplite.js (JavaScriptフレームワーク)
    │      └─ aspAjax() (AJAX通信)
    │
    └─ bs_itemmedia_handler.asp (AJAXハンドラー)
           │
           ├─ bs_security.asp (認証)
           │
           ├─ bs_itemmedia_ajax.resx (メディア一覧/設定)
           │      ├─ page.mediafiles (ファイル取得)
           │      ├─ page.iPMlocation (位置設定)
           │      ├─ page.save() (保存)
           │      └─ page.removeallmedia() (全削除)
           │
           └─ bs_itemmedia_upload.resx (アップロードフォーム)
                  └─ bs_itemuploadfile.asp (ファイル保存)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

ページID(iId)       ┌─────────────────┐
       ───────────▶ │ ページ情報取得   │ ───▶ ページオブジェクト
                    └─────────────────┘
                           │
                           ▼
                    ┌─────────────────┐
                    │ メディアファイル  │ ───▶ サムネイル一覧
                    │ 取得・表示       │       (HTML/Bootstrap)
                    └─────────────────┘
                           │
        ┌──────────────────┼──────────────────┐
        ▼                  ▼                  ▼
┌───────────────┐ ┌───────────────┐ ┌───────────────┐
│ 位置設定変更   │ │ ファイル削除   │ │ ファイル追加   │
│ iPMlocation  │ │ delFile       │ │ upload       │
└───────────────┘ └───────────────┘ └───────────────┘
        │                  │                  │
        ▼                  ▼                  ▼
   tblPage更新      ファイルシステム     ファイルシステム
   (iPMlocation)        削除               保存
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_itemmedia.asp | `asp/bs_itemmedia.asp` | ソース | メディア管理画面のHTMLベース |
| bs_itemmedia_handler.asp | `asp/bs_itemmedia_handler.asp` | ソース | AJAXリクエストハンドラー |
| bs_itemmedia_ajax.resx | `asp/bs_itemmedia_ajax.resx` | ソース | メディア一覧・設定処理 |
| bs_itemmedia_upload.resx | `asp/bs_itemmedia_upload.resx` | ソース | アップロードフォーム生成 |
| bs_itemuploadfile.asp | `asp/bs_itemuploadfile.asp` | ソース | ファイルアップロード処理 |
| page.asp | `asp/includes/page.asp` | インクルード | ページクラス定義 |
| asplite.asp | `asp/asplite/asplite.asp` | フレームワーク | aspLiteフレームワーク |
| asplite.js | `asp/asplite/asplite.js` | JavaScript | aspLite JS ライブラリ |
| bs_security.asp | `asp/bs_security.asp` | インクルード | バックサイトセキュリティ |
