# 画面設計書 133-リストアイテム画像編集

## 概要

本ドキュメントは、QuickerSite CMSにおけるリストアイテム画像編集画面（bs_editpictureLI.asp）の設計仕様を定義するものである。

### 本画面の処理概要

本画面は、リストページ内の個別アイテムに設定された画像の表示設定を編集する機能を提供する。画像の配置方法（左寄せ・全幅・右寄せ・カスタムCSS）を選択でき、必要に応じて画像を削除することも可能である。

**業務上の目的・背景**：リストページ（ブログ記事一覧やニュース一覧など）では、各アイテムにサムネイル画像を設定することが一般的である。本画面は、アップロード済みの画像に対して表示スタイルを設定し、ページデザインに合わせた見た目を実現するために使用される。コンテンツ制作者が画像の配置を柔軟に調整できることで、視覚的なコンテンツ品質を向上させる。

**画面へのアクセス方法**：リストアイテム編集画面（bs_editListItem.asp）から、画像設定のリンクをクリックすることでアクセスする。Colorboxモーダルウィンドウとして表示される。リクエストパラメータとして対象ページ（リストアイテム）のiIdを必要とする。

**主要な操作・処理内容**：
1. 現在の画像表示設定（sLPIC）を取得して表示
2. ラジオボタンで表示スタイルを選択（al/fp/ar/CC）
3. 保存ボタンで設定を更新
4. 削除ボタンで画像を削除

**画面遷移**：
- 遷移元：bs_editListItem.asp（リストアイテム編集）、bs_uploadpictureLI.asp（画像アップロード後リダイレクト）
- 処理完了時：JavaScript（colorbox.close）で親ウィンドウのモーダルを閉じる

**権限による表示制御**：バックサイトのセキュリティ認証（bs_security.asp）を通過した管理者のみがアクセス可能。また、顧客設定でbListItemPicがTrueの場合のみ機能が有効。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 13 | リストページ管理 | 主機能 | リストアイテム画像の編集 |
| 116 | サムネイル生成 | 補助機能 | 画像サムネイルの自動生成 |

## 画面種別

編集（リストアイテム画像設定画面）

## URL/ルーティング

`asp/bs_editpictureLI.asp?iId={暗号化されたページID}`

## 入出力項目

| 項目名 | 項目ID | 入力/出力 | データ型 | 必須 | 説明 |
|--------|--------|-----------|----------|------|------|
| ページID | iId | 入力 | String | 必須 | 暗号化されたリストアイテムID |
| 画像表示スタイル | sLPIC | 入力 | String | - | al:左寄せ, fp:全幅, ar:右寄せ, CC:カスタムCSS |
| 保存アクション | btnAction | 入力 | String | - | 保存ボタン押下時 |
| 削除アクション | delAction | 入力 | String | - | 削除ボタン押下時 |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| Align left (50%) | Radio | 左寄せ50%幅で表示（sLPIC=al） |
| Full page width (100%) | Radio | 全幅100%で表示（sLPIC=fp） |
| Align right (50%) | Radio | 右寄せ50%幅で表示（sLPIC=ar） |
| custom CSS | Radio | カスタムCSS適用（sLPIC=CC、class="ListItemPictureCSS"） |
| 保存ボタン | Button | 設定を保存 |
| 削除ボタン | Button | 画像を削除（確認ダイアログあり） |

## イベント仕様

### 1-設定保存（Save）

btnActionが送信された場合、画像表示設定を保存する。

1. フォームからsLPIC値を取得
2. page.sLPICに値を設定
3. page.save()で保存
4. JavaScriptでcolorboxを閉じる

### 2-画像削除（Delete Picture）

delActionが送信された場合、確認後に画像を削除する。

1. JavaScriptでconfirm()確認ダイアログを表示
2. 確認後、page.deleteListItemImage()を呼び出し
3. 画像ファイルと関連設定を削除
4. JavaScriptでcolorboxを閉じる

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 設定保存 | tblPage | UPDATE | sLPIC列を更新 |
| 画像削除 | tblPage | UPDATE | sItemPicture列をクリア |

### テーブル別更新項目詳細

#### tblPage

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | sLPIC | "al" / "fp" / "ar" / "CC" | 画像表示スタイル |
| UPDATE | sItemPicture | NULL（削除時） | 画像ファイル拡張子 |
| UPDATE | updatedTS | now() | 更新日時 |

## メッセージ仕様

| 種別 | メッセージ | 発生条件 |
|------|----------|---------|
| 確認 | "Are you sure to delete the picture?" | 削除ボタンクリック時 |

## 例外処理

| 例外 | 処理内容 |
|------|---------|
| bListItemPic=False | response.endで処理を終了（機能無効時） |
| 無効なページID | ページ情報が取得できず処理が継続不可 |

## 備考

- 顧客設定（customer.bListItemPic）がTrueの場合のみ機能が有効
- CSRF対策としてQS_secCodeHiddenを使用
- カスタムCSSを選択した場合、class="ListItemPictureCSS"が適用される
- デフォルト値はfp（全幅）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | page.asp | `asp/includes/page.asp` | cls_pageクラスのsLPIC、sItemPictureプロパティを理解する |

**読解のコツ**: sLPICはList Page Item Configurationの略。画像表示設定を2文字のコードで管理している。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_editpictureLI.asp | `asp/bs_editpictureLI.asp` | 画像設定編集のメイン処理 |

**主要処理フロー**:
1. **行6**: bListItemPicフラグで機能有効性チェック
2. **行8-10**: ページオブジェクトを取得
3. **行12-16**: btnAction処理（設定保存）
4. **行18-21**: delAction処理（画像削除）
5. **行35-44**: ラジオボタンの選択状態制御

#### Step 3: 関連画面を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_uploadpictureLI.asp | `asp/bs_uploadpictureLI.asp` | 画像アップロード処理との連携 |

**主要処理フロー**:
- アップロード後、bs_editpictureLI.aspにリダイレクトされる

### プログラム呼び出し階層図

```
bs_editpictureLI.asp
    │
    ├─ begin.asp (共通初期化)
    │
    ├─ bs_security.asp (認証チェック)
    │
    ├─ customer.bListItemPic (機能有効性チェック)
    │
    └─ cls_page
           ├─ pick() (ページ取得)
           ├─ sLPIC (表示設定)
           ├─ save() (保存)
           └─ deleteListItemImage() (画像削除)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

iId(暗号化)         ┌─────────────────┐
       ───────────▶ │ 復号化＆取得     │ ───▶ ページオブジェクト
                    │ page.pick()     │
                    └─────────────────┘
                           │
                           ▼
                    ┌─────────────────┐
                    │ フォーム表示     │ ───▶ HTMLフォーム
                    │ ・ラジオボタン   │       (sLPIC選択)
                    │ ・現在値反映    │
                    └─────────────────┘
                           │
        ┌──────────────────┴──────────────────┐
        ▼                                     ▼
┌───────────────┐                     ┌───────────────┐
│ 設定保存       │                     │ 画像削除       │
│ btnAction     │                     │ delAction     │
└───────────────┘                     └───────────────┘
        │                                     │
        ▼                                     ▼
   page.sLPIC更新                      page.deleteListItemImage()
   page.save()                        sItemPicture=NULL
        │                                     │
        └──────────────────┬──────────────────┘
                           ▼
                    colorbox.close()
                    (親ウィンドウへ戻る)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_editpictureLI.asp | `asp/bs_editpictureLI.asp` | ソース | 画像設定編集画面 |
| bs_uploadpictureLI.asp | `asp/bs_uploadpictureLI.asp` | ソース | 画像アップロード画面 |
| page.asp | `asp/includes/page.asp` | インクルード | ページクラス定義 |
| customer.asp | `asp/includes/customer.asp` | インクルード | 顧客設定（bListItemPic） |
| begin.asp | `asp/begin.asp` | インクルード | 共通初期化処理 |
| bs_security.asp | `asp/bs_security.asp` | インクルード | バックサイトセキュリティ |
| bs_editListItem.asp | `asp/bs_editListItem.asp` | ソース | リストアイテム編集（呼び出し元） |
