# 画面設計書 134-リストアイテム画像アップロード

## 概要

本ドキュメントは、QuickerSite CMSにおけるリストアイテム画像アップロード画面（bs_uploadpictureLI.asp）の設計仕様を定義するものである。

### 本画面の処理概要

本画面は、リストページ内の個別アイテムに対して画像ファイル（JPG/GIF/PNG）をアップロードする機能を提供する。アップロードされた画像はlistitemimagesフォルダに保存され、リストアイテムに関連付けられる。

**業務上の目的・背景**：リストページ（ブログ記事一覧やニュース一覧など）では、各アイテムにサムネイル画像を設定することでビジュアル的な訴求力を高められる。本画面は、リストアイテムに画像を追加するためのシンプルなアップロードインターフェースを提供する。アップロード後は自動的に画像設定画面に遷移し、表示スタイルを設定できる。

**画面へのアクセス方法**：リストアイテム編集画面（bs_editListItem.asp）から、画像アップロードのリンク/ボタンをクリックすることでアクセスする。Colorboxモーダルウィンドウとして表示されることが多い。リクエストパラメータとして対象ページ（リストアイテム）のiIdを必要とする。

**主要な操作・処理内容**：
1. ファイル選択ダイアログで画像を選択
2. 選択と同時に自動的にフォームを送信
3. ファイル形式を検証（PNG/JPG/GIF/JPEGのみ許可）
4. 画像をページIDにリネームして保存
5. ページ情報（sItemPicture、sLPIC）を更新
6. 画像設定画面（bs_editpictureLI.asp）にリダイレクト

**画面遷移**：
- 遷移元：bs_editListItem.asp（リストアイテム編集）
- 遷移先：bs_editpictureLI.asp（画像設定画面）

**権限による表示制御**：バックサイトのセキュリティ認証（bs_security.asp）を通過した管理者のみがアクセス可能。また、顧客設定でbListItemPicがTrueの場合のみ機能が有効。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 13 | リストページ管理 | 主機能 | リストアイテム画像のアップロード |
| 38 | マルチファイルアップロード | 補助機能 | ファイルアップロード処理 |

## 画面種別

処理（ファイルアップロード画面）

## URL/ルーティング

`asp/bs_uploadpictureLI.asp?iId={暗号化されたページID}`

## 入出力項目

| 項目名 | 項目ID | 入力/出力 | データ型 | 必須 | 説明 |
|--------|--------|-----------|----------|------|------|
| ページID | iId | 入力 | String | 必須 | 暗号化されたリストアイテムID |
| 画像ファイル | picture | 入力 | File | 必須 | アップロードする画像ファイル |
| セキュリティコード | QSSEC | 入力 | String | 必須 | CSRF対策トークン |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| ファイル選択 | File Input | 画像ファイル選択（onchangeで自動送信） |
| アップロードボタン | Button | "Upload"ボタン（または多言語ラベル） |
| エラーメッセージ | Text | ファイル形式エラー時のメッセージ |

## イベント仕様

### 1-ファイル選択

ファイルが選択されると、onchangeイベントで自動的にフォームを送信する。

1. ファイル選択ダイアログを表示
2. ファイル選択時にボタンテキストを"please wait..."に変更
3. フォームを自動送信

### 2-アップロード処理

フォーム送信後、ファイルを処理して保存する。

1. FreeASPUploadでファイルを受信
2. CSRF検証（checkCSRF_Upload）
3. ファイル拡張子を検証（png/jpg/gif/jpegのみ）
4. ファイルをページIDにリネームして保存
5. ページ情報を更新（sItemPicture、sLPIC）
6. 画像設定画面にリダイレクト

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| アップロード成功 | tblPage | UPDATE | sItemPicture、sLPIC列を更新 |

### テーブル別更新項目詳細

#### tblPage

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | sItemPicture | 拡張子（png/jpg/gif等） | ファイル形式を保存 |
| UPDATE | sLPIC | "fp" | 全幅表示をデフォルト設定 |
| UPDATE | updatedTS | now() | 更新日時 |

### ファイルシステム操作

| 操作 | 対象パス | 処理内容 |
|-----|---------|---------|
| フォルダ作成 | `{siteRoot}/userfiles/listitemimages/` | フォルダが存在しない場合に作成 |
| ファイル保存 | `{siteRoot}/userfiles/listitemimages/{pageId}.{ext}` | ページIDにリネームして保存 |
| ファイル削除 | - | 不正な拡張子のファイルは即座に削除 |

## メッセージ仕様

| 種別 | メッセージ | 発生条件 |
|------|----------|---------|
| エラー | "Only JPG/GIF/PNG files please." | 許可されていないファイル形式がアップロードされた場合 |

## 例外処理

| 例外 | 処理内容 |
|------|---------|
| bListItemPic=False | response.endで処理を終了（機能無効時） |
| 不正なファイル形式 | エラーメッセージを表示し、ファイルを削除 |
| CSRF検証失敗 | checkCSRF_Uploadでエラー処理 |

## 備考

- 対応ファイル形式：PNG、JPG、GIF、JPEG
- ファイル名はページIDにリネームされる（例：123.jpg）
- アップロード成功時、sLPICは自動的に"fp"（全幅）に設定
- FreeASPUploadコンポーネントを使用
- ファイル選択時に自動送信される（JavaScript onchange）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | page.asp | `asp/includes/page.asp` | cls_pageクラスのsItemPicture、sLPICプロパティを理解する |

**読解のコツ**: sItemPictureには拡張子のみが保存される。実際のファイル名はページIDから生成される。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_uploadpictureLI.asp | `asp/bs_uploadpictureLI.asp` | ファイルアップロード処理のメイン |

**主要処理フロー**:
1. **行5**: bListItemPicフラグで機能有効性チェック
2. **行7-9**: ページオブジェクトを取得
3. **行11-16**: listitemimagesフォルダの作成
4. **行18-19**: アップロード先パスの設定
5. **行21-24**: FreeASPUploadでファイル受信
6. **行25**: CSRF検証
7. **行34-45**: ファイル拡張子検証と不正ファイル削除
8. **行47-57**: 正常ファイルの処理（リネーム、保存、リダイレクト）

#### Step 3: セキュリティ処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_security.asp | `asp/bs_security.asp` | バックサイト認証処理 |

### プログラム呼び出し階層図

```
bs_uploadpictureLI.asp
    │
    ├─ begin.asp (共通初期化)
    │
    ├─ bs_security.asp (認証チェック)
    │
    ├─ customer.bListItemPic (機能有効性チェック)
    │
    ├─ FileSystemObject
    │      ├─ folderExists() (フォルダ確認)
    │      └─ createfolder() (フォルダ作成)
    │
    ├─ FreeASPUpload
    │      ├─ Save() (ファイル保存)
    │      ├─ UploadedFiles.keys (ファイル一覧)
    │      ├─ delete() (ファイル削除)
    │      └─ rename() (ファイルリネーム)
    │
    ├─ checkCSRF_Upload() (CSRF検証)
    │
    └─ cls_page
           ├─ pick() (ページ取得)
           ├─ sItemPicture (画像拡張子)
           ├─ sLPIC (表示設定)
           └─ save() (保存)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

iId(暗号化)         ┌─────────────────┐
       ───────────▶ │ 復号化＆取得     │ ───▶ ページオブジェクト
                    │ page.pick()     │
                    └─────────────────┘
                           │
                           ▼
画像ファイル         ┌─────────────────┐
(multipart)  ─────▶ │ FreeASPUpload   │
                    │ ・ファイル受信   │
                    └─────────────────┘
                           │
                           ▼
                    ┌─────────────────┐
                    │ 拡張子検証       │
                    │ png/jpg/gif/jpeg│
                    └─────────────────┘
                           │
                    ┌──────┴──────┐
                    ▼             ▼
               [成功]         [エラー]
                    │             │
                    ▼             ▼
           ┌───────────────┐  ファイル削除
           │ リネーム＆保存 │  エラー表示
           │ {pageId}.{ext}│
           └───────────────┘
                    │
                    ▼
           ┌───────────────┐
           │ DB更新        │ ───▶ tblPage
           │ sItemPicture  │       (sItemPicture, sLPIC)
           │ sLPIC="fp"    │
           └───────────────┘
                    │
                    ▼
           リダイレクト
           bs_editpictureLI.asp
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_uploadpictureLI.asp | `asp/bs_uploadpictureLI.asp` | ソース | 画像アップロード処理 |
| bs_editpictureLI.asp | `asp/bs_editpictureLI.asp` | ソース | 画像設定画面（リダイレクト先） |
| page.asp | `asp/includes/page.asp` | インクルード | ページクラス定義 |
| customer.asp | `asp/includes/customer.asp` | インクルード | 顧客設定（bListItemPic） |
| begin.asp | `asp/begin.asp` | インクルード | 共通初期化処理 |
| bs_security.asp | `asp/bs_security.asp` | インクルード | バックサイトセキュリティ |
| FreeASPUpload | - | コンポーネント | ファイルアップロードライブラリ |
