# 画面設計書 135-顧客一覧

## 概要

本ドキュメントは、QuickerSite CMSにおける顧客一覧画面（ad_clientList.asp）の設計仕様を定義するものである。

### 本画面の処理概要

本画面は、システム管理者（Admin）が登録されているクライアント（顧客）の一覧を表示・管理するための画面である。クライアント情報の確認、詳細画面へのアクセスが可能である。

**業務上の目的・背景**：QuickerSiteはマルチテナント型CMSであり、複数のクライアント（顧客）のウェブサイトを一元管理する。本画面は、システム管理者がすべてのクライアントを俯瞰し、個別クライアントの管理画面にアクセスするためのエントリーポイントとして機能する。クライアント数の把握、連絡先情報の確認、個別管理への導線として重要な役割を担う。

**画面へのアクセス方法**：管理者ダッシュボード（ad_default.asp）から、クライアント管理メニューを選択することでアクセスする。管理者メニュー（ad_adminMenu.asp）からもアクセス可能。

**主要な操作・処理内容**：
1. 登録済みクライアントの一覧表示
2. クライアント名によるソート（sortableテーブル）
3. クライアント詳細画面へのリンク
4. メールアドレスへの直接連絡（mailto:リンク）

**画面遷移**：
- 遷移元：ad_default.asp（管理者ダッシュボード）、ad_adminMenu.asp
- 遷移先：ad_client.asp（クライアント詳細）

**権限による表示制御**：管理者認証（ad_security.asp）を通過したシステム管理者のみがアクセス可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 8 | ページ一覧 | 主機能 | クライアント一覧の表示・管理 |

## 画面種別

一覧（クライアント一覧画面）

## URL/ルーティング

`asp/ad_clientList.asp`

## 入出力項目

本画面は一覧表示専用であり、入力項目はない。

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| Nr | Integer | 連番（表示順） |
| iId | Integer | クライアントID |
| Name | String | クライアント名（詳細へのリンク） |
| Email | String | メインメールアドレス（mailto:リンク） |

## イベント仕様

### 1-クライアント名クリック

クライアント名をクリックすると、クライアント詳細画面に遷移する。

1. 暗号化されたクライアントIDをパラメータとして渡す
2. ad_client.aspに遷移

### 2-メールアドレスクリック

メールアドレスをクリックすると、メールクライアントが起動する。

1. mailto:プロトコルでメールアドレスを開く

### 3-テーブルソート

テーブルヘッダーをクリックすると、該当列でソートする。

1. JavaScriptのsortable機能でクライアントサイドソート

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | tblClient | SELECT | クライアント一覧を取得 |

### テーブル別更新項目詳細

#### tblClient（SELECT）

| 項目（カラム名） | 取得条件 | 備考 |
|-----------------|---------|------|
| iId | 全件 | クライアントID |
| sName | 全件 | クライアント名 |
| sContactPerson | 全件 | 担当者名 |
| sMainEmail | 全件 | メインメールアドレス |

## メッセージ仕様

本画面にはメッセージ表示機能はない。

## 例外処理

| 例外 | 処理内容 |
|------|---------|
| クライアント未登録 | テーブルが表示されない（空の状態） |
| 認証失敗 | ad_security.aspにより管理者ログイン画面にリダイレクト |

## 備考

- sortableクラスでソート可能なテーブルを実現
- sNameでASC順にソート（初期表示）
- クライアントIDは暗号化して遷移パラメータに使用

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | client.asp | `asp/includes/client.asp` | cls_clientクラスの構造を理解する |

**読解のコツ**: cls_clientクラスはクライアント（顧客）情報を管理する。listAll()メソッドで全クライアントを取得できる。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ad_clientList.asp | `asp/ad_clientList.asp` | 一覧表示のメイン処理 |

**主要処理フロー**:
1. **行4**: ad_adminMenu.aspをインクルードしてメニュー表示
2. **行5-6**: cls_clientインスタンス作成とlistAll()呼び出し
3. **行7**: 結果がNullでなければテーブル表示開始
4. **行7**: forループでクライアント一覧を出力

#### Step 3: 認証処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ad_security.asp | `asp/ad_security.asp` | 管理者認証処理 |
| 3-2 | beginClient.asp | `asp/beginClient.asp` | クライアント初期化処理 |

### プログラム呼び出し階層図

```
ad_clientList.asp
    │
    ├─ begin.asp (共通初期化)
    │
    ├─ beginClient.asp (クライアント初期化)
    │
    ├─ ad_security.asp (管理者認証)
    │
    ├─ includes/header.asp (ヘッダー)
    │
    ├─ bs_initBack.asp (バック画面初期化)
    │
    ├─ bs_header.asp (バックサイトヘッダー)
    │
    ├─ ad_adminMenu.asp (管理者メニュー)
    │
    └─ cls_client
           └─ listAll() (クライアント一覧取得)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

なし                ┌─────────────────┐
       ───────────▶ │ cls_client      │
                    │ listAll()       │
                    └─────────────────┘
                           │
                           ▼
                    ┌─────────────────┐
                    │ tblClient       │
                    │ SELECT          │
                    │ iId,sName,      │
                    │ sContactPerson, │
                    │ sMainEmail      │
                    └─────────────────┘
                           │
                           ▼
                    ┌─────────────────┐
                    │ HTMLテーブル生成 │ ───▶ クライアント一覧
                    │ sortableクラス  │       (HTML Table)
                    └─────────────────┘
                           │
                           ▼
                    [画面表示]
                    ・Nr（連番）
                    ・iId（ID）
                    ・Name（リンク）
                    ・Email（mailto）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ad_clientList.asp | `asp/ad_clientList.asp` | ソース | クライアント一覧画面 |
| ad_client.asp | `asp/ad_client.asp` | ソース | クライアント詳細画面（遷移先） |
| client.asp | `asp/includes/client.asp` | インクルード | クライアントクラス定義 |
| ad_security.asp | `asp/ad_security.asp` | インクルード | 管理者認証 |
| ad_adminMenu.asp | `asp/ad_adminMenu.asp` | インクルード | 管理者メニュー |
| beginClient.asp | `asp/beginClient.asp` | インクルード | クライアント初期化 |
| begin.asp | `asp/begin.asp` | インクルード | 共通初期化処理 |
