# 画面設計書 136-顧客詳細

## 概要

本ドキュメントは、QuickerSite CMSにおける顧客詳細画面（ad_client.asp）の設計仕様を定義するものである。

### 本画面の処理概要

本画面は、システム管理者（Admin）が個別クライアント（顧客）の詳細情報を表示・編集・削除するための画面である。クライアントの基本情報の管理と、関連する製品（サービス契約）の一覧表示が可能である。

**業務上の目的・背景**：QuickerSiteはマルチテナント型CMSであり、各クライアントの管理が必要である。本画面は、クライアントの連絡先情報、担当者情報などを管理し、契約製品の追加・確認を行うためのインターフェースを提供する。顧客との連絡、契約管理、サポート対応などの業務で活用される。

**画面へのアクセス方法**：顧客一覧画面（ad_clientList.asp）からクライアント名をクリックすることでアクセスする。新規クライアント作成時は直接アクセスも可能。

**主要な操作・処理内容**：
1. クライアント基本情報の表示・編集（名前、担当者、メールアドレス、住所）
2. クライアント情報の保存
3. クライアントの削除（確認ダイアログあり）
4. 関連製品（契約）の一覧表示
5. 新規製品の追加へのリンク

**画面遷移**：
- 遷移元：ad_clientList.asp（顧客一覧）
- 遷移先：ad_clientproduct.asp（製品詳細）、ad_clientList.asp（削除後）

**権限による表示制御**：管理者認証（ad_security.asp）を通過したシステム管理者のみがアクセス可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 5 | サイト基本設定 | 主機能 | クライアント詳細情報の表示 |

## 画面種別

詳細・編集（クライアント詳細画面）

## URL/ルーティング

`asp/ad_client.asp?iClientID={暗号化されたクライアントID}`

## 入出力項目

| 項目名 | 項目ID | 入力/出力 | データ型 | 必須 | 説明 |
|--------|--------|-----------|----------|------|------|
| クライアントID | iClientId | 入力 | String | - | 暗号化されたクライアントID（編集時） |
| 名前 | sName | 入力 | String | 必須 | クライアント名（最大250文字） |
| 担当者名 | sContactPerson | 入力 | String | 必須 | 担当者名（最大250文字） |
| メインメール | sMainEmail | 入力 | String | 必須 | 主要メールアドレス（最大250文字） |
| その他メール | sOtherEmail | 入力 | String | - | その他メールアドレス |
| 住所 | sAddress | 入力 | String | - | 住所・連絡先 |
| アクション | btnaction | 入力 | String | - | 保存/削除 |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| 一般情報セクション | Header | "general"ラベル |
| Name | Text Input | クライアント名 |
| Contact Person | Text Input | 担当者名 |
| Main email | Text Input | メインメールアドレス |
| Other email | Textarea | その他メールアドレス（複数行） |
| Full Address | Textarea | 住所（複数行） |
| 製品一覧 | List | 関連する製品のリスト（既存クライアントのみ） |
| Add product | Link | 製品追加へのリンク |
| 保存ボタン | Button | 情報を保存 |
| 削除ボタン | Button | クライアントを削除（確認あり、既存のみ） |

## イベント仕様

### 1-保存（Save）

btnactionが"save"の場合、クライアント情報を保存する。

1. フォームから各項目を取得
2. client.save()で保存
3. 成功時、"fb_saveOK"メッセージを表示

### 2-削除（Delete）

btnactionが"delete"の場合、クライアントを削除する。

1. JavaScript confirm()で確認
2. CSRF検証（checkCSRF）
3. client.remove()で削除
4. 顧客一覧（ad_clientList.asp）にリダイレクト

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存（新規） | tblClient | INSERT | クライアント情報を新規作成 |
| 保存（更新） | tblClient | UPDATE | クライアント情報を更新 |
| 削除 | tblClient | DELETE | クライアント情報を削除 |
| 削除 | tblClientProduct | DELETE | 関連製品情報を削除 |

### テーブル別更新項目詳細

#### tblClient

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT/UPDATE | sName | フォーム入力値 | クライアント名 |
| INSERT/UPDATE | sContactPerson | フォーム入力値 | 担当者名 |
| INSERT/UPDATE | sMainEmail | フォーム入力値 | メインメール |
| INSERT/UPDATE | sOtherEmail | フォーム入力値 | その他メール |
| INSERT/UPDATE | sAddress | フォーム入力値 | 住所 |
| INSERT | dCreatedTS | now() | 作成日時 |
| UPDATE | dUpdatedTS | now() | 更新日時 |
| DELETE | - | iId条件 | 該当レコードを削除 |

## メッセージ仕様

| 種別 | メッセージ | 発生条件 |
|------|----------|---------|
| 成功 | fb_saveOK | 保存成功時 |
| エラー | err_mandatory | 必須項目未入力時 |
| 確認 | areyousure | 削除ボタンクリック時 |

## 例外処理

| 例外 | 処理内容 |
|------|---------|
| 必須項目未入力 | message.Adderror()でエラー表示、保存処理中止 |
| 認証失敗 | ad_security.aspにより管理者ログイン画面にリダイレクト |

## 備考

- 必須項目：Name、Contact Person、Main email
- 新規作成時は削除ボタンは非表示
- 製品一覧は既存クライアントのみ表示
- 削除時は関連する製品情報（tblClientProduct）も削除

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | client.asp | `asp/includes/client.asp` | cls_clientクラスのプロパティとメソッドを理解 |
| 1-2 | clientproduct.asp | `asp/includes/clientproduct.asp` | cls_clientproductクラスとの関連を理解 |

**読解のコツ**: cls_clientクラスのproductsプロパティで関連製品を取得できる。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ad_client.asp | `asp/ad_client.asp` | メイン処理フロー |

**主要処理フロー**:
1. **行4-6**: クライアント・製品オブジェクトの初期化
2. **行7-16**: 保存処理（btnaction=save）
3. **行17-21**: 削除処理（btnaction=delete）
4. **行21**: 製品一覧の取得と表示

### プログラム呼び出し階層図

```
ad_client.asp
    │
    ├─ begin.asp (共通初期化)
    │
    ├─ beginClient.asp (クライアント初期化)
    │
    ├─ ad_security.asp (管理者認証)
    │
    ├─ ad_adminMenu.asp (管理者メニュー)
    │
    └─ cls_client
           ├─ pick() (クライアント取得)
           ├─ save() (保存)
           ├─ remove() (削除)
           │     └─ tblClientProduct削除
           └─ products (製品一覧プロパティ)
                  └─ cls_clientproduct
```

### データフロー図

```
[入力]                    [処理]                         [出力]

iClientID(暗号化)   ┌─────────────────┐
       ───────────▶ │ 復号化＆取得     │ ───▶ クライアントオブジェクト
                    │ client.pick()   │
                    └─────────────────┘
                           │
        ┌──────────────────┼──────────────────┐
        ▼                  ▼                  ▼
┌───────────────┐ ┌───────────────┐ ┌───────────────┐
│ フォーム表示   │ │ 製品一覧取得   │ │ 保存/削除処理  │
│               │ │ client.products│ │               │
└───────────────┘ └───────────────┘ └───────────────┘
        │                  │                  │
        ▼                  ▼                  ▼
   HTMLフォーム       製品リンク表示     tblClient更新
                    (ad_clientproduct)   またはリダイレクト
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ad_client.asp | `asp/ad_client.asp` | ソース | クライアント詳細画面 |
| ad_clientList.asp | `asp/ad_clientList.asp` | ソース | クライアント一覧（遷移元） |
| ad_clientproduct.asp | `asp/ad_clientproduct.asp` | ソース | 製品詳細（遷移先） |
| client.asp | `asp/includes/client.asp` | インクルード | クライアントクラス定義 |
| clientproduct.asp | `asp/includes/clientproduct.asp` | インクルード | 製品クラス定義 |
| ad_security.asp | `asp/ad_security.asp` | インクルード | 管理者認証 |
| ad_adminMenu.asp | `asp/ad_adminMenu.asp` | インクルード | 管理者メニュー |
