# 画面設計書 137-顧客編集

## 概要

本ドキュメントは、QuickerSite CMSにおける顧客編集画面（ad_customer.asp）の設計仕様を定義するものである。

### 本画面の処理概要

本画面は、システム管理者（Admin）がサイト顧客（Customer）の設定を詳細に編集するための画面である。サイトの基本情報、ドメイン設定、各種機能のON/OFF、SMTP設定など、サイト運営に必要な全般的な設定を管理する。

**業務上の目的・背景**：QuickerSiteはマルチテナント型CMSであり、各顧客（Customer）が独自のウェブサイトを運営する。本画面は、各サイトの詳細設定を行うための中心的な管理画面である。ドメインバインディング、機能の有効/無効化、メール配信設定など、サイト運営の根幹に関わる設定を一元管理できる。

**画面へのアクセス方法**：管理者ダッシュボード（ad_default.asp）から、サイト設定メニューを選択するか、新規サイト作成時に自動遷移する。

**主要な操作・処理内容**：
1. サイト基本情報の編集（名前、URL、開始日）
2. 機能設定（RSS、アプリケーション、ユーザーフレンドリーURL等）
3. SMTP設定（メールサーバー、認証情報）
4. 代替ドメインの設定
5. バックサイトパスワードのリセット
6. サイトの削除

**画面遷移**：
- 遷移元：ad_default.asp（管理者ダッシュボード）
- 遷移先：ad_default.asp（保存/削除後）

**権限による表示制御**：管理者認証（ad_security.asp）を通過したシステム管理者のみがアクセス可能。自分自身のサイトは削除不可。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 5 | サイト基本設定 | 主機能 | サイト顧客の編集 |

## 画面種別

編集（サイト顧客設定画面）

## URL/ルーティング

`asp/ad_customer.asp?iId={顧客ID}`

## 入出力項目

| 項目名 | 項目ID | 入力/出力 | データ型 | 必須 | 説明 |
|--------|--------|-----------|----------|------|------|
| 顧客ID | iId | 入力 | Integer | - | 顧客ID（編集時） |
| 組織名 | sName | 入力 | String | 必須 | サイト名（最大250文字） |
| URL | sURL | 入力 | String | 必須 | サイトURL |
| 開始日 | dOnlineFrom | 入力 | Date | - | サービス開始日 |
| Main RSS | bEnableMainRSS | 入力 | Boolean | - | RSSフィード有効化 |
| アプリケーション許可 | bApplication | 入力 | Boolean | - | アプリケーション使用許可 |
| ユーザーフレンドリーURL | bUserFriendlyURL | 入力 | Boolean | - | SEO URL有効化 |
| リストアイテム画像 | bListItemPic | 入力 | Boolean | - | リストアイテム画像機能 |
| ショッピングカート | bShoppingCart | 入力 | Boolean | - | EC機能有効化 |
| WWW外ストレージ許可 | bAllowStorageOutsideWWW | 入力 | Boolean | - | 外部ストレージ許可 |
| リファラースキャン | bScanReferer | 入力 | Boolean | - | 参照元記録 |
| モニター | bMonitor | 入力 | Boolean | - | アクセス監視 |
| ニュースレター | bEnableNewsletters | 入力 | Boolean | - | ニュースレター機能 |
| ページキャッシュ | bUseCachingForPages | 入力 | Boolean | - | ページキャッシュ有効化 |
| SMTPサーバー | C_SMTPSERVER | 入力 | String | - | SMTPサーバーアドレス |
| SMTPポート | C_SMTPPORT | 入力 | String | - | SMTPポート（デフォルト25） |
| SMTPユーザー | C_SMTPUSERNAME | 入力 | String | - | SMTP認証ユーザー |
| SMTPパスワード | C_SMTPUSERPW | 入力 | String | - | SMTP認証パスワード |
| 送信方式 | C_SENDUSING | 入力 | String | - | 1:local/2:external/3:exchange |
| SSL使用 | C_SMTPUSESSL | 入力 | String | - | 0:no/1:yes |
| 代替ドメイン | sAlternateDomains | 入力 | String | - | 代替ドメイン一覧（改行区切り） |
| 管理者パスワード | adminPassword | 入力 | String | - | バックサイトPWリセット用 |
| アクション | btnaction | 入力 | String | - | 保存/削除 |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| 一般セクション | Header | 基本設定項目群 |
| SMTPセクション | Fieldset | SMTP設定項目群 |
| 代替ドメインセクション | Textarea | 代替ドメイン一覧 |
| 全体パスワード有無 | Boolean表示 | 全体パスワード設定状況 |
| 作成日 | Date表示 | dCreatedTS |
| 更新日 | Date表示 | dUpdatedTS |
| 統計リセット日 | Date表示 | dResetStats |
| アプリケーションリセットリンク | Link | キャッシュクリア用リンク |

## イベント仕様

### 1-保存（Save）

btnactionが"save"の場合、サイト設定を保存する。

1. フォームから各項目を取得
2. URL/ドメイン変更時はIISバインディング更新フラグを設定
3. 新規作成時はデフォルトパスワード設定、初期化処理実行
4. customerObj.save()で保存
5. 管理者パスワードが入力されていれば更新
6. ad_default.aspにリダイレクト

### 2-削除（Delete）

btnactionが"delete"の場合、サイトを削除する。

1. JavaScript confirm()で確認
2. CSRF検証（checkCSRF）
3. customerObj.remove()で削除
4. ad_default.aspにリダイレクト

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存（新規） | tblCustomer | INSERT | サイト情報を新規作成 |
| 保存（更新） | tblCustomer | UPDATE | サイト情報を更新 |
| 削除 | tblCustomer | DELETE | サイト情報を削除 |
| 削除 | tblPage | DELETE | 関連ページを削除 |
| 削除 | tblMonitor | DELETE | 監視情報を削除 |

### テーブル別更新項目詳細

#### tblCustomer

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT/UPDATE | sName | フォーム入力値 | 組織名 |
| INSERT/UPDATE | sURL | フォーム入力値 | サイトURL |
| INSERT/UPDATE | dOnlineFrom | フォーム入力値 | 開始日 |
| INSERT/UPDATE | bEnableMainRSS | フォーム入力値 | RSS有効 |
| INSERT/UPDATE | bApplication | フォーム入力値 | アプリケーション許可 |
| INSERT/UPDATE | bUserFriendlyURL | フォーム入力値 | SEO URL |
| INSERT/UPDATE | bListItemPic | フォーム入力値 | リスト画像機能 |
| INSERT/UPDATE | bShoppingCart | フォーム入力値 | EC機能 |
| INSERT/UPDATE | bScanReferer | フォーム入力値 | リファラー記録 |
| INSERT/UPDATE | bMonitor | フォーム入力値 | 監視機能 |
| INSERT/UPDATE | bEnableNewsletters | フォーム入力値 | NL機能 |
| INSERT/UPDATE | bUseCachingForPages | フォーム入力値 | キャッシュ |
| INSERT/UPDATE | C_SMTPSERVER〜 | フォーム入力値 | SMTP設定群 |
| INSERT/UPDATE | sAlternateDomains | フォーム入力値 | 代替ドメイン |
| UPDATE | adminPassword | sha256(入力値) | 管理者PW |

## メッセージ仕様

| 種別 | メッセージ | 発生条件 |
|------|----------|---------|
| エラー | err_mandatory | 必須項目未入力時 |
| エラー | err_url | URLが無効な場合 |
| 確認 | areyousure | 削除ボタンクリック時 |

## 例外処理

| 例外 | 処理内容 |
|------|---------|
| 必須項目未入力 | message.AddError()でエラー表示、保存処理中止 |
| URL長不足 | 7文字以下の場合エラー |
| 自サイト削除試行 | 削除ボタンを非表示にして防止 |

## 備考

- 必須項目：組織名、URL
- 新規作成時のデフォルトパスワードはQS_defaultPW
- 管理者パスワードはSHA256でハッシュ化
- 自分自身のサイト（customerObj.iId = cId）は削除不可
- URL変更時はIISバインディングも更新
- SMTPポートのデフォルトは25

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | customer.asp | `asp/includes/customer.asp` | cls_customerクラスの膨大なプロパティを理解 |

**読解のコツ**: cls_customerクラスはサイト設定の全てを管理する非常に大きなクラス。SMTP設定、認証設定、機能フラグなど多岐にわたる。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ad_customer.asp | `asp/ad_customer.asp` | メイン処理フロー |

**主要処理フロー**:
1. **行4-10**: 顧客オブジェクトの初期化
2. **行11-58**: 保存処理（各種設定項目の取得と保存）
3. **行59-62**: 削除処理
4. **行63-**: フォーム表示

### プログラム呼び出し階層図

```
ad_customer.asp
    │
    ├─ begin.asp (共通初期化)
    │
    ├─ ad_security.asp (管理者認証)
    │
    ├─ cls_customer
    │      ├─ pick() (顧客取得)
    │      ├─ save() (保存)
    │      │     ├─ check() (バリデーション)
    │      │     ├─ initialize() (新規サイト初期化)
    │      │     └─ IIS設定更新
    │      ├─ saveAdminPW() (管理者PW更新)
    │      │     └─ sha256() (ハッシュ化)
    │      └─ remove() (削除)
    │            └─ 関連テーブル削除
    │
    └─ cls_customerList
           └─ count (顧客数取得)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

iId                 ┌─────────────────┐
       ───────────▶ │ 顧客取得         │ ───▶ 顧客オブジェクト
                    │ customerObj.pick│
                    └─────────────────┘
                           │
                           ▼
                    ┌─────────────────┐
フォーム入力 ─────▶ │ 設定更新         │
                    │ ・基本情報      │
                    │ ・機能フラグ    │
                    │ ・SMTP設定      │
                    │ ・ドメイン設定  │
                    └─────────────────┘
                           │
        ┌──────────────────┼──────────────────┐
        ▼                  ▼                  ▼
┌───────────────┐ ┌───────────────┐ ┌───────────────┐
│ 保存処理       │ │ PW更新        │ │ 削除処理       │
│ save()        │ │ saveAdminPW() │ │ remove()      │
└───────────────┘ └───────────────┘ └───────────────┘
        │                  │                  │
        ▼                  ▼                  ▼
   tblCustomer更新    sha256ハッシュ     関連テーブル削除
   IISバインディング     保存           リダイレクト
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ad_customer.asp | `asp/ad_customer.asp` | ソース | サイト顧客編集画面 |
| ad_default.asp | `asp/ad_default.asp` | ソース | 管理者ダッシュボード（遷移元/先） |
| customer.asp | `asp/includes/customer.asp` | インクルード | 顧客クラス定義 |
| customerList.asp | `asp/includes/customerList.asp` | インクルード | 顧客一覧クラス |
| sha256.asp | `asp/includes/sha256.asp` | インクルード | SHA256ハッシュ関数 |
| ad_security.asp | `asp/ad_security.asp` | インクルード | 管理者認証 |
